/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.filesystem;

import org.eso.dfs.util.KeywordListener;
import org.eso.dfs.util.KeywordToken;
import org.eso.gasgano.datamodel.filesystem.FitsFile;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.tools.RADECConverter;

class FitsFileKeywordListener
implements KeywordListener {
    private int currentExtension = -1;
    private FitsFile ff;

    protected FitsFileKeywordListener(FitsFile f) {
        this.ff = f;
    }

    @Override
    public boolean tokenRead(KeywordToken kwt) {
        Keyword k = new Keyword(kwt);
        if (FitsFile.getRadecConversion()) {
            if (k.getName().equals("RA")) {
                k.setValue(RADECConverter.RAconvert(k.getValue()));
            }
            if (k.getName().equals("DEC")) {
                k.setValue(RADECConverter.DECconvert(k.getValue()));
            }
        }
        if (kwt.getExtension() != this.currentExtension + 1) {
            ++this.currentExtension;
            this.ff.addExtension();
        }
        if (this.currentExtension == -1) {
            this.ff.addKeyword(k);
        } else {
            this.ff.addKeywordToExtension(this.currentExtension, k);
        }
        return false;
    }
}

