/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.InterContainer;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.filesystem.FitsFile;
import org.eso.gasgano.datamodel.gui.FitsFileDisplay;
import org.eso.gasgano.datamodel.gui.FitsTableModel;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.properties.GasProp;

public abstract class KeywordContainerOBComponent
extends OBComponent {
    protected FitsFile myFile = null;
    private String[] columnDisplayData;
    protected String arcFile = null;
    private static final int numberIdKeys = 3;
    private static final String fakeSignature = "ffffffffffffffffffffffffffffffff";
    protected static Keyword[] defaultKeywordQuery = null;
    public static long initTime = 0L;
    public static int initNumber = 0;

    public KeywordContainerOBComponent(String address) {
        this.init(address);
    }

    public abstract void addToDataModel(String var1, String var2, String var3);

    public void init(String address) {
        if (defaultKeywordQuery == null) {
            KeywordContainerOBComponent.setDefaultKeywordQuery(null);
        }
        for (int i = 0; i < defaultKeywordQuery.length; ++i) {
            defaultKeywordQuery[i].setValue(null);
        }
        this.myFile = new FitsFile(address, defaultKeywordQuery);
        this.setPipeProduct(this.myFile.isPipelineProduct());
        this.setDescription();
        if (!this.isPipeProduct()) {
            File tmpFile = new File(address);
            this.arcFile = new String(tmpFile.getParent() + File.separator + defaultKeywordQuery[2].getValue());
        }
    }

    public String getClassification() {
        return this.myFile.getClassification();
    }

    public String getInstrument() {
        if (this.myFile.getInstrument() != null) {
            return this.myFile.getInstrument();
        }
        return null;
    }

    public boolean hasIntermediate() {
        String instr = this.getInstrument();
        return GasProp.getProperties().hasInstrumentGrouping(instr) && this.getIntermediateGrouping() != null;
    }

    public void classify() {
        this.myFile.classify(DFSDataModel.getDataModel().getClassifier());
        if (KeywordContainerOBComponent.getDefaultFileDescription() != null) {
            KeywordContainerOBComponent.getDefaultFileDescription().classificationChanged(this);
        }
    }

    public static void setDefaultKeywordQueryToNull() {
        for (int i = 3; i < defaultKeywordQuery.length; ++i) {
            defaultKeywordQuery[i].setValue("");
        }
    }

    public static void setDefaultKeywordQuery(Keyword[] k) {
        int klen = 0;
        if (k != null) {
            klen = k.length;
        }
        defaultKeywordQuery = new Keyword[3 + klen];
        KeywordContainerOBComponent.defaultKeywordQuery[0] = new Keyword("OBS.PROG.ID", null);
        KeywordContainerOBComponent.defaultKeywordQuery[1] = new Keyword("OBS.ID", null);
        KeywordContainerOBComponent.defaultKeywordQuery[2] = new Keyword("ARCFILE", null);
        if (k != null) {
            System.arraycopy(k, 0, defaultKeywordQuery, 3, k.length);
        }
    }

    public static void addToDefaultKeywordQuery(Keyword[] k) {
        if (defaultKeywordQuery == null) {
            KeywordContainerOBComponent.setDefaultKeywordQuery(k);
        } else if (k != null) {
            Keyword[] temp = defaultKeywordQuery;
            defaultKeywordQuery = new Keyword[temp.length + k.length];
            System.arraycopy(temp, 0, defaultKeywordQuery, 0, temp.length);
            System.arraycopy(k, 0, defaultKeywordQuery, temp.length, k.length);
        }
    }

    public static Keyword[] getDefaultKeywordQuery() {
        return defaultKeywordQuery;
    }

    public String[] getDisplayData() {
        return this.columnDisplayData;
    }

    public void setDisplayData(String[] cols) {
        this.columnDisplayData = cols;
    }

    public void resetDescription() {
        KeywordContainerOBComponent.setDefaultKeywordQueryToNull();
        this.myFile.updateKeywords(defaultKeywordQuery);
        this.setDescription();
    }

    public void setDescription() {
        if (KeywordContainerOBComponent.getDefaultFileDescription() != null) {
            KeywordContainerOBComponent.getDefaultFileDescription().setDescription(this);
        }
    }

    public String getArcfile() {
        if (this.isPipeProduct()) {
            return new String("");
        }
        return this.arcFile;
    }

    @Override
    public int update() {
        if (this.myFile.dataRefreshRequired()) {
            boolean inModel;
            String currentProgId = null;
            String currentObId = null;
            String currentTelescopeId = null;
            boolean bl = inModel = this.getStatus() == 3;
            if (this.hasIntermediate()) {
                InterContainer inter = (InterContainer)this.getObservation(0);
                currentObId = inter.getObservation().getId();
                currentProgId = inter.getObservation().getProgram().getId();
            } else {
                currentProgId = this.getObservation(0).getProgram().getId();
                currentObId = this.getObservation(0).getId();
            }
            currentTelescopeId = this.myFile.getTelescope();
            this.init(this.myFile.getPathString());
            if (this.getStatus() == 3) {
                if (!currentProgId.equals(defaultKeywordQuery[0].getValue()) || !currentObId.equals(defaultKeywordQuery[1].getValue())) {
                    if (inModel) {
                        this.removeFromDataModel();
                    }
                    this.addToDataModel(defaultKeywordQuery[0].getValue(), defaultKeywordQuery[1].getValue(), this.myFile.getTelescope());
                    DFSDataModel.getDataModel().fireDataModelChangeEvent(new DataModelEvent(1));
                }
            } else if (inModel) {
                this.removeFromDataModel();
            }
        }
        return this.getStatus();
    }

    @Override
    public String getId() {
        return this.myFile.getAddress();
    }

    @Override
    public DFSFile getSourceFile() {
        return this.myFile;
    }

    @Override
    public int getStatus() {
        return this.myFile.getStatus();
    }

    @Override
    public JComponent getDisplayComponent() {
        JComponent rc = null;
        boolean freeMemory = true;
        if (this.myFile.headerInMemory()) {
            freeMemory = false;
        } else if (this.myFile.readFitsHeaderAndExtensions(FitsFileDisplay.isShowExtensions()) == 1) {
            if (!DFSDataModel.getDataModel().isUpdating()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DFSDataModel.getDataModel().update();
                    }
                }).start();
            }
            rc = new JLabel("The file has been slyly removed from the filesystem", 0);
            return rc;
        }
        String title = null;
        Keyword origFile = this.myFile.getKeyword("ORIGFILE");
        title = origFile == null ? this.toString() + "    <unknown orig name>\t   " + this.myFile.getClassification() : this.getId() + "                " + origFile.getValue() + "\t  " + this.myFile.getClassification();
        rc = new FitsFileDisplay(title, new FitsTableModel(this.myFile));
        if (freeMemory) {
            this.myFile.freeHeaderMemory();
        }
        return rc;
    }

    @Override
    public String getIntermediateGrouping() {
        return this.myFile.getIntermediateGrouping();
    }

    public boolean isCalibFrame() {
        return this.myFile.isCalibFrame();
    }

    public String getSignature() {
        return this.myFile.getSignature();
    }

    public boolean containsRbInfo() {
        return this.myFile.containsRbInfo();
    }

    public String getAssociatedRecipeName() {
        String rc = "";
        Keyword recId = this.myFile.getKeyword("PRO.REC1.ID");
        if (recId != null && (rc = recId.getValue()) == null) {
            rc = "";
        }
        return rc;
    }

    public Vector getAssociatedMasterInfo() {
        String keyBaseName = "PRO.REC";
        String keyBaseNameRec = keyBaseName + "1.CAL";
        String keyName1 = keyBaseNameRec + "1.NAME";
        String keyName2 = keyBaseNameRec + "1.DATAMD5";
        Vector rc = new Vector();
        Vector<String> masterNames = new Vector<String>();
        Vector<String> masterSignatures = new Vector<String>();
        int frameCount = 1;
        int recCount = 1;
        Keyword tmpKey = null;
        rc.addElement(masterNames);
        rc.addElement(masterSignatures);
        while ((tmpKey = this.myFile.getKeyword(keyName1)) != null) {
            while ((tmpKey = this.myFile.getKeyword(keyName1)) != null) {
                masterNames.addElement(tmpKey.getValue());
                tmpKey = this.myFile.getKeyword(keyName2);
                if (tmpKey != null) {
                    masterSignatures.addElement(tmpKey.getValue());
                } else {
                    masterSignatures.addElement(fakeSignature);
                }
                keyName1 = keyBaseNameRec + String.valueOf(++frameCount) + ".NAME";
                keyName2 = keyBaseNameRec + String.valueOf(frameCount) + ".DATAMD5";
            }
            keyBaseNameRec = keyBaseName + String.valueOf(++recCount) + ".CAL";
            frameCount = 1;
            keyName1 = keyBaseNameRec + "1.NAME";
            keyName2 = keyBaseNameRec + "1.DATAMD5";
        }
        return rc;
    }

    public Vector getAssociatedRawFrames() {
        String keyBaseName = "PRO.REC";
        String keyBaseNameRec = keyBaseName + "1.RAW";
        String keyName = keyBaseNameRec + "1.NAME";
        Vector<String> rc = new Vector<String>();
        int frameCount = 1;
        int recCount = 1;
        Keyword tmpKey = null;
        while ((tmpKey = this.myFile.getKeyword(keyName)) != null) {
            while ((tmpKey = this.myFile.getKeyword(keyName)) != null) {
                rc.addElement(tmpKey.getValue());
                keyName = keyBaseNameRec + String.valueOf(++frameCount) + ".NAME";
            }
            keyBaseNameRec = keyBaseName + String.valueOf(++recCount) + ".RAW";
            frameCount = 1;
            keyName = keyBaseNameRec + "1.NAME";
        }
        return rc;
    }

    public void freeHeaderMemory() {
        this.myFile.freeHeaderMemory();
    }

    public boolean precedes(KeywordContainerOBComponent other) {
        boolean rc = false;
        String otherKeyMjd = null;
        String keyMjd = this.myFile.getMjdObs();
        otherKeyMjd = ((FitsFile)other.getSourceFile()).getMjdObs();
        rc = keyMjd.equals("") ? false : (otherKeyMjd.equals("") ? true : keyMjd.compareTo(otherKeyMjd) <= 0);
        return rc;
    }
}

