/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.eso.gasgano.datamodel.InterContainer;
import org.eso.gasgano.datamodel.Observation;
import org.eso.gasgano.datamodel.Program;
import org.eso.gasgano.datamodel.database.DBContainer;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.gui.DBOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.datamodel.gui.ResultsComponent;
import org.eso.gasgano.datamodel.gui.ResultsContainer;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.tools.SortedHashtable;

public class DFSFileTreeCellRenderer
implements TreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JComponent cell = null;
        JLabel tmpCell = null;
        if (value instanceof OBComponent) {
            OBComponent obc = (OBComponent)value;
            cell = obc.getTreeCellComponent();
        } else if (value instanceof DBOBComponent) {
            DBOBComponent dbobc = (DBOBComponent)value;
            cell = dbobc.getTreeCellComponent();
        } else if (value instanceof ResultsComponent) {
            ResultsComponent resobc = (ResultsComponent)value;
            cell = resobc.getTreeCellComponent();
        } else if (value instanceof ResultsContainer) {
            ResultsContainer rescon = (ResultsContainer)value;
            cell = rescon.getTreeCellComponent();
        } else {
            if (value instanceof InterContainer) {
                tmpCell = GUIUtils.interLabel;
            } else if (value instanceof Observation) {
                tmpCell = GUIUtils.obLabel;
            } else if (value instanceof Program) {
                tmpCell = GUIUtils.programLabel;
            } else if (value instanceof DBContainer) {
                if (((DBContainer)value).isProgram()) {
                    tmpCell = GUIUtils.programLabel;
                }
                if (((DBContainer)value).isObservation()) {
                    tmpCell = GUIUtils.obLabel;
                }
                if (((DBContainer)value).isTelescope()) {
                    tmpCell = GUIUtils.telLabel;
                }
            } else {
                tmpCell = value instanceof SortedHashtable ? (DFSDataModel.getDataModel().findTelescope(value.toString()) == null ? GUIUtils.defaultLabel : GUIUtils.telLabel) : GUIUtils.defaultLabel;
            }
            tmpCell.setText(new String(value.toString()));
            tmpCell.setForeground(Color.black);
            return tmpCell;
        }
        return cell;
    }
}

