/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.eso.gasgano.gui.ReportRunner;

public class ReportDialog
extends JDialog
implements ActionListener {
    private JLabel userLabel;
    private String userMessage;
    private JButton cancelButton;
    private boolean interrupted = false;
    private Thread theThread;
    private ReportRunner runner;
    private Timer threadCheckTimer;

    public ReportDialog(Frame p, String title, String msg, boolean modal, ReportRunner r) {
        super(p, title, modal);
        this.userMessage = msg;
        this.theThread = new Thread(r);
        this.runner = r;
    }

    public void run() {
        this.setupDialog();
        this.pack();
        this.setLocation(400, 400);
        this.theThread.start();
        this.threadCheckTimer = new Timer(1000, this);
        this.threadCheckTimer.start();
        this.show();
    }

    public boolean cancelSelected() {
        return this.interrupted;
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        if (a2.getSource() == this.threadCheckTimer) {
            this.threadCheckTimer.stop();
            try {
                this.theThread.join(1000L);
            }
            catch (InterruptedException ie) {
                this.endDialog();
            }
            if (!this.theThread.isAlive()) {
                this.endDialog();
            } else {
                this.threadCheckTimer.restart();
            }
        } else if (a2.getSource() == this.cancelButton) {
            try {
                this.runner.interruptReport();
            }
            catch (SecurityException e2) {
                System.out.println("Security Exception stopping thread.");
            }
            this.interrupted = true;
        }
    }

    private void endDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void setupDialog() {
        this.userLabel = new JLabel(this.userMessage);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.getContentPane().add((Component)this.userLabel, "Center");
        JLabel l = new JLabel(new ImageIcon(ReportDialog.class.getResource("/org/eso/gasgano/gui/icons/ib_hourglas.gif")));
        this.getContentPane().add((Component)l, "West");
        this.getContentPane().add((Component)this.cancelButton, "South");
    }
}

