/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eso.dfs.gui.SwingFileChooser;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.gui.FontChooser;
import org.eso.gasgano.gui.ReportDialog;
import org.eso.gasgano.gui.ReportRunner;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.Report;
import org.eso.gasgano.tools.TestReport;

public class ReportViewer
extends JFrame
implements ActionListener {
    private String fileName;
    private JTextArea ta;
    private Font printerFont = null;
    private int[] columnWidths = null;
    private static final String selectFontLabel = "Select Font";
    private static final String saveAsLabel = "Save As...";
    private static final String quitLabel = "Quit";
    private static final String printLabel = "Print";

    public static void main(String[] args) {
        ReportViewer rep = new ReportViewer("Test Report", new TestReport());
        rep.pack();
        rep.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        rep.setSize(1100, 500);
        rep.setLocation(100, 300);
        rep.setVisible(true);
    }

    private void setColumnWidths(int[] c2) {
        this.columnWidths = new int[c2.length];
        int total = 0;
        for (int i = 0; i < c2.length; ++i) {
            this.columnWidths[i] = total = total + c2[i] + 2;
        }
    }

    public ReportViewer(String title, Report rep) {
        super(title);
        Random rnd = new Random();
        this.fileName = new String("/tmp/dfsreport" + rnd.nextInt());
        String errorString = null;
        boolean reportCancelled = false;
        String tmpString = null;
        DFSDataModel dm = DFSDataModel.getDataModel();
        tmpString = PropertyDB.getInstance().getProperty("PRINT_FONT");
        if (tmpString != null) {
            int colonPost = tmpString.indexOf(58);
            this.printerFont = new Font(tmpString.substring(0, colonPost), 0, Integer.parseInt(tmpString.substring(colonPost + 1, tmpString.length())));
        } else {
            this.printerFont = new Font("Dialog", 0, 5);
        }
        try {
            FileWriter fw = new FileWriter(this.fileName);
            PrintWriter pw = new PrintWriter((Writer)fw, true);
            rep.setPrintWriter(pw);
            ReportRunner runner = new ReportRunner(rep);
            ReportDialog runReport = new ReportDialog(this, "Report", "Generating Report...", true, runner);
            runReport.run();
            reportCancelled = runReport.cancelSelected();
            if (reportCancelled) {
                errorString = new String("Report cancelled.");
            } else {
                if (!runner.reportStatus()) {
                    errorString = new String("Error generating report.");
                } else {
                    this.setColumnWidths(rep.getColumnWidths());
                }
                pw.flush();
                pw.close();
            }
        }
        catch (IOException e2) {
            errorString = new String("Error generating report: " + e2.toString());
        }
        if (errorString != null) {
            JOptionPane.showMessageDialog(this, errorString);
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.fileName));
            StringBuffer text = new StringBuffer();
            String s = "";
            while ((s = in.readLine()) != null) {
                text.append("\n" + s);
            }
            this.ta = new JTextArea(text.toString());
            this.ta.setFont(this.printerFont);
            this.ta.setEditable(false);
            this.getContentPane().add(new JScrollPane(this.ta));
        }
        catch (OutOfMemoryError e3) {
            JOptionPane.showMessageDialog(this, "Error reading file: " + this.fileName + "\n the file is too large for display.");
        }
        catch (IOException e4) {
            JOptionPane.showMessageDialog(this, "Error reading file: " + this.fileName);
        }
        this.setupMenu();
    }

    private void setupMenu() {
        MenuBar mb = new MenuBar();
        Menu fileMenu = new Menu("File");
        MenuItem printMenuItem = new MenuItem(printLabel);
        printMenuItem.addActionListener(this);
        fileMenu.add(printMenuItem);
        MenuItem saveAsMenuItem = new MenuItem(saveAsLabel);
        saveAsMenuItem.addActionListener(this);
        fileMenu.add(saveAsMenuItem);
        MenuItem quitMenuItem = new MenuItem(quitLabel);
        quitMenuItem.addActionListener(this);
        fileMenu.add(quitMenuItem);
        mb.add(fileMenu);
        Menu fontMenu = new Menu("Options");
        MenuItem fontItem = new MenuItem(selectFontLabel);
        fontItem.addActionListener(this);
        fontMenu.add(fontItem);
        mb.add(fontMenu);
        this.setMenuBar(mb);
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        FontChooser fc;
        if (a2.getActionCommand() == quitLabel) {
            File f = new File(this.fileName);
            boolean deleted = true;
            try {
                deleted = f.delete();
            }
            catch (SecurityException e2) {
                deleted = false;
            }
            if (!deleted) {
                JOptionPane.showMessageDialog(this, "Failed to delete temporary report file:\n" + this.fileName);
            }
            this.setVisible(false);
        } else if (a2.getActionCommand() == saveAsLabel) {
            SwingFileChooser fc2 = new SwingFileChooser();
            fc2.setDialogTitle("Enter report file name");
            fc2.setDialogType(1);
            fc2.setMultiSelectionEnabled(false);
            String selectedFile = null;
            if (fc2.showSaveDialog(this) == 0) {
                selectedFile = fc2.getSelectedFile().getPath();
            }
            if (selectedFile != null && this.saveFile(selectedFile)) {
                JOptionPane.showMessageDialog(this, "Report saved to: " + selectedFile);
            }
        } else if (a2.getActionCommand() == printLabel) {
            Properties p = new Properties();
            String orientPrint = new String("landscape");
            String printerName = new String("ppbla3");
            String tmpPrint = null;
            DFSDataModel dm = DFSDataModel.getDataModel();
            tmpPrint = PropertyDB.getInstance().getProperty("PRINT_ORIENTATION");
            if (tmpPrint != null) {
                orientPrint = tmpPrint.equals("p") ? "portrait" : "landscape";
            }
            if ((tmpPrint = PropertyDB.getInstance().getProperty("PRINTER_NAME")) != null) {
                printerName = tmpPrint;
            }
            p.put("awt.print.numCopies", "1");
            p.put("awt.print.paperSize", "A4");
            p.put("awt.print.destination", "printer");
            p.put("awt.print.orientation", orientPrint);
            p.put("awt.print.printer", printerName);
            PrintJob pjob = null;
            try {
                pjob = this.getToolkit().getPrintJob(this, "Fits File Report", p);
            }
            catch (NullPointerException e3) {
                JOptionPane.showMessageDialog(this, "Unable to open print dialog: please check the printer configuration and your local print server", "Error", 0);
            }
            if (pjob != null) {
                Graphics pg = pjob.getGraphics();
                if (pg != null) {
                    pg.setFont(this.printerFont);
                    int lineHeight = pg.getFontMetrics().getAscent() + pg.getFontMetrics().getDescent();
                    int charWidth = pg.getFontMetrics().charWidth('X');
                    try {
                        BufferedReader in = new BufferedReader(new FileReader(this.fileName));
                        String s = "";
                        int lines = 2;
                        int pageNum = 1;
                        int height = pjob.getPageDimension().height;
                        int pageWidth = pjob.getPageDimension().width - charWidth;
                        while ((s = in.readLine()) != null) {
                            if ((++lines + 4) * lineHeight > height) {
                                pg.dispose();
                                pg = pjob.getGraphics();
                                pg.setFont(this.printerFont);
                                lines = 6;
                                this.printString("Page: " + ++pageNum, pg, 4 * lineHeight, charWidth, lineHeight, pageWidth, -1);
                            }
                            int linesPrinted = this.printString(s, pg, lines * lineHeight, charWidth, lineHeight, pageWidth, -1);
                            lines += linesPrinted - 1;
                        }
                    }
                    catch (IOException e4) {
                        JOptionPane.showMessageDialog(this, "Error reading file: " + this.fileName);
                    }
                    pg.dispose();
                }
                pjob.end();
            }
        } else if (a2.getActionCommand() == selectFontLabel && JOptionPane.showConfirmDialog(this, fc = new FontChooser(this.printerFont), "Edit fonts", 2, -1) == 0) {
            this.printerFont = fc.getNewFont();
            this.ta.setFont(this.printerFont);
            this.ta.repaint();
        }
    }

    private int printString(String s, Graphics pg, int height, int width, int lineHeight, int pageWidth, int colIndex) {
        int rc = 1;
        int fromIndex = 0;
        int toIndex = 0;
        do {
            String field;
            toIndex = s.indexOf(9, fromIndex);
            try {
                field = toIndex == -1 ? s.substring(fromIndex) : s.substring(fromIndex, toIndex);
            }
            catch (StringIndexOutOfBoundsException e2) {
                field = null;
            }
            if (field != null) {
                int offset = 30;
                if (colIndex >= 0 && this.columnWidths != null && colIndex < this.columnWidths.length) {
                    offset += this.columnWidths[colIndex] * width;
                }
                if (offset + field.length() * width > pageWidth) {
                    String toBePrinted = null;
                    int lastSpaceInField = (pageWidth - offset) / width;
                    if (lastSpaceInField >= field.length()) {
                        lastSpaceInField = field.length() - 1;
                    }
                    int endOfField = lastSpaceInField;
                    while (lastSpaceInField > 0 && field.charAt(lastSpaceInField) != ' ') {
                        --lastSpaceInField;
                    }
                    if (lastSpaceInField == 0) {
                        lastSpaceInField = endOfField;
                    }
                    toBePrinted = field.substring(0, lastSpaceInField);
                    pg.drawString(toBePrinted, offset, height);
                    if (lastSpaceInField == field.length() - 1) break;
                    String remainder = s.substring(fromIndex + lastSpaceInField + 1);
                    rc += this.printString(remainder, pg, height + lineHeight, width, lineHeight, pageWidth, colIndex);
                    break;
                }
                pg.drawString(field, offset, height);
            }
            fromIndex = toIndex + 1;
            ++colIndex;
        } while (toIndex != -1);
        return rc;
    }

    private int[] setupColumns(String s, FontMetrics fm) {
        int[] columns = null;
        int nCols = 1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\t') continue;
            ++nCols;
        }
        columns = new int[nCols];
        int from = 0;
        int colIndex = 0;
        int total = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\t') continue;
            int columnWidth = fm.stringWidth("X") * (i - from);
            columns[colIndex] = total + columnWidth;
            total += columnWidth;
            ++colIndex;
            from = i;
        }
        return columns;
    }

    boolean saveFile(String name) {
        boolean rc = true;
        if (name == null) {
            return false;
        }
        try {
            FileWriter fw = new FileWriter(name);
            PrintWriter pw = new PrintWriter(fw);
            FileReader fr = new FileReader(this.fileName);
            BufferedReader br = new BufferedReader(fr);
            String s = br.readLine();
            while (s != null) {
                pw.println(s);
                s = br.readLine();
            }
            pw.flush();
            pw.close();
        }
        catch (IOException e2) {
            rc = false;
            JOptionPane.showMessageDialog(this, "Error saving report: " + e2.toString());
        }
        return rc;
    }
}

