/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.tools;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eso.gasgano.properties.PropertyDB;

public class BaseName {
    static RESyntax theSyntax = new RESyntax(RESyntax.RE_SYNTAX_PERL5);
    static String dateReg = "\\d{4}-\\d{2}-\\d{2}";
    static String timeReg = "\\d{2}:\\d{2}:\\d{2}.\\d{3}";
    static String regARCFILE = new String("^([A-Z]|[1-2])*\\." + dateReg + "T" + timeReg);
    private static final int SECONDS_AND_MILLI = 6;

    public static String extractBaseName(String fullPath) {
        String rc = fullPath;
        String tempBname = fullPath;
        int endBname = tempBname.lastIndexOf(58) + 6 + 1;
        int startBname = tempBname.lastIndexOf(File.separatorChar) + 1;
        if (tempBname.startsWith("r.", startBname)) {
            startBname += 2;
        }
        if (endBname + 4 <= tempBname.length() && tempBname.substring(endBname, endBname + 4).equals("_tpl")) {
            endBname += 4;
        }
        try {
            tempBname = tempBname.substring(startBname, endBname);
        }
        catch (StringIndexOutOfBoundsException e2) {
            if (PropertyDB.getInstance().isDebug(4)) {
                System.out.println("Parsing file name 1: <" + fullPath + "> " + e2.toString());
            }
            tempBname = fullPath;
        }
        if (tempBname.equals(fullPath)) {
            endBname = fullPath.lastIndexOf(95);
            if (endBname == -1) {
                endBname = fullPath.lastIndexOf(46);
            }
            if (endBname == -1) {
                endBname = fullPath.length();
            }
            try {
                tempBname = tempBname.substring(startBname, endBname);
            }
            catch (StringIndexOutOfBoundsException e3) {
                if (PropertyDB.getInstance().isDebug(4)) {
                    System.out.println("Parsing file name 2: " + e3.toString());
                }
                tempBname = fullPath;
            }
        }
        rc = tempBname;
        if (PropertyDB.getInstance().isDebug(4)) {
            System.out.println("BASE:<" + rc + "> from <" + fullPath + ">");
        }
        return rc;
    }

    public static String extractProductBaseName(String fullPath) {
        return BaseName.extractProductBaseName(fullPath, File.separatorChar);
    }

    public static String extractProductBaseName(String fullPath, char fileSeparator) {
        String rc = fullPath;
        String tempBname = fullPath;
        int endBname = tempBname.lastIndexOf(58) + 7;
        int startBname = tempBname.lastIndexOf(fileSeparator) + 1;
        if (tempBname.startsWith("r.", startBname)) {
            startBname += 2;
        }
        endBname = fullPath.length();
        try {
            tempBname = tempBname.substring(startBname, endBname);
        }
        catch (StringIndexOutOfBoundsException e2) {
            if (PropertyDB.getInstance().isDebug(4)) {
                System.out.println("Parsing file name 2: " + e2.toString());
            }
            tempBname = fullPath;
        }
        rc = tempBname;
        if (PropertyDB.getInstance().isDebug(4)) {
            System.out.println("BASE:<" + rc + "> from <" + fullPath + ">");
        }
        return rc;
    }

    public static String extractTest(String input) {
        REMatch theMatch = null;
        RE exp = null;
        RE initExp = null;
        String reg = new String("[^/]*$");
        try {
            exp = new RE(regARCFILE);
            initExp = new RE(reg);
        }
        catch (REException ree) {
            // empty catch block
        }
        theMatch = initExp.getMatch(input);
        if (theMatch != null) {
            input = theMatch.toString();
            if (input.startsWith("r.")) {
                input = input.substring(2);
            }
            if (input.endsWith(".fits")) {
                input = input.substring(0, input.length() - 5);
            }
            if (input.endsWith(".tfits")) {
                input = input.substring(0, input.length() - 6);
            }
            if (input.endsWith(".rb") || input.endsWith(".rX") || input.endsWith(".rY") || input.endsWith(".rZ")) {
                input = input.substring(0, input.length() - 2);
            }
            if (exp.isMatch(input)) {
                System.out.println("<matches ARCFILE>");
            }
            return input;
        }
        return "FAILED";
    }

    private static void check(REMatch m, String expect, int x) {
        if (m == null || !m.toString().equals(expect)) {
            System.out.print("Failed");
        } else {
            System.out.print("Passed");
        }
        System.out.println(" test #" + x);
    }

    public static void main(String[] argv) {
        String input = argv[0];
        File aFile = null;
        if (input == null) {
            return;
        }
        aFile = new File(input);
        if (!aFile.exists()) {
            System.out.println("** This test uses methods with REGEXP *NOT* used by Gasgano ** ");
            System.out.println("Test Basename: " + BaseName.extractTest(input));
            System.out.println("== (for comparison)  ==");
            System.out.println("BaseName: " + BaseName.extractBaseName(input));
            System.out.println("ProductBaseName: " + BaseName.extractProductBaseName(input));
            System.out.println("\n");
        } else {
            FileReader dataSource = null;
            try {
                dataSource = new FileReader(input);
            }
            catch (FileNotFoundException ex) {
                System.out.println("File not found: " + input);
            }
            if (dataSource == null) {
                System.exit(0);
            }
            StringBuffer buff = new StringBuffer();
            BufferedReader br = new BufferedReader(dataSource);
            try {
                String s;
                while ((s = br.readLine()) != null) {
                    if (s.startsWith("PRODUCT")) {
                        System.out.println("** This test uses the same methods currently used by Gasgano ** ");
                        String product = s.substring(9, s.length());
                        System.out.println("product: " + product + " \tbasename: " + BaseName.extractProductBaseName(product));
                        continue;
                    }
                    System.out.println("to match: " + s + " \tbasename:" + BaseName.extractBaseName(s));
                }
            }
            catch (IOException e2) {
                System.out.println("failure");
            }
        }
    }
}

