/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.archive;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIUtils;
import org.apache.log4j.Logger;
import org.eso.util.archive.NgasHost;

public abstract class RetrieveTask {
    protected static final String NGAS_HEADONFLY_PLUGIN = "ngamsHeaderOnTheFlyDppi";
    protected static final String ADD_IRAF_KEYWORDS = "add_iraf_keywords";
    static final Logger logger = Logger.getLogger(RetrieveTask.class);
    protected HttpClient httpClient;
    protected NgasHost host;
    protected String fileId;
    protected boolean hotflyEnabled;
    protected boolean addIrafKeywords;

    public RetrieveTask(HttpClient httpClient, NgasHost host, String fileId, boolean hotfly, boolean irafKeywords) {
        this.httpClient = httpClient;
        this.host = host;
        this.fileId = fileId;
        this.hotflyEnabled = hotfly;
        this.addIrafKeywords = irafKeywords;
    }

    protected HttpGet prepareHttpCall() throws URISyntaxException {
        String query = "file_id=" + this.fileId;
        if (this.hotflyEnabled) {
            query = query + "&processing=ngamsHeaderOnTheFlyDppi";
            if (this.addIrafKeywords) {
                query = query + "&processing_pars=add_iraf_keywords";
            }
        }
        URI uri = URIUtils.createURI("http", this.host.host, this.host.port, "/RETRIEVE", query, null);
        return new HttpGet(uri);
    }
}

