/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eso.util.dal.PackageFile;
import org.eso.util.dal.PackageInfo;
import org.eso.util.dal.PackageReport;

public class Package {
    private PackageInfo d_info = null;
    private List<PackageReport> d_reports = null;
    private List<PackageFile> d_files = null;
    private Map<String, List<String>> d_auxFiles = null;

    public PackageInfo getInfo() {
        return this.d_info;
    }

    public void setInfo(PackageInfo d_info) {
        this.d_info = d_info;
    }

    public List<PackageFile> getFiles() {
        return this.d_files;
    }

    public void setFiles(List<PackageFile> d_files) {
        this.d_files = d_files;
    }

    public Map<String, List<String>> getAuxFiles() {
        return this.d_auxFiles;
    }

    public void setAuxFiles(Map<String, List<String>> files) {
        this.d_auxFiles = files;
    }

    public List<PackageReport> getReports() {
        return this.d_reports;
    }

    public void setReports(List<PackageReport> d_reports) {
        this.d_reports = d_reports;
    }

    public String toString(ViewMode mode) {
        String res = mode == ViewMode.FILEIDS ? this.toFileIds() : (mode == ViewMode.FINAL ? this.toFinalNames() : (mode == ViewMode.QC ? this.toQCNames() : (mode == ViewMode.STANDARD ? this.toStandardView() : "Unrecognized mode " + mode.toString())));
        return res;
    }

    public String toString() {
        return this.toStandardView();
    }

    public String toStandardView() {
        String res = this.header();
        ArrayList<String> lines = new ArrayList<String>();
        for (PackageFile file : this.d_files) {
            String tmp = "";
            if (file.getFileType() == PackageFile.Type.AUX) {
                tmp = tmp + file.getFilePath() + System.getProperty("file.separator") + file.getFileName() + " [" + file.getFileId() + "]\n";
                for (String auxFile : this.d_auxFiles.get(file.getFileId())) {
                    tmp = tmp + file.getFilePath().replaceAll(".", " ") + "-" + auxFile + "\n";
                }
            } else {
                tmp = tmp + file.getFilePath() + System.getProperty("file.separator") + file.getFileName() + " [" + file.getFileId() + "]\n";
            }
            lines.add(tmp);
        }
        for (PackageReport rep : this.getActiveReports(true)) {
            lines.add(rep.getFileUrl() + "\n");
        }
        Collections.sort(lines);
        for (String line : lines) {
            res = res + line;
        }
        return res;
    }

    public String toQCNames() {
        String res = this.header();
        ArrayList<String> lines = new ArrayList<String>();
        for (PackageFile file : this.d_files) {
            lines.add(file.getFilePath() + System.getProperty("file.separator") + file.getFileName() + "\n");
        }
        for (PackageReport rep : this.getActiveReports(true)) {
            lines.add(rep.getFileUrl() + "\n");
        }
        Collections.sort(lines);
        for (String line : lines) {
            res = res + line;
        }
        return res;
    }

    public String toFinalNames() {
        String res = this.header();
        ArrayList<String> lines = new ArrayList<String>();
        for (PackageFile file : this.d_files) {
            if (file.getFileType() == PackageFile.Type.AUX) {
                for (String auxFile : this.d_auxFiles.get(file.getFileId())) {
                    lines.add(file.getFilePath() + System.getProperty("file.separator") + auxFile + "\n");
                }
                continue;
            }
            lines.add(file.getFilePath() + System.getProperty("file.separator") + file.getFileName() + "\n");
        }
        for (PackageReport rep : this.getActiveReports(true)) {
            lines.add(rep.getFileUrl() + "\n");
        }
        Collections.sort(lines);
        for (String line : lines) {
            res = res + line;
        }
        return res;
    }

    public String toFileIds() {
        String res = this.header();
        ArrayList<String> lines = new ArrayList<String>();
        for (PackageFile file : this.d_files) {
            lines.add(file.getFileId() + "\n");
        }
        Collections.sort(lines);
        for (String line : lines) {
            res = res + line;
        }
        return res;
    }

    private String header() {
        String res = "\nPackage ID: " + this.d_info.getPackageId() + "\n";
        res = res + "Run ID: " + this.d_info.getRunId() + "\n";
        res = res + "Instrument: " + this.d_info.getInstrument() + "\n";
        res = res + "----------------------------------------------\n";
        res = res + "Contents:\n\n";
        return res;
    }

    public List<PackageReport> getActiveReports(boolean includePreservedDirectories) {
        ArrayList<PackageReport> res = new ArrayList<PackageReport>();
        HashSet<String> directories = new HashSet<String>();
        for (PackageFile file : this.d_files) {
            directories.add(file.getFilePath());
        }
        if (includePreservedDirectories) {
            directories.add(".");
        }
        for (PackageReport report : this.d_reports) {
            String url = report.getFileUrl();
            String baseDir = ".";
            int idx = url.lastIndexOf("/");
            if (idx != -1) {
                baseDir = url.substring(0, url.lastIndexOf("/"));
            }
            if (includePreservedDirectories) {
                if (!directories.contains(baseDir) && !baseDir.contains("GEN_INFO")) continue;
                res.add(report);
                continue;
            }
            if (!directories.contains(baseDir)) continue;
            res.add(report);
        }
        return res;
    }

    public List<String> getFileIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (PackageFile file : this.d_files) {
            res.add(file.getFileId());
        }
        return res;
    }

    public static enum ViewMode {
        STANDARD,
        QC,
        FINAL,
        FILEIDS;

    }
}

