/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.datatransfer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eso.util.datatransfer.DefaultTransferRequestValidator;
import org.eso.util.datatransfer.TransferRequestException;
import org.eso.util.datatransfer.TransferRequestValidator;

public class TransferRequest
extends Hashtable<String, String> {
    private String requestFilename;
    private TransferRequestValidator validator = null;
    private static final Hashtable<String, String> TransferRequestDictionary = new Hashtable();
    private static final String BEGIN = "TRANSFER.REQUEST.BEGIN";
    private static final String END = "TRANSFER.REQUEST.END";
    private static final String TYPE_STRING = "STRING";
    private static final String TYPE_INT = "INT";
    private static final String TYPE_BOOLEAN = "BOOLEAN";
    private static final String EOL = System.getProperty("line.separator");
    public static final String FILEID = "FILEID";
    public static final String FILENAME = "FILENAME";
    public static final String UNCOMPRESSED_FILENAME = "UNCOMPRESSED.FILENAME";
    public static final String TRANSFER_METHOD = "TRANSFER.METHOD";
    public static final String TRANSFER_PRIORITY = "TRANSFER.PRIORITY";
    public static final String COMPRESSION_METHOD = "COMPRESSION.METHOD";
    public static final String SIZE = "SIZE";
    public static final String UNCOMPRESSED_SIZE = "UNCOMPRESSED.SIZE";
    public static final String CHECKSUM = "CHECKSUM";
    public static final String TRANSFER_CATG = "TRANSFER.CATG";
    public static final String USER = "USER";
    public static final String DESTDIR = "DESTDIR";
    public static final String MULTI_FILE_COMPONENTS = "MULTI.FILE.COMPONENTS";
    public static final String FORMAT = "FORMAT";
    public static final String RAW_FILE_CATG = "rawfile";
    public static final String TOO_CATG = "too";
    public static final String MULTI_FILE_CATG = "multifile";
    public static final String HEADER_FILE_CATG = "header";
    public static final String TRANSFER_METHOD_DISK = "disk";
    public static final String TRANSFER_METHOD_NETWORK = "network";
    public static final String COMPRESSION_METHOD_NONE = "none";
    public static final String COMPRESSION_METHOD_UNIXCOMPRESS = "unixcompress";
    static Logger logger = Logger.getLogger(TransferRequest.class);
    private static final String classLogName = "TransferRequest";

    public TransferRequest() {
        String methodLogName = "TransferRequest::TransferRequest()";
        logger.trace("TransferRequest::TransferRequest()");
    }

    public TransferRequest(TransferRequest anotherTransferRequest) {
        super(anotherTransferRequest);
        String methodLogName = "TransferRequest::TransferRequest(TransferRequest)";
        logger.trace("TransferRequest::TransferRequest(TransferRequest)");
        this.requestFilename = anotherTransferRequest.requestFilename;
    }

    public TransferRequest(String filename) throws TransferRequestException {
        String methodLogName = "TransferRequest::TransferRequest(String)";
        logger.trace("TransferRequest::TransferRequest(String)");
        this.load(filename);
    }

    public TransferRequest(String filename, TransferRequestValidator validator) throws TransferRequestException {
        String methodLogName = "TransferRequest::TransferRequest(String,TransferRequestValidator)";
        logger.trace("TransferRequest::TransferRequest(String,TransferRequestValidator)");
        if (filename == null) {
            String message = "TransferRequest::TransferRequest(String,TransferRequestValidator) - filename must not be null.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (validator == null) {
            String message = "TransferRequest::TransferRequest(String,TransferRequestValidator) - validator must not be null.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        this.validator = validator;
        this.load(filename);
        if (!validator.isValid(this)) {
            String message = "TransferRequest file is not valid.";
            logger.error(message);
            throw new TransferRequestException(message);
        }
    }

    public void setValidator(TransferRequestValidator validator) {
        String methodLogName = "TransferRequest::setValidator(TransferRequestValidator)";
        logger.trace("TransferRequest::setValidator(TransferRequestValidator)");
        if (validator == null) {
            String message = "TransferRequest::setValidator(TransferRequestValidator) - validator must not be null.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        this.validator = validator;
    }

    public boolean isValid() {
        if (this.validator == null) {
            logger.error("The TransferRequestValidator is not set.");
            return false;
        }
        return this.validator.isValid(this);
    }

    public String getRequestFilename() {
        return this.requestFilename;
    }

    public void setRequestFilename(String f) {
        this.requestFilename = f;
    }

    private void load(String filename) throws TransferRequestException {
        BufferedReader trFileReader;
        String thisMethod = "TransferRequest::load(String)";
        logger.trace(thisMethod);
        if (filename == null) {
            throw new IllegalArgumentException(thisMethod + " - filename must not be null");
        }
        try {
            logger.debug(thisMethod + " - Opening file " + filename);
            trFileReader = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException fnfe) {
            String message = "Could not open file " + filename;
            logger.error(thisMethod + " - " + message);
            throw new TransferRequestException(message, fnfe);
        }
        this.requestFilename = filename;
        boolean endKeywordFound = false;
        try {
            String currentLine = trFileReader.readLine();
            if (currentLine == null) {
                String message = "File " + this.requestFilename + " is empty.";
                logger.error(thisMethod + " - " + message);
                throw new TransferRequestException(message);
            }
            if (!currentLine.equals(BEGIN)) {
                String message = "File " + this.requestFilename + " is not a valid TransferRequest" + " because it doesn't start with '" + BEGIN + "'.";
                logger.error(thisMethod + " - " + message);
                throw new TransferRequestException(message);
            }
            while ((currentLine = trFileReader.readLine()) != null) {
                logger.debug(thisMethod + " - Parsing line: " + currentLine);
                if (endKeywordFound) {
                    String message = "File '" + this.requestFilename + "' is not a valid TransferRequest" + " because it doesn't end with '" + END + "'.";
                    logger.error(thisMethod + " - " + message);
                    throw new TransferRequestException(message);
                }
                if (currentLine.equals(END)) {
                    endKeywordFound = true;
                    continue;
                }
                if (currentLine.trim().equals("")) continue;
                String[] currentCard = currentLine.split("=");
                if (currentCard.length != 2) {
                    String message = "Could not parse line " + currentLine;
                    logger.error(thisMethod + " - " + message);
                    throw new TransferRequestException(message);
                }
                super.put(currentCard[0].trim(), currentCard[1].trim());
            }
            if (!endKeywordFound) {
                String message = "File '" + this.requestFilename + "' is not a valid TransferRequest" + " because it doesn't end with '" + END + "'.";
                logger.error(thisMethod + " - " + message);
                throw new TransferRequestException(message);
            }
        }
        catch (IOException ioe) {
            String message = "An IO error occurred whilst reading from TRQ file '" + this.requestFilename + "'.";
            logger.error(thisMethod + " - " + message);
            throw new TransferRequestException(message, ioe);
        }
        finally {
            try {
                logger.debug(thisMethod + " - Closing file " + filename);
                trFileReader.close();
            }
            catch (IOException ioe) {
                String message = "Could not close file " + filename;
                logger.error(thisMethod + " - " + message);
                throw new TransferRequestException(message, ioe);
            }
        }
    }

    public void save(String filename) throws TransferRequestException {
        String thisMethod = "TransferRequest::save()";
        if (filename == null) {
            throw new IllegalArgumentException(thisMethod + " - filename must not be null");
        }
        if (this.isEmpty()) {
            String message = "Could not save empty TransferRequest.";
            logger.error(message);
            throw new TransferRequestException(message);
        }
        try {
            FileWriter trFileWriter = new FileWriter(new File(filename));
            trFileWriter.write(BEGIN);
            trFileWriter.write(EOL);
            for (String key : this.keySet()) {
                String value = (String)super.get(key);
                String currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            trFileWriter.write(END);
            trFileWriter.close();
        }
        catch (IOException ioe) {
            String message = "Could not open TRQ file " + filename;
            logger.error(message);
            throw new TransferRequestException(message, ioe);
        }
        this.requestFilename = filename;
    }

    public Integer getPropertyAsInt(String key) throws TransferRequestException {
        if (!TransferRequestDictionary.containsKey(key)) {
            String message = "Keyword '" + key + "' is not in the dictionary.";
            logger.error(message);
            throw new TransferRequestException(message);
        }
        String keyType = TransferRequestDictionary.get(key);
        if (keyType != TYPE_INT) {
            String message = "Requested INT value for keyword '" + key + "', which has type " + keyType;
            logger.error(message);
            throw new TransferRequestException(message);
        }
        if (this.containsKey(key)) {
            return new Integer((String)super.get(key));
        }
        return null;
    }

    public String getPropertyAsString(String key) throws TransferRequestException {
        if (!TransferRequestDictionary.containsKey(key)) {
            String message = "Keyword '" + key + "' is not in the dictionary.";
            logger.error(message);
            throw new TransferRequestException(message);
        }
        String keyType = TransferRequestDictionary.get(key);
        if (keyType != TYPE_STRING) {
            String message = "Requested STRING value for keyword '" + key + "', which has type " + keyType;
            logger.error(message);
            throw new TransferRequestException(message);
        }
        return (String)super.get(key);
    }

    public Boolean getPropertyAsBoolean(String key) throws TransferRequestException {
        if (!TransferRequestDictionary.containsKey(key)) {
            String message = "Keyword '" + key + "' is not in the dictionary.";
            logger.error(message);
            throw new TransferRequestException(message);
        }
        String keyType = TransferRequestDictionary.get(key);
        if (keyType != TYPE_BOOLEAN) {
            String message = "Requested BOOLEAN value for keyword '" + key + "', which has type " + keyType;
            logger.error(message);
            throw new TransferRequestException(message);
        }
        if (this.containsKey(key)) {
            return new Boolean((String)super.get(key));
        }
        return null;
    }

    public Boolean isValidProperty(String key) throws TransferRequestException {
        Boolean isValid = true;
        if (!TransferRequestDictionary.containsKey(key)) {
            String message = "Keyword '" + key + "' is not in the dictionary.";
            logger.error(message);
            throw new TransferRequestException(message);
        }
        String keyType = TransferRequestDictionary.get(key);
        String keyValue = (String)super.get(key);
        if (keyType == TYPE_INT) {
            try {
                Integer.valueOf(keyValue);
            }
            catch (NumberFormatException e2) {
                String message = "NumberFormatException " + e2.getMessage() + " " + key + " value is not a valid integer";
                logger.error(message);
                isValid = false;
            }
        }
        return isValid;
    }

    public void setProperty(String key, String value) throws TransferRequestException {
        this.setProperty(key, TYPE_STRING, value);
    }

    public void setProperty(String key, int value) throws TransferRequestException {
        this.setProperty(key, TYPE_INT, value);
    }

    private void setProperty(String key, String type, Object value) throws TransferRequestException {
        if (!TransferRequestDictionary.containsKey(key)) {
            String message = "Keyword '" + key + "' is not in the dictionary.";
            logger.error(message);
            throw new TransferRequestException(message);
        }
        String keyType = TransferRequestDictionary.get(key);
        if (keyType != type) {
            String message = "Keyword '" + key + "' must have type '" + keyType + "' not '" + type + "'.";
            logger.error(message);
            throw new TransferRequestException(message);
        }
        super.put(key, value.toString());
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TransferRequest tr = new TransferRequest();
        String filename = "c:\\temp\\pippo.trq";
        String filename2 = "c:\\temp\\pippo2.trq";
        try {
            tr.setProperty(FILENAME, "/tmp/pippo");
            tr.setProperty(FILEID, "pippo");
            tr.setProperty(SIZE, 999);
            tr.save(filename);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            TransferRequest tr2 = new TransferRequest(filename);
            logger.debug(tr2.getRequestFilename());
            logger.debug(tr2.getPropertyAsString(FILENAME));
            logger.debug(tr2.getPropertyAsInt(SIZE));
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        try {
            TransferRequest tr3 = new TransferRequest(filename2, new DefaultTransferRequestValidator());
        }
        catch (TransferRequestException e4) {
            e4.printStackTrace();
        }
    }

    static {
        TransferRequestDictionary.put(FILEID, TYPE_STRING);
        TransferRequestDictionary.put(FILENAME, TYPE_STRING);
        TransferRequestDictionary.put(UNCOMPRESSED_FILENAME, TYPE_STRING);
        TransferRequestDictionary.put(TRANSFER_METHOD, TYPE_STRING);
        TransferRequestDictionary.put(TRANSFER_PRIORITY, TYPE_INT);
        TransferRequestDictionary.put(COMPRESSION_METHOD, TYPE_STRING);
        TransferRequestDictionary.put(SIZE, TYPE_INT);
        TransferRequestDictionary.put(UNCOMPRESSED_SIZE, TYPE_INT);
        TransferRequestDictionary.put(CHECKSUM, TYPE_INT);
        TransferRequestDictionary.put(TRANSFER_CATG, TYPE_STRING);
        TransferRequestDictionary.put(USER, TYPE_STRING);
        TransferRequestDictionary.put(DESTDIR, TYPE_STRING);
        TransferRequestDictionary.put(MULTI_FILE_COMPONENTS, TYPE_STRING);
    }
}

