/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.stream;

import org.apache.log4j.Logger;
import org.eso.util.stream.Message;
import org.eso.util.stream.Module;
import org.eso.util.stream.Task;

public abstract class RoutingTask
implements Task {
    static final Logger logger = Logger.getLogger(RoutingTask.class);
    private static final String classLogName = "RoutingTask";
    private Module containingModule = null;
    private final String taskName;
    private boolean taskOpen = false;
    private Task nextTask = null;

    public RoutingTask() {
        String methodLogName = "RoutingTask::RoutingTask() [for task RoutingTask]";
        logger.trace("RoutingTask::RoutingTask() [for task RoutingTask]");
        this.taskName = classLogName;
    }

    public RoutingTask(String taskName) throws NullPointerException {
        String methodLogName = "RoutingTask::RoutingTask(String) [for task " + taskName + "]";
        logger.trace(methodLogName);
        if (taskName == null) {
            String message = methodLogName + " - taskName must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        this.taskName = taskName;
    }

    @Override
    public final void open() {
        String methodLogName = "RoutingTask::open() [for task " + this.taskName + "]";
        logger.trace(methodLogName);
        logger.debug(methodLogName + " - opening task.");
        this.taskOpen = true;
    }

    @Override
    public final boolean isOpen() {
        String methodLogName = "RoutingTask::isOpen() [for task " + this.taskName + "]";
        logger.trace(methodLogName);
        return this.taskOpen;
    }

    @Override
    public final void close() {
        String methodLogName = "RoutingTask::close() [for task " + this.taskName + "]";
        logger.trace(methodLogName);
        logger.debug(methodLogName + " - closing task.");
        this.taskOpen = false;
    }

    @Override
    public final void restart() {
        String methodLogName = "RoutingTask::restart() [for task " + this.taskName + "]";
        logger.trace(methodLogName);
        logger.debug(methodLogName + " - restarting task.");
        this.close();
        this.open();
    }

    @Override
    public abstract Message get();

    @Override
    public abstract Message get(long var1);

    @Override
    public abstract void put(Message var1);

    @Override
    public abstract void putNext(Message var1);

    @Override
    public final String getTaskName() {
        String methodLogName = "RoutingTask::getTaskName() [for task " + this.taskName + "]";
        logger.trace(methodLogName);
        return this.taskName;
    }

    @Override
    public final Task getNextTask() {
        String methodLogName = "RoutingTask::getNextTask() [for task " + this.taskName + "]";
        logger.trace(methodLogName);
        return this.nextTask;
    }

    @Override
    public final Task setNextTask(Task task) {
        String methodLogName = "RoutingTask::setNextTask() [for task " + this.taskName + "]";
        logger.trace(methodLogName);
        if (this.isOpen()) {
            String logMessage = methodLogName + " - task must not be open when calling this method.";
            logger.fatal(logMessage);
            throw new AssertionError((Object)logMessage);
        }
        Task oldTask = this.nextTask;
        this.nextTask = task;
        logger.debug(methodLogName + " - next task set [previously: " + (oldTask == null ? "null][now: " : oldTask.getTaskName() + "][now: ") + (this.nextTask == null ? "null]." : this.nextTask.getTaskName() + "]."));
        return oldTask;
    }

    @Override
    public final Module getContainingModule() {
        String methodLogName = "RoutingTask::getContainingModule() [for task " + this.taskName + "]";
        logger.trace(methodLogName);
        return this.containingModule;
    }

    @Override
    public final Module setContainingModule(Module module) {
        String methodLogName = "RoutingTask::setContainingModule() [for task " + this.taskName + "]";
        logger.trace(methodLogName);
        if (this.isOpen()) {
            String logMessage = methodLogName + " - task must not be open when calling this method.";
            logger.fatal(logMessage);
            throw new AssertionError((Object)logMessage);
        }
        Module oldModule = this.containingModule;
        this.containingModule = module;
        logger.debug(methodLogName + " - containing module set.");
        return oldModule;
    }
}

