/*============================================================================*
 *============================================================================*
 * Component:           ls_mode_pages
 * Filename:            ls_mode_pages.c
 *                                                                             
 * Authors:             Georg Huettenegger
 *                                                                             
 * Date of Creation:    Sat Jan 9 16:04:28 2001
 *                                                                             
 * Last Modification:   Sat Jan 9 16:04:28 2001
 *                                                                             
 * Copyright:           Georg Huettenegger                                   
 *                                                                             
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                             
 *============================================================================*
 *============================================================================*
 */

#include "plextor-tool.h"

char *argv0;

void usage ()
{
  fprintf (stderr, "Usage: %s DEVICE\n", argv0);
#ifdef __linux__
  fprintf (stderr, "Example: %s /dev/sg0\n", argv0);
#endif
#if (defined WIN32) || (defined _WIN32)
  fprintf (stderr, "Example: %s 1 6\n", argv0);
#endif
}

void list_pages (void)
{
  const unsigned char * pages_result;
  int i, length, iter;

  pages_result = ModeSenseAllPages ();
  length = *pages_result;
  i = 12; /* start index for page number */
  while (i < length)
  {
    printf ("\npage with code: 0x%x (size: %d bytes):\n", *(pages_result+i),
	    *(pages_result+i+1));
    for (iter = i+2; iter < i+2+*(pages_result+i+1); ++iter)
    {
      printf ("0x%.2x ", *(pages_result+iter));
    }
    printf ("\n");
    i += *(pages_result+i+1) + 2;
  }
}

int main (int argc, char *argv[])
{
  char *drive_name_part1 = NULL, *drive_name_part2 = NULL;
  argv0 = argv[0];

#ifdef __linux__
  if (argc != 2)
#else
#if (defined WIN32) || (defined _WIN32)
  if (argc != 3)
#else
#error "Unsupported OS"
#endif
#endif
  {
    usage ();
    exit (-1);
  }
  
  /* just be as verbose as possible */
  verbose = 1;

  /* now store our drive_name in the variable(s) */
  drive_name_part1 = argv[1];

#if (defined WIN32) || (defined _WIN32)
  /* just in case set force to 1 */
  force = 1;
  drive_name_part2 = argv[2];
  if (!windows_initialize_scsi ())
  {
    printf ("Could not initialize correctly! Aborting!\n");
    exit (1);
  }
#endif

  /* open the drive or store the drive information */
#ifdef __linux__
  if ((fd = open(drive_name_part1, O_RDWR)) < 0)
  {
    printf ("Cannot open device: %s!\n", drive_name_part1);
    exit (2);
  }
#endif

#if (defined WIN32) || (defined _WIN32)
  pbt->byHaId = atoi (drive_name_part1);
  pbt->byTarget = atoi (drive_name_part2);
#endif

  /* now list all pages */
  list_pages ();

  /* cleanup */
#if (defined WIN32) || (defined _WIN32)
  TermASPI ();
#endif

  return 0;
}

/*============================================================================*
 *============================================================================*
 * EOF ls_mode_pages.c
 *============================================================================*
 *============================================================================*
 */
