/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	"encoding/json"
)

// DBRPUpdate struct for DBRPUpdate
type DBRPUpdate struct {
	// A [retention policy](https://docs.influxdata.com/influxdb/v1.8/concepts/glossary/#retention-policy-rp) name. Identifies the InfluxDB v1 retention policy mapping.
	RetentionPolicy *string `json:"retention_policy,omitempty" yaml:"retention_policy,omitempty"`
	// Set to `true` to use this DBRP mapping as the default retention policy for the database (specified by the `database` property's value). To remove the default mapping, set to `false`.
	Default *bool `json:"default,omitempty" yaml:"default,omitempty"`
}

// NewDBRPUpdate instantiates a new DBRPUpdate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDBRPUpdate() *DBRPUpdate {
	this := DBRPUpdate{}
	return &this
}

// NewDBRPUpdateWithDefaults instantiates a new DBRPUpdate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDBRPUpdateWithDefaults() *DBRPUpdate {
	this := DBRPUpdate{}
	return &this
}

// GetRetentionPolicy returns the RetentionPolicy field value if set, zero value otherwise.
func (o *DBRPUpdate) GetRetentionPolicy() string {
	if o == nil || o.RetentionPolicy == nil {
		var ret string
		return ret
	}
	return *o.RetentionPolicy
}

// GetRetentionPolicyOk returns a tuple with the RetentionPolicy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DBRPUpdate) GetRetentionPolicyOk() (*string, bool) {
	if o == nil || o.RetentionPolicy == nil {
		return nil, false
	}
	return o.RetentionPolicy, true
}

// HasRetentionPolicy returns a boolean if a field has been set.
func (o *DBRPUpdate) HasRetentionPolicy() bool {
	if o != nil && o.RetentionPolicy != nil {
		return true
	}

	return false
}

// SetRetentionPolicy gets a reference to the given string and assigns it to the RetentionPolicy field.
func (o *DBRPUpdate) SetRetentionPolicy(v string) {
	o.RetentionPolicy = &v
}

// GetDefault returns the Default field value if set, zero value otherwise.
func (o *DBRPUpdate) GetDefault() bool {
	if o == nil || o.Default == nil {
		var ret bool
		return ret
	}
	return *o.Default
}

// GetDefaultOk returns a tuple with the Default field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DBRPUpdate) GetDefaultOk() (*bool, bool) {
	if o == nil || o.Default == nil {
		return nil, false
	}
	return o.Default, true
}

// HasDefault returns a boolean if a field has been set.
func (o *DBRPUpdate) HasDefault() bool {
	if o != nil && o.Default != nil {
		return true
	}

	return false
}

// SetDefault gets a reference to the given bool and assigns it to the Default field.
func (o *DBRPUpdate) SetDefault(v bool) {
	o.Default = &v
}

func (o DBRPUpdate) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.RetentionPolicy != nil {
		toSerialize["retention_policy"] = o.RetentionPolicy
	}
	if o.Default != nil {
		toSerialize["default"] = o.Default
	}
	return json.Marshal(toSerialize)
}

type NullableDBRPUpdate struct {
	value *DBRPUpdate
	isSet bool
}

func (v NullableDBRPUpdate) Get() *DBRPUpdate {
	return v.value
}

func (v *NullableDBRPUpdate) Set(val *DBRPUpdate) {
	v.value = val
	v.isSet = true
}

func (v NullableDBRPUpdate) IsSet() bool {
	return v.isSet
}

func (v *NullableDBRPUpdate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDBRPUpdate(val *DBRPUpdate) *NullableDBRPUpdate {
	return &NullableDBRPUpdate{value: val, isSet: true}
}

func (v NullableDBRPUpdate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDBRPUpdate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
