/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTrigger;
import org.jkiss.dbeaver.ext.oracle.model.OracleTriggerColumn;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;

public class OracleTableTrigger
extends OracleTrigger<OracleTableBase> {
    private static final Log log = Log.getLog(OracleTableTrigger.class);
    private OracleSchema ownerSchema;
    private List<OracleTriggerColumn> columns;

    public OracleTableTrigger(OracleTableBase table, String name) {
        super(table, name);
        this.ownerSchema = table.getSchema();
    }

    public OracleTableTrigger(OracleTableBase table, ResultSet dbResult) {
        super(table, dbResult);
        String ownerName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"OWNER");
        if (ownerName != null) {
            this.ownerSchema = (OracleSchema)((OracleDataSource)table.getDataSource()).schemaCache.getCachedObject(ownerName);
            if (this.ownerSchema == null) {
                log.warn((Object)("Trigger owner schema '" + ownerName + "' not found"));
            }
        }
        if (this.ownerSchema == null) {
            this.ownerSchema = table.getSchema();
        }
    }

    @Property(viewable=true, order=4)
    public OracleTableBase getTable() {
        return (OracleTableBase)this.parent;
    }

    @Override
    public OracleSchema getSchema() {
        return this.ownerSchema;
    }

    @Association
    @Nullable
    public Collection<OracleTriggerColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(@NotNull List<OracleTriggerColumn> columns) {
        this.columns = columns;
    }
}

