/*********************************************%***********************

    This file is part of ETSwitch
    Copyright (C) 2004, 2005, 2006  Nicklas Larsson - etswitch@gmail.com - All rights reserved.

    etswitch - switch to desktop

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

********************************************************************/
/*    $Id: etswitch.c,v 1.96 2005/04/14 18:42:18 larsson Exp $ */

#if HAVE_CONFIG_H
# include <config.h>	/* autotool generated ifdef's */
#endif

#include <fcntl.h>	/* locking over nfs */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/ioctl.h>	/* for sending/geting data from special device */
#include <sys/file.h>	/* bsd? */


/* audio */
#include <sys/ioctl.h>	/* +term detect */
#ifdef FREEBSD
#include <machine/soundcard.h>
#endif
#ifdef LINUX
#include <linux/soundcard.h>
#endif

#include <dirent.h>	/* for scandir usage */
#include <libgen.h>	/* dirname / basename */

#include <pwd.h>	/* for getting home/user dir/settings */
#include <sys/types.h>	/* kill / stat */

#include <sys/stat.h>	/* for file info/stat */

#include <X11/X.h>	/* X11 */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/xpm.h>	/* xpm */

#include <X11/Xos.h>
#include <X11/Xmu/WinUtil.h>
#include <X11/keysym.h>

#ifdef HAVE_X11_EXTENSIONS_RECORD_H
#include <X11/extensions/record.h>
#endif



/* for gamma and audio constants */
#define GAME 1
#define DESKTOP 0

#include <malloc.h>
#include <linux/limits.h>

#include <signal.h>	/* signal handler */
#include <sys/time.h>
#include <sys/types.h>	/* kill */



#include <sys/resource.h>	/* resources */

#include "../ico/etswitch.xpm"	/* icon */

#include "etswitch.h" 		/* etswitch */
#include "read_wid.h" 		/* etswitch */
#include "conf.h" 		/* etswitch */
/*
#ifdef LINUX_JOYSTICK
#include "joystick.h" 	
#endif
*/

/*
#include "screenshot.h"
*/
#include <errno.h>
extern int errno;

char *mixer_device;
int mixer_control;

win_struct win;			/* main */
game_info_struct game_info;	/* game info */
XEvent XE;			/* fix me */

/* global, change to bool */
int use_mixer=1;	/* use mixer features by default */
int use_gui=1;		/* use gui interface by default */
int is_tty=1;		/* assume we are in a tty */
int running=1;		/* main loop */
int force=0;		/* enable force start */
int delay=1;		/* man made delays */
int use_repos=0;	/* please fix me */

int renice=0;		/* broken atm */
int df=0;		/* please fix me */

int no_hard=0;		/* please fix me, dont do hardcoded key */
int no_dgawaring=0;	/* do dga warning */

int last_err=0;		/* please fix me.... :( */

int fpid=0;		/* please fix me, keyfork2 pid */

int mapunmap_a = 0;	/* please fix me */

int errorHandler( Display *dpy, XErrorEvent *e){
#ifdef DEBUG
    char errorText[1024];
    if(last_err != 1){	/* filter def inp source loop debug */
	XGetErrorText(dpy, e->error_code, errorText, sizeof(errorText));
	fprintf(stderr,"X Error: %s\n", errorText);
	if(last_err != 0){	/* try to nail down possible man made errors */
    	    fprintf(stderr,"X Error last: %i\n", last_err);
	    last_err = 0;
	}

    }
#endif
    return(0);	/* just let it pass */
}

/* fatal error handler */
void ioerrorHandler(Display *d){
    fprintf(stderr,"*** FATAL X IO Error pid: %i ***\n", fpid);
 /* kill all children */    
/*
    lol, please i dont know why this is here.. sorry guys :)
    (this is kind of an leftover, however then there is no check on fpid what so ever.. well.. )
    
    if(kill(fpid, SIGTERM) == -1){  
	fprintf(stderr, "kill failed: %s.\n", strerror(errno));
    }
*/
}



void usage(void){
	fprintf(stdout, "Usage: etswitch [-d | --display DISPLAY] [[-c | --config] [-m | --mixer] | [-nm | --no-mixer] [-ng | --no-gui]]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Switches to desktop.\n");
	fprintf(stdout, "\n");
	fprintf(stdout, " -h, --help			prints this message\n");
	fprintf(stdout, " -d, --display host:dpy		X server to contact, defaults to enviorment\n");
	fprintf(stdout, "				variable $DISPLAY\n\n");
	fprintf(stdout, " -v, --version			print version info\n");
	fprintf(stdout, " -c, --config			enter interactive mode\n\t\t\t\tlet you select your switch key\n");
	fprintf(stdout, " -m, --mixer device		mixer device, defaults to /dev/mixer\n");
	fprintf(stdout, " -mc, --mixer-control  control	mixer control, defaults to Vol(0)\n");
	fprintf(stdout, " -f, --force			forces start\n\t\t\t\t** make sure you know why you use this **\n\t\t\t\t** option before using it **\n");
	fprintf(stdout, " -wc, --write-conf		writes the default wid file\n"); 
	fprintf(stdout, " -nd, --no-delay		no delays\n");
	fprintf(stdout, " -nn, --no-nice			disable renice feature\n");
	fprintf(stdout, " -nm, --no-mixer		disable mixer feature\n");
	fprintf(stdout, " -ng, --no-gui			no gui window\n");
	fprintf(stdout, " -nw, --no-warning		disable the XFree86-DGA warning\n");
	fprintf(stdout, " -nh, --no-hard			disable Super_L/Super_R+z|s key\n");
#ifdef HAVE_LIBXXF86VM
	fprintf(stdout, " -r, --repos			reposition of the game window\n");
#endif
#ifdef DEBUG
	fprintf(stdout, " -dump			\n");
#endif
	fprintf(stdout, "\n");
	fprintf(stdout, "Comments/ideas/improvments/bug reports/patches/money are always welcome to:\n Nicklas Larsson <etswitch@gmail.com>, <irc://etswitch@quakenet/>\n");
	fprintf(stdout, "The author of etswitch is unemployed so if your company is hiering he is\nlooking for work.\n");
	exit(EXIT_SUCCESS);
}

void version(void){
    fprintf(stdout, "%s\n",PACKAGE_STRING);
    exit(EXIT_SUCCESS);
}
/*			1	 2	 3	  4	   5	    6	*/
int signals[] = { SIGHUP, SIGINT, SIGQUIT, SIGUSR1, SIGTERM, SIGXCPU };
#define signals_n (sizeof(signals) / sizeof(signals[0]))
/* pointer to a signal handler */
typedef void (*sighandler_t)(int);

/* pointers to original signal handlers */
sighandler_t sig[signals_n];

void signal_handler(int signal_number){
    /* print some useful information */
    /* pick one */
    /* reset the signal to its default behavior */
    /* ANSI C does this automatically */
/*    signal(signal_number, SIG_DFL); */

    /* reset the signal to its previous behavior */
/*    signal(signal_number, sig[signal_number]); */

    /* reset the signal to its current behavior */
    /* BSD does this automatically */
    signal(signal_number, signal_handler);
    switch(signal_number){

	case 15:
	    #ifdef DEBUG
	    printf("signal_handler: Terminating.. :%i\n",fpid);
	    #endif
	    running = 0;
	break;
	case 6:
	    #ifdef DEBUG
	    printf("signal_handler: Aborting..\n");
	    #endif
	break;
	case SIGHUP:
	    #ifdef DEBUG
	    printf("signal_handler: HUP..\n");
	    #endif
	    readwid_conf();	    /* re-read wid file */
	break;
	case SIGUSR1:
	    #ifdef DEBUG
	    printf("signal_handler: SIGUSR1..\n");
	    #endif
	    /* do switch
	    mapunmap_a = 0;
	    mapunmap2(win.root, win.d);
	    Xlib: sequence lost :(
	    */
	break;
	default:
	    fprintf(stdout,"signal_handler: undefined signal %d received, hang on.. quiting\n", signal_number);
	    running = 0;
	break;
    }    
}

void eng (Window w, char client_data, XEvent *event, Bool *continue_to_dispatch){
    printf("ENG: \n");
}

int main(int argc, char *argv[]){

    int i;
    unsigned int is;		/* signal handler setup */

    /* | StructureNotifyMask; */
    /* int hook_mask = KeyReleaseMask | SubstructureNotifyMask | VisibilityChangeMask; */
    /* unsigned long hook_mask = KeyReleaseMask | SubstructureNotifyMask; */
    /* change to DEFINE */    

    /* StructureNotifyMask as Destroy notify now */
    long int gui_mask = ButtonPress  | ExposureMask | VisibilityChangeMask | StructureNotifyMask;	/* engine2 */    

    /* Event handler */
    XEvent event;
    
    KeySym key, look_key;

    /* lock file */
    int lock_fd;
    char *lock_file;

    /* hook engine 2 */
    char	*char_ptr, buf1[32], buf2[32], *keys, *saved;

    int	u_delay=10000; 

    char *key_string;

    /* KeySym look_key; */
    KeyCode look_code; /* conf key(kaysym) as keycode */

    int dbl = 0;	/* we get both the press and release, skipping some tests
			    in main loop(precius cpu time) so we save some.. stupid i know */

    /* new mimic alt+z thingy */
    int alt_pressed = 0;
    int z_pressed = 0;
    int s_pressed = 0;

    KeyCode	ALT, LW, RW, Z, S;    /* init hardcoded KeySyms */
/*
    readwid_internal_conf(); */		/* read the internal list to wid */
/*
    if(wid != NULL){
        printf("----- LOOPIE ----- \n"); 
        loopie((wid_info_struct *)wid->first_struct);
    }
    exit(1);
*/

    /* init mutex */
#ifdef HAVE_LIBPTHREAD
/* pthread_mutex_init always returns 0. The other mutex functions return 0
       on success and a non-zero error code on error. */
#endif

#ifdef DEBUG
    fprintf(stdout, "path max: %i, name max: %i, conf_str_l: \n",PATH_MAX, NAME_MAX);

/*    struct rlimit rl; */
    /*	RLIMIT_CPU	seconds
	RLIMIT_DATA	memory alloc
	RLIMIT_NPROC	nr of procs
	RLIMIT_NOFILE	nr max fh
    */
/*    
    getrlimit(RLIMIT_CPU, &rl);
    fprintf(stdout, "Hard limit: %i\n",rl.rlim_max);
    fprintf(stdout, "Soft limit: %i\n",rl.rlim_cur);

    rl.rlim_cur = 1;
*/
/*    setrlimit(RLIMIT_CPU, &rl); */
    /*
    set soft limit
	{ fix sig handler:  abort loops if SIGXCPU } 
    
    */
/*int getrusage(int who, struct rusage *rusage)

*/
#endif
/*
    int pid = sc("et.bin");
    if(pid){
	printf("has pid: %i\n",pid);    
    }
    exit(1); 
*/    

#ifdef LINUX_JOYSTICK
/*
    fprintf(stdout,"linux joystick support enabled\n");
    int joy_fd = 0;
    joy_fd = joystick_open_device("/dev/input/js0");
    fprintf(stdout,"device: %i\n", joy_fd);
    int aa = joystick_get_boss(joy_fd);
    int joy_test = joystick_read(joy_fd);
    fprintf(stdout,"test: %i\n", joy_fd);
*/
#endif

    readwid_conf();	/* read the internal list or wid file, saved to global *wid struct */

/*
    critical_info("This is critical info message\nompaompa");
*/
    /* are we in a tty */
    is_tty=isatty(1);


    for (i=1; argv[i]; i++) {
	if (!strcmp(argv[i], "-d") || !strcmp(argv[i], "--display")) 
	    win.display_name = argv[i+1];
	if (!strcmp(argv[i], "-h") || !strcmp(argv[i], "--help")) 
	    usage();
	if (!strcmp(argv[i], "-v") || !strcmp(argv[i], "--version")) 
	    version();
	if (!strcmp(argv[i], "-c") || !strcmp(argv[i], "--config")){
	    select_bosskey();
	    exit(EXIT_SUCCESS);
	}
	if (!strcmp(argv[i], "-m") || !strcmp(argv[i], "--mixer")) 
	    mixer_device = argv[i+1];
	if (!strcmp(argv[i], "-nm") || !strcmp(argv[i], "--no-mixer")) 
	    use_mixer = 0;
	if (!strcmp(argv[i], "-mc") || !strcmp(argv[i], "--mixer-control")){ 
	    char *device_list[SOUND_MIXER_NRDEVICES] = SOUND_DEVICE_LABELS;
	    if(argv[i+1]){
		/*#strz cmp*/
	        int ic;
		/* should change to mask */
		for(ic=0; ic < SOUND_MIXER_NRDEVICES; ic++){
    		if(!strncmp(argv[i+1],device_list[ic],strlen(argv[i+1]))){		/* hmm, some are padded */
		    printf("Matched -> %s\n",device_list[ic]);
		    mixer_control = ic;
		    ic=SOUND_MIXER_NRDEVICES+1;
		}else{
		    printf("nehe -> '%s'\n",device_list[ic]);
		}
		}
	    }else{
		printf("you must supply a mixer control name. ie %s\n",device_list[4]);
		exit(EXIT_FAILURE);
	    }    
	}
	if (!strcmp(argv[i], "-ng") || !strcmp(argv[i], "--no-gui")) 
	    use_gui = 0;
	if (!strcmp(argv[i], "-f") || !strcmp(argv[i], "--force")) 
	    force = 1;
	if (!strcmp(argv[i], "-nn") || !strcmp(argv[i], "--no-nice")) 
	    renice = 0;
	if (!strcmp(argv[i], "-nd") || !strcmp(argv[i], "--no-delay")) 
	    delay = 0;
	if (!strcmp(argv[i], "-nh") || !strcmp(argv[i], "--no-hard")) 
	    no_hard = 1;
	if (!strcmp(argv[i], "-nw") || !strcmp(argv[i], "--no-warning")) 
	    no_dgawaring = 1;
	if (!strcmp(argv[i], "-r") || !strcmp(argv[i], "--repos")) 
	    use_repos = 1;
	if (!strcmp(argv[i], "-wc") || !strcmp(argv[i], "--write-conf")) 
	    writewid_conf();/* write default wid */

	#ifdef DEBUG
	if (!strcmp(argv[i], "-dump") || !strcmp(argv[i], "--dump")){
	    win_init();    		/* connect to server */ 
	    if(argv[i+1]){
		DUMP(atoi(argv[i+1]));	/* string to int */
	    }else{
		DUMP(win.root);
	    }
	    exit(EXIT_SUCCESS);
	}
	#endif
    }

    if ((getuid() == 0 || geteuid() == 0) && force == 0){    /* stupid check */
        critical_info("Please change to another user acount.\nYou should run etswitch as normal user, please dont run this as root.\nIt's for your own safety\n");
 	exit(EXIT_FAILURE);
    }

    /* setup sighandler */
    for (is = 0; is < signals_n; is++){
	sig[is] = signal(signals[is], signal_handler);
	if (sig[is] == SIG_ERR){
    	    char buffer[128];
	    snprintf(buffer, 128,"%s: signal(%i, signal_handler) failed", argv[0], signals[is]);
	    perror(buffer);
	    exit(EXIT_FAILURE);
	}
    }

    if(mixer_device == NULL){
	mixer_device = "/dev/mixer";
	#ifdef DEBUG
	fprintf(stdout, "Using '%s' as default mixer device.\n", mixer_device);
	#endif
    }
    /* setup lock, fixme */
    /* use temp var */
    lock_file = "/tmp/.etswitch.pid";    /* now this isnt failsafe but at least something */
    lock_fd = open(lock_file, O_CREAT | O_RDWR);
    if (lock_fd < 0) {
	#ifdef DEBUG
	fprintf(stdout, "'%s' allready exits, will try to open.\n",lock_file);
	#endif
	lock_fd = open(lock_file, O_RDWR);
	if (lock_fd < 0) {
	    #ifdef DEBUG
	    fprintf(stdout, "'%s' cant open pid RW.\n",lock_file);
	    #endif
	}
    }

    if(chmod(lock_file, S_IRWXU | S_IRWXG | S_IRWXO)){
	#ifdef DEBUG
        fprintf(stderr,"Can't set perm on file '%s'\n",lock_file);
	#endif
    }

    if (lock_fd < 0) {
	if(force == 0){
	    critical_info("Error open/creating lockfile, disk full? please check/remove file '/tmp/.etswitch.pid'");
	    exit(EXIT_FAILURE);
	}
    }else{
	if(flock(lock_fd,LOCK_EX | LOCK_NB)){
	    /* hmm, cant lock it, other process is locking it */
	    char pid[128];	/* ful hack(tm) */
	    char buffer[128];	/* ful hack(tm) */
	    int sr;

	    sr = read(lock_fd, pid, 128);
	    if(sr == -1){
		fprintf(stderr, "read failed: %s, at line: %d\n", strerror(errno),__LINE__);
	    }else if(sr<128){
		snprintf(buffer, sr+1,"%s", pid);
	    }
	    snprintf(pid, 49+sr+1, "It looks like etswitch is allready running, pid: %s", buffer);
	    critical_info(pid);
	    if(force == 0){
		close(lock_fd);
		exit(EXIT_FAILURE);
	    }
	}else{ /* flock ok */
	    int sr;
    	    int pid_length;
	    char pid[128];	/* ful hack(tm) */
	    snprintf((char *)pid, 128, "%i", getpid());
	    pid_length = strlen(pid);
	    sr = write(lock_fd, pid, pid_length);
	    if(sr != pid_length){
		fprintf(stderr, "write failed: %s, %i at line: %d\n", strerror(errno), lock_fd,__LINE__);
	    }
	}/* if(flock(lock_fd,LOCK_EX + LOCK_NB)){ */
    }/* if (lock_fd < 0) */


    /* merge please ! */
    if(win.display_name == NULL){
        win.display_name = getenv("DISPLAY");
    }
    if(win.display_name == NULL){
        win.display_name = ":0.0";
    }    
    
    win_init();    		/* connect to server */ 

    /* xev program */
    #ifdef HAVE_LIBXXF86VM
    get_res();		/* read server resolutions */
    save_res(0);	/* save desktop */
    #endif

    /* our gui window event's */
    XSelectInput(win.d, win.w, gui_mask);

    /* eng2 init */
    /* XSynchronize(disp, 1); */
    /* setup buffers */
    saved=buf1; keys=buf2;
    XQueryKeymap(win.d, saved);

    look_key = read_conf();
    look_code = XKeysymToKeycode(win.d, look_key);

    win.screen = DefaultScreen(win.d);
    win.root = RootWindow(win.d, win.screen);

    /* init hardcoded KeySyms */
    ALT = XKeysymToKeycode(win.d, XStringToKeysym("Alt_L"));
    LW  = XKeysymToKeycode(win.d, XStringToKeysym("Super_L"));
    RW  = XKeysymToKeycode(win.d, XStringToKeysym("Super_R"));
    Z   = XKeysymToKeycode(win.d, XStringToKeysym("z"));
    S   = XKeysymToKeycode(win.d, XStringToKeysym("s"));

    /* interactive */
    if(is_tty){
	/* input is term */
	fprintf(stdout, "Ready.\n");
    }

    /* old Event loop, its moving.. */
    while(running){

	if(XCheckWindowEvent(win.d, win.w, gui_mask, &event)){
	    switch(event.type){
	    case MappingNotify:
		#ifdef DEBUG
		    fprintf(stdout, "MappingNotify, refreshing..\n");
		#endif
		XRefreshKeyboardMapping(&event.xmapping);	/* keep it up-to-date */
	    break;
	    case VisibilityNotify:
		if(event.xvisibility.window == win.w){	/* our wid */
		    if(event.xvisibility.state == 0){
			if(alt_pressed == 1){
			    /* if clicked and keypress */
			    printf("Config\n");
			    XIconifyWindow(win.d, win.w, win.screen);
			    select_bosskey();
			    look_key = read_conf();
			    look_code = XKeysymToKeycode(win.d, look_key);
			}else{
			    /* know stupid issue, please fix */
			    /* klick/alt+tab */
			    
			    XIconifyWindow(win.d, win.w, win.screen);
    			    mapunmap_a = 0;
			    mapunmap2(win.root, win.d);

			    if((use_gui) && (df == 0)){
				XSetIconName(win.d, win.w, "ETSwitch");	/* taskbar name */
    				XStoreName(win.d, win.w, "ETSwitch");	/* taskbar tooltip / window title */
			    }else if(df == 1){
				df=0;
			    }
			    
			}
		    }
		}
	    break;
	    case DestroyNotify:	/* broken */
		/* could remove if statement.. */
		#ifdef DEBUG
		    fprintf(stdout, "DestroyNotify.. Mask -> StructureNotifyMask\n");
		#endif

		if(event.xdestroywindow.window == win.w){
		    printf("we are closing display\n");
		    win_close();
		    exit(EXIT_FAILURE);	
		}
	    break;

	default:
	    #ifdef DEBUG
		fprintf(stdout, "Unknown event: %i\n",event.type);
	    #endif
	break;
	}

	}else{

	}/* if(XCheckWindowEvent(win.d, win.w, gui_mask, &event)){ */

	/* change to pressed och inte */
	
	    XQueryKeymap(win.d, keys);		/* find changed keys */
					/* sure you can use the kernel or /dev/input but they req root, however i do have some other ways also..  */
					/* started hacking on a XOpenDevice(Display *display, XID device_id); way of doing passive grabs.. */
	    for (i=0; i<32*8; i++){
		if (BIT(keys, i)!=BIT(saved, i)){
		    if( i == look_code ){
			if(dbl==0){
			    key = XKeycodeToKeysym(win.d, i, 0);
			    key_string = XKeysymToString(key);
			    #ifdef DEBUG
			    fprintf(stdout, "\nOk, keyhook2 keypress '%s'\n", key_string);
			    #endif
			    mapunmap_a = 0;
			    mapunmap2(win.root, win.d);

			    dbl++;
			}else{
			    dbl=0;
			}
		    }else if(i == LW){
			if(alt_pressed == 0){
			    alt_pressed=1;
			}else{
			    alt_pressed=0;
			}
		    }else if(i == RW){
			if(alt_pressed == 0){
			    alt_pressed=1;
			}else{
			    alt_pressed=0;
			}
		    }else if(i == Z){
			if(z_pressed == 0){
			    z_pressed=1;
			}else{
			    z_pressed=0;
			}
		    }else if(i == S){
			if(s_pressed == 0){
			    s_pressed=1;
			}else{
			    s_pressed=0;
			}
		    }
		    if(no_hard == 0){
			if(alt_pressed & z_pressed){
			    #ifdef DEBUG
			    fprintf(stdout, "\nOk, mapunmap keyhook2 keypress 'ALT+Z'.\n");
			    #endif
			    mapunmap_a = 0;
			    mapunmap2(win.root, win.d);
			}
			if(alt_pressed & s_pressed){
			    #ifdef DEBUG
			    fprintf(stdout, "\nOk, mod view port 'ALT+S'\n");
			    #endif
			    /* inf(win.root); */
			    #ifdef HAVE_LIBXXF86VM
			    /* set view port */
			    XF86VidModeSetViewPort(win.d, win.screen, 0, 0);
			    #endif
			}
		    }
		}
	    }
		
	    /* swap buffers */
	    char_ptr=saved;
	    saved=keys;
	    keys=char_ptr;
	    usleep(u_delay);	/* timer based i know.. it sucks, but it is the best way to get this thing to work with SDL applications */
	

    } /* while running */
    win_close();

    if(flock(lock_fd,LOCK_UN || LOCK_NB)){
	/* hmm, cant unlock it, other process is locking it */
	#ifdef DEBUG
	fprintf(stderr, "Can't unlock %s.\n",lock_file);
	#endif
	exit(EXIT_FAILURE);	
    }
    close(lock_fd);
    /* unlink file */
    exit(EXIT_SUCCESS);
}


void win_init(){

    /* xpm icon pixmap */
    XpmAttributes xpm_attr;
    Pixmap pixmap;
    Pixmap mask;

    /* XListExtensions(win.d, &nextentions); */
    char **extentions;
    int nextentions;

    int dga_check = 0;
    
    if( (win.d = XOpenDisplay(win.display_name)) == NULL) {
	fprintf(stderr, "Error: Can't connect to display '%s'.\nQuiting..\n", win.display_name);
	exit(EXIT_FAILURE);
    }else{
#ifdef DEBUG
	XSynchronize(win.d, 1);	/* turn on sync */
    	fprintf(stdout, "Connected: '%s'.\n", win.display_name);
	fprintf(stdout, "Vendor: '%s'.\n", ServerVendor(win.d));
	fprintf(stdout, "Vendor release: '%i'.\n", VendorRelease(win.d));
        fprintf(stdout, "Protocol version: '%i.%i'.\n", ProtocolVersion(win.d), ProtocolRevision(win.d));
#endif

	extentions = XListExtensions(win.d, &nextentions);
	if(nextentions > 0){
    	    int ii;
#ifdef DEBUG
	    fprintf(stdout, "Nr of extentions loaded: '%i' ", nextentions);
#endif
	    for(ii=0;ii < nextentions; ii++){
#ifdef DEBUG
    		fprintf(stdout, ", %s", extentions[ii]);
#endif
		/* if DGA is the root of the trouble */
		if(!strncmp("XFree86-DGA",extentions[ii], 11)){
		    dga_check = 1;
		}
	    }
#ifdef DEBUG

    		fprintf(stdout, ".\n");
#endif
	    XFreeExtensionList(extentions);	
	}

	/* saveing desktop pointer data, */
	XGetPointerControl(win.d, (int *)&win.accel_numerator_return[0], (int *)&win.accel_denominator_return[0], (int *)&win.threshold_return[0]);
#ifdef DEBUG
	fprintf(stdout, "Input device settings: '%i','%i','%i'\n", win.accel_numerator_return[0], win.accel_denominator_return[0], win.threshold_return[0]);
#endif
	win.do_accel = 1;
	win.do_threshold = 1;

/*	XGetPointerControl(win.d, (int *)&win.accel_numerator_return[0], (int *)&win.accel_denominator_return[0], (int *)&win.threshold_return[0]); */
	/* make it bork now :) not later if bork :P */
	XChangePointerControl(win.d, win.do_accel, win.do_threshold, win.accel_numerator_return[0], win.accel_denominator_return[0], win.threshold_return[0]);
	
	win.screen = DefaultScreen(win.d);
	win.root = RootWindow(win.d, win.screen);

	/* setup errorhandler */
	if(!XSetErrorHandler(&errorHandler)){
	    fprintf(stderr, "X: Can't setup custom errorhandler.\n");
#ifdef DEBUG
	}else{
	    fprintf(stdout, "X: Custom errorhandler installed.\n");
#endif
	}

	/* setup IOerrorhandler */
	if(!XSetIOErrorHandler(&ioerrorHandler)){
	    fprintf(stderr, "X: Can't setup custom IOerrorhandler.\n");
#ifdef DEBUG
	}else{
	    fprintf(stdout, "X: Custom IOerrorhandler installed.\n");
#endif
	}


	if(use_gui){
	    /* create gui window */
	    /* fix current values */
	    
	    win.w = XCreateSimpleWindow(win.d, win.root, 0, 0, 100, 100, 0, 0, 0);
	    XSetIconName(win.d, win.w, "ETSwitch");
	    XMapWindow(win.d, win.w);

	    /* Set class hints (used for startup notify etc) */
	    win.class_hints.res_name = "ETSwitch";
	    win.class_hints.res_class = "ETSwitch";
    
	    /* Set window to win_w * win_h (not resizable) */
	    win.size_hints.flags = PSize | PMinSize | PMaxSize;
	    /* set to res */
	    win.size_hints.min_width = 1;
	    win.size_hints.max_width = 1;
	    win.size_hints.min_height = 1;
	    win.size_hints.max_height = 1;

	    xpm_attr.valuemask = XpmCloseness;
	    xpm_attr.closeness = 40000;		/* magic */
	    
	    if (XpmCreatePixmapFromData(win.d, win.root, etswitch_xpm, &pixmap, &mask, &xpm_attr) != XpmSuccess) {
		fprintf(stderr, "Error reading icon pixmap.\n"); 
	    }
			    
	    /* set window hints, icon and state */    
	    win.wm_hints.flags = IconPixmapHint | IconMaskHint | StateHint;
	    win.wm_hints.icon_pixmap = pixmap;
	    win.wm_hints.icon_mask = mask;
	    win.wm_hints.initial_state = IconicState; /* WithdrawnState, NormalState */

	    /* same as class? FIXME */	
	    XmbSetWMProperties(win.d, win.w, "ETSwitch", "ETSwitch", 0, 0, &win.size_hints, &win.wm_hints, &win.class_hints);  
	    /*
	    void XmbSetWMProperties(display, w, window_name, icon_name, argv, argc, normal_hints, wm_hints, class_hints)
	    Display *display;
	    Window w;
	    char *window_name;
	    char *icon_name;
	    char *argv[];
	    int argc;
	    XSizeHints *normal_hints;
	    XWMHints *wm_hints;
	    XClassHint *class_hints;
	    */								    
									    
									    

	    XStoreName(win.d, win.w, "ETSwitch");	/* not needed, merge with the macro one  */
	    XIconifyWindow(win.d, win.w, win.screen);
	    /* add option to simply unmap the main window */

	    /* XUnmapWindow(win.d, win.w); */
	    /* gui end */
	}
#ifdef HAVE_LIBXXF86VM
	if(XF86VidModeQueryVersion(win.d,(int *)&win.XF86VidModeVersionMajor,(int *)&win.XF86VidModeVersionMinor)){
#ifdef DEBUG
	    fprintf(stdout, "XF86VidMode version: %i.%i\n",win.XF86VidModeVersionMajor, win.XF86VidModeVersionMinor);
#endif
	}
	/* read desktop gamma */
	XF86VidModeGetGamma(win.d, win.screen, &win.desk_gamma);
#endif
    }/* if( (win.d = XOpenDisplay(win.display_name)) == NULL) { */

    /* do initial checks here */
    if(dga_check == 1 && no_dgawaring == 0){
	/*
	    change
	critical_info("*** You have XFree86-DGA loaded ***\nGames(Quake3 based ones for example) using XFree86-DGA mouse hooks may\nnot release mouse pointer, read the documentation on how to disable\nXFree86-DGA if in_dgamouse 0 doesnt help.\n*** You have XFree86-DGA loaded ***\n");
	*/
	critical_info(MESSAGE_DGA_LOADED);
    }
}

/*
    clean up gui here
*/
void win_close(){
    XFlush(win.d);
    XSync(win.d, False);
    XSetErrorHandler(NULL);
    XCloseDisplay(win.d);
}

void keyboard_hook(Window root, unsigned long type){

    static int level = 0;
    Window parent, *children;
#ifdef DEBUG
    Window child_w;
    XTextProperty text_prop;
#endif
    unsigned int nchildren, i;
    /* int stat; */

    level++;

    /* temp disable */
    /*    return; */

    if (!XQueryTree(win.d, root, &root, &parent, &children, &nchildren)){
#ifdef DEBUG
	fprintf(stderr, "Hook: Can't query window tree...\n");
	child_w = XmuClientWindow(win.d, root);
	    if(XGetWMName(win.d, child_w, &text_prop)){
		printf("Hook: WMNAME:'%s'\n", text_prop.value);
	    }else{
		printf("Hook: XGetWMName\n");
	    }
#endif
	return;
    }
    last_err = 1;
    XSelectInput(win.d, root, type);

    if (nchildren == 0) return; /* no need to free */
    
    for(i=0; i < nchildren; i++){
	XSelectInput(win.d, children[i], type);
	keyboard_hook(children[i], type);
    }
    XFree((char *)children);
}


void mapunmap2(Window CHI, Display *display){

    Window root_w, parent_w, child_w, *children_w;
    
    unsigned int children_n;    

    /*  wid info */
    XTextProperty text_prop;
    XClassHint class_hints;
    char *strz;

    int i;

    int classh = 0;		/* if class call ok, and should free pointer */
    int iconn = 0;

    wid_info_struct *p;		/* wid struct */

    int wmname_check = 0;
    int iconname_check = 0;
    int resname_check = 0;
    int resclass_check = 0;

    char buffer[128];
#ifdef DEBUG
    char tmp_a[64];
    char tmp_b[64];
    char tmp_c[64];
#endif    

    /* fulhack, abort if allready switched, maby add this as an option? duno how Unreal Engine wants it
	seems to work with UT2003 anyway
     */
    if(mapunmap_a == 1){
	#ifdef DEBUG
	/* fprintf(stdout,"mapunmap2: Aborting loop.\n"); */
	#endif
	return;
    }
    last_err = 1001;
    if(! XQueryTree(display, CHI, &root_w, &parent_w, &children_w, &children_n)){ 
	/* abort(); */
	/* backtrace shows no children */
	/* printf("2 bad window\n"); */
	return;
    }

    last_err = 1002;
    child_w = XmuClientWindow(display, CHI);

    last_err = 1003;
    classh = XGetClassHint(display, child_w, &class_hints);

    last_err = 1004;
    iconn = XGetIconName(display, child_w, &strz);

    if(XGetWMName(display, child_w, &text_prop)){
	/* get all info here: addnum, breakout this one.. :( */

	/* test *wid array against the CHI */
	if(wid == NULL){
	    fprintf(stderr, "no array loaded, trying to read it now..\n");
	    /* try to create/read it here, fulhack */
	    readwid_conf();
	    return;
	}
	
	p = (wid_info_struct *)wid->first_struct; 

	while(running){ /* break if not running or p->next_struct == NULL */
	    /* clear */
	    wmname_check = 0;
	    iconname_check = 0;
	    resname_check = 0;
	    resclass_check = 0;
	    /*
	    printf("ID:%i,WM:%s,IC:%s,NA:%s,CL:%s,KB:%sTW:%i\n",
	    p->id, 	p->WMNAME, p->iconname, p->res_name, p->res_class,
	    p->known_binary, p->tweak);	
	    */

	    /*
	    # 1       2                  4                8           
	    #WMNAME	iconname	res_name	res_class	known_binary	tweak
	    */

	    /* move all the null tests to top and simply break, or in readwid_conf set * if null */

	    if((p->WMNAME != NULL) & (text_prop.value != NULL)){

		if(p->tweak & 1){
		    /* partial match */
    		    if(!strncmp(p->WMNAME, text_prop.value, strlen(p->WMNAME))) wmname_check = 1;
		}else{
		    /* exact match */
    		    if(!strcmp(text_prop.value, p->WMNAME)) wmname_check = 1;
		}	
		if(p->WMNAME[0] == '*') wmname_check = 1;	/* pass any */
	    }

	    /* fixme */
	    if(p->iconname != NULL){

		/*
		printf("ID:%i,WM:%s,IC:%s,NA:%s,CL:%s,KB:%sTW:%i\n",
		p->id, p->WMNAME, p->iconname, p->res_name, p->res_class,
		p->known_binary, p->tweak);	
		*/

		if(iconn != 0){
		    if(p->tweak & 2){
			/* partial match */
    			if(!strncmp(p->iconname, strz, strlen(p->iconname))) iconname_check = 1;
		    }else{
			/* exact match */
    			if(!strcmp(strz, p->iconname)) iconname_check = 1;
		    }	
		}
    		if(p->iconname[0] == '*') iconname_check = 1;	/* pass any */
    		/* dummy atm */
		/* iconname_check = 1; */
	    }
    
	    if(p->res_name != NULL){

		if(p->tweak & 4){
		    /* partial match */
		    if(classh){
    			if(!strncmp(p->res_name, class_hints.res_name, strlen(p->res_name))) resname_check = 1;
		    }
		}else{
		    /* exact match */
		    if(classh){
    			if(!strncmp( class_hints.res_name, p->res_name, strlen(class_hints.res_name))) resname_check = 1;
		    }
		}	
		if(p->res_name[0] == '*') resname_check = 1;	/* pass any */
	    }

	    if(p->res_class != NULL){
		if(p->tweak & 8){
		    /* partial match */
		    if(classh){
    			if(!strncmp(p->res_class, class_hints.res_class, strlen(p->res_class))) resclass_check = 1;
		    }
		}else{
		    /* exact match */
		    if(classh){
    			if(!strncmp( class_hints.res_class, p->res_class, strlen(class_hints.res_class))) resclass_check = 1;
		    }
		}	
    		if(p->res_class[0] == '*') resclass_check = 1;	/* pass any */
	    }

	    /*
	    printf("ID:%i,WM:%s,IC:%s,NA:%s,CL:%s,KB:%sTW:%i\n",
	    p->id, p->WMNAME, p->iconname, p->res_name, p->res_class,
	    p->known_binary, p->tweak);	
	    */

	    /* HIT */	
	    if(wmname_check & iconname_check & resname_check & resclass_check){

#ifdef DEBUG
		fprintf(stdout,"Checks %i, %i, %i, %i\n"
		,wmname_check,iconname_check,resname_check,resclass_check);
		/* 
		    strlen error libc.so.6 on tls?
		    text_prop.value may be borked also.. :/    
		*/
		if(classh){
		    snprintf(tmp_a, 64, "%s", text_prop.value);
		    snprintf(tmp_b, 64, "%s", class_hints.res_name);
		    snprintf(tmp_c, 64, "%s", class_hints.res_class);
		    fprintf(stdout,"HIT: '%s', '%s', '%s'\n", tmp_a,tmp_b,tmp_c);
		}else{
		    fprintf(stderr, "classh was not called!\n");
		}
		fprintf(stdout,"WID SWITCH\n");
#endif
		/* add visual XStoreName is tooltip on gnome 2.12  */
		snprintf(buffer, 128, "ETS: %s", text_prop.value);
		XStoreName(win.d, win.w, buffer);			/* taskbar tooltip / window title */
		XSetIconName(win.d, win.w, buffer);			/* taskbar name */
		/* create a new text_prop struct and set acord.. */
		/* XSetWMName(win.d, win.w, text_prop.value); */
 
		sw(child_w);
		/* break */
		mapunmap_a = 1;	/* abort mapunmap */

		return;
	    }

	    if(p->next_struct == NULL){
		break;	/* no more in array */
	    }
	    p = (wid_info_struct *)p->next_struct;
	} /* while running */

    if(classh){	/* free */
	XFree(class_hints.res_name);
	XFree(class_hints.res_class);
    }

    }

    if (children_n == 0){
	return;
    }

    /* top most window is last in array */
    for (i = children_n-1; i>=0; i--){
	last_err = 1005;
	child_w = XmuClientWindow(display, children_w[i]);
	mapunmap2(children_w[i], display);
    }

    XFree(children_w);

    /*
    else if not found */
    XFlush(display);	/* flush pending requests to X server */
}

void sw(Window child_w){
    int visible = 1;	/* fixme */
    int result = 0;
    int s;	/* set prio */
    XWindowAttributes xwa;
    int rc;
        
#ifdef DEBUG
    fprintf(stdout, "Switching..\n");
#endif

    /* get current state of window.. */
    if(!XGetWindowAttributes(win.d, child_w, &xwa)){
	fprintf(stderr, "cant get wattrib of w.\n");
    }else{
	/* fprintf(stdout, "xwa: %i %i, %ix%i\n",xwa.x,xwa.y,xwa.width, xwa.height); */
	if(xwa.map_state == IsUnmapped){
	     visible = 0;
	}
    }
    
    if(child_w){
	if(visible){	/* game is visible */
	    visible=0;
	    /* save game pointer values */
	    XGetPointerControl(win.d, (int *)&win.accel_numerator_return[1], (int *)&win.accel_denominator_return[1], (int *)&win.threshold_return[1]);
#ifdef DEBUG
	    fprintf(stderr, "Input device gsettings: '%i','%i','%i'\n", win.accel_numerator_return[1], win.accel_denominator_return[1], win.threshold_return[1]);
	    fprintf(stderr, "Input device dsettings: '%i','%i','%i'\n", win.accel_numerator_return[0], win.accel_denominator_return[0], win.threshold_return[0]);
#endif 

/*	    XChangePointerControl(win.d, win.do_accel, win.do_threshold[0], win.accel_numerator_return[0], win.accel_denominator_return[0], win.threshold_return[0]); */
	    
#ifdef HAVE_LIBXXF86VM

	    XF86VidModeGetGamma(win.d, win.screen, &win.game_gamma); /* read game gamma */

	    readmix(mixer_control);    /* save game vol */
	    setmix(mixer_control, win.game_vol.left / 2, win.game_vol.right / 2);

	    save_res(1);	/* save game res */
	    gammadown();
#endif
	    /* show desktop */
	    result = XUnmapWindow(win.d, child_w);	/* hide window */
	    result = XUnmapSubwindows(win.d, child_w);	/* hide sub windows, part of SDL fix */
	    /* set urg hint */
	    win.wm_hints.flags = IconPixmapHint | IconMaskHint | StateHint | 256;
	    XSetWMHints(win.d, win.w, &win.wm_hints);

#ifdef HAVE_LIBXXF86VM
	    gammaup(win.desk_gamma);
	    XF86VidModeSetGamma(win.d, win.screen, &win.desk_gamma); /* set desk gamma */
#endif

#ifdef HAVE_LIBXXF86VM
	    restore_res(0);	/* restore desktop */
#endif
	    /*
	    grab / ungrab pointer possible fix for "stuck mouse"
	    i dont think this will help with the DGA issue
	    (someone with that trouble should test and get back to me)
	    
	    if(XGrabPointer(win.d, win.root, False, PointerMotionMask, GrabModeAsync,GrabModeAsync,None,None,CurrentTime) == GrabSuccess){
		fprintf(stdout, "GrabPointer OK\n");
		XFlush(win.d);
		XUngrabPointer(win.d,CurrentTime);
	    }
	    */
	    
	    /* restore desktop pointer */
	    XChangePointerControl(win.d, win.do_accel, win.do_threshold, win.accel_numerator_return[0], win.accel_denominator_return[0], win.threshold_return[0]);

#ifdef DEBUG
	    fprintf(stderr, "Input device gsettings: '%i','%i','%i'\n", win.accel_numerator_return[1], win.accel_denominator_return[1], win.threshold_return[1]);
	    fprintf(stderr, "Input device dsettings: '%i','%i','%i'\n", win.accel_numerator_return[0], win.accel_denominator_return[0], win.threshold_return[0]);
#endif 


	    /* get prio */
	    /* broken atm */
    	    if(renice == 1){
		int pid = sc("et.x86");
		if(pid){
		    /* fixme check error */
		    game_info.pid = pid;
		    game_info.prio = getpriority(PRIO_PROCESS, pid);
    		    if(game_info.prio == 0){
			game_info.prio = -1;	/* ful hack(tm) */
		    }
		    /* set new prio */
		    s = setpriority(PRIO_PROCESS, game_info.pid, 10); /* set new */
		    fprintf(stdout, "game prio is default/was: %i\n",game_info.prio);
		}
	    }

	    /* show our window, minimized, when maximized, remove window, map main */
	    /* XMapWindow(win.d, win.w); */
	}else{
	    visible=1;	/* game not visible */
	    /* save desktop  */
	    XGetPointerControl(win.d, (int *)&win.accel_numerator_return[0], (int *)&win.accel_denominator_return[0], (int *)&win.threshold_return[0]);
#ifdef DEBUG
	    fprintf(stderr, "Input device gsettings: '%i','%i','%i'\n", win.accel_numerator_return[1], win.accel_denominator_return[1], win.threshold_return[1]);
	    fprintf(stderr, "Input device dsettings: '%i','%i','%i'\n", win.accel_numerator_return[0], win.accel_denominator_return[0], win.threshold_return[0]);
#endif 
/*	    XChangePointerControl(win.d, win.do_accel, win.do_threshold[0], win.accel_numerator_return[0], win.accel_denominator_return[0], win.threshold_return[0]); */

	    
	    /* remove urg hint */
	    win.wm_hints.flags = IconPixmapHint | IconMaskHint | StateHint;
	    XSetWMHints(win.d, win.w, &win.wm_hints);

#ifdef HAVE_LIBXXF86VM
	    /* set game gamma */
	    gammadown();
#endif
	    /* show game */
	    result = XMapWindow(win.d, child_w);
	    result = XMapSubwindows(win.d, child_w);	    /* may bork other games, tests are needed !! create option */


#ifdef HAVE_LIBXXF86VM
	    /* width and height comes from xf86call so we need HAVE_LIBXXF86VM */
	    if(use_repos == 1){	/* ful hack(tm) */
		XMoveResizeWindow(win.d,child_w,0,0,game_info.width,game_info.height);
	    }

/*
	    this may resolve non-dga mouse quirks, issues may be resolved by moving pointer at grabing w
	    XWarpPointer(win.d, None, child_w, 0, 0, 0, 0, game_info.width / 2, game_info.height / 2);
*/

#endif
	    setmix(mixer_control, win.game_vol.left, win.game_vol.right);

#ifdef HAVE_LIBXXF86VM
    	    gammaup(win.game_gamma);
	    XF86VidModeSetGamma(win.d, win.screen, &win.game_gamma); /* set game gamma */

	    /*
		the array gets reorderd, so we ignore it until we rewrite it
		sadly this feature will req some work manage own res array and
		switch manually so ive disabled it for now
	        save_res(0); */	/* save desktop */
#endif
#ifdef HAVE_LIBXXF86VM
	    restore_res(1);	/* restore game vidmode */
#endif
	    /* restore input */
	    XChangePointerControl(win.d, win.do_accel, win.do_threshold, win.accel_numerator_return[1], win.accel_denominator_return[1], win.threshold_return[1]);
#ifdef DEBUG
	    fprintf(stderr, "Input device gsettings: '%i','%i','%i'\n", win.accel_numerator_return[1], win.accel_denominator_return[1], win.threshold_return[1]);
	    fprintf(stderr, "Input device dsettings: '%i','%i','%i'\n", win.accel_numerator_return[0], win.accel_denominator_return[0], win.threshold_return[0]);
#endif 

	    /* restore prio */
	    if((game_info.pid > 1) && (renice == 1)){
    		int s = setpriority(PRIO_PROCESS, game_info.pid, game_info.prio); /* restore */
		fprintf(stdout, "res: %i, game prio is now: %i\n", s, game_info.prio);
	    }

	}/* if visible */
#ifdef DEBUG
	fprintf(stdout, "Switching raise and select..\n");
#endif
	/* set focus, possible fix for submapwindows if it breaks */
        XRaiseWindow(win.d, child_w);
        XSetInputFocus(win.d, child_w, RevertToParent, CurrentTime);
	/* why doesnt this always work? */
	
#ifdef HAVE_LIBXXF86VM
	/* set view port */
	XF86VidModeSetViewPort(win.d, win.screen, 0, 0);
#endif
	/* sync it, please.. issue ? */
	XSync(win.d, 0);

#ifdef HAVE_LIBXXF86VM
	/* set view port */
	XF86VidModeSetViewPort(win.d, win.screen, 0, 0);
#endif
	    
    }/* if(child_w){ */
#ifdef DEBUG
    fprintf(stdout, "Switching done..\n");
#endif
}/* sw */


#ifdef HAVE_LIBXXF86VM
void get_res(){
#ifdef DEBUG
    printf("XF86VidMode: GetAllModeLines\n");
#endif
    XF86VidModeGetAllModeLines(win.d, win.screen, &win.res_count, &win.res_modelines);
    XFlush(win.d);	/* flush pending requests to X server */
#ifdef DEBUG
    printf("XF86VidMode: GetAllModeLines: %i\n", win.res_count);
#endif
}

void save_res(int mode){
    int a;	
    XF86VidModeGetModeLine( win.d, win.screen, &a, &win.vm_modelines[mode]);
    XFlush(win.d);    	/* flush pending requests to X server */
#ifdef DEBUG
    fprintf(stderr, "XF86VidMode: saveing: %i, %dx%d\n", mode, win.vm_modelines[mode].hdisplay,win.vm_modelines[mode].vdisplay);
#endif
}

/* restore res */
void restore_res(int mode){
    int i;

#ifdef DEBUG
    fprintf(stdout,"XF86VidMode: restore %i, res count: %i\n",mode, win.res_count);
#endif

    for(i=0; i < win.res_count; i++) {
        if((win.res_modelines[i]->hdisplay == win.vm_modelines[mode].hdisplay) && (win.res_modelines[i]->vdisplay == win.vm_modelines[mode].vdisplay)){
#ifdef DEBUG
    	    fprintf(stdout,"XF86VidMode: restoring to %dx%d\n",win.res_modelines[i]->hdisplay,win.res_modelines[i]->vdisplay);
#endif
	    XF86VidModeSwitchToMode( win.d, win.screen, win.res_modelines[i]);
	    if(mode == GAME){
		game_info.width=win.res_modelines[i]->hdisplay;
		game_info.height=win.res_modelines[i]->vdisplay;
	    }

	    XFlush(win.d);	/* flush pending requests to X server */
	    break;
	}
    }
#ifdef DEBUG
    fprintf(stdout, "XF86VidMode: restore done\n");
#endif
}

void gammadown(){

    XF86VidModeGamma curg;
    
    XF86VidModeGetGamma(win.d, win.screen, &curg); /* read current gamma */
#ifdef DEBUG
    fprintf(stdout,"ATI fglrx bug, before change: %f %f %f\n",curg.red, curg.green, curg.blue);
#endif

    if(delay) {
	/* */
	for(;curg.red > 0.000000; curg.red=curg.red-0.025){
	    curg.green = curg.red;
	    curg.blue = curg.red;
	    XF86VidModeSetGamma(win.d, win.screen, &curg); /* set ramp gamma */
	    usleep(5000);
	}
    }else{
	curg.red = 0.000000;
	curg.blue = curg.red;
	curg.green = curg.red;
	XF86VidModeSetGamma(win.d, win.screen, &curg); /* set ramp gamma */
    }
#ifdef DEBUG
    XF86VidModeGetGamma(win.d, win.screen, &curg); /* read current gamma */
    fprintf(stdout,"ATI fglrx bug, after change: %f %f %f\n",curg.red, curg.green, curg.blue);
#endif
}

void gammaup(XF86VidModeGamma newg){

    XF86VidModeGamma curg;

    XF86VidModeGetGamma(win.d, win.screen, &curg); /* read current gamma */
    if(delay){
	for(;curg.red < newg.red; curg.red=curg.red+0.025){
	    curg.green = curg.red;
	    curg.blue = curg.red;
	    XF86VidModeSetGamma(win.d, win.screen, &curg); /* set ramp gamma */
	    usleep(5000);
	}
    } 
    XF86VidModeSetGamma(win.d, win.screen, &newg); /* set ramp gamma */
}

#endif	/* #ifdef HAVE_LIBXXF86VM  */

/*
    convert to pthread, work started
    #define HAVE_PTHREAD_H 1
    change to "HAVE_LIBPTHREAD"
    need to pass struct number, lvalue and rvalue

    struct setmix_thread {
	int number;
	int lvalue;
	int rvalue;
    };

    its a little borked atm
    need to make sure no ext vars get used.. im too sick atm, i can barley see straigt(its a miracle i could merge this code today)
    aha, need to mutex the game.vol thingy (feeling abit better)
*/
void setmix(int number, int lvalue, int rvalue){

/*	fixme, clean this one.. elotso redundent stuffo
	this has some ugle leftovers 
	basic new structure is ploted on paper..
*/


    struct stereo vol;
    int mixer_fd, devmask;

#ifdef DEBUG
    char *device_list[SOUND_MIXER_NRDEVICES] = SOUND_DEVICE_LABELS;
#endif

    if(!use_mixer) return;

    mixer_fd = open(mixer_device, O_RDWR, 0);	/* open device */
    if (mixer_fd < 0) {
#ifdef DEBUG
        fprintf(stderr, "setmix: Error opening mixer device '%s', aborting.\n",mixer_device);
#endif
        return;
    }
    
    if (ioctl(mixer_fd, SOUND_MIXER_READ_DEVMASK, &devmask) == -1) {
#ifdef DEBUG
	fprintf(stdout, "setmix: Error read: SOUND_MIXER_READ_DEVMASK, aborting.\n");
#endif
	return;
    }

#ifdef DEBUG
    fprintf(stdout, "setmix: setting device '%d'(%s) channel left: '%d' right: '%d'\n",number,device_list[number],lvalue,rvalue);
#endif

    readmix(mixer_control);			/* read current */

#ifdef DEBUG
    fprintf(stdout, "setmix: from value %i to L%i:R%i\n",win.game_vol.left, lvalue, rvalue);
#endif

    vol.left = lvalue;
    vol.right = rvalue;

#ifdef DEBUG
    fprintf(stdout, "setmix: final value %i\n",lvalue);
#endif

    /* final set */
    if ((ioctl(mixer_fd, MIXER_WRITE(number), &vol))== -1 ){
 	fprintf(stderr, "setmix: error setting vol\n");
    }
    
    close(mixer_fd);

#ifdef DEBUG
    fprintf(stdout, "setmix: done.\n");
#endif
}

void readmix(int dev){	/* allow change of dev, cmd option */

    int mixer_fd, devmask, d;

    if(use_mixer){
#ifdef DEBUG
	fprintf(stdout, "readmix: Reading mixer.\n");
#endif
	mixer_fd = open(mixer_device, O_RDWR, 0);     /* open device */
	if (mixer_fd < 0) {
	    fprintf(stderr, "readmix: Error opening mixer device '%s'\n",mixer_device);
	    return;
	}else{
	    if (ioctl(mixer_fd, SOUND_MIXER_READ_DEVMASK, &devmask) == -1) {
		fprintf(stderr, "readmix: Error read: SOUND_MIXER_READ_DEVMASK\n");
		return;
	    }
	    d = (1 << dev);	/* mask out selected device */
	    if (0 != (devmask & d)) {
		if (-1 == ioctl(mixer_fd, MIXER_READ(dev), &win.game_vol)) {
		    fprintf(stderr, "readmix: Error: MIXER_READ dev nr %d\n",dev);
		}
	    }
	    close(mixer_fd);
	}
    }
#ifdef DEBUG
    else{
	fprintf(stdout, "readmix: Reading mixer: Disabled.\n");
    }
#endif

#ifdef DEBUG
    fprintf(stdout, "readmix: done.\n");
#endif

}


/* is there a better way ? */
int sc(char *binary){
    struct dirent **namelist;
    int n;
    int return_pid = -1;
    n = scandir("/proc/", &namelist, 0, 0);    /* alphasort */
    if (n < 0){
	fprintf(stderr, "hey?!?, no directories in /proc ?\n");
    }else{ 
	while(n--) {
	    struct stat dir_stat;	    /* check dest path */
	    struct stat file_stat;

	    /* int ret; */

    	    char dir[128];	/* change to constant */
    	    char file[128];

	    snprintf(dir, 128, "/proc/%s", namelist[n]->d_name);
    
	    if (stat(dir, &dir_stat)!=-1){
		if (S_ISDIR (dir_stat.st_mode)){    /* the name is a directory  */
		    /* printf("file: %s\n", namelist[n]->d_name); */
		    snprintf(file, 128, "%s/cmdline", dir);
		    if (stat(file, &file_stat)!=-1){
			if (S_ISREG (file_stat.st_mode)){ /* check for cmdline */
			    int fp;
			    if (!(fp = open(file,O_RDONLY))){
				fprintf(stderr, "fopen read failed: %s, at line: %d\n", strerror(errno),__LINE__);
			    }else{
				int special = 128; /* fix me */
				char *mret = malloc((special)*sizeof(char));
				if(read(fp,mret,special)){
				    char *bin;
				    bin = basename(mret); /* pekar i mret */
				    /* mret = full path to binary */
				    /* bin = only the binary */
				    /* namelist[n]->d_name = pid */
				    if(!strcmp(binary,bin) || !strcmp(binary,mret)){ /* dual */
					return_pid = atoi(namelist[n]->d_name); 
				    }
				}else{
				    /* fprintf(stderr, "Cant read file\n"); */
				}
				free(mret);
				close(fp);
			    }
			}
		    }
		}
	    }
	    free(namelist[n]);	    
	}
	free(namelist);
    }
    return(return_pid);
}

/*
    selects bosskey
    clean up
*/
void select_bosskey(){

    KeySym	key;
    char	*key_string;
    int		dummy = 1;

    key = read_conf();			/* read from conf */
    key_string = XKeysymToString(key);	/* set as conf */

if(use_gui){

    Display		*d;		/* display */
    Window		w;		/* gui window */
    GC			gc;		/* gui window gfx content */
    int			screen;		/* default screen for this display */
    Window		root;		/* default rootw for this screen */
    XFontStruct*	font_info;	/* gui */
    char* font_name = "9x15"; 		/* "*-helvetica-*-12-*" */

    int blackColor = 0;
    int whiteColor = 0;

    XEvent event;			/* our event */
    int until_done = 1;

    char *str = "*** Press your boss key ***";
    char *buffer[128];

    Pixmap		pixmap, mask;	/* icon with mask */
    XpmAttributes	xpm_attr;	/* Set icon (with mask) */

    if( (d = XOpenDisplay(win.display_name)) == NULL) {
        fprintf(stderr, "Error: Can't connect to display '%s'.\nQuiting..\n", win.display_name);
        exit(EXIT_FAILURE);
    }else{
        screen = DefaultScreen(d);
        root = RootWindow(d, screen);
        blackColor = BlackPixel(d, screen);
        whiteColor = WhitePixel(d, screen);
        w = XCreateSimpleWindow(d, root, 0, 0, 400, 50, 1, blackColor, whiteColor);
        XSetIconName(d, w, "etswitch: config");	/* taskbar name */
	XStoreName(d, w, "Click anywhere in the window to close"); /* taskbar tooltip / window title */
	XSelectInput(d, w, ExposureMask | ButtonPressMask | KeyPressMask); 	/* Set up which event types the window will handle */
	XMapWindow(d, w);
	gc = XCreateGC(d, w, 0, 0); /* &gc */
	XSetForeground(d, gc, blackColor);
	XSetBackground(d, gc, whiteColor);
	XSetFillStyle(d, gc, FillTiled);

	/*	XDrawLine(d,w,gc,2,5,12,21); */
	font_info = XLoadQueryFont(d, font_name);
	if(!font_info){
	    fprintf(stderr, "XLoadQueryFont: error loading font, use '-ng' option");
	}else{
	    XSetFont(d, gc, font_info->fid);
		/*    XDrawString(d, w, gc, 10, 10, string, strlen(string)); */
	}

	XFlush(d);
	XSync(d, False);

	/* Set icon (with mask) */
	xpm_attr.valuemask = XpmCloseness;
	xpm_attr.closeness = 40000;
	
	if (XpmCreatePixmapFromData(d, root, etswitch_xpm, &pixmap, &mask, &xpm_attr) != XpmSuccess) {
	    fprintf(stderr, "Error reading icon pixmap.\n"); 
	}

	while (until_done && running) {	/* break if */
	    XNextEvent(d, &event);
    	    switch (event.type) {
		case Expose:
		    #ifdef DEBUG
		    printf("Expose\n");
		    #endif
		    /* XDrawLine(d,w,gc,2,5,12,21); */
		    XDrawString(d, w, gc, 10, 20, str, strlen(str));
		    snprintf((char *)buffer, 128,"Selected key: %s      ", (char *)key_string);
		    XDrawString(d, w, gc, 10, 45, (char *)buffer, strlen((char *)buffer));
		    XCopyArea(d, pixmap, w, gc, 0, 0, 100, 100, 100, 50);
		break; /* Draw/re-draw everything */
		case ButtonPress:
	    	    until_done = 0;
	    	    fprintf(stdout, "Okey, Quiting\n");
		break; /* Quit on mouse button press */
    		case KeyPress:
		    key = XKeycodeToKeysym(d, event.xkey.keycode, 0);
		    key_string = XKeysymToString(key);
		    fprintf(stdout, "\nOk, saving your selected keypress '%s'\n", key_string);
		    /* XDrawString(d, w, gc, 0, 20, key_string, strlen(key_string));*/
        	    XClearWindow(d, w);
		    XDrawString(d, w, gc, 10, 20, str, strlen(str));
		    snprintf((char *)buffer, 128,"Selected key: %s", (char *)key_string);
		    XDrawString(d, w, gc, 10, 45, (char *)buffer, strlen((char *)buffer));

		    write_conf(key_string);
		    dummy=0;
    		break;
		default: 
		break;
	    } /* switch */
	} /* loop until click, get event loop */
    fprintf(stdout, "Configuration done.\n");
    XCloseDisplay(d); /* Kill connection to the X server */
    } /* while running | until_done */
}/* if(is_tty){ */
}


/************************/
/* DUMP */
void DUMP(Window root){
    static int level = 0;
    Window parent, *children;
    unsigned int nchildren, i;
    Window root_w, child_w;
    Window tmp;
    char *str;
    Status status;
    XClassHint class_hints;
    XTextProperty text_prop;
/*
    char **cliargv;
    int cliargc;
*/
    Atom	*proplist = (Atom *) 0;
    int num = 0;
    Atom type;
    int format;
    unsigned long nitems, bytesafter;
    int sol=65536 / sizeof (long);
    char *AtomData; /* changed to (unsigned char **) down */
    char *AtomName;
    XWindowAttributes xwa;
    int dummy;
    level++;

    if (!XQueryTree(win.d, root, &root_w, &parent, &children, &nchildren)){
#ifdef DEBUG
	fprintf(stderr, "Can't query window tree...\n");
#endif
	return;
    }
/* GET INFO */
    dummy = root;
    fprintf(stdout, "====== %i - Level: %i\n",dummy, level);
    
    if(XGetIconName(win.d, root, &str)){
	printf("iconname: '%s'\n",str);
    }
    
    if(XGetClassHint(win.d, root, &class_hints)){
	printf("res_name: '%s'\nres_class: '%s'\n", class_hints.res_name, class_hints.res_class);
	XFree(class_hints.res_name);
	XFree(class_hints.res_class);
    }
    tmp = root;
    child_w = XmuClientWindow(win.d, tmp);

    status = XGetWMName(win.d, root,&text_prop);    
    if(status){
	printf("WMNAME:%s\n", text_prop.value);
    }
/*	fixme
#    Status XGetCommand(Display *display, Window w, char ***argv_return, int *argc_return);
		if(XGetCommand(win.d, child_w, &cliargv, &cliargc)){
		    printf("arg: '%s' '%i'\n", (char **)cliargv, cliargc); 
		    if(cliargc > 1){
			printf("arg: more then 1\n");
			printf("arg: '%s' '%i'\n", *cliargv[*cliargc], cliargc);

			for(i=0; i < *cliargc; i++){
			    printf("arg: '%s' '%i'\n", *cliargv[i], cliargc);
			} 

		XFreeStringList(cliargv);
		printf("okej freed\n"); 
		    } */
		proplist = XListProperties(win.d, child_w, &num);
		if (num){
		    printf("Xlist\n");
		    for (i = num-1; i>0; i--){ /* unsigned i>=0 */
			AtomData=AtomName=0;
			/* XA_STRING */
			/* fixme */
			if(!XGetWindowProperty (win.d, child_w, proplist[i], 0, sol, False, AnyPropertyType, &type, &format, &nitems, &bytesafter, (unsigned char **)&AtomData)){
			    AtomName=XGetAtomName(win.d, proplist[i]);
    			    printf("%s\t= %s\n", AtomName, AtomData);
			    XFree(AtomData);
			    XFree(AtomName);
			    /* free the others ?? */
			}
		    }
		    XFree(proplist);
		}else{
		    printf("no xlist\n");
		}

	    

    if(XGetWindowAttributes(win.d, child_w, &xwa)){
	printf("xwa: %i %i, %ix%i %ix",xwa.x, xwa.y, xwa.width, xwa.height, xwa.map_state);
	if(xwa.map_state){
	    printf(", STATE:%i",xwa.map_state);
	}
	printf("\n");
    }

/* END INFO */
/*
    XSelectInput(win.d, child_w, (KeyReleaseMask | SubstructureNotifyMask));
*/
    if (nchildren == 0){
	printf("no children\n");
	return;
    }else{
	for(i=0; i < nchildren; i++){
	    printf("Has child %i ->\n",i);
	    DUMP(children[i]);
	}
    }
  XFree((char *)children);
}

/* change to global , ttycheck inside .. */
void critical_info(char *string){	/* fixme */

    Display *d;			/* display */
    Window w;			/* gui window */
    XWMHints wm_hints;		/* hints */
    GC gc;			/* gui window gfx content */
    int screen;			/* default screen for this display */
    Window root;		/* default rootw for this screen */
    XFontStruct* font_info;	/* gui */
    char* font_name = "9x15";	/*    char* font_name = "*-helvetica-*-12-*"; */

    int blackColor = 0;
    int whiteColor = 0;

    int until_done = 1;
    int font_maxwidth = 0;
    int ftmp = 0;
    int tokn;
    int font_height;

    char *token;		/* text output */
    char delimiters[] = "\n";

    XEvent event;	/* window events */
    char *tmp;

    /* interactive */
    if(is_tty){
	fprintf(stderr, "%s\n",string);
    }else{
	/* gui */
	if( (d = XOpenDisplay(win.display_name)) == NULL) {
	    fprintf(stderr, "Error: Can't connect to display '%s'.\nQuiting..\n", win.display_name);
	    exit(EXIT_FAILURE);
	}else{
	    screen = DefaultScreen(d);
	    root = RootWindow(d, screen);
	    blackColor = BlackPixel(d, screen);
	    whiteColor = WhitePixel(d, screen);

    	    w = XCreateSimpleWindow(d, root, 0, 0, 400, 50, 1, blackColor, whiteColor);
	    XSetIconName(d, w, "ETSwitch");	/* taskbar name */
    	    XStoreName(d, w, "ETSwitch - Click anywhere in the window to close"); /* taskbar tooltip / window title */
	    wm_hints.flags = IconPixmapHint | IconMaskHint | StateHint | 256;
	    XSetWMHints(d,w, &wm_hints);	/* set urg hint */

	    XSelectInput(d, w, ExposureMask | ButtonPressMask); 	/* Set up which event types the window will handle */

	    XMapWindow(d, w);	/* show window */

	    gc = XCreateGC(d, w, 0, 0);	/* fix modes */
	    XSetForeground(d, gc, blackColor);
	    XSetBackground(d, gc, whiteColor);
	    /*	XDrawLine(d,w,gc,2,5,12,21); */
	
	    font_info = XLoadQueryFont(d, font_name);
	    if(!font_info){
		fprintf(stderr, "XLoadQueryFont: error loading font, use '-ng' option");
	    }else{
		XSetFont(d, gc, font_info->fid);
		/*    XDrawString(d, w, gc, 10, 10, string, strlen(string)); */
	    }
	    XFlush(d);
	    XSync(d, False);

	    while (until_done && running) {	/* break if */

		XNextEvent(d, &event);
    		switch (event.type) {
		case Expose:

		    tmp = strdup(string);
		    token = strtok(tmp, delimiters);
		    tokn = 0;
		    while(token != NULL){    
			/* printf("token: %i '%s'\n",tokn, token); */
		        if(tokn != 0){
			    XDrawString(d, w, gc, 0, 15+(15*tokn), token, strlen(token));
			}else{
			    XDrawString(d, w, gc, 0, 15, token, strlen(token));
			}
			/* get max */
			ftmp = XTextWidth(font_info, token, strlen(token));
			if(ftmp > font_maxwidth) font_maxwidth = ftmp;
			token = strtok(NULL, delimiters);
			tokn++;
		    }
		    /* hojd p% w = (tokn*15)+15*/
		    font_height = font_info->ascent + font_info->descent;
		    /* printf("%ix%i\n",font_maxwidth, font_height); */
		    XResizeWindow(d, w, font_maxwidth, (tokn*15));

		    free(tmp);
/* ************************************************************************** */
		break; /* Draw/re-draw everything */
		case ButtonPress:
		    until_done = 0; /* Quit on mouse button press */
		break; 
		default: 
		break;
		}
	    }
	    /* loop until click, get event loop */
	    XCloseDisplay(d); /* Kill connection to the X server */
	} /* while running | until_done */
    } /* if(is_tty){ */
} /* critical_info */
