/* variables listing
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"
#include "global.h"
#include "target.h"
#include "errorlh.h"
#include "stacksg.h"
#include "reswords.h"
#include "treerep.h"
#include "treetools.h"
#include "parser.h"
#include "regalloc.h"
#include "assemble.h"
#include "scanner.h"
#include "codegen.h"
#include "varlist.h"

#define max_variables 4096
tree var_list[max_variables][8];

/* the variable list (comment in the assembler file) */
void show_variables(FILE * f)
{
    int i, j;
    fprintf(f, "; ********** variable mapping\n");
    for (i = 0; i < max_variables; i++) {
        for (j = 0; j < 8; j++) {
            tree p = var_list[i][j];
            if (p != NULL) {
                fprintf(f, "; %02X:%01X : ;\n", i, j);
                for (; p != NULL; p = p->next) {
                    assert_kind(p->loc, p, node_chain);
                    assert_kind(p->loc, p->first, node_var);
                    fprintf(f, ";   %-30s %c %s\n", p->first->name, (p->first->fixed ? '*' : ' '),
                            loc_string(p->first->loc));
                }
            }
        }
    }
}

void add_variable(tree p)
{
    int i, j;

    assert_kind(p->loc, p, node_var);
    assert_kind(p->loc, p->address, node_chain);
    assert_kind(p->loc, p->address->first, node_value);
    assert_kind(p->loc, p->address->next, node_value);
    assert_pointer(p->loc, p->name);

    i = p->address->first->x;
    j = p->address->next->x;

    jal_assert(p->loc, (i >= 0) && (i <= max_variables));
    jal_assert(p->loc, (j >= 0) && (j <= 7));

#ifdef __DEBUG__
    log((m, "i=%d j=%d %s", i, j, loc_string(p->loc)));
#endif
    var_list[i][j] = new_chain2(p, var_list[i][j]);
}

void init_variables(void)
{
    int i, j;
    for (i = 0; i < max_variables; i++) {
        for (j = 0; j < 8; j++) {
            var_list[i][j] = NULL;
        }
    }
}
