/* target
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __TARGET_H__
#define __TARGET_H__

typedef enum {
    t_none,
    t_16c84, t_16f84,
    t_16f877,
    t_sx18, t_sx28,
    t_12c509a, t_12c508,
    t_12ce674, t_16f628,
    t_18f252, t_18f242, t_18f442, t_18f452,
    t_12f629, t_12f675, t_16f88, t_16f876, t_16f873     /* Added 16f876 & 16f873 by Javi 2003-03-01 */
} chip_t;

extern char chip_name[][20];
extern chip_t target_chip;
typedef enum { a_none, pic_12, pic_14, pic_16, sx_12 } cpu_t;
extern char cpu_name[][20];
extern cpu_t target_cpu;
extern char *target_name;
extern int target_clock;
extern int target_first_rom;
extern int target_last_rom;
extern int target_first_ram;
extern int target_last_ram;
extern int target_fuses;
extern int target_origin;
#define target_fuses_array_size 16
extern int target_fuses_array[ target_fuses_array_size ];
extern int target_fuses_count;


/* configuration */
typedef enum { osc_none, osc_hs, osc_xt, osc_rc, osc_lp, osc_int } osc_t;
extern char osc_name[][20];
extern char osc_name_509[][20];

extern osc_t config_osc;
extern boolean config_watchdog;
extern boolean config_protection;
extern boolean config_int_mclr;
extern boolean config_powerup;

#endif
