# Contributing to CGDB

## Submitting Patches

### Submission Process

If you are interested in contributing to CGDB, discuss your ideas with CGDB's
active maintainers. Once a feature or bug has been agreed to be worked on by
both parties, fork CGDB and develop your feature in a new branch. Commit and
push your changes and send a pull request when ready.

### Signed-off-by Process

CGDB uses the signed-off-by language and process, used by the Linux kernel, to
give us a clear chain of trust for every patch received.

In short, you need to include a signed-off-by tag in every patch. This is a
developer's certification that he or she has the right to submit the patch for
inclusion in this project. It is an agreement to the Developer's Certificate of
Origin (below). Code without a proper signoff cannot be merged into the
mainline.

When submitting code for inclusion in CGDB, you agree to allow the project
owners to license your work under the terms of the Modified BSD License and the
GPL version 2 or later.

To sign-off a commit, use the `-s` or `--signoff` option.

### Developer's Certificate of Origin

By making a contribution to this project, I certify that:

  (a) The contribution was created in whole or in part by me and I
      have the right to submit it under the open source license
      indicated in the file; or

  (b) The contribution is based upon previous work that, to the best
      of my knowledge, is covered under an appropriate open source
      license and I have the right under that license to submit that
      work with modifications, whether created in whole or in part
      by me, under the same open source license (unless I am
      permitted to submit under a different license), as indicated
      in the file; or

  (c) The contribution was provided directly to me by some other
      person who certified (a), (b) or (c) and I have not modified
      it.

  (d) I understand and agree that this project and the contribution
      are public and that a record of the contribution (including all
      personal information I submit with it, including my sign-off) is
      maintained indefinitely and may be redistributed consistent with
      this project or the open source license(s) involved.
