<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/squid/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/squid/metadata.yaml"
sidebar_label: "Squid"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Web Servers and Web Proxies"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Squid


<img src="https://netdata.cloud/img/squid.png" width="150"/>


Plugin: python.d.plugin
Module: squid

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors statistics about the Squid Clients and Servers, like bandwidth and requests.


It collects metrics from the endpoint where Squid exposes its `counters` data.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, this collector will try to autodetect where Squid presents its `counters` data, by trying various configurations.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Squid instance

These metrics refer to each monitored Squid instance.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| squid.clients_net | in, out, hits | kilobits/s |
| squid.clients_requests | requests, hits, errors | requests/s |
| squid.servers_net | in, out | kilobits/s |
| squid.servers_requests | requests, errors | requests/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Configure Squid's Cache Manager

Take a look at [Squid's official documentation](https://wiki.squid-cache.org/Features/CacheManager/Index#controlling-access-to-the-cache-manager) on how to configure access to the Cache Manager.



### Configuration

#### File

The configuration file name for this integration is `python.d/squid.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/squid.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 1 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. | local | no |
| host | The host to connect to. |  | yes |
| port | The port to connect to. |  | yes |
| request | The URL to request from Squid. |  | yes |

</details>

#### Examples

##### Basic

A basic configuration example.

```yaml
example_job_name:
  name: 'local'
  host: 'localhost'
  port: 3128
  request: 'cache_object://localhost:3128/counters'

```
##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
local_job:
  name: 'local'
  host: '127.0.0.1'
  port: 3128
  request: 'cache_object://127.0.0.1:3128/counters'

remote_job:
  name: 'remote'
  host: '192.0.2.1'
  port: 3128
  request: 'cache_object://192.0.2.1:3128/counters'

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `squid` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin squid debug trace
  ```


