<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/upsd/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/upsd/metadata.yaml"
sidebar_label: "UPS (NUT)"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/UPS"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# UPS (NUT)


<img src="https://netdata.cloud/img/plug-circle-bolt.svg" width="150"/>


Plugin: go.d.plugin
Module: upsd

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Uninterruptible Power Supplies by polling the UPS daemon using the NUT network protocol.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per ups

These metrics refer to the UPS unit.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| ups_name | UPS name. |
| battery_type | Battery type (chemistry). "battery.type" variable value. |
| device_model | Device model. "device.mode" variable value. |
| device_serial | Device serial number. "device.serial" variable value. |
| device_manufacturer | Device manufacturer. "device.mfr" variable value. |
| device_type | Device type (ups, pdu, scd, psu, ats). "device.type" variable value. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| upsd.ups_load | load | percentage |
| upsd.ups_load_usage | load_usage | Watts |
| upsd.ups_status | on_line, on_battery, low_battery, high_battery, replace_battery, charging, discharging, bypass, calibration, offline, overloaded, trim_input_voltage, boost_input_voltage, forced_shutdown, other | status |
| upsd.ups_temperature | temperature | Celsius |
| upsd.ups_battery_charge | charge | percentage |
| upsd.ups_battery_estimated_runtime | runtime | seconds |
| upsd.ups_battery_voltage | voltage | Volts |
| upsd.ups_battery_voltage_nominal | nominal_voltage | Volts |
| upsd.ups_input_voltage | voltage | Volts |
| upsd.ups_input_voltage_nominal | nominal_voltage | Volts |
| upsd.ups_input_current | current | Ampere |
| upsd.ups_input_current_nominal | nominal_current | Ampere |
| upsd.ups_input_frequency | frequency | Hz |
| upsd.ups_input_frequency_nominal | nominal_frequency | Hz |
| upsd.ups_output_voltage | voltage | Volts |
| upsd.ups_output_voltage_nominal | nominal_voltage | Volts |
| upsd.ups_output_current | current | Ampere |
| upsd.ups_output_current_nominal | nominal_current | Ampere |
| upsd.ups_output_frequency | frequency | Hz |
| upsd.ups_output_frequency_nominal | nominal_frequency | Hz |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ upsd_10min_ups_load ](https://github.com/netdata/netdata/blob/master/src/health/health.d/upsd.conf) | upsd.ups_load | UPS ${label:ups_name} average load over the last 10 minutes |
| [ upsd_ups_battery_charge ](https://github.com/netdata/netdata/blob/master/src/health/health.d/upsd.conf) | upsd.ups_battery_charge | UPS ${label:ups_name} average battery charge over the last minute |
| [ upsd_ups_last_collected_secs ](https://github.com/netdata/netdata/blob/master/src/health/health.d/upsd.conf) | upsd.ups_load | UPS ${label:ups_name} number of seconds since the last successful data collection |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/upsd.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/upsd.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| address | UPS daemon address in IP:PORT format. | 127.0.0.1:3493 | yes |
| timeout | Connection/read/write timeout in seconds. The timeout includes name resolution, if required. | 2 | no |

</details>

#### Examples

##### Basic

A basic example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:3493

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:3493

  - name: remote
    address: 203.0.113.0:3493

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `upsd` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m upsd
  ```


