<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/hpssa/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/hpssa/metadata.yaml"
sidebar_label: "HPE Smart Arrays"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Storage, Mount Points and Filesystems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# HPE Smart Arrays


<img src="https://netdata.cloud/img/hp.svg" width="150"/>


Plugin: go.d.plugin
Module: hpssa

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitors the health of HPE Smart Arrays by tracking the status of controllers, arrays, logical and physical drives in your storage system.
It relies on the `ssacli` CLI tool but avoids directly executing the binary.
Instead, it utilizes `ndsudo`, a Netdata helper specifically designed to run privileged commands securely within the Netdata environment.
This approach eliminates the need to use `sudo`, improving security and potentially simplifying permission management.

Executed commands:
-  `ssacli ctrl all show config detail`




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per controller

These metrics refer to the Controller.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| slot | Slot number |
| model | Controller model |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hpssa.controller_status | ok, nok | status |
| hpssa.controller_temperature | temperature | Celsius |
| hpssa.controller_cache_module_presence_status | present, not_present | status |
| hpssa.controller_cache_module_status | ok, nok | status |
| hpssa.controller_cache_module_temperature | temperature | Celsius |
| hpssa.controller_cache_module_battery_status | ok, nok | status |

### Per array

These metrics refer to the Array.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| slot | Slot number |
| array_id | Array id |
| interface_type | Array interface type (e.g. SATA) |
| array_type | Array type (e.g. Data) |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hpssa.array_status | ok, nok | status |

### Per logical drive

These metrics refer to the Logical Drive.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| slot | Slot number |
| array_id | Array id |
| logical_drive_id | Logical Drive id (number) |
| disk_name | Disk name (e.g. /dev/sda) |
| drive_type | Drive type (e.g. Data) |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hpssa.logical_drive_status | ok, nok | status |

### Per physical drive

These metrics refer to the Physical Drive.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| slot | Slot number |
| array_id | Array id or "na" if unassigned |
| logical_drive_id | Logical Drive id or "na" if unassigned |
| location | Drive location in port:box:bay format (e.g. 1I:1:1) |
| interface_type | Drive interface type (e.g. SATA) |
| drive_type | Drive type (e.g. Data Drive, Unassigned Drive) |
| model | Drive model |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hpssa.physical_drive_status | ok, nok | status |
| hpssa.physical_drive_temperature | temperature | status |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Install ssacli

See [official installation instructions](https://support.hpe.com/connect/s/softwaredetails?language=en_US&collectionId=MTX-0cb3f808e2514d3d).



### Configuration

#### File

The configuration file name for this integration is `go.d/ssacli.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/ssacli.conf
```
#### Options

The following options can be defined globally: update_every.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| timeout | ssacli binary execution timeout. | 2 | no |

</details>

#### Examples

##### Custom update_every

Allows you to override the default data collection interval.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: hpssa
    update_every: 5  # Collect HPE Smart Array statistics every 5 seconds

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `hpssa` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m hpssa
  ```


