/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.dsi;

import java.util.LinkedList;
import java.util.List;
import org.jitsi.utils.dsi.ActiveSpeakerChangedListener;
import org.jitsi.utils.dsi.ActiveSpeakerDetector;

public abstract class AbstractActiveSpeakerDetector<T>
implements ActiveSpeakerDetector<T> {
    private final List<ActiveSpeakerChangedListener<T>> listeners = new LinkedList<ActiveSpeakerChangedListener<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActiveSpeakerChangedListener(ActiveSpeakerChangedListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<ActiveSpeakerChangedListener<T>> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    protected void fireActiveSpeakerChanged(T id) {
        for (ActiveSpeakerChangedListener<T> listener : this.listeners) {
            listener.activeSpeakerChanged(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveSpeakerChangedListener(ActiveSpeakerChangedListener<T> listener) {
        if (listener != null) {
            List<ActiveSpeakerChangedListener<T>> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }
}

