/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputInfo;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.JupyterWebOutputPanel;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookCefManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenViewComponent;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020\u0011H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffscreenCellOutput;", "Lcom/intellij/openapi/Disposable$Default;", "info", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;", "cefManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookCefManager;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookCefManager;)V", "getInfo", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;", "setInfo", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;)V", "component", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/JupyterWebOutputPanel;", "getComponent", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/JupyterWebOutputPanel;", "id", "", "getId$intellij_jupyter_core", "()Ljava/lang/String;", "viewport", "Ljava/awt/Rectangle;", "getViewport", "()Ljava/awt/Rectangle;", "createOrUpdateViewPort", "", "bounds", "initViewComponent", "viewComponent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;", "createPort", "top", "", "height", "toString", "intellij.jupyter.core"})
public final class NotebookOffscreenCellOutput
implements Disposable.Default {
    @NotNull
    private JupyterWebOutputInfo info;
    @NotNull
    private final NotebookCefManager cefManager;
    @NotNull
    private final JupyterWebOutputPanel component;

    public NotebookOffscreenCellOutput(@NotNull JupyterWebOutputInfo info, @NotNull NotebookCefManager cefManager) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)cefManager, (String)"cefManager");
        this.info = info;
        this.cefManager = cefManager;
        this.component = new JupyterWebOutputPanel(this);
    }

    @NotNull
    public final JupyterWebOutputInfo getInfo() {
        return this.info;
    }

    public final void setInfo(@NotNull JupyterWebOutputInfo jupyterWebOutputInfo) {
        Intrinsics.checkNotNullParameter((Object)jupyterWebOutputInfo, (String)"<set-?>");
        this.info = jupyterWebOutputInfo;
    }

    @NotNull
    public final JupyterWebOutputPanel getComponent() {
        return this.component;
    }

    @NotNull
    public final String getId$intellij_jupyter_core() {
        return this.info.getId();
    }

    @Nullable
    public final Rectangle getViewport() {
        NotebookOutputInlayShowable notebookOutputInlayShowable = this.component.getViewComponent();
        return notebookOutputInlayShowable != null && (notebookOutputInlayShowable = notebookOutputInlayShowable.getViewPort()) != null ? notebookOutputInlayShowable.getBounds() : null;
    }

    public final void createOrUpdateViewPort(@NotNull Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        JcefOffScreenViewComponent viewComponent = this.component.getViewComponent();
        if (viewComponent == null) {
            this.createPort(bounds.y, bounds.height);
        } else {
            viewComponent.getViewPort().setBounds(bounds);
        }
    }

    private final void initViewComponent(JcefOffScreenViewComponent viewComponent) {
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> NotebookOffscreenCellOutput.initViewComponent$lambda$0(this, viewComponent), (int)1, null);
    }

    private final void createPort(int top, int height) {
        JcefOffScreenViewComponent viewComponent = new JcefOffScreenViewComponent(this.getId$intellij_jupyter_core().hashCode(), this.cefManager, top, height);
        Disposer.register((Disposable)((Disposable)this), (Disposable)viewComponent);
        this.initViewComponent(viewComponent);
        this.component.setViewComponent(viewComponent);
        this.component.add((Component)viewComponent, "Center");
        this.component.revalidate();
    }

    @NotNull
    public String toString() {
        return "NotebookOffscreenCellOutput(id='" + this.getId$intellij_jupyter_core() + "', index=" + this.info.getCellIndex() + ", cellId=" + this.info.getCellId() + ", cellIndex=" + this.info.getCellIndex() + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Unit initViewComponent$lambda$0(NotebookOffscreenCellOutput this$0, JcefOffScreenViewComponent $viewComponent) {
        int n;
        if (this$0.info.getCellId() != null) {
            Object object = JupyterEditorExtensionsKt.getNotebookOrNull(this$0.cefManager.getEditor());
            if (object == null || (object = object.getCellById(this$0.info.getCellId())) == null || (object = object.getIndex()) == null) return Unit.INSTANCE;
            n = (Integer)object;
        } else {
            n = this$0.info.getCellIndex();
        }
        int index = n;
        NotebookIntervalPointer notebookIntervalPointer = NotebookIntervalPointerFactory.Companion.get(this$0.cefManager.getEditor()).getForOrdinalIfExists(index);
        if (notebookIntervalPointer == null) {
            return Unit.INSTANCE;
        }
        NotebookIntervalPointer pointer = notebookIntervalPointer;
        NotebookCellLines.Interval interval = pointer.get();
        boolean isCode = (interval != null ? interval.getType() : null) == NotebookCellLines.CellType.CODE;
        $viewComponent.setIntervalPointer(pointer);
        PopupHandler.installPopupMenu((JComponent)$viewComponent, (String)(isCode ? "JupyterWebOutputPopupActions" : "JupyterMarkdownOutputPopupActions"), (String)"JcefOffScreenViewComponent");
        return Unit.INSTANCE;
    }
}

