/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.nbformat.metadata.ExecutionTimeMetadataKt;
import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"endTime", "startTime"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000f\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/metadata/ExecutionTimeMetadata;", "", "startTime", "", "endTime", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getStartTime", "()Ljava/lang/String;", "setStartTime", "(Ljava/lang/String;)V", "getEndTime", "setEndTime", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.jupyter.core"})
public final class ExecutionTimeMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String startTime;
    @Nullable
    private String endTime;
    @NotNull
    public static final String keyExecutionTimeMeta = "ExecuteTime";

    public ExecutionTimeMetadata(@JsonProperty(value="start_time") @Nullable String startTime, @JsonProperty(value="end_time") @Nullable String endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public /* synthetic */ ExecutionTimeMetadata(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Nullable
    public final String getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(@Nullable String string) {
        this.startTime = string;
    }

    @Nullable
    public final String getEndTime() {
        return this.endTime;
    }

    public final void setEndTime(@Nullable String string) {
        this.endTime = string;
    }

    @Nullable
    public final String component1() {
        return this.startTime;
    }

    @Nullable
    public final String component2() {
        return this.endTime;
    }

    @NotNull
    public final ExecutionTimeMetadata copy(@JsonProperty(value="start_time") @Nullable String startTime, @JsonProperty(value="end_time") @Nullable String endTime) {
        return new ExecutionTimeMetadata(startTime, endTime);
    }

    public static /* synthetic */ ExecutionTimeMetadata copy$default(ExecutionTimeMetadata executionTimeMetadata, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = executionTimeMetadata.startTime;
        }
        if ((n & 2) != 0) {
            string2 = executionTimeMetadata.endTime;
        }
        return executionTimeMetadata.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "ExecutionTimeMetadata(startTime=" + this.startTime + ", endTime=" + this.endTime + ")";
    }

    public int hashCode() {
        int result = this.startTime == null ? 0 : this.startTime.hashCode();
        result = result * 31 + (this.endTime == null ? 0 : this.endTime.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExecutionTimeMetadata)) {
            return false;
        }
        ExecutionTimeMetadata executionTimeMetadata = (ExecutionTimeMetadata)other;
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)executionTimeMetadata.startTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endTime, (Object)executionTimeMetadata.endTime);
    }

    public ExecutionTimeMetadata() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/metadata/ExecutionTimeMetadata$Companion;", "", "<init>", "()V", "keyExecutionTimeMeta", "", "createExecutionMetadata", "Lcom/intellij/jupyter/core/jupyter/nbformat/metadata/ExecutionTimeMetadata;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "formattingExecutionTime", "executionTime", "Ljava/time/ZonedDateTime;", "parseExecutionMetadata", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutionTimeMetadata createExecutionMetadata(@Nullable JsonNode node) {
            ExecutionTimeMetadata executionTimeMetadata;
            if (node != null) {
                Object object = JupyterJsonKt.getJackson().treeToValue((TreeNode)node, ExecutionTimeMetadata.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"treeToValue(...)");
                executionTimeMetadata = (ExecutionTimeMetadata)object;
            } else {
                executionTimeMetadata = new ExecutionTimeMetadata(null, null, 3, null);
            }
            return executionTimeMetadata;
        }

        @Nullable
        public final String formattingExecutionTime(@Nullable ZonedDateTime executionTime) {
            String string;
            try {
                ZonedDateTime zonedDateTime = executionTime;
                string = zonedDateTime != null && (zonedDateTime = zonedDateTime.withZoneSameInstant(ZoneOffset.UTC)) != null ? zonedDateTime.toString() : null;
            }
            catch (DateTimeException ex) {
                Object[] objectArray = new Object[]{executionTime, ex.getMessage()};
                ExecutionTimeMetadataKt.access$getLOG$p().error(MessageFormat.format("Error while parsing local date from metadata {0}. {1}", objectArray));
                string = null;
            }
            return string;
        }

        @Nullable
        public final ZonedDateTime parseExecutionMetadata(@NotNull String executionTime) {
            ZonedDateTime zonedDateTime;
            Intrinsics.checkNotNullParameter((Object)executionTime, (String)"executionTime");
            try {
                zonedDateTime = ZonedDateTime.parse(executionTime).withZoneSameInstant(ZoneId.systemDefault());
            }
            catch (DateTimeParseException ex) {
                Object[] objectArray = new Object[]{executionTime, ex.getMessage()};
                ExecutionTimeMetadataKt.access$getLOG$p().error(MessageFormat.format("Error while parsing local date from metadata {0}. {1}", objectArray));
                zonedDateTime = null;
            }
            return zonedDateTime;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

