/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.util.concurrent.Future;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.ContentResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;

public class Async {
    private Executor executor;
    private java.util.concurrent.Executor concurrentExec;

    public static Async newInstance() {
        return new Async();
    }

    Async() {
    }

    public Async use(Executor executor2) {
        this.executor = executor2;
        return this;
    }

    public Async use(java.util.concurrent.Executor concurrentExec) {
        this.concurrentExec = concurrentExec;
        return this;
    }

    public <T> Future<T> execute(Request request, ResponseHandler<T> handler2, FutureCallback<T> callback2) {
        BasicFuture future = new BasicFuture(callback2);
        ExecRunnable<T> runnable = new ExecRunnable<T>(future, request, this.executor != null ? this.executor : Executor.newInstance(), handler2);
        if (this.concurrentExec != null) {
            this.concurrentExec.execute(runnable);
        } else {
            Thread t = new Thread(runnable);
            t.setDaemon(true);
            t.start();
        }
        return future;
    }

    public <T> Future<T> execute(Request request, ResponseHandler<T> handler2) {
        return this.execute(request, handler2, null);
    }

    public Future<Content> execute(Request request, FutureCallback<Content> callback2) {
        return this.execute(request, (ResponseHandler)new ContentResponseHandler(), (FutureCallback)callback2);
    }

    public Future<Content> execute(Request request) {
        return this.execute(request, (ResponseHandler)new ContentResponseHandler(), null);
    }

    static class ExecRunnable<T>
    implements Runnable {
        private final BasicFuture<T> future;
        private final Request request;
        private final Executor executor;
        private final ResponseHandler<T> handler;

        ExecRunnable(BasicFuture<T> future, Request request, Executor executor2, ResponseHandler<T> handler2) {
            this.future = future;
            this.request = request;
            this.executor = executor2;
            this.handler = handler2;
        }

        @Override
        public void run() {
            try {
                Response response = this.executor.execute(this.request);
                T result = response.handleResponse(this.handler);
                this.future.completed(result);
            }
            catch (Exception ex) {
                this.future.failed(ex);
            }
        }
    }
}

