/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/jsonSchema/impl/fixes/RemoveDuplicateArrayItemsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "indices", "", "<init>", "([I)V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.json.backend"})
@SourceDebugExtension(value={"SMAP\nRemoveDuplicateArrayItemsFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveDuplicateArrayItemsFix.kt\ncom/jetbrains/jsonSchema/impl/fixes/RemoveDuplicateArrayItemsFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n785#2:30\n796#2:31\n1878#2,2:32\n797#2,2:34\n1880#2:36\n799#2:37\n1617#2,9:38\n1869#2:47\n1870#2:49\n1626#2:50\n1#3:48\n*S KotlinDebug\n*F\n+ 1 RemoveDuplicateArrayItemsFix.kt\ncom/jetbrains/jsonSchema/impl/fixes/RemoveDuplicateArrayItemsFix\n*L\n21#1:30\n21#1:31\n21#1:32,2\n21#1:34,2\n21#1:36\n21#1:37\n22#1:38,9\n22#1:47\n22#1:49\n22#1:50\n22#1:48\n*E\n"})
public final class RemoveDuplicateArrayItemsFix
implements LocalQuickFix {
    @NotNull
    private final int[] indices;

    public RemoveDuplicateArrayItemsFix(@NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        this.indices = indices;
    }

    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message((String)"remove.duplicated.items", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIndexedTo$iv$iv;
        JsonArrayValueAdapter jsonArrayValueAdapter;
        Object it2;
        JsonLikePsiWalker walker;
        block7: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            JsonLikePsiWalker jsonLikePsiWalker = JsonLikePsiWalker.getWalker(descriptor.getPsiElement(), null);
            if (jsonLikePsiWalker == null) {
                return;
            }
            walker = jsonLikePsiWalker;
            PsiElement psiElement = descriptor.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
            for (Object it2 : PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)true)) {
                boolean bl = false;
                JsonValueAdapter jsonValueAdapter = walker.createValueAdapter((PsiElement)it2);
                it2 = jsonValueAdapter != null ? jsonValueAdapter.getAsArray() : null;
                if (it2 == null) continue;
                jsonArrayValueAdapter = it2;
                break block7;
            }
            jsonArrayValueAdapter = null;
        }
        if (jsonArrayValueAdapter == null) {
            return;
        }
        JsonArrayValueAdapter parentArray = jsonArrayValueAdapter;
        List<JsonValueAdapter> list = parentArray.getElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getElements(...)");
        Iterable $this$filterIndexed$iv = list;
        boolean $i$f$filterIndexed = false;
        it2 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            JsonValueAdapter cfr_ignored_0 = (JsonValueAdapter)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (!ArraysKt.contains((int[])this.indices, (int)index)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIndexedTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JsonValueAdapter it3 = (JsonValueAdapter)element$iv$iv;
            boolean bl3 = false;
            if (it3.getDelegate() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elementsToDelete = (List)destination$iv$iv;
        for (PsiElement it4 : elementsToDelete) {
            if (it4.getTextRange().intersects(descriptor.getPsiElement().getTextRange())) continue;
            JsonLikeSyntaxAdapter jsonLikeSyntaxAdapter = walker.getSyntaxAdapter(project);
            if (jsonLikeSyntaxAdapter == null) continue;
            jsonLikeSyntaxAdapter.removeArrayItem(it4);
        }
    }
}

