/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.warmup.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/warmup/util/ConsoleLog;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "info", "", "message", "", "warn", "error", "cause", "", "intellij.platform.warmup"})
public final class ConsoleLog {
    @NotNull
    public static final ConsoleLog INSTANCE = new ConsoleLog();
    @NotNull
    private static final Logger LOG;

    private ConsoleLog() {
    }

    public final void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LOG.info(message);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            System.out.println((Object)message);
        }
    }

    public final void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LOG.warn(message);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            System.out.println((Object)("WARN - " + message));
        }
    }

    public final void error(@NotNull String message, @Nullable Throwable cause) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LOG.error(message, cause);
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) break block1;
            System.out.println((Object)("ERROR - " + message));
            Throwable throwable = cause;
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public static /* synthetic */ void error$default(ConsoleLog consoleLog, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        consoleLog.error(string, throwable);
    }

    static {
        Logger logger = Logger.getInstance(ConsoleLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

