/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.driver.impl;

import com.intellij.driver.impl.CallTarget;
import com.intellij.driver.impl.HardReference;
import com.intellij.driver.impl.InvokerMBean;
import com.intellij.driver.impl.RefProducer;
import com.intellij.driver.model.DriverIllegalStateException;
import com.intellij.driver.model.LockSemantics;
import com.intellij.driver.model.OnDispatcher;
import com.intellij.driver.model.ProductVersion;
import com.intellij.driver.model.RdTarget;
import com.intellij.driver.model.transport.NewInstanceCall;
import com.intellij.driver.model.transport.Ref;
import com.intellij.driver.model.transport.RefCall;
import com.intellij.driver.model.transport.RefList;
import com.intellij.driver.model.transport.RemoteCall;
import com.intellij.driver.model.transport.RemoteCallResult;
import com.intellij.driver.model.transport.ServiceCall;
import com.intellij.driver.model.transport.UtilityCall;
import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.awt.IllegalComponentStateException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Invoker
implements InvokerMBean {
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    private static final int GLOBAL_SESSION_ID = 0;
    static final AtomicInteger REF_SEQUENCE = new AtomicInteger(1);
    private final Map<Integer, Session> sessions;
    private final AtomicInteger sessionIdSequence;
    private final Map<String, WeakReference<Object>> adhocReferenceMap;
    private final ClearableLazyValue<IJTracer> tracer;
    private final Function<String, String> screenshotAction;
    private final Supplier<? extends Context> timedContextSupplier;
    private final RdTarget rdTarget;

    public Invoker(RdTarget rdTarget, final @NotNull Supplier<? extends IJTracer> tracerSupplier, @NotNull Supplier<? extends Context> timedContextSupplier, @NotNull Function<String, String> screenshotAction) {
        if (tracerSupplier == null) {
            Invoker.$$$reportNull$$$0(0);
        }
        if (timedContextSupplier == null) {
            Invoker.$$$reportNull$$$0(1);
        }
        if (screenshotAction == null) {
            Invoker.$$$reportNull$$$0(2);
        }
        this.sessions = new ConcurrentHashMap<Integer, Session>();
        this.sessionIdSequence = new AtomicInteger(1);
        this.adhocReferenceMap = new ConcurrentHashMap<String, WeakReference<Object>>();
        this.rdTarget = rdTarget;
        this.timedContextSupplier = timedContextSupplier;
        this.tracer = new ClearableLazyValue<IJTracer>(){

            @NotNull
            protected IJTracer compute() {
                IJTracer iJTracer = (IJTracer)tracerSupplier.get();
                if (iJTracer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iJTracer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/driver/impl/Invoker$1", "compute"));
            }
        };
        this.screenshotAction = screenshotAction;
        this.sessions.put(0, new GlobalSession());
    }

    @Override
    public ProductVersion getProductVersion() {
        BuildNumber build = ApplicationInfoImpl.getShadowInstanceImpl().getBuild();
        return new ProductVersion(build.getProductCode(), build.isSnapshot(), build.getBaselineVersion(), build.asString());
    }

    @Override
    public boolean isApplicationInitialized() {
        Application application = ApplicationManager.getApplication();
        return application != null && ((ApplicationEx)application).isComponentCreated();
    }

    @Override
    public void exit() {
        SwingUtilities.invokeLater(() -> {
            Application app = ApplicationManager.getApplication();
            app.invokeLater(() -> app.exit(true, true, false), ModalityState.current());
        });
    }

    @Override
    @NotNull
    public RemoteCallResult invoke(@NotNull RemoteCall call) {
        Object result;
        Object instance;
        if (call == null) {
            Invoker.$$$reportNull$$$0(3);
        }
        Object[] transformedArgs = this.transformArgs(call);
        if (call instanceof NewInstanceCall) {
            Class<?> targetClass = this.getTargetClass(call);
            Constructor<?> constructor = Invoker.getConstructor(call, targetClass, transformedArgs);
            LOG.debug("Creating instance of " + String.valueOf(targetClass));
            Object result2 = this.withSemantics(call, () -> Invoker.invokeConstructor(constructor, transformedArgs));
            return Invoker.getRemoteCallResult(this.sessions.get(call.getSessionId()), result2);
        }
        CallTarget callTarget = this.getCallTarget(call, transformedArgs);
        LOG.debug("Calling " + String.valueOf(callTarget));
        try {
            instance = this.findInstance(call, callTarget);
        }
        catch (Exception e) {
            if (!call.getMethodName().equals("isShowing")) {
                LOG.error("Unable to get instance for " + String.valueOf(call));
            }
            throw new DriverIllegalStateException("Unable to get instance for " + String.valueOf(call), e);
        }
        if (call.getDispatcher() == OnDispatcher.EDT) {
            Object[] res = new Object[1];
            ModalityState[] modalityState = new ModalityState[1];
            try {
                SwingUtilities.invokeAndWait(() -> {
                    modalityState[0] = ModalityState.current();
                });
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            Application app = ApplicationManager.getApplication();
            Runnable runnable = () -> {
                res[0] = this.withSemantics(call, () -> Invoker.invokeMethod(callTarget, instance, transformedArgs));
            };
            if (call.getLockSemantics() == LockSemantics.NO_LOCK && app instanceof ApplicationEx) {
                ApplicationEx applicationEx = (ApplicationEx)app;
                applicationEx.invokeAndWaitRelaxed(runnable, modalityState[0]);
            } else {
                app.invokeAndWait(runnable, modalityState[0]);
            }
            result = res[0];
        } else {
            result = this.withSemantics(call, () -> Invoker.invokeMethod(callTarget, instance, transformedArgs));
        }
        return Invoker.getRemoteCallResult(this.sessions.get(call.getSessionId()), callTarget, result);
    }

    @Override
    @NotNull
    public Ref putAdhocReference(@NotNull Object item) {
        if (item == null) {
            Invoker.$$$reportNull$$$0(4);
        }
        return Invoker.putAdhocReference(item, this.sessions.get(0));
    }

    @NotNull
    private Object getReference(int sessionId, String id) {
        Session session = this.sessions.get(sessionId);
        if (session == null) {
            throw new DriverIllegalStateException("No such session " + sessionId);
        }
        Object value = session.findReference(id);
        if (value != null) {
            Object object = value;
            if (object == null) {
                Invoker.$$$reportNull$$$0(5);
            }
            return object;
        }
        for (Session s : this.sessions.values()) {
            value = s.findReference(id);
            if (value == null) continue;
            Object object = value;
            if (object == null) {
                Invoker.$$$reportNull$$$0(6);
            }
            return object;
        }
        throw new DriverIllegalStateException("No such reference with id " + id + ". It may happen if a weak reference to the variable expires. Please use `Driver.withContext { }` for hard variable references.");
    }

    @NotNull
    private static Object invokeConstructor(Constructor<?> constructor, Object[] transformedArgs) throws Exception {
        Object obj;
        try {
            obj = constructor.newInstance(transformedArgs);
        }
        catch (IllegalArgumentException ie) {
            String message = "Argument type mismatch for constructor " + String.valueOf(constructor) + " , actual types are [" + Invoker.getExpectedTypesMessage(transformedArgs) + "]";
            LOG.warn(message, (Throwable)ie);
            throw new IllegalArgumentException(message, ie);
        }
        catch (Throwable e) {
            LOG.warn("Error during remote driver call " + String.valueOf(constructor), e);
            throw e;
        }
        if (obj == null) {
            Invoker.$$$reportNull$$$0(7);
        }
        return obj;
    }

    @NotNull
    private static String getExpectedTypesMessage(Object[] transformedArgs) {
        String string = Arrays.stream(transformedArgs).map(a -> {
            if (a == null) {
                return "null";
            }
            return a.getClass().getSimpleName();
        }).collect(Collectors.joining(", "));
        if (string == null) {
            Invoker.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static Object invokeMethod(CallTarget callTarget, Object instance, Object[] args) throws Exception {
        try {
            return callTarget.targetMethod().invoke(instance, args);
        }
        catch (IllegalArgumentException ie) {
            String message = "Argument type mismatch for call " + String.valueOf(callTarget.targetMethod()) + ", actual types are [" + Invoker.getExpectedTypesMessage(args) + "]";
            LOG.warn(message, (Throwable)ie);
            throw new IllegalArgumentException(message, ie);
        }
        catch (Throwable e) {
            LOG.warn("Error during remote driver call " + String.valueOf(callTarget.targetMethod()), e);
            throw e;
        }
    }

    @Nullable
    private Object withSemantics(@NotNull RemoteCall call, @NotNull Callable<?> supplier) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(9);
        }
        if (supplier == null) {
            Invoker.$$$reportNull$$$0(10);
        }
        switch (call.getLockSemantics()) {
            case NO_LOCK: {
                return this.call(call, supplier);
            }
            case READ_ACTION: {
                if (call.getDispatcher() == OnDispatcher.EDT) {
                    return WriteIntentReadAction.compute(() -> this.call(call, supplier));
                }
                return ReadAction.compute(() -> this.call(call, supplier));
            }
            case WRITE_ACTION: {
                return WriteAction.compute(() -> this.call(call, supplier));
            }
        }
        throw new UnsupportedOperationException("Unsupported LockSemantics " + String.valueOf((Object)call.getLockSemantics()));
    }

    @Nullable
    private Object call(@NotNull RemoteCall call, @NotNull Callable<?> supplier) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(11);
        }
        if (supplier == null) {
            Invoker.$$$reportNull$$$0(12);
        }
        if (call.getTimedSpan() == null || call.getTimedSpan().isEmpty()) {
            try {
                return supplier.call();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IllegalComponentStateException) {
                    throw (IllegalComponentStateException)e.getCause();
                }
                throw new DriverIllegalStateException(e);
            }
            catch (Exception e) {
                ExceptionUtil.rethrow((Throwable)e);
                throw new IllegalStateException();
            }
        }
        SpanBuilder spanBuilder = ((IJTracer)this.tracer.getValue()).spanBuilder(call.getTimedSpan()).setParent(this.timedContextSupplier.get());
        Span span = spanBuilder.startSpan();
        try {
            Object obj = supplier.call();
            return obj;
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
        finally {
            span.end();
        }
    }

    @Override
    public int newSession() {
        int id = this.sessionIdSequence.getAndIncrement();
        return this.newSession(id);
    }

    @Override
    public int newSession(int id) {
        this.sessions.put(id, new SessionImpl());
        return id;
    }

    private static Constructor<?> getConstructor(@NotNull RemoteCall call, @NotNull Class<?> targetClass, Object[] transformedArgs) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(13);
        }
        if (targetClass == null) {
            Invoker.$$$reportNull$$$0(14);
        }
        int argCount = call.getArgs().length;
        List<Constructor<?>> availableConstructors = Arrays.stream(targetClass.getConstructors()).toList();
        List<Constructor> constructors = availableConstructors.stream().filter(x -> x.getParameterCount() == argCount).toList();
        if (constructors.isEmpty()) {
            throw new IllegalStateException(String.format("No constructor with parameter count %s in class %s. Available constructors: %n%s", argCount, call.getClassName(), availableConstructors.stream().map(it -> it.toString()).collect(Collectors.joining(" - " + System.lineSeparator()))));
        }
        if (constructors.size() > 1) {
            List<@Nullable Class<?>> argumentTypes = Invoker.getArgumentTypes(transformedArgs);
            for (Constructor constructor : constructors) {
                if (!Invoker.areTypesCompatible(constructor.getParameterTypes(), argumentTypes)) continue;
                return constructor;
            }
        }
        return constructors.get(0);
    }

    @NotNull
    private CallTarget getCallTarget(@NotNull RemoteCall call, Object[] transformedArgs) {
        List<Method> targetMethods;
        Class companionClass;
        if (call == null) {
            Invoker.$$$reportNull$$$0(15);
        }
        Class clazz = this.getTargetClass(call);
        int argCount = call.getArgs().length;
        List availableMethods = Arrays.stream(clazz.getMethods()).toList();
        if (call instanceof UtilityCall && Invoker.isKotlinClass(clazz) && (companionClass = (Class)ContainerUtil.find((Object[])clazz.getDeclaredClasses(), c -> c.getName().equals(call.getClassName() + "$Companion"))) != null) {
            clazz = companionClass;
            availableMethods = availableMethods.stream().filter(m -> Modifier.isStatic(m.getModifiers())).toList();
            List<Method> companionNotStaticMethods = Arrays.stream(clazz.getMethods()).filter(m -> m.getAnnotation(JvmStatic.class) == null).toList();
            availableMethods = ContainerUtil.concat(availableMethods, companionNotStaticMethods);
        }
        if ((targetMethods = availableMethods.stream().filter(m -> m.getName().equals(call.getMethodName()) && argCount == m.getParameterCount()).toList()).isEmpty()) {
            StringBuilder message = new StringBuilder(String.format("No method '%s' with parameter count %s in class %s.", call.getMethodName(), argCount, call.getClassName()));
            if (call instanceof UtilityCall && Invoker.isKotlinClass(clazz)) {
                message.append(System.lineSeparator()).append("For utility call only static methods were checked. If there is a companion object, its methods were also checked.");
            }
            message.append(String.format("\nAvailable methods: %n%s", availableMethods.stream().map(it -> it.toString()).collect(Collectors.joining(" - " + System.lineSeparator()))));
            throw new IllegalStateException(message.toString());
        }
        if (targetMethods.size() > 1) {
            List<@Nullable Class<?>> argumentTypes = Invoker.getArgumentTypes(transformedArgs);
            for (Method method : targetMethods) {
                if (!Invoker.areTypesCompatible(method.getParameterTypes(), argumentTypes)) continue;
                return Invoker.buildCallTarget(clazz, method);
            }
        }
        return Invoker.buildCallTarget(clazz, targetMethods.get(0));
    }

    @NotNull
    private static CallTarget buildCallTarget(Class<?> clazz, Method method) {
        method.setAccessible(true);
        return new CallTarget(clazz, method);
    }

    private static @NotNull List<@Nullable Class<?>> getArgumentTypes(Object[] transformedArgs) {
        List<Class<?>> list = Arrays.stream(transformedArgs).map(a -> {
            if (a == null) {
                return null;
            }
            return a.getClass();
        }).toList();
        if (list == null) {
            Invoker.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static boolean areTypesCompatible(Class<?> @NotNull [] parameterTypes, @NotNull List<@Nullable Class<?>> argumentTypes) {
        if (argumentTypes == null) {
            Invoker.$$$reportNull$$$0(17);
        }
        if (parameterTypes == null) {
            Invoker.$$$reportNull$$$0(18);
        }
        for (int i = 0; i < argumentTypes.size(); ++i) {
            Class<?> parameterType;
            Class<?> argType = argumentTypes.get(i);
            if (argType == null || ClassUtils.isAssignable(argType, parameterType = parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Class<?> getTargetClass(RemoteCall call) {
        Class<?> clazz;
        try {
            clazz = this.getClassLoader(call).loadClass(call.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new DriverIllegalStateException((String)(this.rdTarget == RdTarget.DEFAULT ? "" : String.valueOf((Object)this.rdTarget) + ": ") + "No such class '" + call.getClassName() + "' in plugin " + call.getPluginId(), e);
        }
        Class<?> clazz2 = clazz;
        if (clazz2 == null) {
            Invoker.$$$reportNull$$$0(19);
        }
        return clazz2;
    }

    @NotNull
    private ClassLoader getClassLoader(RemoteCall call) {
        String pluginId = call.getPluginId();
        if (pluginId == null || pluginId.isEmpty()) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                Invoker.$$$reportNull$$$0(20);
            }
            return classLoader;
        }
        if (pluginId.contains("/")) {
            String mainId = StringsKt.substringBefore((String)pluginId, (String)"/", (String)pluginId);
            String moduleId = StringsKt.substringAfter((String)pluginId, (String)"/", (String)pluginId);
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)mainId));
            if (plugin == null) {
                throw new DriverIllegalStateException("No such plugin " + mainId);
            }
            List modules = IdeaPluginDescriptorImplKt.getContentModules((IdeaPluginDescriptorImpl)((IdeaPluginDescriptorImpl)plugin));
            for (ContentModuleDescriptor module : modules) {
                if (!Objects.equals(moduleId, module.getModuleName())) continue;
                ClassLoader classLoader = Objects.requireNonNull(module.getPluginClassLoader());
                if (classLoader == null) {
                    Invoker.$$$reportNull$$$0(21);
                }
                return classLoader;
            }
            throw new DriverIllegalStateException("No such plugin module " + pluginId);
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId));
        if (plugin == null) {
            throw new DriverIllegalStateException("No such plugin " + pluginId);
        }
        ClassLoader classLoader = plugin.getClassLoader();
        if (classLoader == null) {
            Invoker.$$$reportNull$$$0(22);
        }
        return classLoader;
    }

    @Nullable
    private Object findInstance(RemoteCall call, CallTarget callTarget) {
        Class<?> clazz = callTarget.clazz();
        if (call instanceof ServiceCall) {
            Object instance;
            Object projectInstance = null;
            Ref projectRef = ((ServiceCall)call).getProjectRef();
            if (projectRef != null) {
                projectInstance = this.getReference(call.getSessionId(), projectRef.id());
            }
            Class<?> serviceClass = clazz;
            String serviceInterface = ((ServiceCall)call).getServiceInterface();
            if (serviceInterface != null && (serviceClass = Invoker.findServiceInterface(clazz, serviceInterface)) == null) {
                throw new DriverIllegalStateException("Unable to find interface " + serviceInterface + " for service " + String.valueOf(clazz));
            }
            if (projectInstance instanceof Project) {
                instance = ((Project)projectInstance).getService(serviceClass);
                if (instance == null) {
                    instance = ((Project)projectInstance).getServices(serviceClass, ClientKind.CONTROLLER).get(0);
                }
            } else {
                instance = ApplicationManager.getApplication().getService(serviceClass);
                if (instance == null) {
                    instance = ApplicationManager.getApplication().getServices(serviceClass, ClientKind.CONTROLLER).get(0);
                }
            }
            return instance;
        }
        if (call instanceof RefCall) {
            Ref ref = ((RefCall)call).getRef();
            Object reference = this.getReference(call.getSessionId(), ref.id());
            if (reference == null) {
                throw new DriverIllegalStateException("No such ref exists " + String.valueOf(ref));
            }
            return reference;
        }
        if (call instanceof UtilityCall) {
            Object instance = null;
            int modifiers = callTarget.targetMethod().getModifiers();
            if (Modifier.isStatic(modifiers)) {
                return instance;
            }
            if (Invoker.isKotlinClass(clazz)) {
                if (clazz.getName().endsWith("$Companion")) {
                    try {
                        instance = clazz.getEnclosingClass().getDeclaredField("Companion").get(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new DriverIllegalStateException(String.format("Failed to get an instance of a companion class %s", clazz.getName()), e);
                    }
                }
                try {
                    instance = clazz.getDeclaredField("INSTANCE").get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new DriverIllegalStateException(String.format("Failed to get an instance of a Kotlin object %s", clazz.getName()), e);
                }
            }
            return instance;
        }
        throw new UnsupportedOperationException("Unsupported call type " + String.valueOf(call));
    }

    private static boolean isKotlinClass(Class<?> clazz) {
        return clazz.getAnnotation(Metadata.class) != null;
    }

    @Nullable
    private static Class<?> findServiceInterface(@NotNull Class<?> clazz, @NotNull String serviceInterface) {
        if (clazz == null) {
            Invoker.$$$reportNull$$$0(23);
        }
        if (serviceInterface == null) {
            Invoker.$$$reportNull$$$0(24);
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            if (!serviceInterface.equals(anInterface.getName())) continue;
            return anInterface;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            if (serviceInterface.equals(superclass.getName())) {
                return superclass;
            }
            return Invoker.findServiceInterface(superclass, serviceInterface);
        }
        return null;
    }

    private Object @NotNull [] transformArgs(@NotNull RemoteCall call) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(25);
        }
        Object[] args = new Object[call.getArgs().length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = call.getArgs()[i];
            args[i] = this.transformArg(call, arg);
        }
        if (args == null) {
            Invoker.$$$reportNull$$$0(26);
        }
        return args;
    }

    private Object transformArg(@NotNull RemoteCall call, Object arg) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(27);
        }
        if (arg != null && arg.getClass().isArray() && Array.getLength(arg) > 0 && Invoker.arrayAll(arg, item -> item instanceof Ref)) {
            Class<?> componentType = this.getReference(call.getSessionId(), ((Ref)Array.get(arg, 0)).id()).getClass();
            Object result = Array.newInstance(componentType, Array.getLength(arg));
            for (int i = 0; i < Array.getLength(arg); ++i) {
                Array.set(result, i, this.getReference(call.getSessionId(), ((Ref)Array.get(arg, i)).id()));
            }
            return result;
        }
        if (arg instanceof List && !((List)arg).isEmpty() && ContainerUtil.and((Iterable)((List)arg), item -> item instanceof Ref)) {
            return ContainerUtil.map((Collection)((List)arg), item -> this.getReference(call.getSessionId(), ((Ref)item).id()));
        }
        if (arg instanceof Ref) {
            return this.getReference(call.getSessionId(), ((Ref)arg).id());
        }
        return arg;
    }

    @NotNull
    private static RemoteCallResult getRemoteCallResult(@NotNull Session session, @NotNull CallTarget callTarget, Object result) {
        Class componentType;
        Type type;
        Type[] typeArguments;
        Type returnType;
        Method targetMethod;
        if (session == null) {
            Invoker.$$$reportNull$$$0(28);
        }
        if (callTarget == null) {
            Invoker.$$$reportNull$$$0(29);
        }
        if (Collection.class.isAssignableFrom((targetMethod = callTarget.targetMethod()).getReturnType()) ? (returnType = targetMethod.getGenericReturnType()) instanceof ParameterizedType && (typeArguments = ((ParameterizedType)returnType).getActualTypeArguments()).length == 1 && (type = typeArguments[0]) instanceof Class && RemoteCall.isPassByValue(componentType = (Class)type) : targetMethod.getReturnType().isArray() && RemoteCall.isPassByValue(targetMethod.getReturnType().getComponentType())) {
            return new RemoteCallResult(result);
        }
        return Invoker.getRemoteCallResult(session, result);
    }

    @NotNull
    private static Object dereference(@NotNull WeakReference<Object> reference, String id) {
        Object weakTarget;
        if (reference == null) {
            Invoker.$$$reportNull$$$0(30);
        }
        if ((weakTarget = reference.get()) == null) {
            throw new IllegalStateException("Weak reference to variable " + id + " expired. Please use `Driver.withContext { }` for hard variable references.");
        }
        Object t = weakTarget;
        if (t == null) {
            Invoker.$$$reportNull$$$0(31);
        }
        return t;
    }

    @NotNull
    private static RemoteCallResult getRemoteCallResult(@NotNull Session session, Object result) {
        Stream stream;
        if (session == null) {
            Invoker.$$$reportNull$$$0(32);
        }
        if (RemoteCall.isPassByValue(result)) {
            return new RemoteCallResult(result);
        }
        Ref ref = Invoker.putAdhocReference(result, session);
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            v0 = collection.stream();
        } else {
            v0 = stream = result.getClass().isArray() ? Arrays.stream((Object[])result) : null;
        }
        if (stream == null) {
            return new RemoteCallResult(ref);
        }
        List<Ref> items = stream.map(item -> Invoker.putAdhocReference(item, session)).toList();
        return new RemoteCallResult(new RefList(ref.id(), result.getClass().getName(), items));
    }

    @NotNull
    private static Ref putAdhocReference(@NotNull Object item, @NotNull Session session) {
        if (item == null) {
            Invoker.$$$reportNull$$$0(33);
        }
        if (session == null) {
            Invoker.$$$reportNull$$$0(34);
        }
        Ref ref = session.putReference(item);
        if (ref == null) {
            Invoker.$$$reportNull$$$0(35);
        }
        return ref;
    }

    @Override
    public void cleanup(int sessionId) {
        this.sessions.remove(sessionId);
        List<String> expiredKeys = this.adhocReferenceMap.entrySet().stream().filter(entry -> ((WeakReference)entry.getValue()).get() == null).map(Map.Entry::getKey).toList();
        for (String key : expiredKeys) {
            this.adhocReferenceMap.remove(key);
        }
    }

    @Override
    public String takeScreenshot(@Nullable String outFolder) {
        return this.screenshotAction.apply(outFolder);
    }

    private String genId() {
        return this.rdTarget.name() + "_" + REF_SEQUENCE.getAndIncrement();
    }

    private static boolean arrayAll(Object array, Predicate<Object> predicate) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (predicate.test(Array.get(array, i))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 16, 19, 20, 21, 22, 26, 31, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracerSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timedContextSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenshotAction";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/driver/impl/Invoker";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 28: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callTarget";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/driver/impl/Invoker";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeConstructor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClass";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoader";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "transformArgs";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "dereference";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "putAdhocReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "putAdhocReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 35: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withSemantics";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "call";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConstructor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCallTarget";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "areTypesCompatible";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findServiceInterface";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "transformArgs";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "transformArg";
                break;
            }
            case 28: 
            case 29: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteCallResult";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "dereference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 16, 19, 20, 21, 22, 26, 31, 35 -> new IllegalStateException(string);
        };
    }

    final class GlobalSession
    implements Session {
        GlobalSession() {
        }

        @Override
        @Nullable
        public Object findReference(String id) {
            WeakReference<Object> reference = Invoker.this.adhocReferenceMap.get(id);
            if (reference == null) {
                return null;
            }
            return Invoker.dereference(reference, id);
        }

        @Override
        @NotNull
        public Ref putReference(@NotNull Object value) {
            if (value == null) {
                GlobalSession.$$$reportNull$$$0(0);
            }
            String id = Invoker.this.genId();
            Invoker.this.adhocReferenceMap.put(id, new WeakReference<Object>(value));
            Ref ref = RefProducer.makeRef(id, Invoker.this.rdTarget, value);
            if (ref == null) {
                GlobalSession.$$$reportNull$$$0(1);
            }
            return ref;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/driver/impl/Invoker$GlobalSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/driver/impl/Invoker$GlobalSession";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "putReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "putReference";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static interface Session {
        @Nullable
        public Object findReference(String var1);

        @NotNull
        public Ref putReference(@NotNull Object var1);
    }

    final class SessionImpl
    implements Session {
        private final Map<String, HardReference> variables = new ConcurrentHashMap<String, HardReference>();

        SessionImpl() {
        }

        @Override
        @Nullable
        public Object findReference(String id) {
            HardReference ref = this.variables.get(id);
            if (ref == null) {
                return null;
            }
            return ref.value;
        }

        @Override
        @NotNull
        public Ref putReference(@NotNull Object value) {
            if (value == null) {
                SessionImpl.$$$reportNull$$$0(0);
            }
            String id = Invoker.this.genId();
            this.variables.put(id, new HardReference(value));
            Invoker.this.adhocReferenceMap.put(id, new WeakReference<Object>(value));
            Ref ref = RefProducer.makeRef(id, Invoker.this.rdTarget, value);
            if (ref == null) {
                SessionImpl.$$$reportNull$$$0(1);
            }
            return ref;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/driver/impl/Invoker$SessionImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/driver/impl/Invoker$SessionImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "putReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "putReference";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

