/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.RuleSet;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tagging.disambiguation.rules.DisambiguationRuleLoader;
import org.xml.sax.SAXException;

public class XmlRuleDisambiguator
extends AbstractDisambiguator {
    private static final String DISAMBIGUATION_FILE = "disambiguation.xml";
    private static final String GLOBAL_DISAMBIGUATION_FILE = "disambiguation-global.xml";
    private final RuleSet disambiguationRules;

    public XmlRuleDisambiguator(Language language) {
        this(language, false);
    }

    public XmlRuleDisambiguator(Language language, boolean useGlobalDisambiguation) {
        List<DisambiguationPatternRule> disambiguationRulesList;
        Objects.requireNonNull(language);
        String disambiguationFile = language.getShortCode() + "/" + DISAMBIGUATION_FILE;
        try {
            disambiguationRulesList = this.loadPatternRules(disambiguationFile, language);
        }
        catch (Exception e) {
            throw new RuntimeException("Problems with loading disambiguation file: " + disambiguationFile, e);
        }
        if (useGlobalDisambiguation) {
            try {
                disambiguationRulesList.addAll(this.loadPatternRules(GLOBAL_DISAMBIGUATION_FILE, language));
            }
            catch (Exception e) {
                throw new RuntimeException("Problems with loading global disambiguation file: disambiguation-global.xml", e);
            }
        }
        this.disambiguationRules = RuleSet.textHinted(disambiguationRulesList);
    }

    @Override
    public AnalyzedSentence disambiguate(AnalyzedSentence input) throws IOException {
        return this.disambiguate(input, null);
    }

    @Override
    public AnalyzedSentence disambiguate(AnalyzedSentence sentence, @Nullable JLanguageTool.CheckCancelledCallback checkCanceled) throws IOException {
        for (Rule rule : this.disambiguationRules.rulesForSentence(sentence)) {
            if (checkCanceled != null && checkCanceled.checkCancelled()) break;
            sentence = ((DisambiguationPatternRule)rule).replace(sentence);
        }
        return sentence;
    }

    protected List<DisambiguationPatternRule> loadPatternRules(String filename, Language language) throws ParserConfigurationException, SAXException, IOException {
        DisambiguationRuleLoader ruleLoader = new DisambiguationRuleLoader();
        return ruleLoader.getRules(JLanguageTool.getDataBroker().getFromResourceDirAsStream(filename), language, filename);
    }
}

