// robots.h 
//
// Copyright (c) 1997-2003,2006, Richard Rognlie <rrognlie@gamerz.net>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
// 
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
// 
//     * Neither the name of Gamerz.NET Enterprises nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
// 
//     * If you do make any modifications, please drop Richard a note so
//       that he can incorporate interesting patches into the baseline.
// 
// This software is provided by the copyright holders and contributors
// "AS IS" and any express or implied warranties, including, but not
// limited to, the implied warranties of MERCHANTABILITY and FITNESS FOR
// A PARTICULAR PURPOSE are disclaimed.  In no event shall the copyright
// owner or contributors be liable for any direct, indirect, incidental,
// special, exemplary, or consequential damages (including, but not limited
// to, procurement of substitute goods or services; loss of use, data, or
// profits; or business interruption) however caused and on any theory of
// liability, whether in contract, strict liability, or tort (including
// negligence or otherwise) arising in any way out of the use of this
// software, even if advised of the possibility of such damage.


typedef int	DEGREE;

/* Debug Functions */
volatile int printlog(char *format,...);

/* Control Functions */
volatile int scan(DEGREE dir,int resolution);	/* range to nearest target */
volatile int cannon(DEGREE dir,int range);	/* 1 if fired. 0 if still loading. */
volatile int drive(DEGREE dir,int speed);	/* 1 if direction changed. 0 if not. */
volatile int damage(void);			/* 0..99.  100 => dead robot */
volatile int speed(void);			/* 0..100 */
volatile int heading(void);			/* 0..359 */
volatile int loc_x(void);			/* 0..9999 */
volatile int loc_y(void);			/* 0..9999 */

volatile unsigned int time(void);		/* Current time (in CPU cycles) */

/* Math Functions */
volatile unsigned int rand(unsigned int limit);	/* random number [ 0..limit-1 ] */
int sqrt(int number);				
double sin(DEGREE angle);
double cos(DEGREE angle);
double tan(DEGREE angle);

DEGREE atan(double ratio);
DEGREE atan2(int y,int x);

/* Macros */
#define status(x,y,s,h,d,t)	{ \
	(x) = loc_x();	\
	(y) = loc_y();	\
	(s) = speed();	\
	(h) = heading();	\
	(d) = damage();	\
	(t) = time();	\
}

#define abs(x)	((x)<0 ? -(x) : (x))
