/*
 * // Copyright (c) Radzivon Bartoshyk 8/2025. All rights reserved.
 * //
 * // Redistribution and use in source and binary forms, with or without modification,
 * // are permitted provided that the following conditions are met:
 * //
 * // 1.  Redistributions of source code must retain the above copyright notice, this
 * // list of conditions and the following disclaimer.
 * //
 * // 2.  Redistributions in binary form must reproduce the above copyright notice,
 * // this list of conditions and the following disclaimer in the documentation
 * // and/or other materials provided with the distribution.
 * //
 * // 3.  Neither the name of the copyright holder nor the names of its
 * // contributors may be used to endorse or promote products derived from
 * // this software without specific prior written permission.
 * //
 * // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * // AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * // DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * // FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * // DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * // SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * // CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * // OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
J1 taylor expansion at zeros and extremums.

Generated by SageMath:
```python
def print_taylor_coeffs(poly, x0):
    print("[")
    for i in range(0, 24):
        coeff = poly[i]
        print_double_double("", coeff)
        # print(f"{double_to_hex(coeff)},")
    print("],")

print(f"pub(crate) static J1_COEFFS_TAYLOR: [(u64, u64); {len(j1_zeros)}] = [")

for i in range(0, len(j1_zeros)):
    k_range = j1_zeros[i]
    range_diff = k_range - prev_zero
    g_c = 1

    x0 = mp.mpf(k_range)
    from mpmath import mp, j1, taylor
    poly = taylor(lambda val: j1(val), x0, 25)
    print_taylor_coeffs(poly, CDR(k_range))
    prev_zero = j1_zeros[i]

print("];")
```
**/
pub(crate) static J1_COEFFS_TAYLOR: [[(u64, u64); 24]; 47] = [
    [
        (0x3c61f1c324453b30, 0x3fe29ea3d19f035f),
        (0xb5b2f6354c9ff45d, 0x392031b7410e0111),
        (0xbc6e3631ae171270, 0xbfca41115c5df243),
        (0xbc18acc5100eb0b3, 0x3f78d1448e6fed48),
        (0x3c0e85a7d0bc098f, 0x3f8c441a2f9de22b),
        (0x3bd94ca1b6912493, 0xbf386671c18b088a),
        (0x3bd950cc4e8482d1, 0xbf39e2504ddc7608),
        (0xbb61b481438e4089, 0x3ee34ccbca0c75d1),
        (0x3b7aba05e287d170, 0x3eda4973784d1087),
        (0x3b1ffacaebcbb72b, 0xbe81045322aaab45),
        (0x3b03dabae8fea73e, 0xbe70fae0da6cdcef),
        (0x3abc719b8692aa74, 0x3e13546cef5ed00a),
        (0xba8ac75d7c570055, 0x3dfe5ee82e667708),
        (0xba263b1d65111e4c, 0xbd9ec80cc8b63c39),
        (0xba145e6e27b1490b, 0xbd83eb2e99629b44),
        (0x39b7626e428b4f57, 0x3d222bfcdb19561c),
        (0xb98421e04d0e0d8c, 0x3d03fb3376a42e35),
        (0xb922e25ac68f0c81, 0xbca0901287d105ae),
        (0x391c50bf6cf518de, 0xbc7fa6a90c6a0c33),
        (0xb8b3ffd27bab3779, 0x3c180774f17c486b),
        (0x38976f3626c20293, 0x3bf44b79578fc6fb),
        (0xb82c4199c877aeaa, 0xbb8c6ab05fe77307),
        (0x380edbb8b3f4ef74, 0xbb65805fbd38e218),
        (0x3787f411d416c35b, 0x3afbed5bcea231a2),
    ],
    [
        (0x356eab958ab851b5, 0xb8d9a91f973ec303),
        (0x3c62de1143765a96, 0xbfd9c6cf582cbf7f),
        (0xbc46b8d73329ae53, 0x3faae8a39f51ad04),
        (0xbc47767d9698b536, 0x3fab589d1da13905),
        (0x3c0e65e41f8b156f, 0xbf7537544c331da7),
        (0x3bc117d15907382b, 0xbf624b3409959064),
        (0x3bb8c81b03584e43, 0x3f26e4c2d5354224),
        (0x3b9859e8c0ae37ce, 0x3f083a06e30c4109),
        (0x3b51fe68ee4dfe26, 0xbec9799d4c9f2549),
        (0xbb4ffb11fda5bef3, 0xbea33825cd2e2c16),
        (0x3ae8a5cec4a77c6c, 0x3e617069233e916c),
        (0xbaabdbb69c094017, 0x3e34569b22afc3c8),
        (0x3a76236a521c1ecc, 0xbdf03b9e9651056a),
        (0xba58526061a7319e, 0xbdbec62310af5f52),
        (0x39f8c0813d01aca5, 0x3d75ec84e47b6f4f),
        (0x39df157bfc6eaf25, 0x3d417a40c9422e17),
        (0x399dbf21a6dd6ae2, 0xbcf67cb1d0030c9c),
        (0xb95f5d6974a310bb, 0xbcbee7ff918f9b69),
        (0xb8ed0057404186a7, 0x3c721fb8bdc4d7fa),
        (0x38a1a3560d39e992, 0x3c35e0517dd0b5c9),
        (0x388155451c853ffa, 0xbbe792595a1eec68),
        (0xb829a85503eb4baf, 0xbba95a682022dcb8),
        (0x37f61a6a78be1e62, 0x3b59438c464a0b99),
        (0x37ba49a9e0951317, 0x3b187f5c94382543),
    ],
    [
        (0xbc782d627160714a, 0xbfd626ee83500bf2),
        (0x35a0f040f68d1816, 0x3909887c15bb2d86),
        (0x3c6ae8952e6f1d99, 0x3fc55f6bec9ef962),
        (0x3c0d30f1a30652af, 0xbf83d23336fd10e4),
        (0x3c2695c3589cdcfe, 0xbf88c77a983a0814),
        (0x3bea1200f3887332, 0x3f45cdc98db1cbe2),
        (0x3bd343248cea52bc, 0x3f373576ff46ee3b),
        (0x3b8a8cd6bedb881b, 0xbef2461447d7b423),
        (0x3b6a8a902c87e6bb, 0xbed7b853456b6eaa),
        (0xbaff7253673d7fa0, 0x3e90abfc68274a98),
        (0xbae9e22e3ad66ed4, 0x3e6ea7a1ee26124d),
        (0xbac56987dde26b61, 0xbe235c0413e01418),
        (0x3a9eb6867453dd1c, 0xbdfb5c5d512fbb00),
        (0x3a3a4481d08d2199, 0x3daf4c5e26fd6e90),
        (0xba21e34f6852a2b6, 0x3d81e4c43397be51),
        (0x39d14c360485170d, 0xbd32addefc4d51c5),
        (0xb9605d05ffcc6dea, 0xbd01e4fadc0e435c),
        (0xb923b05198207824, 0x3cb12a0b88508f37),
        (0x391a5ac22b8f14bd, 0x3c7c4246a0342e39),
        (0xb8ce78a27a5aabf3, 0xbc290ede5816f2ce),
        (0xb8986d234d468db8, 0xbbf211307906e314),
        (0x381bc4668970e7dc, 0x3b9dc7bf70396b28),
        (0x380949fa46f6dd76, 0x3b6316e7f158a264),
        (0xb79167d26945830c, 0xbb0d623edc3b24ac),
    ],
    [
        (0x35a1c201de6b176a, 0xb90f8a0b194e92aa),
        (0x3c7af22d033ee0a5, 0x3fd33518b3874e8a),
        (0xbc23b4d6298472ae, 0xbf95e70dc60362bf),
        (0xbc476d8715df682d, 0xbfa80c83bdeee5b0),
        (0x3c03dac20ab22d50, 0x3f69a4b292e3de42),
        (0x3bd887eed6e6880a, 0x3f613fbc7d698217),
        (0xbbac52a925910e75, 0xbf207358bbdbff91),
        (0xbb64763d026d3263, 0xbf0796a751f89051),
        (0xbb6df65f1fdd48ef, 0x3ec4255b015aded4),
        (0xbb3ae816d26784fd, 0x3ea3026e0ce97ab9),
        (0xbaf57b3883b98fa3, 0xbe5d48dcdae92f2c),
        (0x3aca4c50b5ee02fb, 0xbe344639d7eeb0a6),
        (0xba8fd8f34b9ecafc, 0x3dec62ccb4a32eb5),
        (0xba5032cb87171f64, 0x3dbecae92e854457),
        (0xba1beb1ed7eaf160, 0xbd73bb6898d73cd2),
        (0xb9dd5420c79c50f5, 0xbd4183edbb8ef55e),
        (0x399a66b105ba2d65, 0x3cf4ae3e7e4cce3d),
        (0xb918cb92ea651e7f, 0x3cbefbb1e700730a),
        (0xb9146c2f2b670d08, 0xbc70f28da3efa3c7),
        (0x38c4ac35b8206d4a, 0xbc35ec318df9b467),
        (0x388be1913e828c5e, 0x3be6555a952345fa),
        (0x384ff998fe9bf37c, 0x3ba9633c7f133c92),
        (0x37f9fe5cad2d2342, 0xbb583145f93c70ae),
        (0x37bb7a15502058b2, 0xbb1881cb99e6a1d9),
    ],
    [
        (0xbc7d48dbfa0ea1a4, 0x3fd17dbf09d40d25),
        (0x35a4427f3ab43500, 0x3910992c4b87a2c6),
        (0xbc61eb914d33c2fa, 0xbfc1404bf647c28f),
        (0x3c098a23a3934c81, 0x3f74f4df2769f830),
        (0x3c24ae93dcbae42e, 0x3f85c6285429b66d),
        (0x3bdddb259d6919ae, 0xbf3d68ab722881bd),
        (0xbbd8cd731f6bf3ff, 0xbf356acb6452d860),
        (0x3b60d2b8ff5b8f47, 0x3eec10b47cf7ef69),
        (0xbb3cc7e8d830a4e7, 0x3ed67eaae97bbc86),
        (0x3b0230ef0e6803fa, 0xbe8bb6530c63f2df),
        (0xbaf83f73085e8893, 0xbe6d87201e450edd),
        (0xbaaefe243bce74cc, 0x3e20f47c83ec550b),
        (0x3a995905da4f9c80, 0x3dfa98331f6ea799),
        (0x3a40b4039f32743f, 0xbdac70414a236a67),
        (0xba249d55aee4b10f, 0xbd817c057a5fcd3d),
        (0x39d02164b46fc11f, 0x3d316fea14d1fe7c),
        (0x39990498a42b8b9e, 0x3d0189bd3ec36234),
        (0x39512fd1dca06419, 0xbcb05af44aaf2ab4),
        (0x38fe8d7eea675e23, 0xbc7bbdb47ae6b94d),
        (0xb8b4cc5b1f63c320, 0x3c28435e8461ed37),
        (0x3882cf7a81930228, 0x3bf1bfd66fba7b36),
        (0xb828cec539879f22, 0xbb9d3526fa2c65e2),
        (0xb7f6bbe8d3df2731, 0xbb62c1e2b3f208cd),
        (0x376ec8c34abcf067, 0x3b0d1f12fb9ae97d),
    ],
    [
        (0x359d2cb8a50a29e8, 0x38f8cdeedd7089d9),
        (0xbc5052a3a2541c57, 0xbfcff654544ebcd1),
        (0xbc01b402d42ea509, 0x3f89223ff2c0785b),
        (0xbc323a275590a85f, 0x3fa4b0c5d5da6789),
        (0x3bb3ea54ac68ef82, 0xbf5f91a9ee0d2897),
        (0x3bfc41f7f61682c1, 0xbf5f51c2489b9e6f),
        (0x3bad7af9f28c7680, 0x3f16b4c9ca0f770d),
        (0xbbadd3415a058d7b, 0x3f063c5475439cb2),
        (0x3b59f6c7b33666e7, 0xbebe3725daf69867),
        (0x3b21f2a7db95aa23, 0xbea25c1238b32e59),
        (0xbaeb35e7c5937061, 0x3e57486f6b9aa951),
        (0x3ad95c3e197deb05, 0x3e33e3bf248277ee),
        (0xba77b9fdb9bee258, 0xbde78a38a73e7c0a),
        (0xba480ea277e7ec50, 0xbdbe844eb6b211b0),
        (0x3a0c6dae4342e4f7, 0x3d70e24abb40708e),
        (0xb9e5f9316e1c5efa, 0x3d41797e5eacddfb),
        (0x398387d37934edf1, 0xbcf21fc0f1265a7c),
        (0xb95b8aad5aec742b, 0xbcbf0c12e445cb41),
        (0x390e42f5b55d3825, 0x3c6e4423559080b2),
        (0x38cc1d5a56b93a77, 0x3c36080463b41f1d),
        (0xb87dbc48deb40e7d, 0xbbe43e38b263073e),
        (0x38442a4086626b0d, 0xbba98fa121c815cb),
        (0x37e94a11e9993a14, 0x3b56325cba16fa62),
        (0x378f6607677ad6cb, 0x3b18b3fd438c6ab3),
    ],
    [
        (0x3c50f8942d3f902b, 0xbfcddceb4ce1bf4a),
        (0xb5776203d5c7d545, 0x39009f7250661abf),
        (0x3c433d5334b42c83, 0x3fbda52116c0a640),
        (0xbbe72468a28942f7, 0xbf6a9da4603b67ea),
        (0xbc0c5e08317c5bc1, 0xbf8331e74ea59ab8),
        (0xbbdac4579bb7d320, 0x3f33e5cb6eba6eaa),
        (0x3bd0ad973dfed7a9, 0x3f33885fe9afa541),
        (0xbb74d72fe9613abb, 0xbee494c0f4b0680b),
        (0x3b783e70ffbfc8f8, 0xbed512b9d37762d7),
        (0x3b137aef41758720, 0x3e85a861082bfb7f),
        (0xbb059fce2a743f33, 0x3e6c323ea0a042c3),
        (0xbaaeb25b7edb5f5d, 0xbe1bcc962f7b91eb),
        (0x3a6a5caf0a45be46, 0xbdf9bc94e2f29a52),
        (0x3a4115f7a8e1da37, 0x3da82bc6fcfa8e89),
        (0x3a2ca2e9a78a230c, 0x3d81141ce7b78460),
        (0x399649188487057f, 0xbd2e79ccb1860d7a),
        (0x397e5f7602a25533, 0xbd013e1fbe0a5971),
        (0xb91843ce4e8dd1b6, 0x3cad36d12b0d249d),
        (0xb9191629f123918b, 0x3c7b66072bbdf478),
        (0x38cfbb54dd8d36aa, 0xbc260cb923a35433),
        (0x385274d20bfe6ac3, 0xbbf196237500b24e),
        (0x383559483b284848, 0x3b9aeba1005e1830),
        (0x380a4bb85b8cb2ba, 0x3b62a07d164c6a6f),
        (0xb76cc607fa3605e1, 0xbb0b27ac12f04a31),
    ],
    [
        (0x3540e66d0c71e44c, 0x38b8ae14acc03cc2),
        (0x3c6c8c66d2e42062, 0x3fcbf3337873a7d8),
        (0x3c25e81c4baa84e9, 0xbf80c83a2d7add33),
        (0x3c44192692d7c9db, 0xbfa251858011816b),
        (0x3bd0475c4916a7f2, 0x3f559eb160bf72d8),
        (0x3b9e04d41bf0d87b, 0x3f5c5bce33af2d77),
        (0x3b7eb490c3282478, 0xbf10413e306e0039),
        (0xbb9e3a426e412d42, 0xbf04a6704d05ad0b),
        (0xbb5a4f33202681b2, 0x3eb6c43eedfed6c9),
        (0x3b2d2f110d38d23b, 0x3ea16abd7815de74),
        (0xbae416eabc41ca79, 0xbe5257f16f5d4346),
        (0xbad1043744ab6130, 0xbe332db1b4b2ff8b),
        (0xba872ca31e31d0a7, 0x3de33acccf7bfdce),
        (0x3a00b03336c2218e, 0x3dbdc8f5682566ba),
        (0xb9e9cd15ad06d38b, 0xbd6c6513386daae2),
        (0x39d8466ad52efa61, 0xbd413585a9b7473f),
        (0xb9408c90ab21329f, 0x3cef322ea2e20db6),
        (0x3952e07fa31826b3, 0x3cbec749ba31d0ed),
        (0x3904a43ae3e1adf7, 0xbc6a8abab44a5a16),
        (0x38bd7572726e9fd6, 0xbc35f2aba27d0156),
        (0xb8753cce6cac9ae4, 0x3be20705169a0885),
        (0x38458824bb426ee4, 0x3ba98e9c9fa1064a),
        (0xb7e6e8cdd35eeba7, 0xbb540557c89d65c9),
        (0x3759f423b384f394, 0xbb18c41cdedb0d3e),
    ],
    [
        (0xbc26397095487bb8, 0x3fca7f63fea81f26),
        (0xb579a23f3e01c02a, 0x3900cbe4fe15df81),
        (0x3c4341d92ebaf0e5, 0xbfba60afb06640cf),
        (0x3c0aa0cf7edfc4af, 0x3f62c1e930935d3c),
        (0x3c2253175b5dc28b, 0x3f814506466d7f1f),
        (0x3bcf594f6cb1e048, 0xbf2cca8c0c0eaa3f),
        (0xbbc23306ba391f44, 0xbf31df821cc1377e),
        (0xbb6f4273eb18d486, 0x3edee8814ed0ac45),
        (0x3b3531e00c0b1e91, 0x3ed3a365a4199dd1),
        (0xbb2539aeb3d4946a, 0xbe80ed2f9c3e458e),
        (0xbae7dc7c41800a98, 0xbe6ab3b37c5271b3),
        (0xbabe3080b40ebc8e, 0x3e1684d6e62b5c66),
        (0xba980fe8dabe0c36, 0x3df8b105a5120ed2),
        (0xba34afb054573ddf, 0xbda42dc5991b9d01),
        (0x3a24e165917f0851, 0xbd808d6405ffe3dc),
        (0xb9bea36c059d9a67, 0x3d2a15203365a9e0),
        (0x397717476aec9541, 0x3d00d7c118bbeb37),
        (0x39474ba7f9cdad9c, 0xbca984ffd2857b4d),
        (0xb8f090df156cf8ee, 0xbc7aecb2d322693f),
        (0xb8b29f8b4dabfed8, 0x3c2396ff2d246042),
        (0xb86310d4b1263ad5, 0x3bf15cbae441ca24),
        (0xb8388b6c6238abda, 0xbb9841be044fa28d),
        (0xb7f60da5e67d9193, 0xbb627467b799ccfc),
        (0xb7ab569bc7745d94, 0x3b08c28575d745a7),
    ],
    [
        (0xb5a0840c646e7364, 0xb909bb79105907c8),
        (0x3c6e9557ccd1703f, 0xbfc925c6fca08f55),
        (0x3c091bef69239af0, 0x3f786dd32e059b0e),
        (0x3c3dac1b118bb946, 0x3fa09463bbd0367f),
        (0x3be231ff19225462, 0xbf4fda0298c8768b),
        (0xbbf0185527e9208e, 0xbf59f4be60758fb1),
        (0xbbac474063460803, 0x3f0877991af9d1bb),
        (0x3b85632e0e751036, 0x3f032cb00ee8c1f3),
        (0x3b46a0371f5eb5de, 0xbeb19d8ce8c35f58),
        (0x3b44398edcd31b46, 0xbea06a042fbba455),
        (0xbaeabb097c7d4aab, 0x3e4d3a689e677731),
        (0x3adf851e84662874, 0x3e325108c4ce2b63),
        (0x3a700c6a94a96471, 0xbddf7b8e9ab53152),
        (0xb9e39398140885a8, 0xbdbcc40d05652642),
        (0xb9debdd38ee83cbd, 0x3d67cd76e2d7e2cb),
        (0xb9d4060b8e456ec8, 0x3d40c58770231c0a),
        (0xb986fdcd6522fa14, 0xbceaafec4cd92006),
        (0x395ac6a53012f35d, 0xbcbe36dd57088c43),
        (0xb90acfe289832416, 0x3c67199e80bb8ec3),
        (0xb8d65ad3a5a6b128, 0x3c35ab8b86951bb2),
        (0xb87d16fd2ded0f9a, 0xbbdfd7377ba12be2),
        (0xb83aa7858e0cbb98, 0xbba9595b17afa78d),
        (0xb7f5f340e3e25bf0, 0x3b51e6cee419b353),
        (0xb7a44c40cb1a1e24, 0x3b18a74f87d027a4),
    ],
    [
        (0x3c2a5f1938003f5d, 0xbfc810f50225b04b),
        (0x358a4e47631896a5, 0xb8fd56c48838f152),
        (0x3c5462bc86c50f0a, 0x3fb7fdf97ac36b1f),
        (0x3beaefb0d3d06c9d, 0xbf5c3c256a8caa05),
        (0xbc191dbdbe4ca6d9, 0xbf7f98feb7286b47),
        (0xbbcd0c6b4f6c3ad8, 0x3f25f6559e5686e2),
        (0xbbd9de4a645cf978, 0x3f3080f57ac215af),
        (0xbb69ed06d60efe89, 0xbed80c51397e5eba),
        (0x3ae04eb6bd1f24a9, 0xbed256db543cd140),
        (0x3b1af2db1b084be5, 0x3e7af7598a219824),
        (0x3b0693a9fa38dfa0, 0x3e69398226ca2305),
        (0x3a95f5676bd10cd5, 0xbe1260985d92587d),
        (0x3a8d5612be0b4b05, 0xbdf792bb3eea6f6a),
        (0x3a4432d95d96cbda, 0x3da0d862695e1a7a),
        (0x39d7cd101d99d4e5, 0x3d7fe52adc2baacf),
        (0x39baa545a1a5eb63, 0xbd263801377398f0),
        (0xb90a458f0e1e2682, 0xbd005a1befdbe42c),
        (0x39473f5560f8b44e, 0x3ca6205041739aa5),
        (0x38f53ca728fe9101, 0x3c7a4e1503b6d0e4),
        (0x38a22b93c20b3937, 0xbc213ef141f6d641),
        (0x3854274bba40b623, 0xbbf10ccc96cd4c02),
        (0x382225ebf160c143, 0x3b95a2fe023aea26),
        (0x380398ff54fa8423, 0x3b6232d7c90d33bc),
        (0x37acf10d8068ed39, 0xbb0656435697f160),
    ],
    [
        (0x3590c69d1d5ad990, 0x38fbdadd24cf38cb),
        (0x3c62da0057f84d3c, 0x3fc70c511227d5aa),
        (0xbbfb574e506cf75b, 0xbf72ccb0e97558da),
        (0x3c2e61277dedf705, 0xbf9e7dc08e70e99a),
        (0x3ba77952da42c6eb, 0x3f48acdc5b058c0e),
        (0xbbf340f4df9939b5, 0x3f580503724ad30a),
        (0xbba115f69745949b, 0xbf032ee4ca1fcafb),
        (0x3ba6a66de44f6f2b, 0xbf01e5d2836c8d99),
        (0xbb2b264207f7cf59, 0x3eac129f077bb163),
        (0x3b3381f3bd8fb4b6, 0x3e9ef161591181a2),
        (0x3ae466d818a45b43, 0xbe47b9bb07f19f82),
        (0x3ac2d952a84a8f21, 0xbe316f3937595d96),
        (0xba7571ae406938c3, 0x3dda0bc8665b687b),
        (0x3a588295d4921561, 0x3dbba135f99a9e19),
        (0xb9ff299934254ca8, 0xbd640d543d2cbdf0),
        (0x3982fb1c3cc08579, 0xbd403d0592185f1c),
        (0xb925c1461a28ff32, 0x3ce6db5e22d3be75),
        (0xb939bcdb12fd3c24, 0x3cbd745a1f778590),
        (0xb8f8314c949b4d69, 0xbc64141c4b5a4105),
        (0x38a825ab0fff4716, 0xbc353f4e6ca53f65),
        (0x387f0bb5f3376671, 0x3bdc09c1732e9344),
        (0x3845a8dc1ed995e7, 0x3ba8f971fa1f374a),
        (0xb7ce30cb1f02717b, 0xbb4fe39c23f51b6c),
        (0x37b9858646741b7e, 0xbb1862f419e2ba54),
    ],
    [
        (0xbc6b166d180d579d, 0x3fc633e7f7f05301),
        (0x356d48b037092f86, 0x38f9187186657edf),
        (0xbc100659a075d9a7, 0xbfb6273784c1c06e),
        (0x3bfcb74bd0872e23, 0x3f563ae94ade18d4),
        (0x3c02a45d712a2f91, 0x3f7d4666536c88b9),
        (0x3b825e9acb600ae8, 0xbf216d528345ca11),
        (0x3bbb9405b8c58d57, 0xbf2ec0dcdbb7c5fe),
        (0xbb7cb6e04f4b97e8, 0x3ed34e966b0b09f8),
        (0xbb7a79e09bd0a7d3, 0x3ed135c64dc2d8d0),
        (0x3b01284c6af65eda, 0xbe75f7bc78b5fc2b),
        (0xbaf68597192a53a4, 0xbe67dc35b0764096),
        (0xbaab08d1b3bdd3d7, 0x3e0e6d697361ea54),
        (0x3a825acf92327a4e, 0x3df679e3704987b4),
        (0x3a25a180ac4a289b, 0xbd9c595f278a4d6c),
        (0xba0b8a094432fbc2, 0xbd7ea36aef56eec0),
        (0x39c8d7c90342cb95, 0x3d22fd66b4e62185),
        (0xb99cefe59fbb0bf2, 0x3cffa04c9faacec1),
        (0x3947eb4362c2f94b, 0xbca32f47f03857d7),
        (0x3912dc0b9f745208, 0xbc799658479ebb31),
        (0xb8ab4e5c1533c13c, 0x3c1e4c26032e5de5),
        (0x389fabe9c1dc18b3, 0x3bf0ab1b47f9c785),
        (0xb83bf6eec6ed25da, 0xbb933a3c78295756),
        (0xb7f90ac82d0d0179, 0xbb61de19b957005d),
        (0x37ab71627757371c, 0x3b040e310c05ed67),
    ],
    [
        (0x35ac924d3bf8bf5b, 0xb900f098dc38e480),
        (0x3c6a47ab4241a9f5, 0xbfc5664e13b70622),
        (0x3c04d78c254f4422, 0x3f6e16555e108dc6),
        (0x3c1fe75afd6ce0fa, 0x3f9c5e1ad9fb2f40),
        (0x3be099fe50e43632, 0xbf43d369f958e56a),
        (0xbbf3ed70de366684, 0xbf566f4ec27a96e9),
        (0xbb9b30f071ce70bb, 0x3eff0de0532652d5),
        (0xbb747f8eea3cc056, 0x3f00cf264341409e),
        (0x3b4f2ff7c971467d, 0xbea6f46d51e5766f),
        (0xbb3708c3f9c7bd34, 0xbe9d407f7c248d45),
        (0xbaee70df563a5b0f, 0x3e43a33cd9df6696),
        (0x3ad300d61c332fb0, 0x3e309901b0a816e5),
        (0x3a69fdf1dd8c15b3, 0xbdd5d856a58443f5),
        (0xba3f02f5ec08db44, 0xbdba7cbcd8fc0758),
        (0xb9fcaa58f7c81511, 0x3d610b62c2fd47f6),
        (0xb9bf896eb454c48a, 0x3d3f56a09da19f70),
        (0xb97cb0796a5c153d, 0xbce3ae6849b36426),
        (0x39389530ecefefbd, 0xbcbc977524a64328),
        (0x390af889f4247b24, 0x3c617fc9db74cefd),
        (0x38de6ffabef002da, 0x3c34bbe426d77a28),
        (0x387b388027811ac5, 0xbbd8b5659628a8e3),
        (0xb83cddf274f119b8, 0xbba87bcc22e21171),
        (0x37ec559bf73a5d47, 0x3b4c62cff42626ad),
        (0x37656c3911a78ec3, 0x3b1800b5df5b52ae),
    ],
    [
        (0xbc4f6f339127993d, 0xbfc4b71d4ca2cc69),
        (0x359c1da4eb8655d5, 0xb8f3a018f8f76877),
        (0x3c5422c1a1ae8ec4, 0x3fb4ae245697fba6),
        (0xbbf4ff572c18742a, 0xbf5215e4e1a5f1d6),
        (0xbbf259ec9ab217a9, 0xbf7b633ed6d9cf61),
        (0x3bab33aa46f3e729, 0x3f1c7f17b4b7dbbd),
        (0xbb79333ace27b68d, 0x3f2ce01b8b6aa34c),
        (0x3b5f4e5e8507bc88, 0xbecfced71b11e35b),
        (0x3b57f324d6293b07, 0xbed03c9d5823261d),
        (0xbb15cd82948c15bb, 0x3e724508091063b2),
        (0x3b02ba31739f7dac, 0x3e66a2d20111e303),
        (0x3aae84f884334dbd, 0xbe0995a18f8e6888),
        (0x3a67a35968d37628, 0xbdf572d1a074f647),
        (0xba3a336c953bedde, 0x3d981df03c1911f1),
        (0xba104dc5bcacab30, 0x3d7d6895e48f475d),
        (0x39c36eea9cd69feb, 0xbd205887f0b3df78),
        (0xb98ded8dfba53f0d, 0xbcfe86703ddf1bbb),
        (0x394a6d81e9b745de, 0x3ca0b3c70ca73df2),
        (0xb91aba894f18e42b, 0x3c78d28ba328c189),
        (0x38aea5b88a7dff57, 0xbc1aa9275d6882a0),
        (0xb88b4724ad7898dc, 0xbbf03e89774aa977),
        (0x3836acf6717c7348, 0x3b911679204a4a38),
        (0xb7fc2c9e5a53a6f2, 0x3b617bd36a04e549),
        (0x37a2112e77b7283b, 0xbb01fc50745d8566),
    ],
    [
        (0x357f9e30ee0b6fbb, 0x38e84b55d671e3ab),
        (0x3c6316f8ffd294bc, 0x3fc40f90793605bb),
        (0xbbd411ad350e6def, 0xbf68c833077fbeae),
        (0x3c051eb6f09db1a0, 0xbf9aa0ce0421d1a8),
        (0xbbec0fe78acda469, 0x3f405fa598ef5d1d),
        (0x3bff2085596ae958, 0x3f551d30d78ab526),
        (0x3b92b31b33779fc8, 0xbef9c5807675c5f6),
        (0xbb7cb5b0088841fe, 0xbeffc1bbf57e3ae2),
        (0x3b3cc2b42d9f0f1a, 0x3ea32dfea2518ce6),
        (0x3b18c85914c086a8, 0x3e9bc212085dcbc6),
        (0xbaed44a5431df5e5, 0xbe408b946d64c5c2),
        (0x3ac14bfc6bd39224, 0xbe2fa8f9d8da736a),
        (0xba679104007a668d, 0x3dd293fe14af1d0f),
        (0x3a2b5ef4a8a2fdf9, 0x3db96544cb75a58d),
        (0xb9d2b2107643b642, 0xbd5d4750748e2ce8),
        (0xb9d8369e87f01d70, 0xbd3e341812329072),
        (0x398c6f9e47f04995, 0x3ce112aa495187a4),
        (0xb950e224f8078ca7, 0x3cbbb1656dc67704),
        (0x38e16eb1b3f03824, 0xbc5ea7b98f478c96),
        (0x38b9cf2d9132a338, 0xbc342cad7eaaf63a),
        (0xb82267864912b80e, 0x3bd5d798d87eadd4),
        (0xb83715c9cdc64b23, 0x3ba7ec2199e9d0da),
        (0xb7e050cf70a270e2, 0xbb494f3573e03531),
        (0x379b105713845f41, 0xbb178a4eaef852c1),
    ],
    [
        (0x3c4f5ffd019535e2, 0x3fc37dfa8f5a550a),
        (0xb5701036f2fd5ce7, 0x38d71a135ef735e1),
        (0xbc5c4cd2161ee713, 0xbfb3775c1a04f09c),
        (0x3bd3d562913301ed, 0x3f4e2b4810a46c60),
        (0xbc1b976f3317abb9, 0x3f79d151a72b83a8),
        (0x3bbcef8b523f5a0b, 0xbf17d8e5a090e4e6),
        (0xbbcb7ef16d9cb057, 0xbf2b49a6427386a0),
        (0x3b59248209e494f4, 0x3ecac10957ddd2eb),
        (0x3b424396e09f7471, 0x3ececa620745d3d3),
        (0xbaf3438d41f60802, 0xbe6eefc7e795dcdd),
        (0x3ae3b35ebff03a32, 0xbe658c5d2a0da41d),
        (0x3aa0b413dedd34fc, 0x3e05d4721f44a8f9),
        (0x3a892a275db60362, 0x3df481ce2314af59),
        (0x3a3feec436d1ef8f, 0xbd94c0d3279e920d),
        (0x3a19e07a129c683f, 0xbd7c3ea707530563),
        (0x39a52b925c059e39, 0x3d1c61d5b165f7da),
        (0xb94e05a7550119da, 0x3cfd72bf189b67b4),
        (0xb9108732c7d2e8ad, 0xbc9d427a9769e9ed),
        (0xb91f784bb6f88124, 0xbc780c9653705698),
        (0x38b8d964fc9666c3, 0x3c178e36fc02b9df),
        (0x38865f872c0449a7, 0x3bef9a2c168b6442),
        (0x38235589e9a3fa21, 0xbb8e71f82f6f0229),
        (0x37fbb8f42441d570, 0xbb6111ac11e28162),
        (0x377b5f7617aeeb8e, 0x3b0025a92b5f22a5),
    ],
    [
        (0x35952cb8f89f3c55, 0xb901222bb44bcf14),
        (0x3c689d1f48185c7e, 0xbfc2f2072e638cf4),
        (0x3c0f48257333acd5, 0x3f64df208bbd44f1),
        (0xbc282c4cf012e7aa, 0x3f992bb5e1e159fc),
        (0x3bb5967313b48e35, 0xbf3ba181c06897cd),
        (0xbbea6566cfb06bed, 0xbf53fe9d5baa4a3d),
        (0xbb98b4ff1892c87c, 0x3ef5d17602b01cac),
        (0xbb84f1d79d1c68cf, 0x3efe26d3747fe829),
        (0xbb47899cac28d06e, 0xbea0509768ab6ecb),
        (0xbb30edc18e594fda, 0xbe9a70f232d9d06c),
        (0x3adf4967ed4b405c, 0x3e3c509252de33f9),
        (0x3ac643cb92fae2ea, 0x3e2e454fee07116e),
        (0xba7c2d5f536fab40, 0xbdd0015b062ba125),
        (0xba43993ecbbb44ab, 0xbdb860e95adf840f),
        (0x39fd1ca7896c45b4, 0x3d59691e90f7d9c0),
        (0x39bccb74999a40d8, 0x3d3d1ce7997b3c0d),
        (0x397d856301e23d11, 0xbcdddcd1c54cee54),
        (0xb958f0d58afd0876, 0xbcbacd10a03552dc),
        (0xb8f2692f00e7abd7, 0x3c5b043a7a08961a),
        (0x38a216228008b2d7, 0x3c3399ba2ef94a8a),
        (0xb87b2260cea416f3, 0xbbd3650fec070f67),
        (0xb84885e84e43eded, 0xbba7538b0e0444f1),
        (0x37e7ac0e69e3062b, 0x3b46a2dce760f8a5),
        (0x37b02054fc976f06, 0x3b1707ea3ba222e3),
    ],
    [
        (0xbc6b9fbd89653a0b, 0xbfc2768d29c69936),
        (0xb5883d7e7aae0fdd, 0xb8ec8fe2d361f507),
        (0xbc592c5350d4d775, 0x3fb271811730b0ef),
        (0xbbcd42067c3280c8, 0xbf49a8df96a1225e),
        (0xbbde819659787fc8, 0xbf787c81cf1c6fc4),
        (0x3ba0986868518e75, 0x3f14549cdbb77978),
        (0xbbcc0c937839cf2f, 0x3f29ed2568116e19),
        (0xbb638a1daff4bf5c, 0xbec6e4136f033ace),
        (0xbb692b821c2e6f36, 0xbecd53330316cde7),
        (0x3af82b5a8a9ea4e0, 0x3e6a983b5782dfca),
        (0x3b0d6817ea51c39b, 0x3e64952ba7c5a1dc),
        (0x3a858779f386d0c6, 0xbe02df3ad6f82e0d),
        (0xba85be3593e2be88, 0xbdf3a70f9a89d2c2),
        (0xba32f63410f44e43, 0x3d920e086c17f5dc),
        (0xb9feeb5c5526cc87, 0x3d7b29a554c1159f),
        (0xb9b6a518f14f6a05, 0xbd18dbe08f4a9f69),
        (0x396f8eba4a78c6ed, 0xbcfc6bd9fc45c380),
        (0x390a2175db343220, 0x3c99ce5a735b2911),
        (0x390e5b428d8e3c26, 0x3c774ade0ebbb04a),
        (0x38a68dee1fa00957, 0xbc14eb88e02b008f),
        (0x3835846ba71a1987, 0xbbeeb63f264071fb),
        (0x38105020072f2234, 0x3b8b39319da680c5),
        (0xb80e1b59bc2fb16c, 0x3b60a4325ae8cea7),
        (0xb79ae8092aa3eb9d, 0xbafd11021ccd9832),
    ],
    [
        (0x359a05b7bb6a66e7, 0x38ff07a73b062717),
        (0x3c51f9b16832f362, 0x3fc1ff5eec6a01cd),
        (0xbc0f89ce0d1cb83e, 0xbf61e438b722c3b5),
        (0x3c39a4b7b3ed5b9d, 0xbf97ed5fffc1c774),
        (0xbbdc35d9a8dca8fd, 0x3f37b7997babd9ca),
        (0xbbe39da4066981e2, 0x3f53081def9612c5),
        (0x3b8551b9a497b582, 0xbef2c5f5edafc4e9),
        (0xbb9dbae692eab5c3, 0xbefcc11a59e13739),
        (0x3b351580930803f5, 0x3e9c2c3a1b8014a3),
        (0xbb333a214b9dbd86, 0x3e9946d1dab7bd01),
        (0x3ad8fc5f68299915, 0xbe388db61946be64),
        (0x3ac5620984f97782, 0xbe2d04d33be580e8),
        (0xba6d7f1c30d157b7, 0x3dcbe64386d2c5d0),
        (0xba48b7e9cdf3e557, 0x3db77142e0e4497b),
        (0x39fe42ca4fdc0820, 0xbd56458476679697),
        (0x39cde02178f2e8a7, 0xbd3c15e96b25adba),
        (0xb96d7f2805e659cb, 0x3cda545e6ec71d21),
        (0xb95169031622e59c, 0x3cb9f0a9b74e034f),
        (0xb8f6c8c4cb1d2951, 0xbc57f751eaad5943),
        (0x38b9f3826864d2b2, 0xbc33083bfba900b3),
        (0xb83ad0a2f62d2470, 0x3bd14f7886799e5e),
        (0xb846ea6a99d583b1, 0x3ba6b8756a3461ea),
        (0xb7bff8edb785364b, 0xbb44533c12e31410),
        (0x37b9373ae2b3a681, 0xbb167fc01d26c703),
    ],
    [
        (0x3c54fa3fb220c497, 0x3fc194eba75b32f9),
        (0x35968efa101689a5, 0x38fdc9a2706a3090),
        (0x3c59f5fdd12caa11, 0xbfb190f7dc27362b),
        (0xbbd96244746ca1b2, 0x3f462bb47a5c5f7f),
        (0x3c106edbe0bb689e, 0x3f7756ef20f5d2e2),
        (0x3bb1231bc44f6f51, 0xbf1198b0ba97ecfb),
        (0xbbafcaf4935a1752, 0xbf28be8cf9358d55),
        (0x3b341ada5c144f0c, 0x3ec3dd6f7c8cc3c0),
        (0xbb22797862876f18, 0x3ecc09c80ee7f9af),
        (0xbb04005395d49e04, 0xbe6728e46a451e32),
        (0xbb056333198576a9, 0xbe63b91113508622),
        (0xbaa195a6693f0d85, 0x3e0080fddad62bf8),
        (0x3a8352e1bf38cbc8, 0x3df2e111e88dae1f),
        (0xba2109236d67d65e, 0xbd8fbae88bdab215),
        (0x39fdc60e2c5c7d37, 0xbd7a2a4fbea868a8),
        (0x39b8e39633481264, 0x3d15f540e9769e8b),
        (0x39976a66d79bb910, 0x3cfb74c0b2686df3),
        (0xb92c1d434c75162e, 0xbc96eb75a7dd13a2),
        (0x390c7fe154372598, 0xbc76910c1dc865c3),
        (0xb8a43f5790d81d03, 0x3c12af36490b5c71),
        (0x3886f89d2e40041f, 0x3bedd7036ea48d55),
        (0xb82a048b55f91332, 0xbb88734f1fdd1068),
        (0xb7dfa5ba1f878585, 0xbb6036af368c39fc),
        (0xb7993db41d2f7ce5, 0x3afa3fd8a11def52),
    ],
    [
        (0xb5745b4e1af1b85e, 0xb8d7a991cf97ce2e),
        (0x3c6e71c482be67bd, 0xbfc12dd57bf18ada),
        (0xbbe9a8a827c4a2d4, 0x3f5f1e1e7f393e83),
        (0x3c3286f932bea2b2, 0x3f96d9afe88301fa),
        (0xbbd360330deffaa0, 0xbf34a538a482979b),
        (0x3bef838ddd540b11, 0xbf52316250b4ae37),
        (0xbb94c13fb3eaf5ab, 0x3ef05f11577b4627),
        (0x3b6771ef99211bfa, 0x3efb86bad42fc220),
        (0x3b1a6b7e5cebbbf8, 0xbe98a1b3a9e92749),
        (0x3b32d778489fadef, 0xbe983dcaf3f8fcc5),
        (0x3abceef7b37a414b, 0x3e3589a7ca5fdcf1),
        (0x3ac97ff4495956a4, 0x3e2be3ee3298bb99),
        (0x3a6770b1a9ab05ca, 0xbdc8913f1d0ff12a),
        (0x3a430c1f9492528b, 0xbdb695c386660813),
        (0xb9fd8f50c7d974dd, 0x3d53b25d364762e7),
        (0xb9d664d160d01e32, 0x3d3b20c42e642ccd),
        (0x397bc60dbe38d043, 0xbcd7650532b4f1e0),
        (0xb920283e56ce5b47, 0xbcb91f514b70b40a),
        (0x38fcae3e188ec691, 0x3c55661aac4dcfde),
        (0xb8b0ad982f98ebec, 0x3c327b48d9478b06),
        (0x38441168fe323c23, 0xbbcf11115f1e0760),
        (0x383a0b5e44af3cea, 0xbba61f1bd02130ad),
        (0x37eb4e4f03156997, 0x3b4254646f0f97c7),
        (0x37b0ea6aa46492cb, 0x3b15f63be5634cd2),
    ],
    [
        (0xbc27736b1f56d701, 0xbfc0d0d36473e98c),
        (0x356c9dc61ea15303, 0xb90248314540cb10),
        (0xbc517d3bbb8e7764, 0x3fb0cda9974abe2b),
        (0xbbe2a43b589b29f9, 0xbf4367f38f201c25),
        (0xbc17d1323005eae7, 0xbf7656b75e3c242e),
        (0x3b94b9f5a7acb7cc, 0x3f0ed82abf7489f1),
        (0xbbcb0bedf1c81292, 0x3f27b4e5b83eeb36),
        (0x3b0621247626b416, 0xbec171fd0fb670e7),
        (0xbb638b7d64b281f7, 0xbecae62b4ad017fb),
        (0x3b0b83d61a6ff722, 0x3e64648495a7b49e),
        (0x3b05f0212db7e5c2, 0x3e62f42a577135ad),
        (0xba76b0fd54cd9d5a, 0xbdfd286e7fa32656),
        (0xba30ca02b11abb11, 0xbdf22dbcbf76a1c7),
        (0x3a27e83235238ba2, 0x3d8c222accc0d2d2),
        (0x3a056929761e3d77, 0x3d793fc7f6c8d355),
        (0x39bc237122bbb790, 0xbd138c7e1f668eb4),
        (0xb99070434bc7e0cc, 0xbcfa8e4efc6deb61),
        (0x3935816fed04585f, 0x3c947e808eb72ce3),
        (0xb91069ce4b7c1dbd, 0x3c75e0f075f73393),
        (0xb8ab681bd123ab34, 0xbc10c866ba43aebb),
        (0xb87344f73adf2486, 0xbbecffe1c0e02083),
        (0x3821df2bad78c005, 0x3b86102f988e0a87),
        (0xb7f3ec5f37bb8303, 0x3b5f96a57efd09fb),
        (0x379def01809beed4, 0xbaf7cbac5fb57a91),
    ],
    [
        (0x35391b3b00fc7751, 0xb8c00dbc5df9a26a),
        (0x3c61a13e2fee5687, 0x3fc076826cc2c191),
        (0xbbcb789ffb667f58, 0xbf5b62885e0070c6),
        (0x3c35dbe9d7210c2e, 0xbf95e7f53001e4b1),
        (0xbbddb8eb1d2032f3, 0x3f322ebeb8dc2202),
        (0xbbf72618e87154fc, 0x3f517444a7a04cd0),
        (0x3b7b01e81c8c370d, 0xbeece06f1f1fcd7e),
        (0x3b80168184fb2a2f, 0xbefa7006e6ad9cfe),
        (0x3b13ac36b9efbb35, 0x3e95c42f02cf15ca),
        (0x3b08b69b698a2f2f, 0x3e9750ca5e1366b4),
        (0xbac08a205d6fbd27, 0xbe3314982df7eaa2),
        (0x3abf2c98d7c5b0b0, 0xbe2aded75306b3b3),
        (0xba2551d965dce668, 0x3dc5d47847d8ebf1),
        (0x3a2b475ee50f9af2, 0x3db5ccf44d287a21),
        (0x39d9490ac846b5fb, 0xbd518fce3e04028a),
        (0xb9d525cc1707dd4e, 0xbd3a3d6bcad0c3fc),
        (0x39615f1fc81188f8, 0x3cd4efbd76727c05),
        (0x3954cf183e4c6eef, 0x3cb85a4b163fcc04),
        (0xb8eb35201a650448, 0xbc5339ddeca79d0a),
        (0xb8df2fda8e574f19, 0xbc31f48b47bc4419),
        (0x384d7bc59effa619, 0x3bcc06bd6710b45b),
        (0xb84a385b5ed821eb, 0x3ba58a1ad9e65449),
        (0xb7c4e5225bdf41b3, 0xbb409abe2b8be0ed),
        (0xb7ba1343bcfa4e16, 0xbb156e575d965e88),
    ],
    [
        (0x3c61a6e02553980f, 0x3fc02455675ab6d2),
        (0x35884b224ed40dc9, 0x38eb5eb0626a64d4),
        (0xbc5a58b3083e7e3d, 0xbfb021c155a720df),
        (0xbbea19c1039d30bd, 0x3f412be56fc1449a),
        (0x3c01bad3e8f9abb9, 0x3f75749d556ad61c),
        (0xbb75621370147dfe, 0xbf0b51f1f9bea93e),
        (0x3bc81ccb29b6a851, 0xbf26c96a07e236bd),
        (0xbb218064e9ecad2c, 0x3ebef3a7abd5ac6b),
        (0xbb6f6ed0aeaecba4, 0x3ec9e207c257433a),
        (0xbaf0aed16a93326e, 0xbe6220b96eef8058),
        (0xbad4d7e3d546f2c4, 0xbe624317cb296737),
        (0xba91f73fb3d22bed, 0x3df9fc2f2cd3917f),
        (0x3a9403e6cf9143a4, 0x3df18ae8347e8256),
        (0x3a2f17c7d5411c26, 0xbd892540423f2dda),
        (0x3a04a4080028f5b2, 0xbd78687dcdc2e3a9),
        (0x39a201bd34791753, 0x3d1187909103d474),
        (0x39844a97e12dfc96, 0x3cf9b8362872c324),
        (0x393da5147587382e, 0xbc92711ecdaaeca0),
        (0x38fae8f5aa2732b8, 0xbc753b342a24814e),
        (0x388ad67623e40669, 0x3c0e50eba2ee4760),
        (0xb86ad1f354cf2e6b, 0x3bec32aa5f596a62),
        (0xb8257b3c1a8fb2c7, 0xbb8400cf17d2fcd3),
        (0x37f2a48d3485143a, 0xbb5ec6ef456ce7f9),
        (0xb79fa0988ef64e6e, 0x3af5a82ff0aad8bd),
    ],
    [
        (0xb57640b478e02a1f, 0x38d6a301383ff88d),
        (0x3c5d7cc4171715a0, 0xbfbfa8b41711c83a),
        (0x3bf6219a48a25ba1, 0x3f5857d3969997d1),
        (0xbc395ccf34fc85bb, 0x3f9511c6dadaaa12),
        (0x3bd13cc55ae24369, 0xbf302c289dbdbd4f),
        (0xbbde8aacf935744f, 0xbf50cc2238d229f9),
        (0x3b831f1c91d27574, 0x3ee9b64d5c63668f),
        (0xbb967f7ad529fbab, 0x3ef976fb023f0f79),
        (0xbb26431725df20f0, 0xbe93693ba0b5ba70),
        (0xbb30bc5202714831, 0xbe967b952987350c),
        (0xbadfac3d160cee71, 0x3e310cb79a2addac),
        (0x3abbc10a636cca3c, 0x3e29f2079f8e397f),
        (0xba6f1f3686791203, 0xbdc38d957eaa53ad),
        (0x3a5a464b4d5f0cbd, 0xbdb51511e93ba74c),
        (0xb9d76cb5fc51dd5d, 0x3d4f8bb4d9d2f3a4),
        (0x39d5f6bc31063165, 0x3d396afe82155a3c),
        (0xb9789c1d34756db7, 0xbcd2dc3c5a412fc8),
        (0x394e5ac9a5d43674, 0xbcb7a1c8dec76ff7),
        (0x38fa62b937a855d9, 0x3c51600c3d779ccc),
        (0x3891168a3d883e25, 0x3c3174c64bf0b16a),
        (0xb8380d11dc898cc6, 0xbbc969e37524ef7c),
        (0xb8337a7c5fb777c9, 0xbba4faf03e3cc2d5),
        (0x37d9f91b76239dc9, 0x3b3e37a63e276939),
        (0x37b81fff9e082645, 0x3b14e9f8e51a9731),
    ],
    [
        (0x3c50e4250a158a22, 0xbfbf161d0c28b48c),
        (0x3588b2630fb1ecb4, 0xb8fcdc55525190c5),
        (0x3c421e360c4c70dd, 0x3faf11d837aa6f64),
        (0x3bd18f48c3547c45, 0xbf3eab76da4d07a0),
        (0x3c1ebe3b9893ac4d, 0xbf74ab329f067aea),
        (0xbb5e80c3b0d6f6c7, 0x3f086ada57bc1c51),
        (0x3bc03960ef6e6bc0, 0x3f25f6e78f11ab9a),
        (0x3b5e77180c5644f6, 0xbebbb271f54c8965),
        (0x3b5cfd1d7da5a2ee, 0xbec8f85328c26cb7),
        (0x3b05a5d710343230, 0x3e603f82aebdeac1),
        (0x3b008f5133b080df, 0x3e61a3010279a195),
        (0x3a8746b6f6e07b70, 0xbdf75660809cdedf),
        (0xba824b566432a315, 0xbdf0f6931774a05f),
        (0xb9f3c0bb6b052f2c, 0x3d86a2e61267070b),
        (0xba1950de7a0ba4a4, 0x3d77a2a8e0311c3a),
        (0xb9a048f7d1f2b252, 0xbd0fa4c8e3ce0140),
        (0x3973ca66f22df187, 0xbcf8f1926f4e33ae),
        (0x391f7bbe0252e068, 0x3c90b165b2615bc8),
        (0xb90630bee239e401, 0x3c749fd329a93d0e),
        (0xb8723f37b0afb367, 0xbc0b864a393597bd),
        (0xb88ea6b58b8f277b, 0xbbeb70236cfe6bd6),
        (0xb81ff9b7e892d837, 0x3b823801bcba96ae),
        (0xb7f460e58de7fcd8, 0x3b5dffc2deb31092),
        (0x379c28f920f7c081, 0xbaf3c9fe3b84a659),
    ],
    [
        (0xb57bd9f791078c7d, 0x38d74664ec9bed14),
        (0x3c0020b4016594ac, 0x3fbe8727daa3daed),
        (0xbbea4d873618788f, 0xbf55d353e2854a37),
        (0x3c3361836c532514, 0xbf94524d4813cc25),
        (0xbbb70735fa989563, 0x3f2d037574e28370),
        (0x3bf7f1d7c0f30b41, 0x3f50356bb747a763),
        (0x3b73015c07f2d91b, 0xbee7156bfccef376),
        (0xbb99523f4f9b3609, 0xbef896d7dc819faf),
        (0x3b307f0e451ebc2a, 0x3e9172c6dadf4149),
        (0xbb334d6933f971d7, 0x3e95baae8efc2e31),
        (0x3aba01d72c453106, 0xbe2eb347eb4d6941),
        (0x3acc3dd30f660e51, 0xbe291a60a72a20e0),
        (0xba0f68f511402a90, 0x3dc1a345a9a6a5f7),
        (0x3a3173892dc95a66, 0x3db46c56b01906be),
        (0x39d1db37247899b5, 0xbd4c84bb37677838),
        (0x39de56935f64b195, 0xbd38a83e6e4c168c),
        (0xb968986bb0f698d5, 0x3cd11796d017a52c),
        (0x394e35cdfe4ad2e0, 0x3cb6f5675cf3bead),
        (0xb8e0c38450c266b7, 0xbc4f936d06630982),
        (0xb8da35936b142aeb, 0xbc30fc2f8042c9f9),
        (0x38692f73e25e293e, 0x3bc7281c276f90d6),
        (0xb8390095011ee718, 0x3ba4725b73c87824),
        (0xb7a6c2d5c298847c, 0xbb3b9d22918ceeba),
        (0x37901e1a341f19f8, 0xbb146a436f16dfe0),
    ],
    [
        (0xbc5b4c98f0d3c4c3, 0x3fbe0357c158b119),
        (0x3583cebeaacf2fa8, 0xb8efc7d3f760c89c),
        (0xbc410072ccb88630, 0xbfadffc2fc1a91f5),
        (0x3bd769e0c0dbfe1c, 0x3f3b9b82ae07da44),
        (0xbc02d8dbfa194096, 0x3f73f64e05320ac6),
        (0x3bafe44f6e4f7a6d, 0xbf05fe4b66cf19d9),
        (0xbbc540e88468d2a5, 0xbf2539518e1b00f5),
        (0xbb397c60f4bd9fcd, 0x3eb8f8d01c487905),
        (0xbb5e1765287d55c8, 0x3ec825045b97e2dc),
        (0xbad349d279137fbd, 0xbe5d565f3bb61dea),
        (0x3af6ef17211ae45b, 0xbe611186586f4f74),
        (0x3a9d5c753068eefb, 0x3df51a669158191b),
        (0xba9c8af441d79379, 0x3df06ef52f6715ac),
        (0x3a0be37a7ebfa57f, 0xbd848215e95caa77),
        (0xba12aea2c5547dd9, 0xbd76ec8422019b0d),
        (0xb995ce432bf4ea43, 0x3d0cbaf5fc139339),
        (0xb9937ae255b6301e, 0x3cf8393ffa4f5afd),
        (0xb92ae7fb140219c1, 0xbc8e6232fb7e093b),
        (0xb8f4f418e0ddb215, 0xbc740e69bcb200c8),
        (0x38ab0659f3e0af92, 0x3c091cd1de02ebf5),
        (0x388ccf22ef87b9fa, 0x3beab86d72560db8),
        (0xb82e0b1ad1c5038b, 0xbb80aa949dd60551),
        (0xb7d9ff00c88f4aa2, 0xbb5d41db239438ec),
        (0xb79bfe1d2d6ef829, 0x3af2270328ec903e),
    ],
    [
        (0xb5ac5e4a2e275705, 0xb9005c1969d4e17b),
        (0xbc5cb1f28997ca39, 0xbfbd8293aa55d18f),
        (0xbbd0e0b711c0f01a, 0x3f53b6beb83f2596),
        (0x3c36c091c5e2bd3b, 0x3f93a5ccbc12a67b),
        (0x3bc80bb5066b1aa8, 0xbf2a3765d26aa42b),
        (0x3bc464654b3f4248, 0xbf4f5ab33748c215),
        (0xbb86c3ad1bc53ee0, 0x3ee4df6f1c257a5c),
        (0xbb9372510d6e3ed7, 0x3ef7cbd49c315be0),
        (0x3b1dfc7e29b94af4, 0xbe8f96098cf07175),
        (0x3b0aec3564d78716, 0xbe950b37dd43531f),
        (0x3aaa5efe8cd0d0ca, 0x3e2bd2e6405c605d),
        (0xbab9fdafce391124, 0x3e285530df0d4b70),
        (0x3a6ec037594c88d5, 0xbdc0029e21930f25),
        (0xba5f6bee6aa06bbf, 0xbdb3d11aeba731a1),
        (0xb9ee33d66b9efc78, 0x3d49ef077e065d17),
        (0xb9c765f6255cb3d1, 0x3d37f3d211d80ca6),
        (0xb95ffeb5c7b606b6, 0xbccf2617ced04ef7),
        (0xb95d433df855b01a, 0xbcb654785f90474d),
        (0x38a47f029dbdf48b, 0x3c4cd5d490baf361),
        (0x38d6ed83985660af, 0x3c308aa98d1885fa),
        (0xb81200c557f40391, 0xbbc53243b8f4a2ce),
        (0x384da8d1f6aaa7a2, 0xbba3f0a1e04e0f85),
        (0x37ce2a379bc1d480, 0x3b39568fa5547980),
        (0xb7a7c00b2c409082, 0x3b13efd3e10a8faf),
    ],
    [
        (0xbc57ac02118ce034, 0xbfbd0b36e5737458),
        (0x355dad3277703540, 0x38d5fb77d2e0e26b),
        (0xbc494ec699987c67, 0x3fad082ce3c6b59b),
        (0x3bdbdb6b7d6d9ed8, 0xbf3905d00c5e6800),
        (0xbc14d8fddd68c49d, 0xbf7352b073fdac7b),
        (0x3ba8a390eb7c2b92, 0x3f03f1ccfec2fc88),
        (0xbb8f7492cb6fd0c1, 0x3f248d74583834bc),
        (0x3b536c4ae37b379a, 0xbeb6a9ef0d896bae),
        (0xbb686d0e0d1bf502, 0xbec764d9798d6a80),
        (0xbaf460a4621e034f, 0x3e5aa785d6736f5c),
        (0x3b035fd3f6a4b201, 0x3e608cae36118cdb),
        (0x3a9d857819eb2176, 0xbdf332ddfb39cd01),
        (0x3a737fa058aa2bf7, 0xbdefe502ff1a8f0d),
        (0xb9e58926244b72c2, 0x3d82afc83348eeb2),
        (0x3a12be94371e2b16, 0x3d764468c0a31511),
        (0x39a6e4a5223f4dab, 0xbd0a399e849c3f2a),
        (0x3993f30753f88192, 0xbcf78e09772ae1e8),
        (0xb90378dd4b889265, 0x3c8bc9dea67a7452),
        (0xb90f40c403d002cc, 0x3c738663e180417e),
        (0xb8a2c55a9de7b5bb, 0xbc07042a23846064),
        (0x3863528c0f407011, 0xbbea0b467e151132),
        (0x38083d5af6007837, 0x3b7e9e53f034f206),
        (0xb7fe52cf6cca2436, 0x3b5c8d6dc762abf9),
        (0x3781845e75790839, 0xbaf0b68e9fe150d5),
    ],
    [
        (0x359b9f4f66331222, 0x3900369fa71bf644),
        (0xbc49df1f0f8d2108, 0x3fbc96700bf039e2),
        (0x3bd298b7ed2d16c5, 0xbf51ec0b5de4befe),
        (0xbc26397704521ddc, 0xbf93095734a24496),
        (0xbbbe43e747e8c9b8, 0x3f27d74e12285cb2),
        (0x3bbff97a4e7e808e, 0x3f4e636fe259352c),
        (0x3b74153b68748e94, 0xbee2fe11972bc0c6),
        (0x3b833d879080abe9, 0xbef712e4d44c4a74),
        (0xbb0f13d0520649e9, 0x3e8cc3adabae0452),
        (0x3b2bb2db97d7803d, 0x3e946ad2d9cbeb5c),
        (0x3aba423494626154, 0xbe295d81ae83f621),
        (0xbab425671ce4734d, 0xbe27a02aefea3d60),
        (0xba5a8cbe07596457, 0x3dbd3a949a72239d),
        (0xba589ce4399c7b23, 0x3db341e0bb193b49),
        (0x39c60f1c6ee12738, 0xbd47b550a4f77497),
        (0x39b9524731c89f4a, 0xbd374c654a2656ac),
        (0x396b773706300926, 0x3ccc861736a2cb66),
        (0x393ffcb4d6c5437c, 0x3cb5be2db467cb27),
        (0xb8d79e659806e4b3, 0xbc4a7433021b81a8),
        (0x38d24a44d0a8359e, 0xbc301fe901a012cf),
        (0x385ca56d7686e059, 0x3bc37bf8ae8852f8),
        (0x3823e08435643d0a, 0x3ba375bd0bad91a1),
        (0x37af4610bb7d3555, 0xbb37570ac69055a0),
        (0x37aa35e716b3a1f5, 0xbb137aed9b4389e6),
    ],
    [
        (0x3c2c279ff462c3c0, 0x3fbc29ae8400a320),
        (0x356e0e33fd319cb9, 0xb8d9231986c55c3a),
        (0xbc47ac9bcf34430d, 0xbfac27138da31c2b),
        (0xbbbe5ab192b0135a, 0x3f36d141fcbea853),
        (0x3c12b724fd75b152, 0x3f72bdc71062acd6),
        (0x3baf5f2a5ef8fa68, 0xbf0231cf643ffc17),
        (0x3b6e53f54e3bf9fc, 0xbf23f0bf3b3fe8be),
        (0xbb4cfe2b683d9564, 0x3eb4b05e955de175),
        (0x3b6d19f537fcf89e, 0x3ec6b52b868fa5e2),
        (0x3afd6a6cb52830e5, 0xbe585a7aa3e84cc3),
        (0x3afd15d476513524, 0xbe6012d3384c9164),
        (0x3a5b65df2e4e4330, 0x3df18f8c4872544f),
        (0xba81d06080a51e9d, 0x3deeffc4029f2f06),
        (0x3a249fcb796b8760, 0xbd811d5a3daf70fa),
        (0x3a00e5fc84cbd7e0, 0xbd75a8d84ce12a33),
        (0x39aac0f727b50a5e, 0x3d080dfa27f213b4),
        (0xb98deba8bfe45bc0, 0x3cf6eec07f1e9fed),
        (0x3926f40f27003ad3, 0xbc8987d6f3b6b977),
        (0xb900c69dbdeb6cd7, 0xbc7307196963d259),
        (0xb8970cc24a5ffc69, 0x3c052f0ef3a48697),
        (0xb82c63f97263dd39, 0x3be968357fda6848),
        (0x38062270d5c769fc, 0xbb7c3bf907642446),
        (0xb7f7074e3e5184fa, 0xbb5be25cb690eabb),
        (0xb76e99e1fa5b8f27, 0x3aeee27d7ef3ffc0),
    ],
    [
        (0x3538ee4168591cac, 0x38bef99392c87f53),
        (0x3c58fff4515190b5, 0xbfbbbf246914235f),
        (0xbbb59d638f727e96, 0x3f5062daee35411a),
        (0x3c1bef9e896a9a49, 0x3f927a96f174b6d1),
        (0x3bc79c688e785f3a, 0xbf25cdb5dea9c121),
        (0x3bd1f78082ebf798, 0xbf4d818348f98a0f),
        (0xbb8cf93ea6c33ca2, 0x3ee160aab829409d),
        (0xbb9dfe5ed028776c, 0x3ef6698d6ee99eb9),
        (0xbb0db3033371a004, 0xbe8a5633d8f0b3bf),
        (0x3b3148bb33e218be, 0xbe93d788d61154a7),
        (0xbabbfbbbe3dfb01e, 0x3e273ec2ae0084b9),
        (0x3a5bb0a12307343a, 0x3e26f958f6235deb),
        (0x3a36a5b33f99627e, 0xbdbad0939c43a9fe),
        (0xba4257e147ffea34, 0xbdb2bd56309cf195),
        (0xb9e2488ea9163776, 0x3d45c709d717f2e4),
        (0xb9d93a6f276892ca, 0x3d36b0b8fe737496),
        (0x3964c91263a6ad47, 0xbcca3cece6eae9d2),
        (0xb95aac081c12d91a, 0xbcb531b157cc8875),
        (0xb8e3db9a4bc40ecb, 0x3c485f3495a556d9),
        (0xb8cf57e3f8bac92a, 0x3c2f771622298662),
        (0xb86da2770d25e277, 0xbbc1fb1e956ae1b4),
        (0x3836de845e2a3207, 0xbba30179264b3e35),
        (0xb7dd698f3e703bcd, 0x3b3593d8b3319ae7),
        (0xb79dcfbbb66501cd, 0x3b130b99b87c3b97),
    ],
    [
        (0xbc4b1bd5a08c4698, 0xbfbb5b8273b75055),
        (0xb579007ca42ecf31, 0xb8f30640d843b3e4),
        (0xbc19066393ec82d1, 0x3fab59418c36a684),
        (0x3bd4c6e4a4b62a0c, 0xbf34eafeaa92aa79),
        (0xbc1e8c2463f82477, 0xbf7235801af9be44),
        (0x3b9bcf2d21045067, 0x3f00af9747d0be92),
        (0xbbaf406893c94ac9, 0x3f23611db0e1566f),
        (0xbb5fa294e3a6cf5c, 0xbeb2fbe414da1250),
        (0xbb6579c1dd810ff1, 0xbec613ccbb9cbe59),
        (0xbafba31f9ef26cbe, 0x3e565cf274e84d31),
        (0xbae9213eec3645d6, 0x3e5f452996e3dc2b),
        (0x3a93719707a6b39b, 0xbdf023f5382da3ad),
        (0x3a83d3a0c57bd4cc, 0xbdee2be24fbad63f),
        (0x3a1e0d9a1a424f4e, 0x3d7f7ed3740f8cf5),
        (0xba195448240988be, 0x3d75187e998a1997),
        (0xb9a83d289fab0c82, 0xbd06293c9e781b76),
        (0x399920ae46c70e84, 0xbcf65a49786c4515),
        (0xb9223154eb869eba, 0x3c878dbf0233422a),
        (0xb8db7350f762522d, 0x3c728fde2c70ddb7),
        (0x389a86a79f193b5b, 0xbc0392b8f6167154),
        (0xb883a3fc81fa37b9, 0xbbe8cea59f44a3e2),
        (0x37d28560a2d0c913, 0x3b7a213dbaca9263),
        (0xb7672b5585eddf9a, 0x3b5b40576765c08e),
        (0xb78ee5530750cce7, 0xbaeca1b39264a34b),
    ],
    [
        (0x359f12f74a1a873e, 0xb8fd67b1800cc2aa),
        (0xbc5024304247ada3, 0x3fbaf9cb49c4f935),
        (0x3bd43675d81a390c, 0xbf4e1d930b513228),
        (0xbc26b1ae600584f2, 0xbf91f7a8fec6eba8),
        (0xbbccaafb65ee566e, 0x3f240a55310866fc),
        (0xbbe93eb318fc691a, 0x3f4cb20c812fd3aa),
        (0x3b7bc11f6acb6aed, 0xbedff51953c6b6cc),
        (0x3b7ca6d60de07627, 0xbef5cdc48f5d75eb),
        (0xbb1e5c798f5702c3, 0x3e883b091952c721),
        (0x3b392f384e40f60f, 0x3e934fb685e58ab7),
        (0x3abc9afeb4201722, 0xbe2566fc4369ab71),
        (0x3ac8555b1f6751cc, 0xbe265f0f7de29720),
        (0x3a505976fb73241a, 0x3db8b61e5f9b7a00),
        (0xba04a898dd824080, 0x3db24253069b78a9),
        (0x39bb5929dac6aff0, 0xbd441732d722b422),
        (0xb9d662b0ae22d5ef, 0xbd361fa985a16926),
        (0xb92bfd8dca36b2a6, 0x3cc83c175673059f),
        (0xb956fcc071485aba, 0x3cb4ae32974df1c6),
        (0xb8d5a8f989475dc8, 0xbc468a7f73f5be7c),
        (0xb8c1d7200f0ee470, 0xbc2eba46ae458bcc),
        (0xb8686a635728619a, 0x3bc0a770636ddc81),
        (0x3846e16decd06b9b, 0x3ba29388d9fcba28),
        (0xb7da9125321029a4, 0xbb34040dedb7bebe),
        (0x37af7783c5802665, 0xbb12a1bc8335b315),
    ],
    [
        (0x3c5ffacf3e2418f7, 0x3fba9e13a0db6429),
        (0xb583910dd6018bba, 0x38e353089e99116d),
        (0xbc305f5aef327444, 0xbfaa9c1ca2161b9b),
        (0xbbd5ab98ac97faea, 0x3f3344a09efdc635),
        (0x3be8bf0e556cf4b8, 0x3f71b82c430a2381),
        (0xbb93a99455084734, 0xbefebfb97bca01f2),
        (0xbb99136a1ed7b5f9, 0xbf22dcdb1bc1d038),
        (0x3b5ea30ecc612715, 0x3eb180047f0b79ae),
        (0x3b46ae074e2d9e22, 0x3ec57eeeee84d0d0),
        (0xbadb1941bb0e0bc1, 0xbe54a0c699c8318b),
        (0x3adc2d735741fddf, 0xbe5e7594e8a2c760),
        (0xba8de62221d00ec8, 0x3dedccbbb4c0ba7f),
        (0x3a8cf847ee673438, 0x3ded6766337b5c95),
        (0xba0200bd41d3e51f, 0xbd7d1a05cea18a02),
        (0xba1f3622c8b76f5f, 0xbd74922fb50a29f1),
        (0xb99416959af186e5, 0x3d047fa35bf627ce),
        (0x3983729747e80125, 0x3cf5cfa087122294),
        (0xb90144302fbdaa10, 0xbc85d009937bf5ab),
        (0x3907a8b2df9e5ac3, 0xbc72200b01fdbf9d),
        (0xb8a0a7e595a1fb47, 0x3c02265f004c1d49),
        (0x387e52805deaab21, 0x3be83df71ae8ab7a),
        (0x37bb19a9df1aa0a8, 0xbb7843800001ddf6),
        (0xb7eb3ebd0a11156f, 0xbb5aa6f0e2f25140),
        (0x37780a266a5c06bb, 0x3aeaa04878c515a9),
    ],
    [
        (0x357a12f34662767b, 0x38ebd844c546d1fe),
        (0xbc55d35a88f1e0a3, 0xbfba4407e04298d1),
        (0x3bdf6dddc07add4c, 0x3f4bcc9df0cf00b2),
        (0xbc3c3cb8ccc39cf1, 0x3f917f0266db2149),
        (0x3ba3d974ad0c21fe, 0xbf2280a052234a05),
        (0x3bb902b669103937, 0xbf4bf2ada1f44071),
        (0xbb64ad3fa1509171, 0x3edd83d58032b48d),
        (0x3b3d6efd0446126a, 0x3ef53dd972d8f232),
        (0xbb230c11b6006891, 0xbe8663c1fe202028),
        (0xbb26dbba4ce8bd7d, 0xbe92d1fbf2203ff6),
        (0x3ac866e6e348b7b7, 0x3e23c9f0b759c5f9),
        (0x3ac489ff33dfce8f, 0x3e25cfe1b012696d),
        (0x3a4981337ac7965a, 0xbdb6ddc0795781e9),
        (0xba4b13e076398cc3, 0xbdb1cfd49504266a),
        (0x39edb765a45cfad5, 0x3d429b7af5214fbc),
        (0x39bd594b3ede144b, 0x3d3598302ab3ac8a),
        (0xb96436f0bc69940b, 0xbcc677f6a604ab42),
        (0xb95aaa7d20415d1b, 0xbcb432ecc122bbc3),
        (0x38b6c227de389245, 0x3c44ec114bfb6bf7),
        (0x38b8822ee44d55d6, 0x3c2e0887f8c2f57d),
        (0x38569ce3e7c211fb, 0xbbbef44a37f84f12),
        (0x384d44f14e9f294c, 0xbba22b91f5f4449b),
        (0xb7c6e331300713b4, 0x3b32a03f80301aa2),
        (0xb7bc71f13c4d9d35, 0x3b123d23f8f7ad2f),
    ],
    [
        (0x3c423404089aea01, 0xbfb9ef3bb2213b0b),
        (0x3564b334f22dc8c4, 0x38ec7aef8237b6d2),
        (0x3c342c5cb51f2b57, 0x3fa9ed82007a9a45),
        (0xbbad41b75b8a8df3, 0xbf31d2fdeeb29f8a),
        (0x3c189945952fed1e, 0xbf71446866ff1b83),
        (0x3b94bf0ff761bace, 0x3efc73b684f93259),
        (0xbbc79edfb80bfc5d, 0x3f22628de594b6c9),
        (0xbb2bef93c666f4ba, 0xbeb03303c1427449),
        (0x3b69194ecd6aac53, 0xbec4f51007c51087),
        (0x3af53d1fa2147ee3, 0x3e531adfa36f2213),
        (0xbafbf005f05fcc98, 0x3e5db4f306b19095),
        (0x3a88f72949d1398a, 0xbdeb9e33598f899e),
        (0xba8457c3274ebd59, 0xbdecb09ed6ecb896),
        (0xba159f6f24f8986e, 0x3d7afe1183148a99),
        (0x3a11bfaf9fbcb95f, 0x3d7414e442aa8d57),
        (0x39ae38a755a019d9, 0xbd0307c129418397),
        (0xb99de6576700d7e4, 0xbcf54ddabca7b729),
        (0xb91f28f4f591d3f4, 0x3c84455c62381679),
        (0xb913f1c98ec45b97, 0x3c71b70264da382d),
        (0xb8a8129bcf1d63a0, 0xbc00e2cfa963d4c5),
        (0xb8879c81e5b960aa, 0xbbe7b5896de3457b),
        (0xb8030217c1f78b40, 0x3b7699efca5cd8c8),
        (0x37e0b0e37cbd943a, 0x3b5a15ae188cedc6),
        (0xb78b8997136a2cc2, 0xbae8d5720aed06a6),
    ],
    [
        (0xb59a217cd5a5fc59, 0xb8f8cb0a4bb92b1c),
        (0x3c5728ab934a26a0, 0x3fb99be744018c90),
        (0xbbdb8852614fe858, 0xbf49c3f52a2af724),
        (0xbc2f281d89ca12e4, 0xbf910f5ca51f98b0),
        (0xbbc3c6681ac39db5, 0x3f2126c8e8ca2766),
        (0x3babb471b2b6cf3f, 0x3f4b416f7d4fc313),
        (0xbb677b33eb16cea4, 0xbedb5e2e5580e1ce),
        (0xbb988d4663776f74, 0xbef4b862279de756),
        (0xbb2b43c42f7f04bd, 0x3e84c5071b39dc13),
        (0xbb3de6264de806d7, 0x3e925d2fc3b19021),
        (0x3ac879393dd83f28, 0xbe225df322279972),
        (0xbac3ec23ad6e970a, 0xbe254a971eb6fe3b),
        (0x3a5048109b74bd8a, 0x3db53cc6c9922f2b),
        (0xba43610ec595546e, 0x3db164f95180d8c1),
        (0x39e236638a339577, 0xbd414b9ef404ed89),
        (0x39d5e32a69772db7, 0xbd3519623b4e50ac),
        (0x396ac2c256389163, 0x3cc4e7271a71f23c),
        (0x39593e237428a68a, 0x3cb3bf2a1b859197),
        (0xb8e5a9f4a410aefa, 0xbc437bc0d8e44b83),
        (0x38afa844b04c9f72, 0xbc2d6104b94c47d8),
        (0xb85bd976332a8ad4, 0x3bbcdb4b3544bc80),
        (0xb81ec0f06119d6f0, 0x3ba1c93567462aba),
        (0xb7dbdd21527e43db, 0xbb31623ef293806e),
        (0x37b58068411a8ada, 0xbb11dd917bc85327),
    ],
    [
        (0xbc54096ec8637e04, 0x3fb94d3276914e51),
        (0xb599a52e7e447fba, 0xb8f7c4d3a1091c64),
        (0x3c4baee1d6c0d38b, 0xbfa94bac1950e319),
        (0x3bdbfe3ad50b1c19, 0x3f308d4ff8f2059e),
        (0xbc1cca1c2770b225, 0x3f70d90d29bfeecd),
        (0xbb987fee6225f412, 0xbefa6d56162f7fb4),
        (0xbbc7e723313bf860, 0xbf21f107da23807d),
        (0x3b42cbddeb0faca2, 0x3eae1a626277437b),
        (0x3b665fad37433b79, 0x3ec474eafd0cc642),
        (0x3acb91aaa2286db9, 0xbe51c27144f42d78),
        (0x3af7189d5fa17ee0, 0xbe5d01999b1a4fe9),
        (0x3a35f0e0348c776a, 0x3de9b014801da87a),
        (0x3a8958b840cda80a, 0x3dec061740bc8a45),
        (0x3a16875708b7d88b, 0xbd791f8c2972547e),
        (0x3a1c0289b9700b84, 0xbd739fb558b7aa4d),
        (0x39a9d6b95b5ce534, 0x3d01b9f74d47b35f),
        (0x3992cf3210e813d7, 0x3cf4d425557e1f1c),
        (0x392e1b1b93526a26, 0xbc82e617ae27952e),
        (0x3913ab3cd31920c7, 0xbc715432898c29d0),
        (0x3894feceefbf4d3a, 0x3bff843f6347963f),
        (0x388afc3194a2db07, 0x3be734c130fc648e),
        (0xb81e9da93ee8d83a, 0xbb751d395949afbc),
        (0x37d1fb7f6ae8afc8, 0xbb598c0f03028f01),
        (0x3751f15d40f7c19d, 0x3ae739cc4684a5bc),
    ],
    [
        (0xb568e6ce9dddcc62, 0x38c846638d0f2565),
        (0x3c5e213a1a4b3671, 0xbfb8ffc9bd24fe08),
        (0x3be5e8a5d70cf555, 0x3f47f7d46ab33721),
        (0x3c2f532ddb23dab4, 0x3f90a7a725d3fbc4),
        (0xbbb3f089aa8f2adf, 0xbf1fea1728f216b4),
        (0xbbdf63ef3319327c, 0xbf4a9cac69f0ed64),
        (0x3b78f775cf86e9c6, 0x3ed977f48ff1056b),
        (0x3b8a77447ea6fe43, 0x3ef43c2d8e698c10),
        (0x3b293f5e91559672, 0xbe8355d1a6765ea6),
        (0x3b177401cf3aa17c, 0xbe91f0553501d121),
        (0xba823a3e8101b9d1, 0x3e211b47f6a44829),
        (0xbaa6a02fffa2b5eb, 0x3e24ce23303889a9),
        (0xba42b03ad2eec174, 0xbdb3ca98df62221f),
        (0xba50afdcc563be7a, 0xbdb100fc746529d7),
        (0xb9edcbe05d10e11a, 0x3d4020f11e2dca08),
        (0xb9da9e6748bc0bea, 0x3d34a26ef2219c2c),
        (0x3957914c29f9b911, 0xbcc38203ff52c747),
        (0xb94441377b47cfd9, 0xbcb35244c153aa29),
        (0xb8ef173859510b43, 0x3c4232dbbbea35fb),
        (0x38b7c43340294390, 0x3c2cc2f30d7e4a86),
        (0xb850cdea356a6de6, 0xbbbafaa22e04387a),
        (0x38455c9d49ba1463, 0xbba16c1420a026bc),
        (0x37ce36d7bd132716, 0x3b3044e17b70797e),
        (0x37bc48ba65be1620, 0x3b1182c036f66e44),
    ],
    [
        (0x3c4123b2f0e7c9dd, 0xbfb8b67a2481077d),
        (0xb54bc05ff5d82c4f, 0xb8f3f299f5be57c2),
        (0xbc4b4ca91be60b3e, 0x3fa8b51f21068ea2),
        (0x3bb25eeb0c780d24, 0xbf2ed935c7aefa31),
        (0xbbf1e97629a4fbd3, 0xbf707522a5037f2d),
        (0x3b9aa02b2936e0d6, 0x3ef8a196061f8bbc),
        (0x3bc503ddcb9034df, 0x3f21874a47e3c1e3),
        (0x3b255f9307a25ea3, 0xbeac10cf34c04f17),
        (0xbb5b1d5a1969a1af, 0xbec3fd6c2d4fa2a4),
        (0xbaeb932c5947d65c, 0x3e50906d55522785),
        (0xbabb5acdea3816e2, 0x3e5c5a1c124dfa08),
        (0xba561fcb9b3ed156, 0xbde7f883b31a5f59),
        (0xba75531c808efbb8, 0xbdeb668cf53028e4),
        (0x3a104761ec9ef33f, 0x3d7775372d05b25d),
        (0xba0f2cfa85a363c5, 0x3d7331d871d677e0),
        (0xb9a6539a2342e3af, 0xbd009010248989d3),
        (0x398a668272dab0b6, 0xbcf461c4067c742d),
        (0xb92d7ef952991dfa, 0x3c81abf993696e78),
        (0x3913091355b7de99, 0x3c70f715fa383b8a),
        (0x3875a2bcb94003ab, 0xbbfd7ed2f30db038),
        (0x388cafff31b61f18, 0xbbe6bb0b4da7d6b8),
        (0xb7ea731441eedbfd, 0x3b73c73f0e157e5c),
        (0xb7f38c8cb3f130f8, 0x3b5909945c395947),
        (0x37892d92eac220fa, 0xbae5c71cc3e16dfe),
    ],
    [
        (0x35720ba7b8040a50, 0xb8ee1da34bfeb8e0),
        (0x3c5b1c9821974148, 0x3fb86e51be0a9153),
        (0xbbeaa494385dab26, 0xbf465ed1b387e5da),
        (0x3c09cfc1363faa0e, 0xbf9046fc5a218a86),
        (0x3bbf17fc55a88b96, 0x3f1dca617fefa913),
        (0xbbe411ddd3f224d7, 0x3f4a0300221528a7),
        (0xbb35922d57d34f24, 0xbed7c7618906f1e2),
        (0x3b985c37a3fcd2ca, 0xbef3c838897d0a1e),
        (0xbb1cfc9e9ef07548, 0x3e820ede9f9dd7dd),
        (0x3b3d338a91461c93, 0x3e918a94165592bb),
        (0x3ab91bf2c08f3e78, 0xbe1ff76205118f09),
        (0x3ab5cfc207f32cd7, 0xbe24599dfeef01a1),
        (0x3a40b7bcb17c141b, 0x3db2803e59983134),
        (0xba1b8c9ffd59054b, 0x3db0a33202feb043),
        (0x39bbb27b9c04cfb6, 0xbd3e2bff738680f8),
        (0xb9daf156baca0aee, 0xbd34329cf32bcb6e),
        (0xb95aa99554b94956, 0x3cc2424890fb6cfb),
        (0xb94757efb61f4861, 0x3cb2eba657649d9b),
        (0x38e0a8b550a3fb8e, 0xbc410bda49bebe27),
        (0xb8b5e1a905ee61d3, 0xbc2c2d96d94f34d6),
        (0x38596b550a29ba35, 0x3bb94a9b8509dda4),
        (0xb8120159994b4d70, 0x3ba113d205a63be1),
        (0x37caf2ee39614a11, 0xbb2e87a2990f48e9),
        (0xb7a8109d37f955d6, 0xbb112c694684c14b),
    ],
    [
        (0x3c48caabfef07d2c, 0x3fb829d06fee9266),
        (0xb57d95eabe44a5ef, 0xb8d5c95908041d40),
        (0xbc46f7f245223685, 0xbfa8289a526d7785),
        (0xbbbd55f593621103, 0x3f2cd680355c9eb6),
        (0x3c19dafafbc85033, 0x3f7017d70f512861),
        (0x3b94ef924915594e, 0xbef707978e2a0db8),
        (0xbbb84f6dd554027b, 0xbf21247ce15e7385),
        (0x3b3c1549321f5896, 0x3eaa3f6125485ec1),
        (0xbb6485c950af11e4, 0x3ec38da848401be9),
        (0xbae81c7e658ccb44, 0xbe4efe39d8db4cd8),
        (0xbaf106727152dad2, 0xbe5bbd40f1db0e94),
        (0x3a7e01f9c4e4c0e2, 0x3de66f7d49436f83),
        (0xba6a9de5073f8785, 0x3dead0e8148229b3),
        (0xb9edea6b298d9cb4, 0xbd75f78595133d0b),
        (0x3a0ffda12b15058b, 0xbd72ca9bb10321b3),
        (0xb995d841a594fd98, 0x3cff09e49c887e91),
        (0xb993b69afd44cfe7, 0x3cf3f60eeb66f747),
        (0xb910a7c26357cc61, 0xbc8091d689cc53d3),
        (0x3912aa74818ab310, 0xbc709f335e86201a),
        (0x389d74a5732f64e7, 0x3bfbad342a8e077c),
        (0xb889c873abcae58c, 0x3be647de871fcaea),
        (0x380999f107e74e72, 0xbb7292e087988121),
        (0xb7dd56a4a524a0b3, 0xbb588dc30bd642e2),
        (0x373e8c81645a59c4, 0x3ae4781fefecc3ab),
    ],
    [
        (0x3590e3abb994f19d, 0xb8f3c9c05fc68dd7),
        (0x3c21907f595a082a, 0xbfb7e656efb009ae),
        (0x3bea53822a52d942, 0x3f44f15066f3d876),
        (0xbbef8f1c9736150f, 0x3f8fd932c26aad94),
        (0xbba4e6bbdf1f5013, 0xbf1be460dd86a0a4),
        (0x3bdda15b3eedcfa3, 0xbf49733b591879f8),
        (0x3b7b0e620a04314f, 0x3ed64488c56022e0),
        (0xbb74588b63a38eb3, 0x3ef35ba58bf2f993),
        (0xbb2d0149456492a2, 0xbe80ea47bceb9a8f),
        (0xbb1839787899a71b, 0xbe912b327055d0e9),
        (0xbaaeacb6c41bd108, 0x3e1df42fc4e2482c),
        (0xba6bbde5a22c7137, 0x3e23ec3e76876dba),
        (0xba4c4c84b112be57, 0xbdb1580393f473c3),
        (0x3a22a6076d63b081, 0xbdb04b0353c35935),
        (0xb9c9681ae93e12c5, 0x3d3c4ca30ffe2a12),
        (0xb9d1f206b8c5d3a1, 0x3d33c947b936c2fd),
        (0xb963c18fe06a22d6, 0xbcc122c73f770a60),
        (0x39590514d9616a4d, 0xbcb28ac7295026a0),
        (0x38e4da699d53ec4a, 0x3c4002243876b909),
        (0x38b0a1100a850e1a, 0x3c2ba04294d52584),
        (0xb85e4caf2a0c3dac, 0xbbb7c4c63a56cf5d),
        (0x383d5bda7bf4fb51, 0xbba0c0178f4adc58),
        (0x37ba459191582324, 0x3b2cb6cf025ab9d0),
        (0x37b2a1b95a167cc0, 0x3b10da465bbcd445),
    ],
    [
        (0xbc2f952341a4610f, 0xbfb7a62320798175),
        (0x3588b8c77a52cc96, 0xb8e354421b948434),
        (0x3c4f5aadff868986, 0x3fa7a50ca4504bb8),
        (0xbbc425ed1e2ffb88, 0xbf2b095ccb50a68c),
        (0x3c0088e41711bdb7, 0xbf6f80ef11daa37a),
        (0xbb8b1b49cdffecd8, 0x3ef59822dc75b064),
        (0x3bc22455dc1dd149, 0x3f20c7e6a7c66630),
        (0x3b4cb7b87c0d2237, 0xbea89e00b5c358d0),
        (0x3b4c5e752b8da3c2, 0xbec324d5238b26d0),
        (0x3ae195d9c7c418a5, 0x3e4d13a888d5dd30),
        (0xbac402a4638ae535, 0x3e5b29f941a95b07),
        (0x3a831332fd181280, 0xbde50e6ebb3d1df6),
        (0xba87a4d1a4734618, 0xbdea4434c6b929dd),
        (0x3a1460d05df6e757, 0x3d74a03fe2c47842),
        (0x3a08550d3cb8e7ab, 0x3d7269628f2df98c),
        (0x398caf5ddb7a6639, 0xbcfd28cc08ef4278),
        (0xb9786d9d39f281e6, 0xbcf390706334abc3),
        (0xb90ccf6b842a2b18, 0x3c7f26c3ea443ebe),
        (0xb909111db3c1a608, 0x3c704c1cd3344483),
        (0xb89c3b1307b1967f, 0xbbfa08922dcea305),
        (0x38837f0ef471dbfb, 0xbbe5dabbff6c2bfb),
        (0xb80bcc939f982679, 0x3b717bccb6cd02d3),
        (0x37fb40b6199ccfa5, 0x3b5818261a2214e1),
        (0xb78fcd71326e756b, 0xbae3485ef660d33a),
    ],
];
