![SDL Hyperion](./readme/images/image_header_herculeshyperionSDL.png)  
[![Build Status](https://travis-ci.org/SDL-Hercules-390/hyperion.svg?branch=master)](https://travis-ci.org/SDL-Hercules-390/hyperion)

## SDL Hercules 4.x Hyperion

## Contents

1. [About](#About)
2. [Find out more](#Find-out-more)
3. [Additional README files](#Additional-README-files)

## About

**Hercules** is an open source software implementation of the mainframe System/370 and ESA/390 architectures, in addition to the latest 64-bit z/Architecture. Hercules runs under Linux, Windows, Solaris, FreeBSD, and Mac OS X.

Hercules is [OSI Certified Open Source Software](http://www.opensource.org/) licensed under the terms of the [Q Public Licence](http://sdl-hercules-390.github.io/html/herclic.html).

SDL Hercules 4.x Hyperion is a version of Hercules containing fixes made by the Hercules development team as well as by others to fix bugs which may still exist in the 3.x and 4.0 versions of Hercules, as well as enhancements and improvements to the emulator's overall functionality above and beyond what may have been provided in earlier versions. It is currently the only actively maintained version and is considered an official version of the Hercules-390 emulator.

Hercules was created by Roger Bowler.

Jay Maynard "the Tron Guy" was the maintainer from 2000 to 2012.

Jan Jaeger designed and implemented many of the advanced features of Hercules, including dynamic reconfiguration, integrated console, interpretive execution and z/Architecture support.

## Find out more

To find out more about this particular version of Hercules 4.x Hyperion, follow this link: [Hercules 4.x (Hyperion)](http://sdl-hercules-390.github.io/html/)

## Additional README files

### Issues/Bugs

[Unresolved Issues](readme/README.ISSUES.md)  

_**Bug reports** (together with your diagnosis of the fault please!)_ should be reported
to our **bug report tracking system** by adding/creating a new
[**"GitHub Issue"**](https://github.com/SDL-Hercules-390/hyperion/issues) on GitHub.

### Building Hercules

[**Building Hercules (Overview)**](http://sdl-hercules-390.github.io/html/hercinst.html#install) &nbsp; _**(Important!)**_  
[**Building "External Packages"**](readme/README.EXTPKG.md) &nbsp; _(Important!)_  
[Building Hercules under AIX](readme/README.AIX.md)  
[Building Hercules under BSD/OSX](readme/README.BSD.md)  
[Budiling Hercules for OSX](readme/README.OSX.md)  
[Building Hercules under 64-bit Windows](readme/README.WIN64.md) &nbsp; _(obsolete)_  
[Building Hercules with MinGW](readme/README.MINGW.md) &nbsp; _(obsolete)_  
[Building Hercules for Windows with Visual C](readme/README.MSVC.md) &nbsp; _(obsolete)_  
[HercIFC and Hercules as setuid root programs](readme/README.SETUID.md)  
[How to build Hercules from SVN under Solaris](readme/README.SUN.md)  

### Mods

[APL/360 mods](readme/README.APL360.md)  
[ECPS:VM & Extended VM Assists](readme/README.ECPSVM.md)  
[Preliminary 2703 BSC Support](readme/README.COMMADPT.md)  
[RXVT4APL Mods](readme/README.RXVT4APL.md)  

### Features and Operation

[Customizable Hercules 3270 Logo](readme/README.HERCLOGO.md)  
[Running Hercules in Daemon mode](readme/README.DAEMON.md)  
[Guest Access To Host IP Stack - The TCPIP (X'75') Instruction](readme/README.TCPIP.md)  
[HAO (Hercules Automatic Operator)](readme/README.HAO.md)  
[Hercules CCKD64 Support](readme/README.CCKD64.md)  
[Hercules Networking](readme/README.NETWORKING.md)  
[Hercules SNA Support](readme/README.SNA.md)  
[Hercules REXX Support](readme/README.REXX.md)  
[Hercules Tape Support Enhancements SPE/Fixes](readme/README.TAPE.md)  
[Host Resource Access Facility](readme/README.HRAF.md)  
[MAKETAPE Create .AWS Tape File from Data Utility](readme/README.MAKETAPE.md)  
[Runtest Low-level Test Cases](tests/README.md)  
[S/370 Backport of select ESA/390 and z/Architecture instructions](readme/README.S37X.md)  
[TCPNJE Support](readme/README.TCPNJE.md)  
[VMFPLC2 (VM) Formatted Tape Utility](readme/README.VMFPLC2.md)  

### HERCULES INTERNAL READMEs

[Adding New Files to Hercules](readme/README.ADDING.md)  
[Adding New z/Architecture Facilities to Hercules](readme/README.FACILITIES.md)  
[CMPSC "Compression Call" instruction support](readme/README.CMPSC.md)  
[Hercules Dynamic Loader](readme/README.HDL.md)  
[Hercules Dynamic Modules (on Windows)](readme/README.DYNMOD.md)  
[HQA Build Scenarios](readme/README.HQA.md)  
[Low-level Test Cases](tests/README.md)  
[PTT Tracing](readme/README.PTT.md)  
[Trace-to-File Support](readme/README.TRACEFILE.md)  
