.\" $NCDId: @(#)AuCrBuc.man,v 1.1 1994/09/27 00:24:59 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id$
.TH AuCreateBucket 3 "1.2" "audiolib - bucket existence"
.SH \fBName\fP
\fBAuCreateBucket\fP \- create a bucket
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
\fBAuBucketID\fP \fBAuCreateBucket\fP(\fIserver\fP, \fIformat\fP, \fItracks\fP, \fIaccess\fP, \fIsample_rate\fP, \fInsamples\fP, \fIdescription\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuUint32\fP \fIformat\fP;
.br
    \fBAuUint32\fP \fItracks\fP;
.br
    \fBAuUint32\fP \fIaccess\fP;
.br
    \fBAuUint32\fP \fIsample_rate\fP;
.br
    \fBAuUint32\fP \fInum_samples\fP;
.br
    \fBAuString\fP *\fIdescription\fP;
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIformat\fP 1i
Specifies the data format of the audio data.
Currently, the following formats are defined: \fBAuFormatULAW8\fP, \fBAuFormatLinearUnsigned8\fP, \fBAuFormatLinearSigned8\fP, \fBAuFormatLinearSigned16MSB\fP, \fBAuFormatLinearUnsigned16MSB\fP, \fBAuFormatSignedLinear16LSB\fP, and \fBAuFormatLinearUnsigned16LSB\fP.
.IP \fItracks\fP 1i
Specifies the number of tracks of the audio data.
.IP \fIaccess\fP 1i
Specifies the types of operations permitted on this bucket.
This must be a bitwise inclusive OR of zero or more of these constants: \fBAuAccessImportMask\fP, \fBAuAccessExportMask\fP, \fBAuAccessDestroyMask\fP, and \fBAuAccessListMask\fP.
.IP \fIsample_rate\fP 1i
Specifies the sample rate of the audio data.
.IP \fInum_samples\fP 1i
Specifies the number of samples the bucket will contain.
.IP \fIdescription\fP 1i
Specifies a textual description of the bucket.
This may be NULL.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuCreateBucket\fP creates a bucket with the specified attributes, and returns the bucket ID, or \fBAuNone\fP if there was an error.
The initial contents of the bucket are undefined.
.SH \fBErrors\fP
\fBAuBadValue\fP,
\fBAuBadLength\fP,
\fBAuBadAlloc\fP.
.SH \fBSee Also\fP
\fBAuDestroyBucket\fP,
\fBAuSetBucketAttributes\fP,
\fBAuListBuckets\fP,
\fBAuFreeBucketAttributes\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
