.\" $NCDId: @(#)AuGetEl.man,v 1.1 1994/09/27 00:29:24 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id$
.TH AuGetElements 3 "1.2" "audiolib - flow elements"
.SH \fBName\fP
\fBAuGetElements\fP \- get the elements in a flow
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
\fBAuElement\fP *\fBAuGetElements\fP(\fIserver\fP, \fIflow\fP, \fIclocked\fP, \fInum_elements\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuFlowID\fP \fIflow\fP;
.br
    \fBAuBool\fP *\fIclocked\fP; /* \fBRETURN\fP */
.br
    int *\fInum_elements\fP; /* \fBRETURN\fP */
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIflow\fP 1i
Specifies the ID of the flow to get the elements from.
.IP \fIclocked\fP 1i
Returns a boolean value that indicates if the flow is clocked.
.IP \fInum_elements\fP 1i
Returns the number of elements.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuGetElements\fP returns the list of elements comprising \fIflow\fP or NULL, with \fInum_elements\fP set to 0, if there was an error.
Use \fBAuFreeElements\fP to free this list when nolonger needed.
.SH \fBErrors\fP
\fBAuBadFlow\fP.
.SH \fBSee Also\fP
\fBAuSetElements\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
