/*
 * This C header file has been generated by smidump 0.5.0.
 * It is intended to be used with the NET-SNMP package.
 *
 * This header is derived from the BRIDGE-MIB module.
 *
 * $Id$
 */

#ifndef _BRIDGE_MIB_H_
#define _BRIDGE_MIB_H_

#include <stdlib.h>

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

/*
 * C type definitions for BRIDGE-MIB::dot1dBase.
 */

typedef struct dot1dBase {
    u_char    *dot1dBaseBridgeAddress;
    int32_t   *dot1dBaseNumPorts;
    int32_t   *dot1dBaseType;
    void      *_clientData;		/* pointer to client data structure */

    /* private space to hold actual values */

    u_char    __dot1dBaseBridgeAddress[6];
    int32_t   __dot1dBaseNumPorts;
    int32_t   __dot1dBaseType;
} dot1dBase_t;

/*
 * C manager interface stubs for BRIDGE-MIB::dot1dBase.
 */

extern int
bridge_mib_mgr_get_dot1dBase(struct snmp_session *s, dot1dBase_t **dot1dBase);

/*
 * C agent interface stubs for BRIDGE-MIB::dot1dBase.
 */

extern int
bridge_mib_agt_read_dot1dBase(dot1dBase_t *dot1dBase);
extern int
bridge_mib_agt_register_dot1dBase();

/*
 * C type definitions for BRIDGE-MIB::dot1dBasePortEntry.
 */

typedef struct dot1dBasePortEntry {
    int32_t   *dot1dBasePort;
    int32_t   *dot1dBasePortIfIndex;
    uint32_t  *dot1dBasePortCircuit;
    size_t    _dot1dBasePortCircuitLength;
    uint32_t  *dot1dBasePortDelayExceededDiscards;
    uint32_t  *dot1dBasePortMtuExceededDiscards;
    void      *_clientData;		/* pointer to client data structure */
    struct dot1dBasePortEntry *_nextPtr;	/* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dot1dBasePort;
    int32_t   __dot1dBasePortIfIndex;
    uint32_t  __dot1dBasePortCircuit[128];
    uint32_t  __dot1dBasePortDelayExceededDiscards;
    uint32_t  __dot1dBasePortMtuExceededDiscards;
} dot1dBasePortEntry_t;

/*
 * C manager interface stubs for BRIDGE-MIB::dot1dBasePortEntry.
 */

extern int
bridge_mib_mgr_get_dot1dBasePortEntry(struct snmp_session *s, dot1dBasePortEntry_t **dot1dBasePortEntry);

/*
 * C agent interface stubs for BRIDGE-MIB::dot1dBasePortEntry.
 */

extern int
bridge_mib_agt_read_dot1dBasePortEntry(dot1dBasePortEntry_t *dot1dBasePortEntry);
extern int
bridge_mib_agt_register_dot1dBasePortEntry();

/*
 * C type definitions for BRIDGE-MIB::dot1dStp.
 */

typedef struct dot1dStp {
    int32_t   *dot1dStpProtocolSpecification;
    int32_t   *dot1dStpPriority;
    uint32_t  *dot1dStpTimeSinceTopologyChange;
    uint32_t  *dot1dStpTopChanges;
    u_char    *dot1dStpDesignatedRoot;
    int32_t   *dot1dStpRootCost;
    int32_t   *dot1dStpRootPort;
    int32_t   *dot1dStpMaxAge;
    int32_t   *dot1dStpHelloTime;
    int32_t   *dot1dStpHoldTime;
    int32_t   *dot1dStpForwardDelay;
    int32_t   *dot1dStpBridgeMaxAge;
    int32_t   *dot1dStpBridgeHelloTime;
    int32_t   *dot1dStpBridgeForwardDelay;
    void      *_clientData;		/* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dot1dStpProtocolSpecification;
    int32_t   __dot1dStpPriority;
    uint32_t  __dot1dStpTimeSinceTopologyChange;
    uint32_t  __dot1dStpTopChanges;
    u_char    __dot1dStpDesignatedRoot[8];
    int32_t   __dot1dStpRootCost;
    int32_t   __dot1dStpRootPort;
    int32_t   __dot1dStpMaxAge;
    int32_t   __dot1dStpHelloTime;
    int32_t   __dot1dStpHoldTime;
    int32_t   __dot1dStpForwardDelay;
    int32_t   __dot1dStpBridgeMaxAge;
    int32_t   __dot1dStpBridgeHelloTime;
    int32_t   __dot1dStpBridgeForwardDelay;
} dot1dStp_t;

/*
 * C manager interface stubs for BRIDGE-MIB::dot1dStp.
 */

extern int
bridge_mib_mgr_get_dot1dStp(struct snmp_session *s, dot1dStp_t **dot1dStp);

/*
 * C agent interface stubs for BRIDGE-MIB::dot1dStp.
 */

extern int
bridge_mib_agt_read_dot1dStp(dot1dStp_t *dot1dStp);
extern int
bridge_mib_agt_register_dot1dStp();

/*
 * C type definitions for BRIDGE-MIB::dot1dStpPortEntry.
 */

typedef struct dot1dStpPortEntry {
    int32_t   *dot1dStpPort;
    int32_t   *dot1dStpPortPriority;
    int32_t   *dot1dStpPortState;
    int32_t   *dot1dStpPortEnable;
    int32_t   *dot1dStpPortPathCost;
    u_char    *dot1dStpPortDesignatedRoot;
    int32_t   *dot1dStpPortDesignatedCost;
    u_char    *dot1dStpPortDesignatedBridge;
    u_char    *dot1dStpPortDesignatedPort;
    uint32_t  *dot1dStpPortForwardTransitions;
    int32_t   *dot1dStpPortPathCost32;
    void      *_clientData;		/* pointer to client data structure */
    struct dot1dStpPortEntry *_nextPtr;	/* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dot1dStpPort;
    int32_t   __dot1dStpPortPriority;
    int32_t   __dot1dStpPortState;
    int32_t   __dot1dStpPortEnable;
    int32_t   __dot1dStpPortPathCost;
    u_char    __dot1dStpPortDesignatedRoot[8];
    int32_t   __dot1dStpPortDesignatedCost;
    u_char    __dot1dStpPortDesignatedBridge[8];
    u_char    __dot1dStpPortDesignatedPort[2];
    uint32_t  __dot1dStpPortForwardTransitions;
    int32_t   __dot1dStpPortPathCost32;
} dot1dStpPortEntry_t;

/*
 * C manager interface stubs for BRIDGE-MIB::dot1dStpPortEntry.
 */

extern int
bridge_mib_mgr_get_dot1dStpPortEntry(struct snmp_session *s, dot1dStpPortEntry_t **dot1dStpPortEntry);

/*
 * C agent interface stubs for BRIDGE-MIB::dot1dStpPortEntry.
 */

extern int
bridge_mib_agt_read_dot1dStpPortEntry(dot1dStpPortEntry_t *dot1dStpPortEntry);
extern int
bridge_mib_agt_register_dot1dStpPortEntry();

/*
 * C type definitions for BRIDGE-MIB::dot1dTp.
 */

typedef struct dot1dTp {
    uint32_t  *dot1dTpLearnedEntryDiscards;
    int32_t   *dot1dTpAgingTime;
    void      *_clientData;		/* pointer to client data structure */

    /* private space to hold actual values */

    uint32_t  __dot1dTpLearnedEntryDiscards;
    int32_t   __dot1dTpAgingTime;
} dot1dTp_t;

/*
 * C manager interface stubs for BRIDGE-MIB::dot1dTp.
 */

extern int
bridge_mib_mgr_get_dot1dTp(struct snmp_session *s, dot1dTp_t **dot1dTp);

/*
 * C agent interface stubs for BRIDGE-MIB::dot1dTp.
 */

extern int
bridge_mib_agt_read_dot1dTp(dot1dTp_t *dot1dTp);
extern int
bridge_mib_agt_register_dot1dTp();

/*
 * C type definitions for BRIDGE-MIB::dot1dTpFdbEntry.
 */

typedef struct dot1dTpFdbEntry {
    u_char    *dot1dTpFdbAddress;
    int32_t   *dot1dTpFdbPort;
    int32_t   *dot1dTpFdbStatus;
    void      *_clientData;		/* pointer to client data structure */
    struct dot1dTpFdbEntry *_nextPtr;	/* pointer to next table entry */

    /* private space to hold actual values */

    u_char    __dot1dTpFdbAddress[6];
    int32_t   __dot1dTpFdbPort;
    int32_t   __dot1dTpFdbStatus;
} dot1dTpFdbEntry_t;

/*
 * C manager interface stubs for BRIDGE-MIB::dot1dTpFdbEntry.
 */

extern int
bridge_mib_mgr_get_dot1dTpFdbEntry(struct snmp_session *s, dot1dTpFdbEntry_t **dot1dTpFdbEntry);

/*
 * C agent interface stubs for BRIDGE-MIB::dot1dTpFdbEntry.
 */

extern int
bridge_mib_agt_read_dot1dTpFdbEntry(dot1dTpFdbEntry_t *dot1dTpFdbEntry);
extern int
bridge_mib_agt_register_dot1dTpFdbEntry();

/*
 * C type definitions for BRIDGE-MIB::dot1dTpPortEntry.
 */

typedef struct dot1dTpPortEntry {
    int32_t   *dot1dTpPort;
    int32_t   *dot1dTpPortMaxInfo;
    uint32_t  *dot1dTpPortInFrames;
    uint32_t  *dot1dTpPortOutFrames;
    uint32_t  *dot1dTpPortInDiscards;
    void      *_clientData;		/* pointer to client data structure */
    struct dot1dTpPortEntry *_nextPtr;	/* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dot1dTpPort;
    int32_t   __dot1dTpPortMaxInfo;
    uint32_t  __dot1dTpPortInFrames;
    uint32_t  __dot1dTpPortOutFrames;
    uint32_t  __dot1dTpPortInDiscards;
} dot1dTpPortEntry_t;

/*
 * C manager interface stubs for BRIDGE-MIB::dot1dTpPortEntry.
 */

extern int
bridge_mib_mgr_get_dot1dTpPortEntry(struct snmp_session *s, dot1dTpPortEntry_t **dot1dTpPortEntry);

/*
 * C agent interface stubs for BRIDGE-MIB::dot1dTpPortEntry.
 */

extern int
bridge_mib_agt_read_dot1dTpPortEntry(dot1dTpPortEntry_t *dot1dTpPortEntry);
extern int
bridge_mib_agt_register_dot1dTpPortEntry();

/*
 * C type definitions for BRIDGE-MIB::dot1dStaticEntry.
 */

typedef struct dot1dStaticEntry {
    u_char    *dot1dStaticAddress;
    int32_t   *dot1dStaticReceivePort;
    u_char    *dot1dStaticAllowedToGoTo;
    size_t    _dot1dStaticAllowedToGoToLength;
    int32_t   *dot1dStaticStatus;
    void      *_clientData;		/* pointer to client data structure */
    struct dot1dStaticEntry *_nextPtr;	/* pointer to next table entry */

    /* private space to hold actual values */

    u_char    __dot1dStaticAddress[6];
    int32_t   __dot1dStaticReceivePort;
    u_char    __dot1dStaticAllowedToGoTo[512];
    int32_t   __dot1dStaticStatus;
} dot1dStaticEntry_t;

/*
 * C manager interface stubs for BRIDGE-MIB::dot1dStaticEntry.
 */

extern int
bridge_mib_mgr_get_dot1dStaticEntry(struct snmp_session *s, dot1dStaticEntry_t **dot1dStaticEntry);

/*
 * C agent interface stubs for BRIDGE-MIB::dot1dStaticEntry.
 */

extern int
bridge_mib_agt_read_dot1dStaticEntry(dot1dStaticEntry_t *dot1dStaticEntry);
extern int
bridge_mib_agt_register_dot1dStaticEntry();


typedef struct bridge_mib {
    dot1dBase_t	dot1dBase;
    dot1dBasePortEntry_t	*dot1dBasePortEntry;
    dot1dStp_t	dot1dStp;
    dot1dStpPortEntry_t	*dot1dStpPortEntry;
    dot1dTp_t	dot1dTp;
    dot1dTpFdbEntry_t	*dot1dTpFdbEntry;
    dot1dTpPortEntry_t	*dot1dTpPortEntry;
    dot1dStaticEntry_t	*dot1dStaticEntry;
} bridge_mib_t;

/*
 * Initialization function:
 */

void bridge_mib_agt_init(void);

#endif /* _BRIDGE_MIB_H_ */
