/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// Configure struct for Configure
type Configure struct {
	// Access ID
	AccessId *string `json:"access-id,omitempty"`
	// Access Key
	AccessKey *string `json:"access-key,omitempty"`
	// Access Type (access_key/password/azure_ad/saml/oidc/aws_iam/gcp/k8s/cert)
	AccessType *string `json:"access-type,omitempty"`
	// Account id (relevant only for access-type=password where the email address is associated with more than one account)
	AccountId *string `json:"account-id,omitempty"`
	// Email (relevant only for access-type=password)
	AdminEmail *string `json:"admin-email,omitempty"`
	// Password (relevant only for access-type=password)
	AdminPassword *string `json:"admin-password,omitempty"`
	// Azure Active Directory ObjectId (relevant only for access-type=azure_ad)
	AzureAdObjectId *string `json:"azure_ad_object_id,omitempty"`
	// Certificate data encoded in base64. Used if file was not provided. (relevant only for access-type=cert in Curl Context)
	CertData *string `json:"cert-data,omitempty"`
	// Certificate Issuer Name
	CertIssuerName *string `json:"cert-issuer-name,omitempty"`
	// The username to sign in the SSH certificate (use a comma-separated list for more than one username)
	CertUsername *string `json:"cert-username,omitempty"`
	// Default path prefix for name of items, targets and auth methods
	DefaultLocationPrefix *string `json:"default-location-prefix,omitempty"`
	// Disable the FAST negotiation in the Kerberos authentication method
	DisablePafxfast *string `json:"disable-pafxfast,omitempty"`
	// The service principal name of the gateway as registered in LDAP (i.e., HTTP/gateway)
	GatewaySpn *string `json:"gateway-spn,omitempty"`
	// GCP JWT audience
	GcpAudience *string `json:"gcp-audience,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The K8S Auth config name (relevant only for access-type=k8s)
	K8sAuthConfigName *string `json:"k8s-auth-config-name,omitempty"`
	// TThe username for the entry within the keytab to authenticate via Kerberos
	KerberosUsername *string `json:"kerberos-username,omitempty"`
	// Private key data encoded in base64. Used if file was not provided.(relevant only for access-type=cert in Curl Context)
	KeyData *string `json:"key-data,omitempty"`
	// Base64-encoded content of a valid keytab file, containing the service account's entry.
	KeytabData *string `json:"keytab-data,omitempty"`
	// Base64-encoded content of a valid krb5.conf file, specifying the settings and parameters required for Kerberos authentication.
	Krb5ConfData *string `json:"krb5-conf-data,omitempty"`
	// Set this option to output legacy ('ssh-rsa-cert-v01@openssh.com') signing algorithm name in the certificate.
	LegacySigningAlgName *bool `json:"legacy-signing-alg-name,omitempty"`
	// The type of the OCI configuration to use [instance/apikey/resource] (relevant only for access-type=oci)
	OciAuthType *string `json:"oci-auth-type,omitempty"`
	// A list of Oracle Cloud IDs groups (relevant only for access-type=oci)
	OciGroupOcid *[]string `json:"oci-group-ocid,omitempty"`
}

// NewConfigure instantiates a new Configure object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewConfigure() *Configure {
	this := Configure{}
	var accessType string = "access_key"
	this.AccessType = &accessType
	var gcpAudience string = "akeyless.io"
	this.GcpAudience = &gcpAudience
	var json bool = false
	this.Json = &json
	var ociAuthType string = "apikey"
	this.OciAuthType = &ociAuthType
	return &this
}

// NewConfigureWithDefaults instantiates a new Configure object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewConfigureWithDefaults() *Configure {
	this := Configure{}
	var accessType string = "access_key"
	this.AccessType = &accessType
	var gcpAudience string = "akeyless.io"
	this.GcpAudience = &gcpAudience
	var json bool = false
	this.Json = &json
	var ociAuthType string = "apikey"
	this.OciAuthType = &ociAuthType
	return &this
}

// GetAccessId returns the AccessId field value if set, zero value otherwise.
func (o *Configure) GetAccessId() string {
	if o == nil || o.AccessId == nil {
		var ret string
		return ret
	}
	return *o.AccessId
}

// GetAccessIdOk returns a tuple with the AccessId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetAccessIdOk() (*string, bool) {
	if o == nil || o.AccessId == nil {
		return nil, false
	}
	return o.AccessId, true
}

// HasAccessId returns a boolean if a field has been set.
func (o *Configure) HasAccessId() bool {
	if o != nil && o.AccessId != nil {
		return true
	}

	return false
}

// SetAccessId gets a reference to the given string and assigns it to the AccessId field.
func (o *Configure) SetAccessId(v string) {
	o.AccessId = &v
}

// GetAccessKey returns the AccessKey field value if set, zero value otherwise.
func (o *Configure) GetAccessKey() string {
	if o == nil || o.AccessKey == nil {
		var ret string
		return ret
	}
	return *o.AccessKey
}

// GetAccessKeyOk returns a tuple with the AccessKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetAccessKeyOk() (*string, bool) {
	if o == nil || o.AccessKey == nil {
		return nil, false
	}
	return o.AccessKey, true
}

// HasAccessKey returns a boolean if a field has been set.
func (o *Configure) HasAccessKey() bool {
	if o != nil && o.AccessKey != nil {
		return true
	}

	return false
}

// SetAccessKey gets a reference to the given string and assigns it to the AccessKey field.
func (o *Configure) SetAccessKey(v string) {
	o.AccessKey = &v
}

// GetAccessType returns the AccessType field value if set, zero value otherwise.
func (o *Configure) GetAccessType() string {
	if o == nil || o.AccessType == nil {
		var ret string
		return ret
	}
	return *o.AccessType
}

// GetAccessTypeOk returns a tuple with the AccessType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetAccessTypeOk() (*string, bool) {
	if o == nil || o.AccessType == nil {
		return nil, false
	}
	return o.AccessType, true
}

// HasAccessType returns a boolean if a field has been set.
func (o *Configure) HasAccessType() bool {
	if o != nil && o.AccessType != nil {
		return true
	}

	return false
}

// SetAccessType gets a reference to the given string and assigns it to the AccessType field.
func (o *Configure) SetAccessType(v string) {
	o.AccessType = &v
}

// GetAccountId returns the AccountId field value if set, zero value otherwise.
func (o *Configure) GetAccountId() string {
	if o == nil || o.AccountId == nil {
		var ret string
		return ret
	}
	return *o.AccountId
}

// GetAccountIdOk returns a tuple with the AccountId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetAccountIdOk() (*string, bool) {
	if o == nil || o.AccountId == nil {
		return nil, false
	}
	return o.AccountId, true
}

// HasAccountId returns a boolean if a field has been set.
func (o *Configure) HasAccountId() bool {
	if o != nil && o.AccountId != nil {
		return true
	}

	return false
}

// SetAccountId gets a reference to the given string and assigns it to the AccountId field.
func (o *Configure) SetAccountId(v string) {
	o.AccountId = &v
}

// GetAdminEmail returns the AdminEmail field value if set, zero value otherwise.
func (o *Configure) GetAdminEmail() string {
	if o == nil || o.AdminEmail == nil {
		var ret string
		return ret
	}
	return *o.AdminEmail
}

// GetAdminEmailOk returns a tuple with the AdminEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetAdminEmailOk() (*string, bool) {
	if o == nil || o.AdminEmail == nil {
		return nil, false
	}
	return o.AdminEmail, true
}

// HasAdminEmail returns a boolean if a field has been set.
func (o *Configure) HasAdminEmail() bool {
	if o != nil && o.AdminEmail != nil {
		return true
	}

	return false
}

// SetAdminEmail gets a reference to the given string and assigns it to the AdminEmail field.
func (o *Configure) SetAdminEmail(v string) {
	o.AdminEmail = &v
}

// GetAdminPassword returns the AdminPassword field value if set, zero value otherwise.
func (o *Configure) GetAdminPassword() string {
	if o == nil || o.AdminPassword == nil {
		var ret string
		return ret
	}
	return *o.AdminPassword
}

// GetAdminPasswordOk returns a tuple with the AdminPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetAdminPasswordOk() (*string, bool) {
	if o == nil || o.AdminPassword == nil {
		return nil, false
	}
	return o.AdminPassword, true
}

// HasAdminPassword returns a boolean if a field has been set.
func (o *Configure) HasAdminPassword() bool {
	if o != nil && o.AdminPassword != nil {
		return true
	}

	return false
}

// SetAdminPassword gets a reference to the given string and assigns it to the AdminPassword field.
func (o *Configure) SetAdminPassword(v string) {
	o.AdminPassword = &v
}

// GetAzureAdObjectId returns the AzureAdObjectId field value if set, zero value otherwise.
func (o *Configure) GetAzureAdObjectId() string {
	if o == nil || o.AzureAdObjectId == nil {
		var ret string
		return ret
	}
	return *o.AzureAdObjectId
}

// GetAzureAdObjectIdOk returns a tuple with the AzureAdObjectId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetAzureAdObjectIdOk() (*string, bool) {
	if o == nil || o.AzureAdObjectId == nil {
		return nil, false
	}
	return o.AzureAdObjectId, true
}

// HasAzureAdObjectId returns a boolean if a field has been set.
func (o *Configure) HasAzureAdObjectId() bool {
	if o != nil && o.AzureAdObjectId != nil {
		return true
	}

	return false
}

// SetAzureAdObjectId gets a reference to the given string and assigns it to the AzureAdObjectId field.
func (o *Configure) SetAzureAdObjectId(v string) {
	o.AzureAdObjectId = &v
}

// GetCertData returns the CertData field value if set, zero value otherwise.
func (o *Configure) GetCertData() string {
	if o == nil || o.CertData == nil {
		var ret string
		return ret
	}
	return *o.CertData
}

// GetCertDataOk returns a tuple with the CertData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetCertDataOk() (*string, bool) {
	if o == nil || o.CertData == nil {
		return nil, false
	}
	return o.CertData, true
}

// HasCertData returns a boolean if a field has been set.
func (o *Configure) HasCertData() bool {
	if o != nil && o.CertData != nil {
		return true
	}

	return false
}

// SetCertData gets a reference to the given string and assigns it to the CertData field.
func (o *Configure) SetCertData(v string) {
	o.CertData = &v
}

// GetCertIssuerName returns the CertIssuerName field value if set, zero value otherwise.
func (o *Configure) GetCertIssuerName() string {
	if o == nil || o.CertIssuerName == nil {
		var ret string
		return ret
	}
	return *o.CertIssuerName
}

// GetCertIssuerNameOk returns a tuple with the CertIssuerName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetCertIssuerNameOk() (*string, bool) {
	if o == nil || o.CertIssuerName == nil {
		return nil, false
	}
	return o.CertIssuerName, true
}

// HasCertIssuerName returns a boolean if a field has been set.
func (o *Configure) HasCertIssuerName() bool {
	if o != nil && o.CertIssuerName != nil {
		return true
	}

	return false
}

// SetCertIssuerName gets a reference to the given string and assigns it to the CertIssuerName field.
func (o *Configure) SetCertIssuerName(v string) {
	o.CertIssuerName = &v
}

// GetCertUsername returns the CertUsername field value if set, zero value otherwise.
func (o *Configure) GetCertUsername() string {
	if o == nil || o.CertUsername == nil {
		var ret string
		return ret
	}
	return *o.CertUsername
}

// GetCertUsernameOk returns a tuple with the CertUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetCertUsernameOk() (*string, bool) {
	if o == nil || o.CertUsername == nil {
		return nil, false
	}
	return o.CertUsername, true
}

// HasCertUsername returns a boolean if a field has been set.
func (o *Configure) HasCertUsername() bool {
	if o != nil && o.CertUsername != nil {
		return true
	}

	return false
}

// SetCertUsername gets a reference to the given string and assigns it to the CertUsername field.
func (o *Configure) SetCertUsername(v string) {
	o.CertUsername = &v
}

// GetDefaultLocationPrefix returns the DefaultLocationPrefix field value if set, zero value otherwise.
func (o *Configure) GetDefaultLocationPrefix() string {
	if o == nil || o.DefaultLocationPrefix == nil {
		var ret string
		return ret
	}
	return *o.DefaultLocationPrefix
}

// GetDefaultLocationPrefixOk returns a tuple with the DefaultLocationPrefix field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetDefaultLocationPrefixOk() (*string, bool) {
	if o == nil || o.DefaultLocationPrefix == nil {
		return nil, false
	}
	return o.DefaultLocationPrefix, true
}

// HasDefaultLocationPrefix returns a boolean if a field has been set.
func (o *Configure) HasDefaultLocationPrefix() bool {
	if o != nil && o.DefaultLocationPrefix != nil {
		return true
	}

	return false
}

// SetDefaultLocationPrefix gets a reference to the given string and assigns it to the DefaultLocationPrefix field.
func (o *Configure) SetDefaultLocationPrefix(v string) {
	o.DefaultLocationPrefix = &v
}

// GetDisablePafxfast returns the DisablePafxfast field value if set, zero value otherwise.
func (o *Configure) GetDisablePafxfast() string {
	if o == nil || o.DisablePafxfast == nil {
		var ret string
		return ret
	}
	return *o.DisablePafxfast
}

// GetDisablePafxfastOk returns a tuple with the DisablePafxfast field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetDisablePafxfastOk() (*string, bool) {
	if o == nil || o.DisablePafxfast == nil {
		return nil, false
	}
	return o.DisablePafxfast, true
}

// HasDisablePafxfast returns a boolean if a field has been set.
func (o *Configure) HasDisablePafxfast() bool {
	if o != nil && o.DisablePafxfast != nil {
		return true
	}

	return false
}

// SetDisablePafxfast gets a reference to the given string and assigns it to the DisablePafxfast field.
func (o *Configure) SetDisablePafxfast(v string) {
	o.DisablePafxfast = &v
}

// GetGatewaySpn returns the GatewaySpn field value if set, zero value otherwise.
func (o *Configure) GetGatewaySpn() string {
	if o == nil || o.GatewaySpn == nil {
		var ret string
		return ret
	}
	return *o.GatewaySpn
}

// GetGatewaySpnOk returns a tuple with the GatewaySpn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetGatewaySpnOk() (*string, bool) {
	if o == nil || o.GatewaySpn == nil {
		return nil, false
	}
	return o.GatewaySpn, true
}

// HasGatewaySpn returns a boolean if a field has been set.
func (o *Configure) HasGatewaySpn() bool {
	if o != nil && o.GatewaySpn != nil {
		return true
	}

	return false
}

// SetGatewaySpn gets a reference to the given string and assigns it to the GatewaySpn field.
func (o *Configure) SetGatewaySpn(v string) {
	o.GatewaySpn = &v
}

// GetGcpAudience returns the GcpAudience field value if set, zero value otherwise.
func (o *Configure) GetGcpAudience() string {
	if o == nil || o.GcpAudience == nil {
		var ret string
		return ret
	}
	return *o.GcpAudience
}

// GetGcpAudienceOk returns a tuple with the GcpAudience field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetGcpAudienceOk() (*string, bool) {
	if o == nil || o.GcpAudience == nil {
		return nil, false
	}
	return o.GcpAudience, true
}

// HasGcpAudience returns a boolean if a field has been set.
func (o *Configure) HasGcpAudience() bool {
	if o != nil && o.GcpAudience != nil {
		return true
	}

	return false
}

// SetGcpAudience gets a reference to the given string and assigns it to the GcpAudience field.
func (o *Configure) SetGcpAudience(v string) {
	o.GcpAudience = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *Configure) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *Configure) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *Configure) SetJson(v bool) {
	o.Json = &v
}

// GetK8sAuthConfigName returns the K8sAuthConfigName field value if set, zero value otherwise.
func (o *Configure) GetK8sAuthConfigName() string {
	if o == nil || o.K8sAuthConfigName == nil {
		var ret string
		return ret
	}
	return *o.K8sAuthConfigName
}

// GetK8sAuthConfigNameOk returns a tuple with the K8sAuthConfigName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetK8sAuthConfigNameOk() (*string, bool) {
	if o == nil || o.K8sAuthConfigName == nil {
		return nil, false
	}
	return o.K8sAuthConfigName, true
}

// HasK8sAuthConfigName returns a boolean if a field has been set.
func (o *Configure) HasK8sAuthConfigName() bool {
	if o != nil && o.K8sAuthConfigName != nil {
		return true
	}

	return false
}

// SetK8sAuthConfigName gets a reference to the given string and assigns it to the K8sAuthConfigName field.
func (o *Configure) SetK8sAuthConfigName(v string) {
	o.K8sAuthConfigName = &v
}

// GetKerberosUsername returns the KerberosUsername field value if set, zero value otherwise.
func (o *Configure) GetKerberosUsername() string {
	if o == nil || o.KerberosUsername == nil {
		var ret string
		return ret
	}
	return *o.KerberosUsername
}

// GetKerberosUsernameOk returns a tuple with the KerberosUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetKerberosUsernameOk() (*string, bool) {
	if o == nil || o.KerberosUsername == nil {
		return nil, false
	}
	return o.KerberosUsername, true
}

// HasKerberosUsername returns a boolean if a field has been set.
func (o *Configure) HasKerberosUsername() bool {
	if o != nil && o.KerberosUsername != nil {
		return true
	}

	return false
}

// SetKerberosUsername gets a reference to the given string and assigns it to the KerberosUsername field.
func (o *Configure) SetKerberosUsername(v string) {
	o.KerberosUsername = &v
}

// GetKeyData returns the KeyData field value if set, zero value otherwise.
func (o *Configure) GetKeyData() string {
	if o == nil || o.KeyData == nil {
		var ret string
		return ret
	}
	return *o.KeyData
}

// GetKeyDataOk returns a tuple with the KeyData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetKeyDataOk() (*string, bool) {
	if o == nil || o.KeyData == nil {
		return nil, false
	}
	return o.KeyData, true
}

// HasKeyData returns a boolean if a field has been set.
func (o *Configure) HasKeyData() bool {
	if o != nil && o.KeyData != nil {
		return true
	}

	return false
}

// SetKeyData gets a reference to the given string and assigns it to the KeyData field.
func (o *Configure) SetKeyData(v string) {
	o.KeyData = &v
}

// GetKeytabData returns the KeytabData field value if set, zero value otherwise.
func (o *Configure) GetKeytabData() string {
	if o == nil || o.KeytabData == nil {
		var ret string
		return ret
	}
	return *o.KeytabData
}

// GetKeytabDataOk returns a tuple with the KeytabData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetKeytabDataOk() (*string, bool) {
	if o == nil || o.KeytabData == nil {
		return nil, false
	}
	return o.KeytabData, true
}

// HasKeytabData returns a boolean if a field has been set.
func (o *Configure) HasKeytabData() bool {
	if o != nil && o.KeytabData != nil {
		return true
	}

	return false
}

// SetKeytabData gets a reference to the given string and assigns it to the KeytabData field.
func (o *Configure) SetKeytabData(v string) {
	o.KeytabData = &v
}

// GetKrb5ConfData returns the Krb5ConfData field value if set, zero value otherwise.
func (o *Configure) GetKrb5ConfData() string {
	if o == nil || o.Krb5ConfData == nil {
		var ret string
		return ret
	}
	return *o.Krb5ConfData
}

// GetKrb5ConfDataOk returns a tuple with the Krb5ConfData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetKrb5ConfDataOk() (*string, bool) {
	if o == nil || o.Krb5ConfData == nil {
		return nil, false
	}
	return o.Krb5ConfData, true
}

// HasKrb5ConfData returns a boolean if a field has been set.
func (o *Configure) HasKrb5ConfData() bool {
	if o != nil && o.Krb5ConfData != nil {
		return true
	}

	return false
}

// SetKrb5ConfData gets a reference to the given string and assigns it to the Krb5ConfData field.
func (o *Configure) SetKrb5ConfData(v string) {
	o.Krb5ConfData = &v
}

// GetLegacySigningAlgName returns the LegacySigningAlgName field value if set, zero value otherwise.
func (o *Configure) GetLegacySigningAlgName() bool {
	if o == nil || o.LegacySigningAlgName == nil {
		var ret bool
		return ret
	}
	return *o.LegacySigningAlgName
}

// GetLegacySigningAlgNameOk returns a tuple with the LegacySigningAlgName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetLegacySigningAlgNameOk() (*bool, bool) {
	if o == nil || o.LegacySigningAlgName == nil {
		return nil, false
	}
	return o.LegacySigningAlgName, true
}

// HasLegacySigningAlgName returns a boolean if a field has been set.
func (o *Configure) HasLegacySigningAlgName() bool {
	if o != nil && o.LegacySigningAlgName != nil {
		return true
	}

	return false
}

// SetLegacySigningAlgName gets a reference to the given bool and assigns it to the LegacySigningAlgName field.
func (o *Configure) SetLegacySigningAlgName(v bool) {
	o.LegacySigningAlgName = &v
}

// GetOciAuthType returns the OciAuthType field value if set, zero value otherwise.
func (o *Configure) GetOciAuthType() string {
	if o == nil || o.OciAuthType == nil {
		var ret string
		return ret
	}
	return *o.OciAuthType
}

// GetOciAuthTypeOk returns a tuple with the OciAuthType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetOciAuthTypeOk() (*string, bool) {
	if o == nil || o.OciAuthType == nil {
		return nil, false
	}
	return o.OciAuthType, true
}

// HasOciAuthType returns a boolean if a field has been set.
func (o *Configure) HasOciAuthType() bool {
	if o != nil && o.OciAuthType != nil {
		return true
	}

	return false
}

// SetOciAuthType gets a reference to the given string and assigns it to the OciAuthType field.
func (o *Configure) SetOciAuthType(v string) {
	o.OciAuthType = &v
}

// GetOciGroupOcid returns the OciGroupOcid field value if set, zero value otherwise.
func (o *Configure) GetOciGroupOcid() []string {
	if o == nil || o.OciGroupOcid == nil {
		var ret []string
		return ret
	}
	return *o.OciGroupOcid
}

// GetOciGroupOcidOk returns a tuple with the OciGroupOcid field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Configure) GetOciGroupOcidOk() (*[]string, bool) {
	if o == nil || o.OciGroupOcid == nil {
		return nil, false
	}
	return o.OciGroupOcid, true
}

// HasOciGroupOcid returns a boolean if a field has been set.
func (o *Configure) HasOciGroupOcid() bool {
	if o != nil && o.OciGroupOcid != nil {
		return true
	}

	return false
}

// SetOciGroupOcid gets a reference to the given []string and assigns it to the OciGroupOcid field.
func (o *Configure) SetOciGroupOcid(v []string) {
	o.OciGroupOcid = &v
}

func (o Configure) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessId != nil {
		toSerialize["access-id"] = o.AccessId
	}
	if o.AccessKey != nil {
		toSerialize["access-key"] = o.AccessKey
	}
	if o.AccessType != nil {
		toSerialize["access-type"] = o.AccessType
	}
	if o.AccountId != nil {
		toSerialize["account-id"] = o.AccountId
	}
	if o.AdminEmail != nil {
		toSerialize["admin-email"] = o.AdminEmail
	}
	if o.AdminPassword != nil {
		toSerialize["admin-password"] = o.AdminPassword
	}
	if o.AzureAdObjectId != nil {
		toSerialize["azure_ad_object_id"] = o.AzureAdObjectId
	}
	if o.CertData != nil {
		toSerialize["cert-data"] = o.CertData
	}
	if o.CertIssuerName != nil {
		toSerialize["cert-issuer-name"] = o.CertIssuerName
	}
	if o.CertUsername != nil {
		toSerialize["cert-username"] = o.CertUsername
	}
	if o.DefaultLocationPrefix != nil {
		toSerialize["default-location-prefix"] = o.DefaultLocationPrefix
	}
	if o.DisablePafxfast != nil {
		toSerialize["disable-pafxfast"] = o.DisablePafxfast
	}
	if o.GatewaySpn != nil {
		toSerialize["gateway-spn"] = o.GatewaySpn
	}
	if o.GcpAudience != nil {
		toSerialize["gcp-audience"] = o.GcpAudience
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.K8sAuthConfigName != nil {
		toSerialize["k8s-auth-config-name"] = o.K8sAuthConfigName
	}
	if o.KerberosUsername != nil {
		toSerialize["kerberos-username"] = o.KerberosUsername
	}
	if o.KeyData != nil {
		toSerialize["key-data"] = o.KeyData
	}
	if o.KeytabData != nil {
		toSerialize["keytab-data"] = o.KeytabData
	}
	if o.Krb5ConfData != nil {
		toSerialize["krb5-conf-data"] = o.Krb5ConfData
	}
	if o.LegacySigningAlgName != nil {
		toSerialize["legacy-signing-alg-name"] = o.LegacySigningAlgName
	}
	if o.OciAuthType != nil {
		toSerialize["oci-auth-type"] = o.OciAuthType
	}
	if o.OciGroupOcid != nil {
		toSerialize["oci-group-ocid"] = o.OciGroupOcid
	}
	return json.Marshal(toSerialize)
}

type NullableConfigure struct {
	value *Configure
	isSet bool
}

func (v NullableConfigure) Get() *Configure {
	return v.value
}

func (v *NullableConfigure) Set(val *Configure) {
	v.value = val
	v.isSet = true
}

func (v NullableConfigure) IsSet() bool {
	return v.isSet
}

func (v *NullableConfigure) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableConfigure(val *Configure) *NullableConfigure {
	return &NullableConfigure{value: val, isSet: true}
}

func (v NullableConfigure) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableConfigure) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


