-- handle the mind school
--blind/paralysis? wouldn't probably make noticable diff from conf/sleep!
--((static: res insanity/effects))

function get_psiblast_dam(Ind, limit_lev)
	local lev, llev, lev2

	lev = get_level(Ind, MMINDBLAST_I, 45)
	--10% cut, since we scaled level from 1..45, not from 1..50:
	llev = (limit_lev * 9 + 1) / 10
	if limit_lev ~= 0 and lev > llev then lev = llev + (lev - llev) / 3 end

	lev2 = get_level(Ind, MMINDBLAST_I, 250)
	if limit_lev ~= 0 and lev2 > limit_lev * 5 then lev2 = limit_lev * 5 + (lev2 - limit_lev * 5) / 3 end

	return 2 + get_level(Ind, MMINDBLAST_I, 7), 3 + lev, lev2
end

function get_psistorm_dam(Ind, limit_lev)
	local lev = get_level(Ind, MPSISTORM_I, 200)

	if limit_lev ~= 0 and lev > limit_lev * 4 then lev = limit_lev * 4 + (lev - limit_lev * 4) / 2 end
	return 33 + lev
end

MSCARE_I = add_spell {
	["name"] = 	"Scare I",
	["name2"] = 	"Scare I",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	1,
	["mana"] = 	2,
	["mana_max"] = 	2,
	["fail"] = 	10,
	["direction"] = TRUE,
	["spell"] = 	function(args)
				fire_ball(Ind, GF_TURN_ALL, 0, 5 + get_level(Ind, MSCARE_I, 80), 1, "stares deep into your eyes")
			end,
	["info"] = 	function()
				return "power "..(5 + get_level(Ind, MSCARE_I, 80))
			end,
	["desc"] = 	{ "Tries to manipulate the mind of adjacent monsters to scare them.", }
}
__lua_MSCARE = MSCARE_I
MSCARE_II = add_spell {
	["name"] = 	"Scare II",
	["name2"] = 	"Scare II",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	10,
	["mana"] = 	10,
	["mana_max"] = 	10,
	["fail"] = 	-20,
	["direction"] = FALSE,
	["spell"] = 	function()
			project_los(Ind, GF_TURN_ALL, 5 + get_level(Ind, MSCARE_I, 80), "stares deep into your eyes")
			end,
	["info"] = 	function()
				return "power "..(5 + get_level(Ind, MSCARE_I, 80))
			end,
	["desc"] = 	{ "Tries to manipulate the minds of all monster in sight to scare them.", }
}

MCONFUSE_I = add_spell {
	["name"] = 	"Confuse I",
	["name2"] = 	"Conf I",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	3,
	["mana"] = 	4,
	["mana_max"] = 	4,
	["fail"] = 	10,
	["direction"] = TRUE,
	["spell"] = 	function(args)
				fire_grid_bolt(Ind, GF_OLD_CONF, args.dir, 5 + get_level(Ind, MCONFUSE_I, 100), "focusses on your mind")
			end,
	["info"] = 	function()
				return "power "..(5 + get_level(Ind, MCONFUSE_I, 100))
			end,
	["desc"] = 	{ "Tries to manipulate the mind of a monster to confuse it.", }
}
MCONFUSE_II = add_spell {
	["name"] = 	"Confuse II",
	["name2"] = 	"Conf II",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	14,
	["mana"] = 	14,
	["mana_max"] = 	14,
	["fail"] = 	-20,
	["direction"] = FALSE,
	["spell"] = 	function()
				project_los(Ind, GF_OLD_CONF, 5 + get_level(Ind, MCONFUSE_I, 100), "focusses on your mind")
			end,
	["info"] = 	function()
				return "power "..(5 + get_level(Ind, MCONFUSE_I, 100))
			end,
	["desc"] = 	{ "Tries to manipulate the minds of all monsters in sight to confuse them.", }
}

MSLEEP_I = add_spell {
	["name"] = 	"Hypnosis I",
	["name2"] = 	"Hyp I",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	33,
	["spell_power"] = 0,
	["level"] = 	5,
	["mana"] = 	4,
	["mana_max"] = 	4,
	["fail"] = 	10,
	["direction"] = TRUE,
	["spell"] = 	function(args)
				fire_grid_bolt(Ind, GF_OLD_SLEEP, args.dir, 5 + get_level(Ind, MSLEEP_I, 80), "mumbles softly")
			end,
	["info"] = 	function()
				return "power "..(5 + get_level(Ind, MSLEEP_I, 80))
			end,
	["desc"] = 	{ "Causes the target to fall asleep instantly.", }
}
MSLEEP_II = add_spell {
	["name"] = 	"Hypnosis II",
	["name2"] = 	"Hyp II",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	33,
	["spell_power"] = 0,
	["level"] = 	18,
	["mana"] = 	15,
	["mana_max"] = 	15,
	["fail"] = 	-20,
	["direction"] = FALSE,
	["spell"] = 	function()
				project_los(Ind, GF_OLD_SLEEP, 5 + get_level(Ind, MSLEEP_I, 80), "mumbles softly")
			end,
	["info"] = 	function()
				return "power "..(5 + get_level(Ind, MSLEEP_I, 80))
			end,
	["desc"] = 	{ "Causes all monsters in sight to fall asleep instantly.", }
}

MSLOWMONSTER_I = add_spell {
	["name"] = 	"Apathy I",
	["name2"] = 	"Apa I",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	7,
	["mana"] = 	5,
	["mana_max"] = 	5,
	["fail"] = 	10,
	["direction"] = TRUE,
	["spell"] = 	function(args)
				fire_grid_bolt(Ind, GF_MIND_SLOW, args.dir, 5 + get_level(Ind, MSLOWMONSTER_I, 100), "weakens your will to act")
			end,
	["info"] = 	function()
				return "power "..(5 + get_level(Ind, MSLOWMONSTER_I, 100))
			end,
	["desc"] = 	{ "Makes an opponent falter, slowing it down.", }
}
MSLOWMONSTER_II = add_spell {
	["name"] = 	"Apathy II",
	["name2"] = 	"Apa II",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	22,
	["mana"] = 	20,
	["mana_max"] = 	20,
	["fail"] = 	-20,
	["direction"] = FALSE,
	["spell"] = 	function()
				project_los(Ind, GF_MIND_SLOW, 5 + get_level(Ind, MSLOWMONSTER_I, 100), "weakens your will to act")
			end,
	["info"] = 	function()
				return "power "..(5 + get_level(Ind, MSLOWMONSTER_I, 100))
			end,
	["desc"] = 	{ "Makes all opponents in sight falter, slowing them down.", }
}

MMINDBLAST_I = add_spell {
	["name"] = 	"Psionic Blast I",
	["name2"] = 	"PsiBlast I",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	1,
	["mana"] = 	2,
	["mana_max"] = 	2,
	["fail"] = 	10,
	["direction"] = TRUE,
	["ftk"] = 	2,
	["spell"] = 	function(args)
			local d, s, p

			d, s, p = get_psiblast_dam(Ind, 1)
			fire_grid_bolt(Ind, GF_PSI, args.dir, damroll(d, s) + p, "")
			end,
	["info"] = 	function()
			local d, s, p

			d, s, p = get_psiblast_dam(Ind, 1)
			return "power "..d.."d"..s.."+"..p
			end,
	["desc"] = 	{ "Blasts the target's mind with psionic energy.", }
}
MMINDBLAST_II = add_spell {
	["name"] = 	"Psionic Blast II",
	["name2"] = 	"PsiBlast II",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	20,
	["mana"] = 	6,
	["mana_max"] = 	6,
	["fail"] = 	-30,
	["direction"] = TRUE,
	["ftk"] = 	2,
	["spell"] = 	function(args)
			local d, s, p

			d, s, p = get_psiblast_dam(Ind, 20)
			fire_grid_bolt(Ind, GF_PSI, args.dir, damroll(d, s) + p, "")
			end,
	["info"] = 	function()
			local d, s, p

			d, s, p = get_psiblast_dam(Ind, 20)
			return "power "..d.."d"..s.."+"..p
			end,
	["desc"] = 	{ "Blasts the target's mind with psionic energy.", }
}
MMINDBLAST_III = add_spell {
	["name"] = 	"Psionic Blast III",
	["name2"] = 	"PsiBlast III",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	40,
	["mana"] = 	15,
	["mana_max"] = 	15,
	["fail"] = 	-95,
	["direction"] = TRUE,
	["ftk"] = 	2,
	["spell"] = 	function(args)
			local d, s, p

			d, s, p = get_psiblast_dam(Ind, 0)
			fire_grid_bolt(Ind, GF_PSI, args.dir, damroll(d, s) + p, "")
			end,
	["info"] = 	function()
			local d, s, p

			d, s, p = get_psiblast_dam(Ind, 0)
			return "power "..d.."d"..s.."+"..p
			end,
	["desc"] = 	{ "Blasts the target's mind with psionic energy.", }
}

MPSISTORM_I = add_spell {
	["name"] = 	"Psi Storm I",
	["name2"] = 	"PStorm I",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	18,
	["mana"] = 	20,
	["mana_max"] = 	20,
	["fail"] = 	5,
	["direction"] = TRUE,
	["spell"] = function(args)
		local d = get_psistorm_dam(Ind, 1)

		fire_cloud(Ind, GF_PSI, args.dir, d, 3 + get_level(Ind, MPSISTORM_I, 4), 6 + get_level(Ind, MPSISTORM_I, 4), 14, " releases a psi storm for")
	end,
	["info"] = function()
		local d = get_psistorm_dam(Ind, 1)

		return "dam "..d.." rad "..(3 + get_level(Ind, MPSISTORM_I, 4)).." dur "..(6 + get_level(Ind, MPSISTORM_I, 4))
	end,
	["desc"] = { "A psionic storm that damages and disturbs all minds within an area.", }
}
MPSISTORM_II = add_spell {
	["name"] = 	"Psi Storm II",
	["name2"] = 	"PStorm II",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	38,
	["mana"] = 	32,
	["mana_max"] = 	32,
	["fail"] = 	-90,
	["direction"] = TRUE,
	["spell"] = function(args)
		local d  = get_psistorm_dam(Ind, 0)

		fire_cloud(Ind, GF_PSI, args.dir, d, 3 + get_level(Ind, MPSISTORM_I, 4), 6 + get_level(Ind, MPSISTORM_I, 4), 14, " releases a psi storm for")
	end,
	["info"] = function()
		local d = get_psistorm_dam(Ind, 0)

		return "dam "..d.." rad "..(3 + get_level(Ind, MPSISTORM_I, 4)).." dur "..(6 + get_level(Ind, MPSISTORM_I, 4))
	end,
	["desc"] = { "A psionic storm that damages and disturbs all minds within an area.", }
}

MSILENCE = add_spell {
	["name"] = 	"Psychic Suppression",
	["name2"] = 	"Supp",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	10,
	["mana"] = 	50,
	["mana_max"] = 	50,
	["fail"] = 	10,
	["direction"] = TRUE,
	["spell"] = 	function(args)
			--using this hack to transport 2 parameters at once,
			--ok since we use a single-target spell and not a ball
			fire_grid_bolt(Ind, GF_SILENCE, args.dir, get_level(Ind, MSILENCE, 63) + ((4 + get_level(Ind, MSILENCE, 4)) * 100), "")
			end,
	["info"] = 	function()
			return "power "..(get_level(Ind, MSILENCE, 63)).." dur "..(4 + get_level(Ind, MSILENCE, 4))
			end,
	["desc"] = 	{ "Drains the target's psychic energy, impacting its ability to cast spells.", }
}

MMAP = add_spell {
	["name"] = 	"Remote Vision",
	["name2"] = 	"Vision",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	20,
	["mana"] = 	30,
	["mana_max"] = 	30,
	["fail"] = 	0,
	["direction"] = FALSE,
	["spell"] = 	function()
			local pow = get_level(Ind, MMAP)

			if pow > 15 then pow = 15 end
			mind_map_level(Ind, pow)
			end,
	["info"] = 	function()
			local pow = get_level(Ind, MMAP)

			if pow > 15 then pow = 15 end
			return "power "..pow
			end,
	["desc"] = 	{
			"Forcefully uses the vision of sentient life forms around.",
			"The effect will additionally be transferred to allied open minds on the same",
			"floor if your Attunement skill is at least 20.",
	}
}

-- Monsters will ignore you (and often your party members too ;)
MCHARM = add_spell {
	["name"] = 	"Charm I",
	["name2"] = 	"Charm I",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	33,
	["mana"] = 	6,
	["mana_max"] = 	6,
	["fail"] = 	-60,
	["stat"] = 	A_CHR,
	["direction"] = TRUE,
	["spell"] = 	function(args)
			fire_grid_bolt(Ind, GF_CHARMIGNORE, args.dir, 10 + get_level(Ind, MCHARM, 150), "focusses")
	end,
	["info"] = 	function()
			return "power "..(10 + get_level(Ind, MCHARM, 150)).." range 17" -- MAX_RANGE - 1
	end,
	["desc"] = 	{
			"Tries to manipulate the mind of a monster",
			" to make them ignore you at the cost of your mana.",
	}
}
MCHARM_II = add_spell {
	["name"] = 	"Charm II",
	["name2"] = 	"Charm II",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	39,
	["mana"] = 	8,
	["mana_max"] = 	8,
	["fail"] = 	-70,
	["stat"] = 	A_CHR,
	["direction"] = TRUE,
	["spell"] = 	function(args)
			fire_ball(Ind, GF_CHARMIGNORE, args.dir, 10 + get_level(Ind, MCHARM, 150), 3, "focusses")
	end,
	["info"] = 	function()
			return "power "..(10 + get_level(Ind, MCHARM, 150)).." range 17" -- MAX_RANGE - 1
	end,
	["desc"] = 	{
			"Tries to manipulate the mind of your target and others around it",
			" to make them ignore you at the cost of your mana.",
	}
}
MCHARM_III = add_spell {
	["name"] = 	"Charm III",
	["name2"] = 	"Charm III",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	50,
	["spell_power"] = 0,
	["level"] = 	45,
	["mana"] = 	10,
	["mana_max"] = 	10,
	["fail"] = 	-93,
	["stat"] = 	A_CHR,
	["direction"] = FALSE,
	["spell"] = 	function(args)
			project_los(Ind, GF_CHARMIGNORE, 10 + get_level(Ind, MCHARM, 150), "focusses")
	end,
	["info"] = 	function()
			return "power "..(10 + get_level(Ind, MCHARM, 150)).." range 17" -- MAX_RANGE - 1
	end,
	["desc"] = 	{
			"Tries to manipulate the mind of all monsters in sight",
			" to make them ignore you at the cost of your mana.",
	}
}

MSTOPCHARM = add_spell {
	["name"] = 	"Stop Charm",
	["name2"] = 	"SCharm",
	["school"] = 	{SCHOOL_MINTRUSION},
	["am"] = 	0,
	["spell_power"] = 0,
	["level"] = 	45,
	["mana"] = 	0,
	["mana_max"] = 	0,
	["fail"] = 	101,
	["direction"] = FALSE,
	["spell"] = 	function()
			do_mstopcharm(Ind)
	end,
	["info"] = 	function()
			return ""
	end,
	["desc"] = 	{ "Cancel charming of any monsters.", }
}
