// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The model must request a specific tool. For example, <code>{"tool" : {"name" : "Your tool name"}}</code>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Call a tool with the Converse API</a> in the Amazon Bedrock User Guide</p><note>
/// <p>This field is only supported by Anthropic Claude 3 models.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct SpecificToolChoice {
    /// <p>The name of the tool that the model must request.</p>
    pub name: ::std::string::String,
}
impl SpecificToolChoice {
    /// <p>The name of the tool that the model must request.</p>
    pub fn name(&self) -> &str {
        use std::ops::Deref;
        self.name.deref()
    }
}
impl SpecificToolChoice {
    /// Creates a new builder-style object to manufacture [`SpecificToolChoice`](crate::types::SpecificToolChoice).
    pub fn builder() -> crate::types::builders::SpecificToolChoiceBuilder {
        crate::types::builders::SpecificToolChoiceBuilder::default()
    }
}

/// A builder for [`SpecificToolChoice`](crate::types::SpecificToolChoice).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct SpecificToolChoiceBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
}
impl SpecificToolChoiceBuilder {
    /// <p>The name of the tool that the model must request.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the tool that the model must request.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the tool that the model must request.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// Consumes the builder and constructs a [`SpecificToolChoice`](crate::types::SpecificToolChoice).
    /// This method will fail if any of the following fields are not set:
    /// - [`name`](crate::types::builders::SpecificToolChoiceBuilder::name)
    pub fn build(self) -> ::std::result::Result<crate::types::SpecificToolChoice, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::SpecificToolChoice {
            name: self.name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "name",
                    "name was not specified but it is required when building SpecificToolChoice",
                )
            })?,
        })
    }
}
