/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.gcalc.calc.Package;
import net.gcalc.calc.PluginList;
import net.gcalc.calc.PluginListReader;
import net.gcalc.calc.PluginStarter;
import net.gcalc.calc.gui.BasicFrame;
import net.gcalc.calc.gui.DebugDialog;
import net.gcalc.calc.gui.HtmlDialog;
import net.gcalc.calc.gui.ShutdownDialog;
import net.gcalc.calc.gui.ShutdownWindowAdapter;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.main.AbstractPlugin;
import net.gcalc.calc.main.DuplicatePluginException;
import net.gcalc.calc.main.ExtensionFileFilter;

public class GCalc
extends BasicFrame
implements ActionListener,
TreeSelectionListener {
    public static final String TITLE = "GCalc 3.0 CR1";
    public static final String COPYRIGHT_NOTICE = "Copyright (C) Jiho Kim 2003-2006";
    public static final String ICON_IMAGE = "resources/gicon.png";
    public static final String PLUGIN_LIST = "pluginlist.xml";
    public static final String SPLASH_IMAGE = "resources/splash1.png";
    public static final String LICENSE_AGREEMENT = "resources/GPL.txt";
    public static final String CREDITS = "resources/Credits.txt";
    private static final boolean DEBUG = true;
    private JMenuItem about;
    private JMenuItem debug;
    private JMenuItem quit;
    private JMenuItem open;
    private JMenuItem load;
    private JMenu plugin;
    private JMenu help;
    private JMenuBar menubar;
    private JEditorPane jep;
    private PluginList pl;

    private void loadWindowIcon() {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            ImageIcon icon = new ImageIcon(cl.getResource(ICON_IMAGE));
            this.setIconImage(icon.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GCalc() {
        super(TITLE);
        AbstractPlugin.setParentFrame(this);
        this.loadWindowIcon();
        this.about = new JMenuItem("About GCalc 3...");
        this.debug = new JMenuItem("Debug Info...");
        this.load = new JMenuItem("Load Plugin...");
        this.open = new JMenuItem("Open Plugin...");
        this.quit = new JMenuItem("Quit...");
        this.menubar = new JMenuBar();
        this.plugin = new JMenu("GCalc");
        this.menubar.add(this.plugin);
        this.menubar.add(Box.createHorizontalGlue());
        this.help = new JMenu("Help");
        this.menubar.add(this.help);
        this.plugin.add(this.load);
        this.plugin.add(this.open);
        this.plugin.addSeparator();
        this.plugin.add(this.quit);
        this.help.add(this.about);
        this.help.add(this.debug);
        this.quit.addActionListener(this);
        this.about.addActionListener(this);
        this.load.addActionListener(this);
        this.open.addActionListener(this);
        this.debug.addActionListener(this);
        this.setJMenuBar(this.menubar);
        this.jep = new JEditorPane("text/html", "");
        JScrollPane sp = null;
        this.pl = new PluginList();
        this.pl.addTreeSelectionListener(this);
        sp = new JScrollPane(this.jep, 20, 30);
        JSplitPane splitPane = new JSplitPane(1, true, this.pl, sp);
        splitPane.setDividerSize(2);
        splitPane.setDividerLocation(0.5);
        sp.setPreferredSize(new Dimension(250, 200));
        this.pl.setPreferredSize(new Dimension(250, 200));
        this.jep.setEditable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", splitPane);
        this.pack();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        int W = 600;
        int H = 300;
        int x = bounds.width / 2 - W / 2;
        int y = bounds.height / 2 - H / 2;
        this.setBounds(x, y, W, H);
        this.setResizable(true);
        this.setVisible(true);
        this.enableOpen(false);
        DoomsdayClock dc = new DoomsdayClock(System.currentTimeMillis() + 300000L);
        dc.timer.start();
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            PluginStarter starter = new PluginStarter(args[0]);
            try {
                starter.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                SwingGUI.popupFatalError(e.toString(), 3);
            }
        } else {
            new GCalc();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.quit) {
            this.shutdown();
        } else if (src == this.load) {
            try {
                this.loadFile();
            }
            catch (DuplicatePluginException e2) {
                JOptionPane.showMessageDialog(this, "There were duplicated plugins.  Some plugins were not loaded.\n" + e2.getMessage(), "Duplicate plugins", 1);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, "Access to filesystem is denied.\n" + e1, "Cannot load plugins!", 0);
            }
        } else if (src == this.open) {
            this.pl.openSelectedPlugin();
        } else if (src == this.about) {
            new AboutGCalcDialog(this);
        } else if (src == this.debug) {
            new Thread(new DebugDialog(this)).start();
        }
    }

    private void setDescription(String s) {
        this.jep.setText(s);
        this.jep.setCaretPosition(0);
    }

    private void enableOpen(boolean b) {
        this.open.setEnabled(b);
    }

    public void shutdown() {
        System.exit(0);
        super.shutdown();
    }

    private void loadFile() throws Exception {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter("jar", ".jar file");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.loadJar(chooser.getSelectedFile());
        }
    }

    private void loadJar(File f) throws Exception {
        URLClassLoader cl = new URLClassLoader(new URL[]{f.toURL()});
        PluginListReader helper = new PluginListReader(cl);
        JarFile jarFile = new JarFile(f);
        Enumeration<JarEntry> e = jarFile.entries();
        DefaultMutableTreeNode top = null;
        while (e.hasMoreElements() && top == null) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            if (!name.equals(PLUGIN_LIST)) continue;
            InputStream is = jarFile.getInputStream(entry);
            top = helper.getTreeRoot(is);
            this.pl.graftBranch(top);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath tp = e.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        Object obj = node.getUserObject();
        if (obj instanceof AbstractPlugin) {
            AbstractPlugin dp = (AbstractPlugin)obj;
            this.setDescription(dp.getHTMLDescription());
            this.enableOpen(true);
        } else if (obj instanceof Package) {
            Package p = (Package)obj;
            String str = "<h1>" + p.getName() + "</h1><p>" + p.getDescription() + "</p></font>";
            this.setDescription(str);
            this.enableOpen(false);
        } else {
            this.setDescription("");
            this.enableOpen(false);
        }
    }

    private class DoomsdayClock
    implements ActionListener {
        Timer timer = new Timer(1000, this);
        long time = 0L;

        public DoomsdayClock(long end) {
            this.time = end;
        }

        public void actionPerformed(ActionEvent e) {
            if (System.currentTimeMillis() < this.time) {
                GCalc.this.setTitle(String.valueOf((this.time - System.currentTimeMillis()) / 1000L) + " " + GCalc.TITLE);
            } else {
                System.exit(20);
            }
        }
    }

    private class AboutGCalcDialog
    extends ShutdownDialog
    implements ActionListener {
        JButton licenseButton = null;
        JButton creditsButton = null;

        public AboutGCalcDialog(Frame f) {
            super(f, "About GCalc", true);
            ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource(GCalc.SPLASH_IMAGE));
            JLabel label = new JLabel(icon);
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            this.licenseButton = new JButton("Show License");
            box.add(this.licenseButton);
            this.creditsButton = new JButton("Credits");
            box.add(this.creditsButton);
            box.add(Box.createHorizontalGlue());
            JPanel jp = new JPanel(new BorderLayout());
            jp.add("Center", label);
            jp.add("South", box);
            this.getContentPane().add(jp);
            this.addWindowListener(new ShutdownWindowAdapter(this));
            label.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ AboutGCalcDialog this$1;
                {
                    this.this$1 = aboutGCalcDialog;
                }

                public void mouseClicked(MouseEvent e) {
                    this.this$1.shutdown();
                }
            });
            this.licenseButton.addActionListener(this);
            this.creditsButton.addActionListener(this);
            this.pack();
            this.center();
            this.setResizable(false);
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.licenseButton) {
                new HtmlDialog((Frame)this.getParent(), "License Agreement", GCalc.LICENSE_AGREEMENT);
            } else if (e.getSource() == this.creditsButton) {
                new HtmlDialog((Frame)this.getParent(), "Credits", GCalc.CREDITS);
            }
        }
    }
}

