/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.gcalc.calc.GCalc;

public class GCalcApplet
extends JApplet {
    String[] pluginList = new String[]{"net.gcalc.plugin.ScientificCalculatorPlugin", "net.gcalc.plugin.plane.CartesianGraphPlugin", "net.gcalc.proto.plugin.space.CartesianGraph3DPlugin", "net.gcalc.plugin.plane.InequalitiesPlugin", "net.gcalc.plugin.plane.PolarGraphPlugin", "net.gcalc.plugin.plane.ParametricGraphPlugin", "net.gcalc.plugin.plane.ImplicitFunctionPlugin", "net.humblestar.gcalcdemo.calculus.NumericalIntegrationPlugin", "net.gcalc.plugin.plane.DirectionFieldPlugin", "net.humblestar.gcalcdemo.calculus.FunctionGymnastics"};
    JButton[] button;
    JMenuItem quitMI;
    JMenuItem aboutMI;

    public void init() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("GCalc");
        this.aboutMI = new JMenuItem(new AboutAction());
        menu.add(this.aboutMI);
        this.quitMI = new JMenuItem(new QuitAction());
        menu.add(this.quitMI);
        menubar.add(menu);
        JList<String> list = new JList<String>(this.pluginList);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GCalc.main(new String[]{GCalcApplet.this.pluginList[e.getFirstIndex()]});
                }
            }
        });
        JLabel copyright = new JLabel("<html><center>Copyright 2006 Jiho Kim <br>http://gcalc.net</center></html>", 0);
        copyright.setFont(new Font("SansSerif", 0, 10));
        this.button = new JButton[this.pluginList.length];
        JPanel grid = new JPanel(new GridLayout(3, 4, 20, 20));
        this.button[0] = new MyButton("Scientific Calculator");
        grid.add(this.button[0]);
        this.button[1] = new MyButton("Function Graph");
        grid.add(this.button[1]);
        this.button[2] = new MyButton("3D Graph");
        grid.add(this.button[2]);
        this.button[3] = new MyButton("Bivariate Inequality");
        grid.add(this.button[3]);
        this.button[4] = new MyButton("Polar Graph");
        grid.add(this.button[4]);
        this.button[5] = new MyButton("Parametric Graph");
        grid.add(this.button[5]);
        this.button[6] = new MyButton("Implicit Function");
        grid.add(this.button[6]);
        this.button[7] = new MyButton("Numerical Integration");
        grid.add(this.button[7]);
        this.button[8] = new MyButton("Direction Field");
        grid.add(this.button[8]);
        this.button[9] = new MyButton("Function Gymnastics");
        grid.add(this.button[9]);
        grid.add(new JPanel());
        grid.add(copyright);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < GCalcApplet.this.button.length) {
                    if (GCalcApplet.this.button[i] == e.getSource()) {
                        GCalcApplet.this.start(i);
                    }
                    ++i;
                }
            }
        };
        int i = 0;
        while (i < this.button.length) {
            this.button[i].addActionListener(listener);
            ++i;
        }
        JPanel panel = new JPanel(new BorderLayout(20, 20));
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        panel.add((Component)grid, "Center");
        this.setContentPane(panel);
    }

    private void start(int n) {
        GCalc.main(new String[]{this.pluginList[n]});
    }

    private void quit() {
        System.exit(0);
    }

    class MyButton
    extends JButton {
        public MyButton(String s) {
            StringTokenizer st = new StringTokenizer(s);
            String html = "<html><center>";
            while (st.hasMoreTokens()) {
                html = String.valueOf(html) + st.nextToken();
                if (!st.hasMoreTokens()) continue;
                html = String.valueOf(html) + "<br>";
            }
            this.setText(html);
        }
    }

    class AboutAction
    extends AbstractAction {
        AboutAction() {
            super("About this program");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class QuitAction
    extends AbstractAction {
        QuitAction() {
            super("Quit");
        }

        public void actionPerformed(ActionEvent e) {
            GCalcApplet.this.quit();
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setPreferredSize(new Dimension(50, 50));
            String s = value.toString();
            int n = 10;
            while (n > 0) {
                n = s.indexOf(46) + 1;
                s = s.substring(n);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setOpaque(true);
            this.setText(s);
            return this;
        }
    }
}

