/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.gui.gradient;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.gcalc.calc.gui.BasicFrame;
import net.gcalc.calc.gui.gradient.CompoundGradient;
import net.gcalc.calc.gui.gradient.Marker;

public class GradientCanvas
extends JPanel {
    private CompoundGradient gradient;
    private int n = 13;

    public GradientCanvas(CompoundGradient g) {
        super(true);
        this.gradient = g;
        this.setPreferredSize(new Dimension(150, 20));
        CustomMouseAdapter cma = new CustomMouseAdapter();
        this.addMouseListener(cma);
        this.addMouseMotionListener(cma);
    }

    public GradientCanvas() {
        this(new CompoundGradient(Color.black, Color.white));
    }

    public CompoundGradient getGradient() {
        return this.gradient;
    }

    public void setMode(int mode) {
        this.gradient.setMode(mode);
    }

    public int getMode() {
        return this.gradient.getMode();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        double w = this.getWidth();
        int i = 0;
        while ((double)i < w) {
            g.setColor(this.gradient.getColor((double)i / (w - 1.0)));
            g.drawLine(i, 0, i, this.getHeight() - this.n);
            ++i;
        }
        Marker[] markers = this.gradient.getMarkers();
        int[] x = new int[3];
        int[] y = new int[3];
        int i2 = 0;
        while (i2 < markers.length) {
            double p = markers[i2].getPosition();
            Color l = markers[i2].getLeft();
            Color r = markers[i2].getRight();
            Color c = markers[i2].getCenter();
            x[2] = x[0] = (int)(p * w);
            y[1] = y[2] = this.getHeight() - 1;
            y[0] = this.getHeight() - this.n - 4;
            x[1] = x[0] + 5;
            g.setColor(r);
            g.fillPolygon(x, y, 3);
            g.setColor(Color.black);
            g.drawPolygon(x, y, 3);
            x[1] = x[0] - 5;
            g.setColor(l);
            g.fillPolygon(x, y, 3);
            g.setColor(Color.black);
            g.drawPolygon(x, y, 3);
            y[0] = this.getHeight() - this.n / 2;
            x[1] = x[0] + 5;
            x[2] = x[0] - 5;
            g.setColor(c);
            g.fillPolygon(x, y, 3);
            g.setColor(Color.black);
            g.drawPolygon(x, y, 3);
            ++i2;
        }
    }

    public static void main(String[] args) {
        BasicFrame bf = new BasicFrame("Test"){

            public void shutdown() {
                System.exit(0);
            }
        };
        bf.getContentPane().add(new GradientCanvas());
        bf.setSize(500, 100);
        bf.setVisible(true);
    }

    class CustomMouseAdapter
    extends MouseAdapter
    implements Observer,
    MouseMotionListener {
        private Marker marker = null;
        private JColorChooser chooser = new JColorChooser();

        CustomMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            int pos = 0;
            Marker[] markers = GradientCanvas.this.gradient.getMarkers();
            int i = 1;
            while (i < markers.length - 1) {
                pos = (int)(markers[i].getPosition() * (double)GradientCanvas.this.getWidth());
                if (Math.abs(pos - e.getX()) < 10 && Math.abs(e.getY() - GradientCanvas.this.getHeight()) < 15) {
                    this.marker = markers[i];
                    return;
                }
                ++i;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.marker != null) {
                this.marker.setPosition((double)e.getX() / (double)GradientCanvas.this.getWidth());
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.marker = null;
            GradientCanvas.this.gradient.compact();
            GradientCanvas.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            Marker[] markers = GradientCanvas.this.gradient.getMarkers();
            int i = 1;
            while (i < markers.length - 1) {
                int pos = (int)(markers[i].getPosition() * (double)GradientCanvas.this.getWidth());
                if (Math.abs(pos - e.getX()) < 10 && Math.abs(e.getY() - GradientCanvas.this.getHeight()) < 15) {
                    GradientCanvas.this.setCursor(new Cursor(13));
                    return;
                }
                ++i;
            }
            GradientCanvas.this.setCursor(new Cursor(0));
        }

        public void mouseExited(MouseEvent e) {
            GradientCanvas.this.setCursor(new Cursor(0));
        }

        public void mouseEntered(MouseEvent e) {
            GradientCanvas.this.setCursor(new Cursor(0));
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1 && e.getButton() == 3 && e.getY() > GradientCanvas.this.getHeight() - GradientCanvas.this.n) {
                Marker[] markers = GradientCanvas.this.gradient.getMarkers();
                int i = 0;
                while (i < markers.length) {
                    int pos = (int)(markers[i].getPosition() * (double)GradientCanvas.this.getWidth());
                    if (Math.abs(pos - e.getX()) < 10 && Math.abs(e.getY() - GradientCanvas.this.getHeight()) < 15) {
                        ChangeMarkerAction action = new ChangeMarkerAction(markers[i], this.chooser);
                        JDialog dialog = JColorChooser.createDialog(GradientCanvas.this, "Chooser a color", true, this.chooser, action, new AbstractAction(this){
                            final /* synthetic */ CustomMouseAdapter this$1;
                            {
                                this.this$1 = customMouseAdapter;
                            }

                            public void actionPerformed(ActionEvent e) {
                            }
                        });
                        dialog.setVisible(true);
                        i = markers.length;
                    }
                    ++i;
                }
            } else if (e.getClickCount() == 2) {
                double position = (double)e.getX() / (double)GradientCanvas.this.getWidth();
                this.chooser.setColor(GradientCanvas.this.gradient.getColor(position));
                Marker m = new Marker(position);
                m.addObserver(this);
                NewMarkerAction action = new NewMarkerAction(m, this.chooser);
                JDialog dialog = JColorChooser.createDialog(GradientCanvas.this, "Chooser a color", true, this.chooser, action, new AbstractAction(this){
                    final /* synthetic */ CustomMouseAdapter this$1;
                    {
                        this.this$1 = customMouseAdapter;
                    }

                    public void actionPerformed(ActionEvent e) {
                    }
                });
                dialog.setVisible(true);
            }
        }

        public void update(Observable m, Object o) {
            GradientCanvas.this.repaint();
        }
    }

    class ChangeMarkerAction
    implements ActionListener {
        private Marker marker;
        private JColorChooser chooser;

        ChangeMarkerAction(Marker m, JColorChooser c) {
            this.marker = m;
            this.chooser = c;
        }

        public void actionPerformed(ActionEvent e) {
            this.marker.setColor(this.chooser.getColor());
            GradientCanvas.this.repaint();
        }
    }

    class NewMarkerAction
    implements ActionListener {
        private Marker marker;
        private JColorChooser chooser;

        NewMarkerAction(Marker m, JColorChooser c) {
            this.marker = m;
            this.chooser = c;
        }

        public void actionPerformed(ActionEvent e) {
            this.marker.setColor(this.chooser.getColor());
            GradientCanvas.this.gradient.addMarker(this.marker);
            GradientCanvas.this.repaint();
        }
    }
}

