/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.gui.gradient;

import java.awt.Color;
import net.gcalc.calc.gui.gradient.Gradient;

public class SimpleGradient
extends Gradient {
    private Color left;
    private Color right;

    public SimpleGradient() {
        this(Color.black, Color.black);
    }

    public SimpleGradient(Color l, Color r) {
        this(l, r, 0);
    }

    public SimpleGradient(Color l, Color r, int mode) {
        super(mode);
        this.left = l;
        this.right = r;
    }

    public Color getColor(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Gradient parameter must be between 0 and 1");
        }
        float[] c = new float[3];
        float[] leftComp = this.left.getRGBColorComponents(null);
        float[] rightComp = this.right.getRGBColorComponents(null);
        if (this.getMode() == 1) {
            leftComp = this.getHSB(this.left, leftComp);
            rightComp = this.getHSB(this.right, rightComp);
        }
        int i = 0;
        while (i < leftComp.length) {
            c[i] = (float)(p * (double)rightComp[i] + (1.0 - p) * (double)leftComp[i]);
            ++i;
        }
        Color color = null;
        color = this.getMode() == 1 ? Color.getHSBColor(c[0], c[1], c[2]) : new Color(c[0], c[1], c[2]);
        return color;
    }
}

