/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.math.functions.UnaryOperation;
import net.gcalc.calc.math.functions.Variable;
import net.gcalc.calc.parser.BadSyntaxRuntimeException;
import net.gcalc.calc.parser.ParseTree;
import net.gcalc.calc.parser.Token;

public class NumericalIntegral
extends UnaryOperation {
    private static final int MAX_RECURSION_DEPTH = 10;
    private double tol;
    private Function f;
    private Function u;
    private Function v;
    private Token variable;
    private SymbolTable symbolTable;
    private ValueTable valueTable;

    public NumericalIntegral(ParseTree pt) throws BadSyntaxRuntimeException {
        super(pt);
        Function t;
        try {
            this.f = FunctionFactory.getFunction(this.getArg(0));
            Function s = FunctionFactory.getFunction(this.getArg(1));
            this.u = FunctionFactory.getFunction(this.getArg(2));
            this.v = FunctionFactory.getFunction(this.getArg(3));
            t = FunctionFactory.getFunction(this.getArg(4));
            this.variable = (Token)((Variable)s).getVars().elementAt(0);
            if (this.u.getVars().contains(this.variable) || this.v.getVars().contains(this.variable)) {
                throw new BadSyntaxRuntimeException("Cannot use dummy variable in integral end points");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Object t2 = null;
            this.v = null;
            this.u = null;
            Object s = null;
            this.f = null;
            this.variable = null;
            throw new BadSyntaxRuntimeException("Not enough arguments");
        }
        catch (ClassCastException e) {
            Object t3 = null;
            this.v = null;
            this.u = null;
            Object s = null;
            this.f = null;
            this.variable = null;
            throw new BadSyntaxRuntimeException("The second argument of int must be a variable.");
        }
        this.tol = t.evaluate();
        this.symbolTable = new SymbolTable();
        this.valueTable = new ValueTable();
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        double a = this.u.evaluate(st, vt);
        double b = this.v.evaluate(st, vt);
        return this.definiteIntegral(this.f, a, b, this.tol);
    }

    private double definiteIntegral(Function f, double a, double b, double tol) {
        return this.definiteIntegral(f, a, b, Double.MAX_VALUE, tol, 0);
    }

    private double definiteIntegral(Function f, double a, double b, double estimate, double tol, int level) {
        double sR;
        if (a > b) {
            return -this.definiteIntegral(f, b, a, -estimate, tol, level);
        }
        double z = (a + b) / 2.0;
        double sL = this.simpsonsRule(f, a, z);
        double newEstimate = sL + (sR = this.simpsonsRule(f, z, b));
        double error = estimate - newEstimate;
        if (Math.abs(error) < 10.0 * tol && level >= 2) {
            return newEstimate;
        }
        if (level > 10) {
            return newEstimate;
        }
        return this.definiteIntegral(f, a, z, sL, tol / 2.0, ++level) + this.definiteIntegral(f, z, b, sR, tol / 2.0, level);
    }

    private double simpsonsRule(Function f, double a, double b) {
        this.valueTable.setValue(this.variable, a);
        double f0 = f.evaluate(this.symbolTable, this.valueTable);
        this.valueTable.setValue(this.variable, (a + b) / 2.0);
        double f1 = f.evaluate(this.symbolTable, this.valueTable);
        this.valueTable.setValue(this.variable, b);
        double f2 = f.evaluate(this.symbolTable, this.valueTable);
        return (b - a) / 6.0 * (f0 + 4.0 * f1 + f2);
    }

    public Function derivative(Vector vars) {
        return NOT_A_NUMBER;
    }
}

