/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.ParseTree;

public abstract class VariableArityFunction
extends Function {
    protected Function IDENTITY = null;

    protected VariableArityFunction(ParseTree pt) {
        super(pt);
        this.convertArgumentsToFunction();
    }

    public boolean isConstant() {
        int i = 0;
        while (i < this.getNumberOfArgs()) {
            if (!((Function)this.getArg(i)).isConstant()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addToArguments(Vector dst, Vector src) {
        if (dst != null && src != null) {
            int i = 0;
            while (i < src.size()) {
                dst.add(((Function)src.elementAt(i)).simplify());
                ++i;
            }
        }
    }

    protected void addToArguments(Vector dst, Function f) {
        if (f.getClass().equals(this.getClass())) {
            this.addToArguments(dst, f.getArgs());
        } else {
            dst.add(f.simplify());
        }
    }

    public Function simplify() {
        if (this.isConstant()) {
            this.simpleVersion = FunctionFactory.getFunction(this.evaluate());
            return this.simpleVersion;
        }
        Vector argList = new Vector();
        int i = 0;
        while (i < this.getNumberOfArgs()) {
            this.addToArguments(argList, ((Function)this.getArg(i)).simplify());
            ++i;
        }
        if (argList.size() == 0) {
            this.simpleVersion = this.IDENTITY;
            return this.simpleVersion;
        }
        if (argList.size() == 1) {
            this.simpleVersion = ((Function)argList.elementAt(0)).simplify();
            return this.simpleVersion;
        }
        this.simpleVersion = FunctionFactory.getFunction(this.getRoot(), argList);
        return this.simpleVersion;
    }
}

