/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.StringCharacterIterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.main.AbstractPlugin;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.SymbolTableException;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.calc.parser.CalcParser;
import net.gcalc.calc.parser.ParseTree;
import net.gcalc.calc.parser.Token;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.plugin.gui.RecallJTextField;

public class ScientificCalculatorPlugin
extends AbstractPlugin {
    protected JEditorPane jep;
    protected RecallJTextField inputTF;
    protected JButton inputButton;
    protected JMenuItem clearOutput;
    protected JMenuItem clearHistory;
    protected JMenuItem save;
    protected JMenuItem print;
    protected JMenuItem close;
    protected JMenuItem copy;
    protected JMenuItem cut;
    protected JMenuItem paste;
    protected JMenuItem showHelp;
    protected JMenuItem aboutPlugin;
    private SymbolTable st;
    private ValueTable vt;
    private ClipboardActionListener cal = new ClipboardActionListener();
    private SciCalcActionListener scal;

    public ScientificCalculatorPlugin() {
        this.st = new SymbolTable();
        this.vt = new ValueTable();
    }

    public void init() {
        if (this.jep != null) {
            return;
        }
        this.jep = new JEditorPane("text/html", "");
        this.jep.setEditable(false);
        Box inputBox = Box.createHorizontalBox();
        this.inputButton = new JButton("Go!");
        this.inputTF = new RecallJTextField("");
        inputBox.add(this.inputTF);
        inputBox.add(this.inputButton);
        this.scal = new SciCalcActionListener();
        this.inputButton.addActionListener(this.scal);
        this.inputTF.addActionListener(this.scal);
        this.inputTF.addFocusListener(this.cal);
        this.jep.addFocusListener(this.cal);
        Box componentBox = Box.createVerticalBox();
        componentBox.add(new JScrollPane(this.jep));
        this.getContentPane().add("Center", SwingGUI.wrapTitledBorder(componentBox, "Output"));
        this.getContentPane().add("South", SwingGUI.wrapTitledBorder(inputBox, "Input"));
        this.setJMenuBar(this.initMenuBar());
        this.setSize(400, 500);
        this.setResizable(true);
        this.inputTF.requestFocus();
    }

    protected JMenuBar initMenuBar() {
        JMenuBar jmb = new JMenuBar();
        JMenu editMenu = new JMenu("Edit");
        JMenu helpMenu = new JMenu("Help");
        JMenu pluginMenu = new JMenu("SciCalc");
        this.clearOutput = new JMenuItem("Clear Calculator Output");
        pluginMenu.add(this.clearOutput);
        pluginMenu.addSeparator();
        this.close = new JMenuItem("Close Plugin");
        pluginMenu.add(this.close);
        this.close.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ScientificCalculatorPlugin.this.shutdown();
            }
        });
        this.clearOutput.addActionListener(new TextComponentClearActionListener(this.jep){

            public void actionPerformed(ActionEvent e) {
                this.textComponent.setText("");
                ScientificCalculatorPlugin.this.scal.clear();
            }
        });
        this.copy = new JMenuItem("Copy");
        editMenu.add(this.copy);
        this.cut = new JMenuItem("Cut");
        editMenu.add(this.cut);
        this.paste = new JMenuItem("Paste");
        editMenu.add(this.paste);
        this.copy.addActionListener(this.cal);
        this.cut.addActionListener(this.cal);
        this.paste.addActionListener(this.cal);
        this.showHelp = new JMenuItem("Help...");
        helpMenu.add(this.showHelp);
        this.aboutPlugin = new JMenuItem("About Plugin...");
        helpMenu.add(this.aboutPlugin);
        jmb.add(pluginMenu);
        jmb.add(editMenu);
        jmb.add(Box.createHorizontalGlue());
        jmb.add(helpMenu);
        return jmb;
    }

    public String inputBorderText() {
        return "Scientific Calculator";
    }

    public String getHTMLDescription() {
        return String.valueOf(this.getStandardHeading()) + "<p>Acts like a scientific calculator.</p>" + "<p>Hint: the last result is saved in the variable <code>ans</code>.</p>";
    }

    public String getPluginName() {
        return "Scientific Calculator";
    }

    public String getCreatorName() {
        return "Jiho Kim (jiho@gcalc.net)";
    }

    public String getDescription() {
        return "Acts like a scientific calculator.";
    }

    public static String formatForHTML(String aTagFragment) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(aTagFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '\\') {
                result.append("&#092;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    class SciCalcActionListener
    implements ActionListener {
        private int count = 0;
        private StringBuffer sb;

        public SciCalcActionListener() {
            this.clear();
        }

        public void clear() {
            this.count = 0;
            this.sb = new StringBuffer();
            this.sb.append("<table border=0 width=\"100%\">");
        }

        public void actionPerformed(ActionEvent e) {
            String input = ScientificCalculatorPlugin.this.inputTF.getText().trim();
            if (input.length() == 0) {
                return;
            }
            ++this.count;
            String color = this.count % 2 == 0 ? "" : " bgcolor=\"#f0f0f0\"";
            this.sb.append("<tr><td" + color + "><div align=left>" + ScientificCalculatorPlugin.formatForHTML(input) + "</div>");
            try {
                ParseTree pt = (ParseTree)CalcParser.parse(input).getArgs().elementAt(0);
                Token root = pt.getRoot();
                if (root.isEqualSign()) {
                    Vector args = pt.getArgs();
                    ParseTree lhs = (ParseTree)args.elementAt(0);
                    ParseTree rhs = (ParseTree)args.elementAt(1);
                    if (!lhs.getRoot().isVariable()) {
                        throw new BadSyntaxException("LHS is not variable");
                    }
                    if (lhs.equals(rhs)) {
                        ScientificCalculatorPlugin.this.st.removeVariable(lhs.getRoot());
                        this.sb.append("<div align=right>" + lhs.getRoot().toString() + " unset</div>");
                    } else {
                        ScientificCalculatorPlugin.this.st.setVariable(lhs.getRoot(), FunctionFactory.getFunction(rhs));
                        this.sb.append("<div align=right>" + input + "</div>");
                    }
                } else {
                    Function F = FunctionFactory.getFunction(input);
                    String result = null;
                    if (F.getRoot().isDerivative()) {
                        result = F.simplify().toInfix();
                    } else {
                        double val = F.evaluate(ScientificCalculatorPlugin.this.st, ScientificCalculatorPlugin.this.vt);
                        if (!Double.isInfinite(val) && !Double.isNaN(val)) {
                            ScientificCalculatorPlugin.this.vt.setValue(new VariableToken("ans"), val);
                            result = "" + val;
                        } else {
                            result = "Error";
                        }
                    }
                    this.sb.append("<div align=right>" + result + "</div>");
                }
            }
            catch (BadSyntaxException exception) {
                String message = exception.getMessage();
                this.outputErrorMessage(message);
            }
            catch (SymbolTableException ex2) {
                System.err.println(ex2);
                this.outputErrorMessage(ex2.getMessage());
            }
            this.sb.append("</td></tr>");
            ScientificCalculatorPlugin.this.inputTF.addToHistory(input);
            ScientificCalculatorPlugin.this.inputTF.setText("");
            ScientificCalculatorPlugin.this.jep.setText(String.valueOf(this.sb.toString()) + "</table>");
        }

        private void outputErrorMessage(String message) {
            if (message == null) {
                message = "";
            }
            this.sb.append("<div align=right><font color=red>ERROR:" + message + "</font></div>");
        }
    }

    abstract class TextComponentClearActionListener
    extends AbstractAction {
        protected JTextComponent textComponent = null;

        public TextComponentClearActionListener(JTextComponent tc) {
            this.textComponent = tc;
        }
    }

    class ClipboardActionListener
    extends FocusAdapter
    implements ActionListener {
        private JTextComponent ta = null;

        ClipboardActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (this.ta == null) {
                return;
            }
            Object src = e.getSource();
            if (src == ScientificCalculatorPlugin.this.copy) {
                this.ta.copy();
            } else if (src == ScientificCalculatorPlugin.this.paste) {
                this.ta.paste();
            } else if (src == ScientificCalculatorPlugin.this.cut) {
                this.ta.cut();
            }
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JTextComponent) {
                this.ta = (JTextComponent)e.getSource();
            }
            ScientificCalculatorPlugin.this.paste.setEnabled(this.ta != ScientificCalculatorPlugin.this.jep);
            ScientificCalculatorPlugin.this.cut.setEnabled(this.ta != ScientificCalculatorPlugin.this.jep);
        }
    }
}

