/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.gui.PropertiesPanel;
import net.gcalc.plugin.gui.RecallJTextField;
import net.gcalc.plugin.plane.gui.FlagPanel;
import net.gcalc.plugin.plane.gui.ShowPropertiesPanelAction;
import net.gcalc.plugin.plane.gui.ViewPanel;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.plugin.properties.Range;
import net.gcalc.plugin.properties.View;

public class TableViewPlugin
extends AbstractCartesianGraphPlugin
implements Observer {
    protected double xmin;
    protected double xmax;
    protected double xscale;
    protected JTable jt;
    protected MyTableModel tableModel;
    protected RecallJTextField inputTF;
    protected JButton inputButton;
    protected JMenuItem clearOutput;
    protected JMenuItem clearHistory;
    protected JMenuItem save;
    protected JMenuItem print;
    protected JMenuItem close;
    protected JMenuItem copy;
    protected JMenuItem cut;
    protected JMenuItem paste;
    protected JMenuItem showHelp;
    protected JMenuItem aboutPlugin;
    private ValueTable vt = new ValueTable();
    private GraphProperties properties = new GraphProperties();
    private LocalActionListener lal;

    public TableViewPlugin() {
        Range R = new Range(-10.0, 10.0, 0.25);
        View view = new View(R);
        this.properties.put(GraphProperties.VIEW, view);
        this.tableModel = new MyTableModel(view);
        this.properties.addObserver(this);
    }

    public void init() {
        if (this.jt != null) {
            return;
        }
        this.jt = new JTable(this.tableModel){

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this, this.columnModel){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        if (realIndex == 0) {
                            return null;
                        }
                        return ((Function)MyTableModel.access$0(1.access$0(this.this$1).tableModel).elementAt(realIndex - 1)).toInfix();
                    }
                };
            }

            static /* synthetic */ TableViewPlugin access$0(1 var0) {
                return var0.TableViewPlugin.this;
            }
        };
        this.jt.setAutoResizeMode(0);
        this.jt.getColumnModel().setColumnSelectionAllowed(true);
        Box inputBox = Box.createHorizontalBox();
        this.inputButton = new JButton("Add Column!");
        this.inputTF = new RecallJTextField("");
        inputBox.add(this.inputTF);
        inputBox.add(this.inputButton);
        inputBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Input"));
        this.lal = new LocalActionListener();
        this.inputButton.addActionListener(this.lal);
        this.inputTF.addActionListener(this.lal);
        Box componentBox = Box.createVerticalBox();
        componentBox.add(new JScrollPane(this.jt, 22, 32));
        componentBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Table View"));
        this.getContentPane().add("Center", componentBox);
        this.getContentPane().add("North", inputBox);
        this.setJMenuBar(this.initMenuBar());
        this.initPropertiesPanel();
        this.setSize(400, 500);
        this.setResizable(true);
        this.inputTF.requestFocus();
    }

    protected JPanel makeFlagPanel() {
        return new FlagPanel(this.getProperties());
    }

    protected JPanel makeViewPanel() {
        return new ViewPanel(this.getProperties(), false);
    }

    protected void initPropertiesPanel() {
        System.out.println("hello");
        Box viewPanel = SwingGUI.wrap(this.makeViewPanel());
        PropertiesPanel propertiesDialog = this.getPropertiesPanel();
        propertiesDialog.addTab("View", viewPanel);
    }

    protected JMenuBar initMenuBar() {
        JMenuBar jmb = new JMenuBar();
        JMenu editMenu = new JMenu("Edit");
        JMenu helpMenu = new JMenu("Help");
        JMenu pluginMenu = new JMenu("TableView");
        this.clearOutput = new JMenuItem("Clear Table");
        pluginMenu.add(this.clearOutput);
        this.clearHistory = new JMenuItem("Clear Input History");
        pluginMenu.add(this.clearHistory);
        pluginMenu.addSeparator();
        this.close = new JMenuItem("Close Plugin");
        pluginMenu.add(this.close);
        this.close.addActionListener(new HideActionListener());
        this.clearOutput.addActionListener(new TableClearActionListener());
        this.clearHistory.addActionListener(new TextComponentClearActionListener(this.inputTF));
        this.copy = new JMenuItem("Copy");
        editMenu.add(this.copy);
        this.cut = new JMenuItem("Cut");
        editMenu.add(this.cut);
        this.paste = new JMenuItem("Paste");
        editMenu.add(this.paste);
        editMenu.addSeparator();
        editMenu.add(new ShowPropertiesPanelAction(this));
        this.showHelp = new JMenuItem("Help...");
        helpMenu.add(this.showHelp);
        this.aboutPlugin = new JMenuItem("About Plugin...");
        helpMenu.add(this.aboutPlugin);
        jmb.add(pluginMenu);
        jmb.add(editMenu);
        jmb.add(Box.createHorizontalGlue());
        jmb.add(helpMenu);
        return jmb;
    }

    public void update(Observable obj, Object key) {
        if (key.equals(GraphProperties.VIEW)) {
            this.tableModel.updateView(this.properties.getViewProperty(GraphProperties.VIEW));
        }
    }

    public String inputBorderText() {
        return "Table View";
    }

    public String getPluginName() {
        return "Table Plugin";
    }

    public String getCreatorName() {
        return "Jiho Kim (jiho@gcalc.net)";
    }

    public String getDescription() {
        return "<p>Shows table of function values.</p>";
    }

    public GraphProperties getProperties() {
        return this.properties;
    }

    class LocalActionListener
    implements ActionListener {
        private StringBuffer sb;

        LocalActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String input = TableViewPlugin.this.inputTF.getText().trim();
            if (input.length() == 0) {
                return;
            }
            try {
                Function F = FunctionFactory.getFunction(input);
                TableViewPlugin.this.tableModel.addFunction(F);
            }
            catch (BadSyntaxException exception) {
                String message = exception.getMessage();
                this.outputErrorMessage(message);
            }
            TableViewPlugin.this.inputTF.addToHistory(input);
            TableViewPlugin.this.inputTF.setText("");
        }

        private void outputErrorMessage(String message) {
            if (message == null) {
                message = "";
            }
            this.sb.append("<div align=right><font color=red>ERROR:" + message + "</font></div>");
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private Vector F;
        private double xmax;
        private double xmin;
        private double xscale;

        public MyTableModel(View view) {
            this.updateView(view);
            this.clear();
        }

        public void updateView(View view) {
            Range range = view.getRange(0);
            this.xmax = range.getMax();
            this.xmin = range.getMin();
            this.xscale = range.getScale();
            this.fireTableStructureChanged();
        }

        public void clear() {
            this.F = new Vector();
            this.fireTableStructureChanged();
        }

        public Function getFunction(int i) {
            return (Function)this.F.elementAt(i);
        }

        public void addFunction(Function f) {
            this.F.add(f);
            this.fireTableStructureChanged();
        }

        public int getRowCount() {
            return (int)((this.xmax - this.xmin) / this.xscale + 0.5) + 1;
        }

        public int getColumnCount() {
            return this.F.size() + 1;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "x";
            }
            return this.getFunction(column - 1).toInfix();
        }

        private double varValueAt(double row) {
            return this.xmin + row * this.xscale;
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return "" + this.varValueAt(row);
            }
            String s = null;
            try {
                s = "" + this.evaluateFunction((Function)this.F.elementAt(column - 1), this.varValueAt(row));
            }
            catch (Exception e) {
                s = "";
            }
            return s;
        }

        private double evaluateFunction(Function f, double x) {
            TableViewPlugin.this.vt.setValue(VariableToken.X_VAR, x);
            return f.evaluate(TableViewPlugin.this.vt);
        }

        static /* synthetic */ Vector access$0(MyTableModel myTableModel) {
            return myTableModel.F;
        }
    }

    class HideActionListener
    implements ActionListener {
        HideActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TableViewPlugin.this.shutdown();
        }
    }

    class TextComponentClearActionListener
    implements ActionListener {
        private JTextComponent tc = null;

        public TextComponentClearActionListener(JTextComponent tc) {
            this.tc = tc;
        }

        public void actionPerformed(ActionEvent e) {
            this.tc.setText("");
            if (this.tc instanceof RecallJTextField) {
                ((RecallJTextField)this.tc).clear();
            }
        }
    }

    class TableClearActionListener
    implements ActionListener {
        TableClearActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TableViewPlugin.this.tableModel.clear();
        }
    }
}

