/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JTextField;

public class RecallJTextField
extends JTextField
implements KeyListener {
    private int cursor;
    private Vector history;

    public RecallJTextField(String s) {
        super(s);
        this.clear();
        this.addKeyListener(this);
    }

    public RecallJTextField(String s, int len) {
        super(s, len);
        this.clear();
        this.addKeyListener(this);
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        int size = this.history.size();
        if (code == 38 || code == 224) {
            this.cursor = (this.cursor + size - 1) % size;
            this.setText((String)this.history.elementAt(this.cursor));
        } else if (code == 40 || code == 225) {
            this.cursor = (this.cursor + 1) % size;
            this.setText((String)this.history.elementAt(this.cursor));
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void resetRecallCursor() {
        this.cursor = 0;
    }

    public void addToHistory(String s) {
        if (!this.history.lastElement().equals(s)) {
            this.history.add(s);
        }
        this.resetRecallCursor();
    }

    public void clear() {
        this.history = new Vector();
        this.history.add("");
        this.resetRecallCursor();
    }
}

