/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.plugin.properties.Range;
import net.gcalc.plugin.properties.View;
import net.gcalc.plugin.properties.Zoom;

public class ParametricGraph
extends CartesianGraph {
    public ParametricGraph(AbstractCartesianGraphPlugin plugin) {
        super(plugin);
        this.getProperties().put(GraphProperties.V_TITLE_STRING, "y");
    }

    protected Vector makeZoomsVector() {
        Vector v = super.makeZoomsVector();
        int i = v.size() - 1;
        while (i >= 0) {
            if (v.elementAt(i) instanceof CartesianGraph.FitZoom) {
                v.removeElementAt(i);
            }
            --i;
        }
        i = 0;
        while (i < v.size()) {
            v.setElementAt(this.zoomWrapper((Zoom)v.elementAt(i)), i);
            ++i;
        }
        return v;
    }

    public Zoom zoomWrapper(Zoom z) {
        return new ParametricZoomWrapper(z);
    }

    public void setDefaultGraphElements() {
        boolean b = true;
        this.properties.initDefault(GraphProperties.H_AXIS, b);
        this.properties.initDefault(GraphProperties.H_GRID, b);
        this.properties.initDefault(GraphProperties.H_SCALE, b);
        this.properties.initDefault(GraphProperties.V_AXIS, b);
        this.properties.initDefault(GraphProperties.V_GRID, b);
        this.properties.initDefault(GraphProperties.V_SCALE, b);
        this.properties.initDefault(GraphProperties.V_TITLE, b);
        this.properties.initDefault(GraphProperties.H_TITLE, b);
        this.properties.initDefault(GraphProperties.V_LABEL, b);
        this.properties.initDefault(GraphProperties.H_LABEL, b);
        this.properties.initDefault(GraphProperties.INTERACTIVE_ZOOM, b);
    }

    public void setDefaultView() {
        super.setDefaultView();
        View view = new View(new Range(-5.0, 5.0, 1.0), new Range(-5.0, 5.0, 1.0), new Range(-10.0, 10.0, 0.01));
        view.setNames(new String[]{"x", "y", "t"});
        this.properties.initDefault(GraphProperties.VIEW, view);
    }

    protected void draw(RenderableModel model) {
        BufferedImage buffer = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        Function f = model.getFunction(0);
        Function g = model.getFunction(1);
        Range T = this.properties.getViewProperty(GraphProperties.VIEW).getRange(2);
        this.draw(f, g, T, model.getColor(), buffer.getGraphics(), new SymbolTable());
        this.gr.drawImage((Image)buffer, 0, 0, null);
        model.setImage(buffer);
    }

    protected void draw(Function F, Function G, Range T, Color c, Graphics g, SymbolTable st) {
        ValueTable vt = new ValueTable();
        int steps = (int)Math.min(T.getWidth() / T.getScale(), 1000000.0);
        double tscl = T.getScale();
        double tmin = T.getMin();
        int ry = Integer.MAX_VALUE;
        int rx = Integer.MAX_VALUE;
        int thickness = this.properties.getBooleanProperty(GraphProperties.THICK_GRAPH) ? 3 : 1;
        int i = 0;
        while (i < steps) {
            double t = (double)i * tscl + tmin;
            vt.setValue(VariableToken.T_VAR, t);
            double x = F.evaluate(st, vt);
            double y = G.evaluate(st, vt);
            int sx = this.cartesianXtoScreen(x);
            int sy = this.cartesianYtoScreen(y);
            if (this.isOnScreen(sx, sy) && this.isOnScreen(rx, ry)) {
                this.drawThickLine(g, sx, sy, rx, ry, c, thickness);
                rx = sx;
                ry = sy;
            } else if (this.isOnScreen(sx, sy)) {
                this.drawThickLine(g, sx, sy, sx, sy, c, thickness);
                rx = sx;
                ry = sy;
            } else {
                ry = Integer.MAX_VALUE;
                rx = Integer.MAX_VALUE;
            }
            ++i;
        }
    }

    class ParametricZoomWrapper
    extends Zoom {
        private Zoom zoom;

        public ParametricZoomWrapper(Zoom z) {
            this.zoom = z;
        }

        public String getName() {
            return this.zoom.getName();
        }

        public View getView() {
            View view = this.zoom.getView();
            int n = view.getDimension();
            Range[] range = new Range[n + 1];
            String[] varName = new String[n + 1];
            int i = 0;
            while (i < n) {
                range[i] = view.getRange(i);
                varName[i] = view.getVarNames()[i];
                ++i;
            }
            range[n] = ParametricGraph.this.properties.getViewProperty(GraphProperties.VIEW).getRange(2);
            varName[n] = ParametricGraph.this.properties.getViewProperty(GraphProperties.VIEW).getVarNames()[2];
            view = new View(range);
            view.setNames(varName);
            return view;
        }
    }
}

