/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin.space;

import java.awt.Color;
import net.gcalc.proto.plugin.space.DoubleTriple;

class Segment3D
implements Comparable {
    private DoubleTriple dt0;
    private DoubleTriple dt1;
    private DoubleTriple dt0p;
    private DoubleTriple dt1p;
    private Color cfar;
    private Color cnear;
    private boolean arrow;

    public Segment3D(DoubleTriple p0, DoubleTriple p1, Color far, Color near) {
        this(p0, p1, far, near, false);
    }

    public Segment3D(DoubleTriple p0, DoubleTriple p1, Color far, Color near, boolean arrow) {
        this.dt0 = p0;
        this.dt1 = p1;
        this.dt0p = new DoubleTriple(this.dt0);
        this.dt1p = new DoubleTriple(this.dt1);
        this.cfar = far;
        this.cnear = near;
        this.arrow = arrow;
    }

    public DoubleTriple getP1() {
        return this.dt0p;
    }

    public DoubleTriple getP2() {
        return this.dt1p;
    }

    public Color farColor() {
        return this.cfar;
    }

    public Color nearColor() {
        return this.cnear;
    }

    public void transform(double s1, double c1, double s2, double c2, double x0, double y0, double z0, double rh, double sf) {
        this.transform(this.dt0, this.dt0p, s1, c1, s2, c2, x0, y0, z0, rh, sf);
        this.transform(this.dt1, this.dt1p, s1, c1, s2, c2, x0, y0, z0, rh, sf);
    }

    private void transform(DoubleTriple p0, DoubleTriple p1, double s1, double c1, double s2, double c2, double x0, double y0, double z0, double rh, double sf) {
        double x = p0.getX() - x0;
        double y = p0.getY() - y0;
        double z = p0.getZ() - z0;
        double xx = c1 * x - s1 * y;
        double yy = s1 * c2 * x + c1 * c2 * y + s2 * z;
        double zz = s2 * s1 * x + c1 * s2 * y - c2 * z + rh;
        p1.setTriple(sf * xx, sf * yy, zz);
    }

    public double averageDistance() {
        return 0.5 * (this.dt0p.getZ() + this.dt1p.getZ());
    }

    public int compareTo(Object obj) {
        Segment3D s = (Segment3D)obj;
        if (this.averageDistance() < s.averageDistance()) {
            return -1;
        }
        if (this.averageDistance() > s.averageDistance()) {
            return 1;
        }
        return 0;
    }

    public boolean isArrow() {
        return this.arrow;
    }
}

