#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/time.h>

# include <sys/resource.h>
# include <sys/types.h>
# include <unistd.h>
# include <signal.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>



#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "parse.h"

gint pids[256][2];		//pids[numberOFpidsAllowed][pid#,g_io_channel,ip]
gchar *ips[256][1];
gint streams = 0;
gchar *binpath = "streamripper";
gchar *arguments = "";
gchar *musicdir = "/tmp/";
GtkWidget *Mainwidget;
gchar *ip = "";
GtkWidget *dialog1;
GtkWidget *entry3;


#define BUFSIZE 1024



/***************************************************************************
code for startNewThread(),kill_proc(),iofunc_stderr(),set_up_io_channel()
have come from, and been derived from, the file listed below.
I found this file through google.com and have found it to be very
informative. Thank you Tim-Philipp M. over at ed2k-gtk-gui.sourceforge.net
for all of your hard work, and well commented code.

                      spawn_async_with_pipes_gtk.c
                      ----------------------------
    begin                : Sun Jan 11 2004
    copyright            : (C) 2004 by Tim-Philipp Muller
    email                : t.i.m at orange dot net
***************************************************************************/






void on_addStation_button_clicked(GtkButton * button, gpointer user_data)
{
	// get text from box
	// open new tab and call startNew proc funct
	gchar *input = NULL;
	gulong child_pid;

	Mainwidget = lookup_widget(GTK_WIDGET(button), "window1");
	input = gtk_entry_get_text(GTK_ENTRY
				   (lookup_widget
				    (GTK_WIDGET(button), "entry1")));
	if(input == NULL || input == "" || (strlen(input) == 0))
	{
		showMessage(Mainwidget);
	}
	else if(musicdir == "" || musicdir == NULL || (strlen(musicdir) == 0))
	{
		on_button2_clicked(button, user_data);
	}
	else
	{
		ip = input;
		child_pid = startNewThread();
		gtk_entry_set_text(GTK_ENTRY
				   (lookup_widget
				    (GTK_WIDGET(Mainwidget), "entry1")), "");

		if(child_pid <= 0)
			showError(GTK_WIDGET(button));
	}
}

void showError()
{
	GtkWidget *dialog;
	dialog = gtk_message_dialog_new(GTK_WINDOW
					(lookup_widget
					 (Mainwidget, "window1")),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
					"Failed to start new thread.");
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
}

void showErrorFull()
{
	GtkWidget *dialog;
	dialog = gtk_message_dialog_new(GTK_WINDOW(Mainwidget),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
					"Max streams reached.");
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
}


gulong startNewThread()
{
	GError *error = NULL;
	gchar **argv;
	gint child_pid;
	gint stdout_fd;
	gint stderr_fd;

	if(streams > 256)
	{
		showErrorFull();
		return -3;
	}

	g_return_val_if_fail(binpath != NULL, FALSE);

	gchar **fields = g_strsplit(arguments, " ", -1);
	gint field_count = 0;
	while(fields[field_count])
		field_count++;


	gint total = field_count + 5;
	argv = g_malloc0((total) * sizeof(gchar *));
	argv[0] = g_strdup(binpath);
	argv[1] = g_strdup(ip);
	argv[2] = g_strdup("-d");
	argv[3] = g_strdup(musicdir);
	gint i = 0;
	while(i < field_count)
	{
		argv[i + 4] = g_strdup(fields[i]);
		i++;
	}
	argv[total - 1] = NULL;


	if(!g_spawn_async_with_pipes(NULL, argv, NULL,
				     (GSpawnFlags) G_SPAWN_SEARCH_PATH, NULL,
				     NULL, &child_pid, NULL, &stdout_fd,
				     &stderr_fd, &error))
	{
		g_warning("g_spawn_async_with_pipes() failed: %s\n",
			  error->message);
		g_error_free(error);
		error = NULL;
		showError(GTK_WIDGET(Mainwidget));
		return 0;
	}

	pids[streams][0] = child_pid;
	ips[streams][0] = g_strdup(ip);


	//make new page
	GtkWidget *nb = lookup_widget(Mainwidget, "notebook1");
	GtkWidget *textview = gtk_text_view_new();
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview), GTK_WRAP_WORD);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(textview), FALSE);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(textview), FALSE);
	gtk_text_view_set_justification(GTK_TEXT_VIEW(textview),
					GTK_JUSTIFY_LEFT);



	GtkWidget *scroll = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
				       GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(scroll), textview);

	GtkWidget *lab = gtk_label_new(ip);
	gint page = gtk_notebook_append_page(GTK_NOTEBOOK(nb), scroll, lab);
	gtk_widget_show_all(scroll);
	gtk_notebook_set_current_page(GTK_NOTEBOOK(nb), page);

	set_up_io_channel(stderr_fd,
			  G_IO_IN | G_IO_PRI | G_IO_ERR | G_IO_HUP |
			  G_IO_NVAL, iofunc_stderr, NULL, textview);



	return (gulong) child_pid;

}


gboolean iofunc_stderr(GIOChannel * ioc, GIOCondition cond, gpointer data)
{
	GtkTextBuffer *textbuf;
	GtkTextIter enditer;


	/* data for us to read? */
	if(cond & (G_IO_IN | G_IO_PRI))
	{
		GIOStatus ret;
		guint8 buf[BUFSIZE];
		gsize len = 0;

		ret = g_io_channel_read_chars(ioc, buf, BUFSIZE, &len, NULL);

		if(len <= 0 || ret != G_IO_STATUS_NORMAL)
			return FALSE;

		textbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(data));

		gtk_text_buffer_get_end_iter(textbuf, &enditer);

		/* Check if messages are in UTF8. If not, assume
		 *  they are in current locale and try to convert.
		 *  We assume we're getting the stream in a 1-byte
		 *   encoding here, ie. that we do not have cut-off
		 *   characters at the end of our buffer (=BAD)
		 */
		if(g_utf8_validate(buf, len, NULL))
		{
			gtk_text_buffer_insert(textbuf, &enditer, buf, len);
		}
		else
		{
			const gchar *charset;
			gchar *utf8;

			(void)g_get_charset(&charset);
			utf8 = g_convert_with_fallback(NULL, len, "UTF-8",
						       charset, NULL, NULL,
						       NULL, NULL);

			if(utf8)
			{
				gtk_text_buffer_insert(textbuf, &enditer,
						       utf8, len);
				g_free(utf8);
			}
			else
			{
				g_warning
					("GStreamripperx Message Output is not in UTF-8 nor in locale charset.\n");
			}
		}

		/* A bit awkward, but better than nothing. Scroll text view to end */
		gtk_text_buffer_get_end_iter(textbuf, &enditer);
		gtk_text_buffer_move_mark_by_name(textbuf, "insert",
						  &enditer);
		gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(data),
					     gtk_text_buffer_get_mark(textbuf,
								      "insert"),
					     0.0, FALSE, 0.0, 0.0);

	}

	if(cond & (G_IO_HUP))
	{

		//connection lost or closed
		textbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(data));
		gtk_text_buffer_get_end_iter(textbuf, &enditer);
		gtk_text_buffer_insert(textbuf, &enditer, "connection closed",
				       -1);
		gtk_text_buffer_get_end_iter(textbuf, &enditer);
		gtk_text_buffer_move_mark_by_name(textbuf, "insert",
						  &enditer);
		gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(data),
					     gtk_text_buffer_get_mark(textbuf,
								      "insert"),
					     0.0, FALSE, 0.0, 0.0);
		return FALSE;
	}
	else if(cond & (G_IO_ERR | G_IO_NVAL))
	{
		return FALSE;
	}


	return TRUE;
}


GIOChannel *set_up_io_channel(gint fd, GIOCondition cond, GIOFunc func,
			      gpointer data, GtkWidget * textview)
{
	GIOChannel *ioc;

	/* set up handler for data */
	ioc = g_io_channel_unix_new(fd);
	pids[streams][1] = ioc;
	streams++;

	/* Set IOChannel encoding to none to make
	 *  it fit for binary data */
	g_io_channel_set_encoding(ioc, NULL, NULL);
	g_io_channel_set_buffered(ioc, FALSE);

	g_io_add_watch(ioc, cond, func, textview);

	g_io_channel_unref(ioc);	/* g_io_add_watch() adds reference */

	return ioc;
}


void showMessage(GtkWidget * widget)
{
	// create error dialog if no text is found
	GtkWidget *dialog;
	dialog = gtk_message_dialog_new(GTK_WINDOW(widget),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
					"Please enter an IP or file location.");
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
}



void on_quit_button_clicked(GtkButton * button, gpointer user_data)
{
	kill_proc(TRUE, -1);
	savePrefs();
	gtk_main_quit();
}

void on_close_button_clicked(GtkButton * button, gpointer user_data)
{
	// kill and close the current tab
	gint curtab = 0;
	if(streams > 0)
	{
		curtab = gtk_notebook_get_current_page(GTK_NOTEBOOK
						       (lookup_widget
							(Mainwidget,
							 "notebook1")));
		kill_proc(FALSE, curtab);
		gtk_notebook_remove_page(GTK_NOTEBOOK
					 (lookup_widget
					  (Mainwidget, "notebook1")), curtab);
	}
}


void kill_proc(gboolean all, gint curtab)
{
	//closing app need to kill all procs
	if(all)
	{
		gint i = 0;
		for(; i < streams; i++)
		{
			if(kill(pids[i][0], SIGKILL) == -1)
			{
				switch (errno)
				{
				case ESRCH:
				{
					g_printerr(("kill() failed - PID %u does not exist anymore!?\n"), pids[i][0]);
				}
					break;
				case EPERM:
				{
					g_printerr(("kill() failed - we don't have permission to kill the streamripper process.\n"));
				}
					break;
				default:
				{
					g_printerr(("kill() failed - some other error (check console output).\n"));
				}
				}
			}
		}
	}
	if(!all)		//just want to close one tab
	{
		if((kill(pids[curtab][0], SIGKILL)) != -1)
		{
			g_io_channel_shutdown((pids[curtab][1]), FALSE, NULL);
		}


		gint i = curtab;
		for(; i < streams; i++)
		{
			pids[i][0] = pids[i + 1][0];
			pids[i][1] = pids[i + 1][1];
			ips[i][0] = ips[i + 1][0];
		}
		streams--;
	}
}




gboolean
on_window1_delete_event(GtkWidget * widget,
			GdkEvent * event, gpointer user_data)
{
	on_quit_button_clicked((widget), user_data);
	gtk_main_quit();
	return FALSE;
}

void savePrefs()
{
	FILE *outfile;
	gchar *file = g_get_home_dir();
	file = g_strconcat(file, "/.gstreamripperx", NULL);
	outfile = fopen(file, "w");
	if(!outfile)
		g_error("couldn't open file!\n%s", file);

	//prefs file is saved in the following format
	//binpath:<location>
	//arguments:<args>
	//musicdir:<location>
	gchar *list = "";
	list = g_strconcat(list, "binpath:", binpath, "\n", NULL);
	list = g_strconcat(list, "arguments:", arguments, "\n", NULL);
	list = g_strconcat(list, "musicdir:", musicdir, NULL);
	fputs(list, outfile);
	fclose(outfile);
}

void loadPrefs()
{
	gchar *contents;
	gchar *homedir = g_get_home_dir();
	homedir = g_strconcat(homedir, "/.gstreamripperx", NULL);
	if(g_file_get_contents(homedir, &contents, NULL, NULL))
	{
		gchar **sub = g_strsplit(contents, "\n", -1);
		gchar *sub1 = sub[0];
		gchar **sub2 = g_strsplit(sub1, "binpath:", -1);
		binpath = sub2[1];
		sub1 = sub[1];
		sub2 = g_strsplit(sub1, "arguments:", -1);
		arguments = sub2[1];
		sub1 = sub[2];
		sub2 = g_strsplit(sub1, "musicdir:", -1);
		musicdir = sub2[1];
	}
}

// type 0=pls-file 1=location 2=saveList 3=openList
gchar *getFile(GtkWidget * widget, gint type)
{
	GtkWidget *fileOpen;
	GtkFileFilter *filter = gtk_file_filter_new();
	switch (type)
	{
	case 0:
	{
		fileOpen =
			gtk_file_chooser_dialog_new("Open pls file",
						    GTK_WINDOW(widget),
						    GTK_FILE_CHOOSER_ACTION_OPEN,
						    GTK_STOCK_CANCEL,
						    GTK_RESPONSE_CANCEL,
						    GTK_STOCK_OPEN,
						    GTK_RESPONSE_ACCEPT,
						    NULL);

		gtk_file_filter_add_pattern(filter, "*.pls");
	}
		break;
	case 1:
	{
		fileOpen =
			gtk_file_chooser_dialog_new
			("Open location to save streams", GTK_WINDOW(widget),
			 GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
			 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			 GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	}
		break;
	case 2:
	{
		fileOpen =
			gtk_file_chooser_dialog_new
			("Open location to save list", GTK_WINDOW(widget),
			 GTK_FILE_CHOOSER_ACTION_SAVE,
			 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			 GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);
		gtk_file_filter_add_pattern(filter, "*");
	}
		break;
	case 3:
	{
		fileOpen =
			gtk_file_chooser_dialog_new("Open saved list",
						    GTK_WINDOW(widget),
						    GTK_FILE_CHOOSER_ACTION_OPEN,
						    GTK_STOCK_CANCEL,
						    GTK_RESPONSE_CANCEL,
						    GTK_STOCK_OPEN,
						    GTK_RESPONSE_ACCEPT,
						    NULL);
		gtk_file_filter_add_pattern(filter, "*");
	}
		break;
	default:
	{
		return NULL;
	}

	}
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(fileOpen),
					    g_get_home_dir());
	gtk_file_chooser_set_filter(GTK_FILE_CHOOSER(fileOpen), filter);
	gtk_widget_show(fileOpen);
	gchar *filename;
	if(gtk_dialog_run(GTK_DIALOG(fileOpen)) == GTK_RESPONSE_ACCEPT)
	{
		filename =
			gtk_file_chooser_get_filename(GTK_FILE_CHOOSER
						      (fileOpen));
	}
	gtk_widget_destroy(fileOpen);
	return filename;
}

//open pls file
void on_button1_clicked(GtkButton * button, gpointer user_data)
{
	Mainwidget = lookup_widget(GTK_WIDGET(button), "window1");
	gchar *file = getFile(Mainwidget, 0);
	//parse file for ips
	if(file != NULL)
	{
		ip = parsePLS(file);
		if(ip != NULL && ip != "" && !(strlen(ip) == 0))
		{
			gint child_pid = startNewThread();
			if(child_pid <= 0)
				showError(GTK_WIDGET(button));
		}
		else
		{
			GtkWidget *error_dlg;
			error_dlg =
				gtk_message_dialog_new(GTK_WINDOW(Mainwidget),
						       0, GTK_MESSAGE_ERROR,
						       GTK_BUTTONS_OK,
						       "Empty or Invalid file");
			gtk_dialog_set_default_response(GTK_DIALOG(error_dlg),
							GTK_RESPONSE_OK);
			gtk_window_set_resizable(GTK_WINDOW(error_dlg),
						 FALSE);
			gtk_dialog_run(GTK_DIALOG(error_dlg));
			gtk_widget_destroy(error_dlg);
		}
	}
}

//open location
void on_locateButton_clicked(GtkWidget * button, gpointer * user_data)
{
	gchar *file = getFile(dialog1, 1);
	if(file != NULL)
	{
		gtk_entry_set_text(GTK_ENTRY(entry3), file);
	}
}

//open save list
void on_saveL_button_clicked(GtkButton * button, gpointer user_data)
{
	Mainwidget = lookup_widget(GTK_WIDGET(button), "window1");
	gchar *file = getFile(Mainwidget, 2);
	if(file != NULL)
	{
		//save current ips to file
		// file format: each line contains one ip 
		//example: ip:127.0.0.1:9808
		gchar *list = "[gstreamripper]\n";
		gint i = 0;
		for(; i < streams; i++)
		{
			list = g_strconcat(list, "ip:", ips[i][0], "\n",
					   NULL);
		}
		FILE *outfile;
		outfile = fopen(file, "w");
		if(!outfile)
			g_error("couldn't open file!");

		fputs(list, outfile);
		fclose(outfile);
	}
}


// should read ips in the form of
// one ip per line in the format of ip:<ip>
void on_loadL_button_clicked(GtkButton * button, gpointer user_data)
{
	Mainwidget = lookup_widget(GTK_WIDGET(button), "window1");
	gchar *file = getFile(Mainwidget, 3);
	if(file != NULL)
	{

		gchar *contents;
		if(g_file_get_contents(file, &contents, NULL, NULL))
		{
			gchar **sub = g_strsplit(contents, "\n", -1);
			gchar **sub1;
			gchar *sub2;

			gint i = 0;
			if((g_ascii_strncasecmp(sub[i], "[gstreamripper]", strlen(sub[i]))))
			{
				return;
			}
			i++;
			while(sub[i + 1] != NULL)
			{
				if((strlen(sub[i])) == 0)	//checking for empty line
				{
					i++;
					continue;
				}
				sub2 = sub[i];
				sub1 = g_strsplit(sub2, "ip:", -1);
				gchar *tmp = sub1[1];
				ip = g_strdup(tmp);
				gint child_pid = startNewThread();
				if(child_pid == -3)
					break;
				i++;
			}
			g_strfreev(sub);
			g_strfreev(sub1);
		}

	}
	else
	{
		GtkWidget *error_dlg;
		error_dlg =
			gtk_message_dialog_new(GTK_WINDOW(Mainwidget), 0,
					       GTK_MESSAGE_ERROR,
					       GTK_BUTTONS_OK,
					       "Empty or Invalid file");
		gtk_dialog_set_default_response(GTK_DIALOG(error_dlg),
						GTK_RESPONSE_OK);
		gtk_window_set_resizable(GTK_WINDOW(error_dlg), FALSE);
		gtk_dialog_run(GTK_DIALOG(error_dlg));
		gtk_widget_destroy(error_dlg);
	}
}


void on_button2_clicked(GtkButton * button, gpointer user_data)
{
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *entry1;
	GtkWidget *hbox2;
	GtkWidget *label2;
	GtkWidget *entry2;
	GtkWidget *hbox3;
	GtkWidget *label3;
	GtkWidget *dialog_action_area1;
	GtkWidget *cancelbutton1;
	GtkWidget *okbutton1;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new();

	dialog1 = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog1), ("dialog1"));
	gtk_window_set_modal(GTK_WINDOW(dialog1), TRUE);

	dialog_vbox1 = GTK_DIALOG(dialog1)->vbox;
	gtk_widget_show(dialog_vbox1);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_box_pack_start(GTK_BOX(dialog_vbox1), vbox1, TRUE, TRUE, 0);

	hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox1);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, TRUE, TRUE, 0);

	label1 = gtk_label_new(("Path to streamripper"));
	gtk_widget_show(label1);
	gtk_box_pack_start(GTK_BOX(hbox1), label1, FALSE, FALSE, 4);

	entry1 = gtk_entry_new();
	gtk_widget_show(entry1);
	gtk_box_pack_start(GTK_BOX(hbox1), entry1, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, entry1,
			     ("Enter the full path to streamripper here"),
			     NULL);
	gtk_entry_set_max_length(GTK_ENTRY(entry1), 256);
	gtk_entry_set_text(GTK_ENTRY(entry1), binpath);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox2, TRUE, TRUE, 0);

	label2 = gtk_label_new(("Arguments you want passed to streamripper"));
	gtk_widget_show(label2);
	gtk_box_pack_start(GTK_BOX(hbox2), label2, FALSE, FALSE, 3);

	entry2 = gtk_entry_new();
	gtk_widget_show(entry2);
	gtk_box_pack_start(GTK_BOX(hbox2), entry2, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, entry2,
			     ("If left empty no arguments are passed to streamripper\n \
                    \n-s             - Don't create a directory for each stream\n-r <base port> - Create a relay server on base port, defaults to port 8000\n-z             - Don't scan for free ports if base port is not avail\n-p <url>       - Use HTTP proxy server at <url>\n-o             - Overwrite tracks in complete\n-t             - Don't overwrite tracks in incomplete\n-c             - Don't auto-reconnect\n-v             - Print version info and quite\n-l <seconds>   - number of seconds to run, otherwise runs forever\n-q             - add sequence number to output file\n-i             - dont add ID3V1 Tags to output file\n-u <useragent> - Use a different UserAgent then <Streamripper>\n--x            - Invoke splitpoint detection rules"),
			     NULL);
	gtk_entry_set_max_length(GTK_ENTRY(entry2), 256);
	gtk_entry_set_text(GTK_ENTRY(entry2), arguments);

	hbox3 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox3, TRUE, TRUE, 0);

	label3 = gtk_label_new(("Directory where you want the music saved to"));
	gtk_widget_show(label3);
	gtk_box_pack_start(GTK_BOX(hbox3), label3, FALSE, FALSE, 3);
	gtk_label_set_line_wrap(GTK_LABEL(label3), TRUE);

	entry3 = gtk_entry_new();
	gtk_widget_show(entry3);
	gtk_box_pack_start(GTK_BOX(hbox3), entry3, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, entry3,
			     ("If left empty then your home directory will be used"),
			     NULL);
	gtk_entry_set_max_length(GTK_ENTRY(entry3), 256);
	gtk_entry_set_text(GTK_ENTRY(entry3), musicdir);

	GtkWidget *locateButton = gtk_button_new_with_label("...");
	gtk_widget_show(locateButton);
	gtk_box_pack_start(GTK_BOX(hbox3), locateButton, TRUE, TRUE, 0);

	g_signal_connect((gpointer) locateButton, "clicked",
			 G_CALLBACK(on_locateButton_clicked), NULL);

	dialog_action_area1 = GTK_DIALOG(dialog1)->action_area;
	gtk_widget_show(dialog_action_area1);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog_action_area1),
				  GTK_BUTTONBOX_END);

	cancelbutton1 = gtk_button_new_from_stock("gtk-cancel");
	gtk_widget_show(cancelbutton1);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog1), cancelbutton1,
				     GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS(cancelbutton1, GTK_CAN_DEFAULT);

	okbutton1 = gtk_button_new_from_stock("gtk-ok");
	gtk_widget_show(okbutton1);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog1), okbutton1,
				     GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS(okbutton1, GTK_CAN_DEFAULT);


	if(gtk_dialog_run(GTK_DIALOG(dialog1)) == (GTK_RESPONSE_OK))
	{
		binpath = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry1)));
		arguments = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry2)));
		musicdir = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry3)));
	}
	gtk_widget_destroy(dialog1);

}
