/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.browser.BrowserActionRunner;
import com.google.jstestdriver.browser.BrowserRunner;
import com.google.jstestdriver.util.Retry;
import com.google.jstestdriver.util.StopWatch;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserManagedRunner
implements Callable<Collection<ResponseStream>> {
    private static final String CAPTURE_URL = String.format("%%s/capture/%s/%%s/%s/%%s/%s/%%s/", "id", "timeout", "upload_size");
    private static final Logger logger = LoggerFactory.getLogger(BrowserManagedRunner.class);
    private final BrowserRunner runner;
    private final String browserId;
    private final BrowserActionRunner browserActionRunner;
    private final String serverAddress;
    private final JsTestDriverClient client;
    private final StopWatch stopWatch;

    public BrowserManagedRunner(BrowserRunner runner, String browserId, String serverAddress, JsTestDriverClient client, BrowserActionRunner browserActionRunner, StopWatch stopWatch) {
        this.runner = runner;
        this.browserId = browserId;
        this.serverAddress = serverAddress;
        this.client = client;
        this.browserActionRunner = browserActionRunner;
        this.stopWatch = stopWatch;
    }

    @Override
    public Collection<ResponseStream> call() throws Exception {
        return new Retry(this.runner.getNumStartupTries()).retry(new Retry.Retryable<Collection<ResponseStream>>(){

            @Override
            public Collection<ResponseStream> run() throws Exception {
                return BrowserManagedRunner.this.startBrowserAndWaitForResponse();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ResponseStream> startBrowserAndWaitForResponse() throws Exception {
        Object object;
        String url = String.format(CAPTURE_URL, this.serverAddress, this.browserId, this.runner.getHeartbeatTimeout(), this.runner.getUploadSize());
        this.stopWatch.start("browser start %s", this.runner);
        this.runner.startBrowser(url);
        try {
            long timeOut = TimeUnit.MILLISECONDS.convert(this.runner.getTimeout(), TimeUnit.SECONDS);
            long start = System.currentTimeMillis();
            while (!this.isBrowserCaptured(this.browserId, this.client)) {
                Thread.sleep(50L);
                if (System.currentTimeMillis() - start <= timeOut) continue;
                throw new RuntimeException("Could not start browser " + this.runner + " in " + this.runner.getTimeout());
            }
            this.stopWatch.stop("browser start %s", this.runner);
            object = this.browserActionRunner.call();
        }
        catch (Throwable throwable) {
            this.stopWatch.start("browser stop %s", this.runner);
            this.runner.stopBrowser();
            this.stopWatch.stop("browser stop %s", this.runner);
            throw throwable;
        }
        this.stopWatch.start("browser stop %s", this.runner);
        this.runner.stopBrowser();
        this.stopWatch.stop("browser stop %s", this.runner);
        return object;
    }

    private boolean isBrowserCaptured(String browserId, JsTestDriverClient client) {
        for (BrowserInfo browserInfo : client.listBrowsers()) {
            if (!browserId.equals(String.valueOf(browserInfo.getId())) || !browserInfo.serverReceivedHeartbeat()) continue;
            logger.debug("Started {}", browserInfo);
            return true;
        }
        return false;
    }
}

